/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.ResourceRateImportActualFeeFunction;
import kd.macc.cad.algox.function.ResourceRateImportActualFunction;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.price.AdditionalCost;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ActualRateForResourceRate
extends AbstractPurchasePrice
implements PurEventPlugin {
    public ActualRateForResourceRate() {
        super("cad_resourcerate", "outsupentry", false);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        PricePluginPojo pricePluginPojo;
        String resStr;
        Long resourceId;
        Long workCenterId;
        Row row;
        this.ruleId = ruleId;
        DataSet dataSet = this.getResultDataSet(costTypeId, ruleId, appNum);
        DataSet resourceDs = dataSet.copy().filter("match ='resource'");
        resourceDs = ActualRateForResourceRate.unionResourceDs(resourceDs);
        DataSet resourceTypeDs = dataSet.filter("match ='resourcetype'");
        resourceTypeDs = ActualRateForResourceRate.unionResourceTypeDs(resourceTypeDs);
        DataSet result = resourceDs.union(resourceTypeDs);
        result = ActualRateForResourceRate.getWorkCenter(result);
        result = result.filter("workcenter is not null and workcenter>0");
        DataSet resDataSet = result.filter("subelementtype in ('001','002','004','005')");
        DataSet mfgDataSet = result.filter("subelementtype = '003'");
        DataSet countDataSet = resDataSet.copy().groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "resource", "resourcename", "costdriver", "name", "match"}).countDistinct(new String[]{"subelement"}, "count").finish();
        countDataSet = countDataSet.filter("count>1");
        countDataSet = countDataSet.groupBy(new String[]{"resource", "resourcename"}).finish();
        String msg = "";
        while (countDataSet.hasNext()) {
            Row row2 = countDataSet.next();
            String resourcename = row2.getString("resourcename");
            if (CadEmptyUtils.isEmpty((String)resourcename)) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = resourcename;
                continue;
            }
            msg = msg + "\u3001" + resourcename;
        }
        if (!CadEmptyUtils.isEmpty((String)msg)) {
            String tip = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u3010%s\u3011\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e\u3002", (String)"ActualRateForResourceRate_0", (String)"macc-cad-business", (Object[])new Object[0]), msg);
            map.put("tip", tip);
        }
        JobSession session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportRateResource");
        DataSetInput input = new DataSetInput(resDataSet);
        DataSetX dataSetX = session.fromInput((Input)input);
        ResourceRateImportActualFunction func = new ResourceRateImportActualFunction(resDataSet.getRowMeta(), Long.valueOf(costTypeId), new ArrayList());
        DataSetX mainDs = dataSetX.groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)func);
        DataSetOutput resultSet = new DataSetOutput(func.getResultRowMeta());
        String billDataId = resultSet.getId();
        mainDs.output((Output)resultSet);
        session.commit(60, TimeUnit.MINUTES);
        DataSet billDtaSet = session.readDataSet(billDataId);
        session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportRateResource_mfg");
        DataSetInput mfgInput = new DataSetInput(mfgDataSet);
        DataSetX mfgDataSetX = session.fromInput((Input)mfgInput);
        ResourceRateImportActualFeeFunction mfgFunc = new ResourceRateImportActualFeeFunction(mfgDataSet.getRowMeta(), Long.valueOf(costTypeId));
        mfgDataSetX = mfgDataSetX.groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)mfgFunc);
        DataSetOutput mfgResultSet = new DataSetOutput(mfgFunc.getResultRowMeta());
        String entryBillDataId = mfgResultSet.getId();
        mfgDataSetX.output((Output)mfgResultSet);
        session.commit(60, TimeUnit.MINUTES);
        DataSet entryBillDtaSet = session.readDataSet(entryBillDataId);
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        while (billDtaSet.hasNext()) {
            row = billDtaSet.next();
            workCenterId = row.getLong("workcenter");
            resourceId = row.getLong("resource");
            resStr = workCenterId + "@" + resourceId;
            pricePluginPojo = new PricePluginPojo();
            pricePluginPojo.setResourceId(row.getLong("resource").longValue());
            pricePluginPojo.setCurrency(row.getLong("currency").longValue());
            pricePluginPojo.setWorkCenterId(row.getLong("workcenter").longValue());
            pricePluginPojo.setElementId(row.getLong("element").longValue());
            pricePluginPojo.setSubElementId(row.getLong("subelement").longValue());
            pricePluginPojo.setCalcBasis("001");
            pricePluginPojo.setResourceUnit(9L);
            pricePluginPojo.setQty(row.getBigDecimal("actualrate"));
            pricePluginPojo.setDataSrc("rate");
            resultMap.put(resStr, pricePluginPojo);
        }
        while (entryBillDtaSet.hasNext()) {
            row = entryBillDtaSet.next();
            workCenterId = row.getLong("workcenter");
            resourceId = row.getLong("resource");
            resStr = workCenterId + "@" + resourceId;
            if (!resultMap.containsKey(resStr)) continue;
            pricePluginPojo = (PricePluginPojo)resultMap.get(resStr);
            AdditionalCost additionalCost = new AdditionalCost();
            additionalCost.setElement(row.getLong("attaelement"));
            additionalCost.setSubElement(row.getLong("attasubelement"));
            additionalCost.setAmount(row.getBigDecimal("attaqty"));
            pricePluginPojo.getAdditionalCosts().add(additionalCost);
        }
        return new ArrayList<PricePluginPojo>(resultMap.values());
    }

    private static DataSet unionResourceDs(DataSet resourceDs) {
        DynamicObject[] dynamicObjects;
        Iterator iterator = resourceDs.copy().iterator();
        HashSet<Long> ids = new HashSet<Long>();
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            ids.add(next.getLong("costdriver"));
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = ActualRateForResourceRate.getRowMeta();
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_costdriver", (String)"id,resource", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            DynamicObjectCollection resource = dynamicObject.getDynamicObjectCollection("resource");
            for (DynamicObject res : resource) {
                Object[] rowData = new Object[]{dynamicObject.getLong("id"), res.getDynamicObject("fbasedataid").getLong("id"), res.getDynamicObject("fbasedataid").getString("name")};
                dataList.add(rowData);
            }
        }
        if (!dataList.isEmpty()) {
            DataSet ds = Algo.create((String)"ResourceRateAutoService_unionResourceDs").createDataSet(dataList.iterator(), rowMeta);
            return resourceDs.leftJoin(ds).on("costdriver", "costdriver").select(resourceDs.getRowMeta().getFieldNames(), new String[]{"resource", "resourcename"}).finish();
        }
        return resourceDs.addNullField("resource").addNullField("resourcename");
    }

    private static RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("costdriver", (DataType)DataType.LongType), new Field("resource", (DataType)DataType.LongType), new Field("resourcename", (DataType)DataType.StringType)};
        return new RowMeta(fields);
    }

    private static DataSet unionResourceTypeDs(DataSet resourceTypeDs) {
        Iterator iterator = resourceTypeDs.copy().iterator();
        HashSet<Long> ids = new HashSet<Long>();
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            ids.add(next.getLong("costdriver"));
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = ActualRateForResourceRate.getRowMeta();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,resourcetype,createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject dynamicObject : dynamicObjects) {
            List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)dynamicObject.getLong("createorg"), (boolean)false);
            if (productOrgs.isEmpty()) continue;
            String resourceType = dynamicObject.getString("resourcetype");
            QFilter filter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList(productOrgs), (String)"mpdm_resources");
            filter.and("enable", "=", (Object)true);
            filter.and("resourcesentryentity.itemclasstype", "in", ActualRateForResourceRate.getItemClassType(resourceType));
            DynamicObjectCollection obj = QueryServiceHelper.query((String)"mpdm_resources", (String)"id,name", (QFilter[])new QFilter[]{filter});
            for (DynamicObject object : obj) {
                Object[] rowData = new Object[]{dynamicObject.getLong("id"), object.getLong("id"), object.getString("name")};
                dataList.add(rowData);
            }
        }
        if (!dataList.isEmpty()) {
            DataSet ds = Algo.create((String)"ResourceRateAutoService_unionResourceDs").createDataSet(dataList.iterator(), rowMeta);
            ds = ds.groupBy(new String[]{"costdriver", "resource", "resourcename"}).finish();
            return resourceTypeDs.leftJoin(ds).on("costdriver", "costdriver").select(resourceTypeDs.getRowMeta().getFieldNames(), new String[]{"resource", "resourcename"}).finish();
        }
        return resourceTypeDs.addNullField("resource").addNullField("resourcename");
    }

    private static List<String> getItemClassType(String resourceType) {
        ArrayList<String> result = new ArrayList<String>(10);
        resourceType = resourceType.substring(1, resourceType.length() - 1);
        String[] split = resourceType.split(",");
        ArrayList<String> list = new ArrayList<String>(10);
        for (String item : split) {
            list.add(item);
        }
        for (String sourKey : list) {
            if ("A".equals(sourKey)) {
                result.add("mpdm_equipment");
            }
            if ("B".equals(sourKey)) {
                result.add("mpdm_toolsresource");
            }
            if ("C".equals(sourKey)) {
                result.add("mpdm_toolequip");
            }
            if ("D".equals(sourKey)) {
                result.add("mpdm_mould");
            }
            if (!"E".equals(sourKey)) continue;
            result.add("mpdm_manuperson");
        }
        return result;
    }

    private DataSet getResultDataSet(Long costType, Long ruleId, String appNum) {
        QFilter filter = ActualRateForResourceRate.getOrgFilterByCstType(costType, ruleId, appNum);
        String selectFiled = "org,costaccount,period,manuorg,currency,benefcostcenter as costcenter,element,subelement,subelement.type subelementtype,allocexpenseitem,actualrate,costdriver,costdriver.name as name,costdriver.matchpattern match";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_autoImportRateResource", (String)"cad_mfgfeeallocco", (String)selectFiled, (QFilter[])new QFilter[]{filter}, null);
        DataSet notCombindDataSet = dataSet.copy().filter("allocexpenseitem>0");
        HashMap<String, Long> costSubElementMap = new HashMap<String, Long>(256);
        while (notCombindDataSet.hasNext()) {
            Row row = notCombindDataSet.next();
            Long costCenter = row.getLong("costcenter");
            Long allocExpenseItem = row.getLong("allocexpenseitem");
            Long subElement = row.getLong("subelement");
            String costDataKey = String.format("%s@%s", costCenter, allocExpenseItem);
            if (costSubElementMap.containsKey(costDataKey)) {
                Long subElementId = (Long)costSubElementMap.get(costDataKey);
                if (subElement == null || subElement.equals(subElementId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5931\u8d25\u3002\u5f53\u4f7f\u7528\u53d6\u6570\u89c4\u5219\u4e3a\uff1a\u5b9e\u9645\u8d39\u7387\u5e73\u5747\u4ef7\uff0c\u540c\u4e00\u8d39\u7528\u9879\u76ee\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u5e94\u8be5\u76f8\u540c\u3002", (String)"ActualRateForResourceRate_1", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            costSubElementMap.put(costDataKey, subElement);
        }
        costSubElementMap.clear();
        dataSet = dataSet.groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "element", "subelement", "subelementtype", "costdriver", "name", "match"}).sum("actualrate").finish();
        DataSet copyDatSet = dataSet.copy();
        HashMap<String, Long> costDriverMap = new HashMap<String, Long>(256);
        while (copyDatSet.hasNext()) {
            Row row = copyDatSet.next();
            Long costCenter = row.getLong("costcenter");
            Long subElement = row.getLong("subelement");
            Long costDriver = row.getLong("costdriver");
            String costDriverKey = String.format("%s@%s", costCenter, subElement);
            if (costDriverMap.containsKey(costDriverKey)) {
                Long costDriverId = (Long)costDriverMap.get(costDriverKey);
                if (costDriver == null || costDriver.equals(costDriverId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5931\u8d25\u3002\u5f53\u4f7f\u7528\u53d6\u6570\u89c4\u5219\u4e3a\uff1a\u5b9e\u9645\u8d39\u7387\u5e73\u5747\u4ef7\uff0c\u540c\u4e00\u6210\u672c\u5b50\u8981\u7d20\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u5e94\u8be5\u76f8\u540c\u3002", (String)"ActualRateForResourceRate_2", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            costDriverMap.put(costDriverKey, costDriver);
        }
        costDriverMap.clear();
        return dataSet;
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return null;
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }

    private static QFilter getOrgFilterByCstType(Long costType, Long ruleId, String appId) {
        QFilter filter = null;
        if ("sca".equals(appId)) {
            DynamicObjectCollection costTypeOrg = ActualRateForResourceRate.getCostTypeOrg(costType);
            if (costTypeOrg == null || CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeOrg)) {
                return filter;
            }
            for (DynamicObject dyo : costTypeOrg) {
                QFilter timeFilter;
                long storagOrg;
                boolean produce;
                long calOrg = dyo.getLong("calorg");
                QFilter f = new QFilter("org", "=", (Object)calOrg);
                long costAccountId = dyo.getLong("costaccount");
                f.and("costaccount", "=", (Object)costAccountId);
                if (OrgHelper.isOrgEnableMultiFactory((Long)calOrg) && (produce = OrgUnitServiceHelper.checkOrgFunction((Long)(storagOrg = dyo.getLong("storageorgunit")), (String)"04"))) {
                    f.and("manuorg", "=", (Object)storagOrg);
                }
                if ((timeFilter = ActualRateForResourceRate.getFilterByCalcRule(costAccountId, ruleId)) == null) continue;
                f.and(timeFilter);
                if (filter == null) {
                    filter = f;
                    continue;
                }
                filter.or(f);
            }
            if (filter == null) {
                return filter;
            }
            filter.and("allocstatus", "=", (Object)"2");
            filter.and("appnum", "=", (Object)appId);
            filter.and("costdriver.islinkresource", "=", (Object)true);
        } else {
            DynamicObject createOrg = CostTypeHelper.getCostType((Long)costType, (String)"createorg.id");
            if (createOrg == null) {
                return filter;
            }
            filter = new QFilter("org", "=", (Object)createOrg.getLong("createorg.id"));
            Long costAccountId = CostAccountHelper.getCostAccountByOrg((Long)createOrg.getLong("createorg.id"), (String)"aca");
            filter.and("costaccount", "=", (Object)costAccountId);
            QFilter timeFilter = ActualRateForResourceRate.getFilterByCalcRule(costAccountId, ruleId);
            if (timeFilter != null) {
                filter.and(timeFilter);
            }
            filter.and("allocstatus", "=", (Object)"2");
            filter.and("appnum", "=", (Object)appId);
            filter.and("costdriver.islinkresource", "=", (Object)true);
        }
        return filter;
    }

    private static QFilter getFilterByCalcRule(Long costAccountId, Long ruleId) {
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        QFilter filter = new QFilter("id", "=", (Object)ruleId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"startyears,startpricetime,endyears,endpricetime", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null || costAccountId == 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        if (CadEmptyUtils.isEmpty((String)dynamicObject.getString("startyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("startpricetime")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endpricetime"))) {
            return null;
        }
        int startYears = Integer.parseInt(dynamicObject.getString("startyears"));
        int endYears = Integer.parseInt(dynamicObject.getString("endyears"));
        int startMonth = Integer.parseInt(dynamicObject.getString("startpricetime"));
        int endMonth = Integer.parseInt(dynamicObject.getString("endpricetime"));
        DynamicObject accountPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (accountPeriod == null) {
            return null;
        }
        DynamicObject currentPeriod = BusinessDataServiceHelper.loadSingle((Object)accountPeriod.getLong("id"), (String)"bd_period");
        if (currentPeriod == null) {
            return null;
        }
        Object periodTypeId = currentPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter qFilter = new QFilter("periodtype.id", "=", periodTypeId);
        startYears = startYears == 1 ? year : (startYears == 2 ? year - 1 : year - 2);
        endYears = endYears == 1 ? year : (endYears == 2 ? year - 1 : year - 2);
        if (startMonth == 13) {
            startPeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod.getLong("id"));
        } else if (startMonth == 14) {
            startPeriod = currentPeriod;
        } else {
            QFilter startQFilter = new QFilter("periodyear", "=", (Object)startYears);
            startQFilter.and("periodnumber", "=", (Object)startMonth);
            startPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])new QFilter[]{qFilter, startQFilter});
        }
        if (endMonth == 13) {
            endPeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod.getLong("id"));
        } else if (endMonth == 14) {
            endPeriod = currentPeriod;
        } else {
            QFilter endQFilter = new QFilter("periodyear", "=", (Object)endYears);
            endQFilter.and("periodnumber", "=", (Object)endMonth);
            endPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])new QFilter[]{qFilter, endQFilter});
        }
        if (startPeriod == null || endPeriod == null) {
            return null;
        }
        List startToEndPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        QFilter timeFilter = new QFilter("period", "in", (Object)startToEndPeriodIds);
        return timeFilter;
    }

    private static DynamicObjectCollection getCostTypeOrg(long costType) {
        QFilter costFilter = new QFilter("id", "=", (Object)costType);
        costFilter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        ArrayList costTypeList = new ArrayList(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtypeId", (QFilter[])new QFilter[]{costFilter});
        if (dynamicObjects.isEmpty()) {
            return null;
        }
        dynamicObjects.forEach(r -> costTypeList.add(r.getLong("costtypeId")));
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeList), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        return QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])filters);
    }

    private static DataSet getWorkCenter(DataSet result) {
        result = result.filter("resource is not null");
        Iterator iterator = result.copy().iterator();
        ArrayList<Long> costCenterIds = new ArrayList<Long>(20);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            costCenterIds.add(next.getLong("costcenter"));
        }
        Date now = new Date();
        QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
        ccFilter.and("effectdate", "<=", (Object)now);
        ccFilter.and("expdate", ">", (Object)now);
        ccFilter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
        DataSet wsDs = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_getWorkCenter", (String)"bos_costcentersourcemap", (String)"costcenter,entryentity.sourcedata as workcenter", (QFilter[])new QFilter[]{ccFilter}, null);
        result = !wsDs.isEmpty() ? result.leftJoin(wsDs).on("costcenter", "costcenter").select(result.getRowMeta().getFieldNames(), new String[]{"workcenter"}).finish() : result.addField("'0'", "workcenter");
        return result;
    }
}

