/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.price.CostInfoDetail;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class CalBalForPurPrices
extends AbstractPurchasePrice
implements PurEventPlugin {
    private static final Log logger = LogFactory.getLog(CalBalForPurPrices.class);

    public CalBalForPurPrices() {
        super("cad_bal", "pursupentry", false);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        this.ruleId = ruleId;
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u53d6\u4ef7-\u5f00\u59cb\u3002\u53c2\u6570\uff1a\u5b9e\u4f53\uff1a{}\uff0c\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u53d6\u4ef7\u89c4\u5219\uff1a{}", new Object[]{entity, orgId, costTypeId, ruleId});
        ArrayList<PricePluginPojo> results = new ArrayList<PricePluginPojo>();
        String splitSign = "#";
        List costTypes = CostTypeHelper.getHsCostByMn((Long)costTypeId);
        logger.info("\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff1a{}", (Object)costTypes);
        Map<Long, Set<Long>> costAccountStoOrgMap = this.getCostAccountStoOrgMap(orgId, costTypes, new Date());
        Map<Long, Long> costAccountCurPeriodMap = this.getCostAccountCurPeriodMap(orgId, costAccountStoOrgMap.keySet());
        List<Long> invOrgIds = this.getInvOrgIds(orgId, costTypes);
        logger.info("\u83b7\u53d6\u5230\u7684\u5e93\u5b58\u7ec4\u7ec7\uff1a{}", invOrgIds);
        List<Long> prodOrgs = this.getProdOrg(orgId, costTypeId);
        logger.info("\u83b7\u53d6\u5230\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", prodOrgs);
        ThreeTuple<String, List<String>, Integer> matAttrRetroPeriodTp = this.getMatAttrRetroPeriodTp(ruleId);
        if (matAttrRetroPeriodTp == null) {
            return results;
        }
        Boolean startBomRule = this.isStartBomRule(costTypeId);
        Set<Long> materials = this.getMaterials(orgId, costTypeId, invOrgIds, prodOrgs, (String)matAttrRetroPeriodTp.item1, (List)matAttrRetroPeriodTp.item2, startBomRule);
        logger.info("\u83b7\u53d6\u5230\u7684\u7269\u6599\u4e2a\u6570\uff1a{}", (Object)materials.size());
        this.material2ElementArray.putAll(ElementHelper.getDefSubEles((Long)orgId, materials));
        Long currency = this.getCurrency(costTypeId);
        this.updatePrecision(currency);
        logger.info("\u8c03\u5b58\u8d27\u63a5\u53e3\uff0c\u5f00\u59cb");
        DataSet resultDataSet = null;
        for (Map.Entry<Long, Set<Long>> entry : costAccountStoOrgMap.entrySet()) {
            Long costAccount = entry.getKey();
            Set<Long> stoOrgs = entry.getValue();
            if (!costAccountCurPeriodMap.containsKey(costAccount)) {
                logger.info("\u6210\u672c\u8d26\u7c3f\uff1a{}\uff0c\u6ca1\u6709\u6838\u7b97\u671f\u95f4\uff0c\u8df3\u8fc7", (Object)costAccount);
                continue;
            }
            Integer retroPeriod = (Integer)matAttrRetroPeriodTp.item3;
            Long curPeriod = costAccountCurPeriodMap.get(costAccount);
            if (CadEmptyUtils.isEmpty((Long)curPeriod)) continue;
            for (int count = 0; count <= retroPeriod && !CadEmptyUtils.isEmpty(materials); ++count) {
                if (count > 0) {
                    curPeriod = PeriodHelper.getPreviousPeriod((Object)curPeriod).getLong("id");
                }
                if (resultDataSet == null) {
                    resultDataSet = this.getPriceDataSet(costAccount, curPeriod, stoOrgs, materials);
                    continue;
                }
                DataSet priceDataSet = this.getPriceDataSet(costAccount, curPeriod, stoOrgs, materials);
                resultDataSet = resultDataSet.union(priceDataSet);
            }
        }
        logger.info("\u8c03\u5b58\u8d27\u63a5\u53e3\uff0c\u7ed3\u675f");
        if (resultDataSet == null) {
            return results;
        }
        resultDataSet = resultDataSet.filter("baseqty >0 and actualcost>0").select("material,costelement,costsubelement,baseqty,actualcost").orderBy(new String[]{"material"});
        Set<Long> attSubelementIds = this.getMoreZeroRateSetting(costTypeId);
        if (!CadEmptyUtils.isEmpty(attSubelementIds)) {
            resultDataSet = resultDataSet.filter("costsubelement not in (" + StringUtils.join(attSubelementIds, (String)",") + ")");
        }
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7\uff0c\u5904\u7406\u7ed3\u679c\u96c6-\u5f00\u59cb");
        ArrayList<Row> toDealList = new ArrayList<Row>(1);
        String billKey = "-1";
        for (Row orderDO : resultDataSet) {
            String curKey = this.jointKey(new StringBuilder(), splitSign, orderDO.getString("material"));
            if (billKey.equals("-1")) {
                billKey = curKey;
            }
            if (billKey.equals(curKey)) {
                toDealList.add(orderDO);
                continue;
            }
            billKey = curKey;
            this.buildPricePojo(results, currency, toDealList);
            toDealList.clear();
            toDealList.add(orderDO);
        }
        this.buildPricePojo(results, currency, toDealList);
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7\uff0c\u5904\u7406\u7ed3\u679c\u96c6-\u7ed3\u675f");
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u53d6\u4ef7-\u7ed3\u675f\u3002\u53c2\u6570\uff1a\u5b9e\u4f53\uff1a{}\uff0c\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u6210\u672c\u7c7b\u578b\uff1a{}\uff0c\u53d6\u4ef7\u89c4\u5219\uff1a{}", new Object[]{entity, orgId, costTypeId, ruleId});
        return results;
    }

    private Map<Long, Long> getCostAccountIdAndCurrentPeriodIdMap(Long org) {
        DynamicObjectCollection costAccountList = this.getAllCostAccountFromCalSysByOrgId(org);
        if (costAccountList == null || costAccountList.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        Map<Long, Long> costAccountIdAndCurrentPeriodIdMap = costAccountList.stream().collect(Collectors.toMap(item -> item.getLong("cost_account_id"), item -> {
            long currentPeriod = item.getLong("currentperiod");
            if (CadEmptyUtils.isEmpty((Long)currentPeriod)) {
                return item.getLong("startperiod");
            }
            return currentPeriod;
        }, (v1, v2) -> v1));
        return costAccountIdAndCurrentPeriodIdMap;
    }

    private DynamicObjectCollection getAllCostAccountFromCalSysByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter costAccountEnableFilter = new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter startPeriodFilter = new QFilter("entry.startperiod", "!=", (Object)0L);
        startPeriodFilter.and("entry.startperiod", "is not null", (Object)"null");
        QFilter[] filters = new QFilter[]{orgFilter, costAccountEnableFilter, startPeriodFilter};
        String selectedFields = "id,entry.costaccount.id as cost_account_id, entry.costaccount.calpolicy.id as calpolicy_id,entry.startperiod as startperiod, entry.currentperiod as currentperiod";
        return QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selectedFields, (QFilter[])filters);
    }

    private DataSet getPriceDataSet(Long costAccount, Long curPeriod, Set<Long> stoOrgs, Set<Long> materials) {
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u5f00\u59cb\u3002\u53c2\u6570\uff1a\u6210\u672c\u8d26\u7c3f\uff1a{}\uff1b\u5f53\u524d\u671f\u95f4\uff1a{}\uff0c\u5e93\u5b58\u7ec4\u7ec7\uff1a{}\uff0c\u7269\u6599\uff1a{}", new Object[]{costAccount, curPeriod, stoOrgs, materials});
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPeriodBeginCostPriceByCache", (Object[])new Object[]{costAccount, curPeriod, stoOrgs, materials, Boolean.TRUE});
        DataSet groupRecordDS = Algo.getCacheDataSet((String)result).toDataSet(Algo.create((String)CalBalForPurPrices.class.getName()), true);
        DataSet dataSet = groupRecordDS.groupBy(new String[]{"material", "costelement", "costsubelement"}).sum("baseqty").sum("actualcost").finish();
        dataSet = dataSet.filter("baseqty!=0");
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> priceMaterials = new HashSet<Long>(10);
        while (copyDataSet.hasNext()) {
            Long material;
            Row row = copyDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty((Long)(material = row.getLong("material")))) continue;
            priceMaterials.add(material);
        }
        logger.info("\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u7ed3\u675f\u3002\u5df2\u53d6\u5230\u4ef7\u7269\u6599\uff1a{}", priceMaterials);
        materials.removeAll(priceMaterials);
        return dataSet;
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return null;
    }

    private ThreeTuple<String, List<String>, Integer> getMatAttrRetroPeriodTp(Long ruleId) {
        String[] split;
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"matrange,matcalcprop,retroperiod", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
        if (rule == null) {
            return null;
        }
        ArrayList<String> attrs = new ArrayList<String>(10);
        String matcalcprop = rule.getString("matcalcprop");
        if (CadEmptyUtils.isEmpty((String)matcalcprop)) {
            return null;
        }
        for (String s : split = matcalcprop.split(",")) {
            if (CadEmptyUtils.isEmpty((String)s)) continue;
            attrs.add(s);
        }
        return new ThreeTuple((Object)rule.getString("matrange"), attrs, (Object)rule.getInt("retroperiod"));
    }

    private Set<Long> getMaterials(Long orgId, Long costTypeId, List<Long> invOrgIds, List<Long> prodOrgs, String matRange, List<String> matAttrs, Boolean isStartBomRule) {
        HashSet<Long> materials = new HashSet<Long>(10);
        if (!isStartBomRule.booleanValue()) {
            ArrayList<String> matAttrPros = new ArrayList<String>(10);
            for (String matAttr : matAttrs) {
                if ("10030".equals(matAttr)) {
                    matAttrPros.add("A");
                    continue;
                }
                if ("10040".equals(matAttr)) {
                    matAttrPros.add("B");
                    continue;
                }
                if (!"10050".equals(matAttr)) continue;
                matAttrPros.add("C");
            }
            QFilter orgFilter = new QFilter("costtype", "in", (Object)costTypeId);
            orgFilter.and(new QFilter("enable", "=", (Object)"1"));
            orgFilter.and(new QFilter("status", "=", (Object)"C"));
            orgFilter.and(new QFilter("matcalcprop", "in", matAttrPros));
            DataSet materialmftinfos = QueryServiceHelper.queryDataSet((String)"CalBalForPurPrices.getMaterials#2", (String)"cad_bomsetting", (String)"material", (QFilter[])new QFilter[]{orgFilter}, null);
            while (materialmftinfos.hasNext()) {
                Row row = materialmftinfos.next();
                Long material = row.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
            return materials;
        }
        if ("A".equals(matRange)) {
            QFilter orgFilter;
            boolean isMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            if (isMulFactory) {
                prodOrgs.retainAll(invOrgIds);
            }
            if ((orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(prodOrgs, (String)"bd_materialmftinfo")) == null) {
                return materials;
            }
            orgFilter.and(new QFilter("enable", "=", (Object)"1"));
            orgFilter.and(new QFilter("status", "=", (Object)"C"));
            DataSet materialmftinfos = QueryServiceHelper.queryDataSet((String)"CalBalForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{orgFilter}, null);
            materialmftinfos = materialmftinfos.select("masterid,materialattr,ctrlstrategy,level").orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            while (materialmftinfos.hasNext()) {
                Row row = materialmftinfos.next();
                Long material = row.getLong("masterid");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                String materialAttr = row.getString("materialattr");
                if (matAttrs.contains(materialAttr)) {
                    materials.add(material);
                }
                existMats.add(material);
            }
        } else {
            QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(invOrgIds, (String)"bd_materialinventoryinfo");
            if (orgFilter == null) {
                return materials;
            }
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            statusFilter.and(new QFilter("enable", "=", (Object)"1"));
            DataSet invInfos = QueryServiceHelper.queryDataSet((String)"CalBalForPurPrices.getMaterials#1", (String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])new QFilter[]{orgFilter, statusFilter}, null);
            while (invInfos.hasNext()) {
                Row row = invInfos.next();
                Long material = row.getLong("masterid");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
            if (CadEmptyUtils.isEmpty(materials)) {
                return materials;
            }
            orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(prodOrgs, (String)"bd_materialmftinfo");
            orgFilter.and(new QFilter("masterid", "in", materials));
            orgFilter.and(new QFilter("enable", "=", (Object)"1"));
            orgFilter.and(new QFilter("status", "=", (Object)"C"));
            DataSet materialmftinfos = QueryServiceHelper.queryDataSet((String)"CalBalForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{orgFilter}, null);
            materialmftinfos = materialmftinfos.select("masterid,materialattr,ctrlstrategy,level").orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            HashSet<Long> inMatIds = new HashSet<Long>(10);
            while (materialmftinfos.hasNext()) {
                Row row = materialmftinfos.next();
                Long material = row.getLong("masterid");
                String materialAttr = row.getString("materialattr");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                if (matAttrs.contains(materialAttr)) {
                    inMatIds.add(material);
                }
                existMats.add(material);
            }
            if (!matAttrs.contains("10040")) {
                return inMatIds;
            }
            materials.removeAll(existMats);
            inMatIds.addAll(materials);
            return inMatIds;
        }
        return materials;
    }

    private void buildPricePojo(List<PricePluginPojo> results, Long currency, List<Row> toDealList) {
        if (toDealList.isEmpty()) {
            return;
        }
        PricePluginPojo pricePluginPojo = new PricePluginPojo();
        pricePluginPojo.setCurrency(currency.longValue());
        pricePluginPojo.setMaterialId(toDealList.get(0).getLong("material").longValue());
        pricePluginPojo.setAuxptyId(0L);
        List costInfoDetailList = pricePluginPojo.getCostInfoDetailList();
        BigDecimal amount = BigDecimal.ZERO;
        for (Row row : toDealList) {
            CostInfoDetail costInfoDetail = new CostInfoDetail();
            costInfoDetail.setElement(row.getLong("costelement").longValue());
            costInfoDetail.setSubElement(row.getLong("costsubelement").longValue());
            BigDecimal baseQty = row.getBigDecimal("baseqty");
            BigDecimal actualCost = row.getBigDecimal("actualcost");
            BigDecimal price = actualCost.divide(baseQty, this.priceprecision, RoundingMode.HALF_UP);
            if (price.compareTo(BigDecimal.ZERO) == 0) continue;
            costInfoDetail.setPrice(price);
            amount = amount.add(price);
            costInfoDetailList.add(costInfoDetail);
        }
        pricePluginPojo.setAmount(amount);
        results.add(pricePluginPojo);
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }

    private Map<Long, Set<Long>> getCostAccountStoOrgMap(Long orgId, List<Long> hsCostTypes, Date date) {
        HashMap<Long, Set<Long>> costAccountStoOrgMap = new HashMap<Long, Set<Long>>(16);
        if (!CadEmptyUtils.isEmpty(hsCostTypes)) {
            QFilter filter = new QFilter("costtype", "in", hsCostTypes);
            filter.and(new QFilter("bizstatus", "=", (Object)"1"));
            QFilter timeFilter = new QFilter("effectdate", "<=", (Object)date);
            timeFilter.and(new QFilter("invaliddate", ">", (Object)date));
            DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costaccount,storageorgunit", (QFilter[])new QFilter[]{filter, timeFilter});
            for (DynamicObject costTypeOrg : costTypeOrgs) {
                long costAccount = costTypeOrg.getLong("costaccount");
                if (CadEmptyUtils.isEmpty((Long)costAccount)) continue;
                Set stoOrgs = costAccountStoOrgMap.computeIfAbsent(costAccount, p -> new HashSet());
                long stoOrg = costTypeOrg.getLong("storageorgunit");
                if (CadEmptyUtils.isEmpty((Long)stoOrg)) continue;
                stoOrgs.add(stoOrg);
            }
        } else {
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and(new QFilter("appnum", "=", (Object)"aca"));
            filter.and(new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection costs = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount", (QFilter[])new QFilter[]{filter});
            for (DynamicObject cost : costs) {
                long costAccountId = cost.getLong("costaccount");
                if (CadEmptyUtils.isEmpty((Long)costAccountId)) continue;
                costAccountStoOrgMap.put(costAccountId, new HashSet());
            }
        }
        return costAccountStoOrgMap;
    }

    private Map<Long, Long> getCostAccountCurPeriodMap(Long orgId, Set<Long> costAccountIds) {
        Map<Long, Long> costAccountIdAndCurrentPeriodIdMap = this.getCostAccountIdAndCurrentPeriodIdMap(orgId);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("entryentity.costaccount", "in", costAccountIds));
        filter.and(new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection costs = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> costAccountCurPeriodMap = new HashMap<Long, Long>(16);
        for (DynamicObject cost : costs) {
            long currentperiod;
            long costAccount = cost.getLong("costaccount");
            if (!costAccountIdAndCurrentPeriodIdMap.containsKey(costAccount) || CadEmptyUtils.isEmpty((Long)(currentperiod = costAccountIdAndCurrentPeriodIdMap.get(costAccount).longValue()))) continue;
            costAccountCurPeriodMap.put(cost.getLong("costaccount"), currentperiod);
        }
        return costAccountCurPeriodMap;
    }

    private Set<Long> getMoreZeroRateSetting(Long costType) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("entryentity.stdrate", ">", (Object)BigDecimal.ZERO));
        DynamicObjectCollection stdRateSettings = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"entryentity.subelement subelement", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getIdSet((DynamicObjectCollection)stdRateSettings, (String)"subelement");
    }
}

