/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.ResourceRateImportPlanFeeFunction;
import kd.macc.cad.algox.function.ResourceRateImportPlanFunction;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.price.AdditionalCost;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanRateForResourceRate
extends AbstractPurchasePrice
implements PurEventPlugin {
    public PlanRateForResourceRate() {
        super("cad_resourcerate", "outsupentry", false);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        PricePluginPojo pricePluginPojo;
        String resStr;
        Long resourceId;
        Long workCenterId;
        Row row;
        this.ruleId = ruleId;
        Set costAccountIds = CostTypeHelper.getCostAccountIds((Long)costTypeId, (String)"sca");
        Long costAccountId = (Long)costAccountIds.stream().findFirst().get();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("costaccount", "=", (Object)costAccountId));
        qFilter.and(new QFilter("mulcalcrule.fbasedataid", "=", (Object)ruleId));
        DynamicObject planScheme = BusinessDataServiceHelper.loadSingle((String)"cad_planscheme", (QFilter[])qFilter.toArray());
        if (planScheme == null) {
            DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)ruleId).toArray());
            String errorMsg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u53d6\u4ef7\u5931\u8d25\u3002\u8ba1\u5212\u65b9\u6848\u8bbe\u7f6e\u4e2d\u4e0d\u5b58\u5728\u7ed1\u5b9a\u8be5\u53d6\u4ef7\u89c4\u5219\u7684\u8ba1\u5212\u65b9\u6848\u3002", (String)"PlanRateForResourceRate_1", (String)"macc-cad-business", (Object[])new Object[0]), rule.getString("name"));
            throw new KDBizException(errorMsg);
        }
        DataSet result = this.getResultDataSet(costTypeId, ruleId, planScheme.getLong("id"), appNum);
        result = PlanRateForResourceRate.getWorkCenter(result);
        result = result.filter("workcenter is not null and workcenter>0");
        DataSet resDataSet = result.filter("subelementtype in ('001','002','004','005')");
        DataSet mfgDataSet = result.filter("subelementtype = '003'");
        DataSet countDataSet = resDataSet.copy().groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "resource", "resourcename"}).countDistinct(new String[]{"subelement"}, "count").finish();
        countDataSet = countDataSet.filter("count>1");
        countDataSet = countDataSet.groupBy(new String[]{"resource", "resourcename"}).finish();
        String msg = "";
        while (countDataSet.hasNext()) {
            Row row2 = countDataSet.next();
            String resourcename = row2.getString("resourcename");
            if (CadEmptyUtils.isEmpty((String)resourcename)) continue;
            if (CadEmptyUtils.isEmpty((String)msg)) {
                msg = resourcename;
                continue;
            }
            msg = msg + "\u3001" + resourcename;
        }
        if (!CadEmptyUtils.isEmpty((String)msg)) {
            String tip = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u3010%s\u3011\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u6570\u636e\u3002", (String)"PlanRateForResourceRate_0", (String)"macc-cad-business", (Object[])new Object[0]), msg);
            map.put("tip", tip);
        }
        JobSession session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportPlanRate");
        DataSetInput input = new DataSetInput(resDataSet);
        DataSetX dataSetX = session.fromInput((Input)input);
        ResourceRateImportPlanFunction func = new ResourceRateImportPlanFunction(resDataSet.getRowMeta(), Long.valueOf(costTypeId), new ArrayList());
        DataSetX mainDs = dataSetX.groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)func);
        DataSetOutput resultSet = new DataSetOutput(func.getResultRowMeta());
        String billDataId = resultSet.getId();
        mainDs.output((Output)resultSet);
        session.commit(60, TimeUnit.MINUTES);
        DataSet billDtaSet = session.readDataSet(billDataId);
        session = AlgoX.createSession((String)"ResourceRateAutoService_autoImportPlanFee");
        DataSetInput mfgInput = new DataSetInput(mfgDataSet);
        DataSetX mfgDataSetX = session.fromInput((Input)mfgInput);
        ResourceRateImportPlanFeeFunction mfgFunc = new ResourceRateImportPlanFeeFunction(mfgDataSet.getRowMeta(), Long.valueOf(costTypeId));
        mfgDataSetX = mfgDataSetX.groupBy(new String[]{"org", "costaccount", "manuorg", "currency", "costcenter", "workcenter", "element", "subelement", "subelementtype", "resource"}).reduceGroup((GroupReduceFunction)mfgFunc);
        DataSetOutput mfgResultSet = new DataSetOutput(mfgFunc.getResultRowMeta());
        String entryBillDataId = mfgResultSet.getId();
        mfgDataSetX.output((Output)mfgResultSet);
        session.commit(60, TimeUnit.MINUTES);
        DataSet entryBillDtaSet = session.readDataSet(entryBillDataId);
        HashMap<String, PricePluginPojo> resultMap = new HashMap<String, PricePluginPojo>(16);
        while (billDtaSet.hasNext()) {
            row = billDtaSet.next();
            workCenterId = row.getLong("workcenter");
            resourceId = row.getLong("resource");
            resStr = workCenterId + "@" + resourceId;
            pricePluginPojo = new PricePluginPojo();
            pricePluginPojo.setResourceId(row.getLong("resource").longValue());
            pricePluginPojo.setCurrency(row.getLong("currency").longValue());
            pricePluginPojo.setWorkCenterId(row.getLong("workcenter").longValue());
            pricePluginPojo.setElementId(row.getLong("element").longValue());
            pricePluginPojo.setSubElementId(row.getLong("subelement").longValue());
            pricePluginPojo.setCalcBasis("001");
            pricePluginPojo.setResourceUnit(9L);
            pricePluginPojo.setQty(row.getBigDecimal("planrate"));
            pricePluginPojo.setDataSrc("rate");
            resultMap.put(resStr, pricePluginPojo);
        }
        while (entryBillDtaSet.hasNext()) {
            row = entryBillDtaSet.next();
            workCenterId = row.getLong("workcenter");
            resourceId = row.getLong("resource");
            resStr = workCenterId + "@" + resourceId;
            if (!resultMap.containsKey(resStr)) continue;
            pricePluginPojo = (PricePluginPojo)resultMap.get(resStr);
            AdditionalCost additionalCost = new AdditionalCost();
            additionalCost.setElement(row.getLong("attaelement"));
            additionalCost.setSubElement(row.getLong("attasubelement"));
            additionalCost.setAmount(row.getBigDecimal("attaqty"));
            pricePluginPojo.getAdditionalCosts().add(additionalCost);
        }
        return new ArrayList<PricePluginPojo>(resultMap.values());
    }

    private DataSet getResultDataSet(Long costType, Long ruleId, Long schemeId, String appNum) {
        QFilter filter = PlanRateForResourceRate.getOrgFilterByCstType(costType, ruleId, appNum);
        if (filter != null) {
            filter.and(new QFilter("planscheme", "=", (Object)schemeId));
        }
        String selectFiled = "org,costaccount,period,manuorg,currency,costcenter,element,subelement,subelement.type subelementtype,expenseitem allocexpenseitem,planrate,mulresource.fbasedataid resource,mulresource.fbasedataid.name resourcename";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_autoImportRateResource_plan", (String)"cad_resourcplanrate", (String)selectFiled, (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"org", "costaccount", "period", "manuorg", "currency", "costcenter", "element", "subelement", "subelementtype", "resource", "resourcename"}).sum("planrate").finish();
        return dataSet;
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return null;
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }

    private static QFilter getOrgFilterByCstType(Long costType, Long ruleId, String appId) {
        QFilter filter = null;
        DynamicObjectCollection costTypeOrg = PlanRateForResourceRate.getCostTypeOrg(costType);
        if (costTypeOrg == null || CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeOrg)) {
            return filter;
        }
        for (DynamicObject dyo : costTypeOrg) {
            QFilter timeFilter;
            long storagOrg;
            boolean produce;
            long calOrg = dyo.getLong("calorg");
            QFilter f = new QFilter("org", "=", (Object)calOrg);
            long costAccountId = dyo.getLong("costaccount");
            f.and("costaccount", "=", (Object)costAccountId);
            if (OrgHelper.isOrgEnableMultiFactory((Long)calOrg) && (produce = OrgUnitServiceHelper.checkOrgFunction((Long)(storagOrg = dyo.getLong("storageorgunit")), (String)"04"))) {
                f.and("manuorg", "=", (Object)storagOrg);
            }
            if ((timeFilter = PlanRateForResourceRate.getFilterByCalcRule(costAccountId, ruleId)) == null) continue;
            f.and(timeFilter);
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return filter;
        }
        return filter;
    }

    private static QFilter getFilterByCalcRule(Long costAccountId, Long ruleId) {
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        QFilter filter = new QFilter("id", "=", (Object)ruleId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"startyears,startpricetime,endyears,endpricetime", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null || costAccountId == 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        if (CadEmptyUtils.isEmpty((String)dynamicObject.getString("startyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("startpricetime")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endpricetime"))) {
            return null;
        }
        int startYears = Integer.parseInt(dynamicObject.getString("startyears"));
        int endYears = Integer.parseInt(dynamicObject.getString("endyears"));
        int startMonth = Integer.parseInt(dynamicObject.getString("startpricetime"));
        int endMonth = Integer.parseInt(dynamicObject.getString("endpricetime"));
        DynamicObject accountPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (accountPeriod == null) {
            return null;
        }
        DynamicObject currentPeriod = BusinessDataServiceHelper.loadSingle((Object)accountPeriod.getLong("id"), (String)"bd_period");
        if (currentPeriod == null) {
            return null;
        }
        Object periodTypeId = currentPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter qFilter = new QFilter("periodtype.id", "=", periodTypeId);
        if (startYears == 1) {
            startYears = year;
        } else if (startYears == 2) {
            startYears = year - 1;
        } else if (startYears == 3) {
            startYears = year - 2;
        } else if (startYears == 21) {
            startYears = year + 1;
        } else if (startYears == 22) {
            startYears = year + 2;
        }
        if (endYears == 1) {
            endYears = year;
        } else if (endYears == 2) {
            endYears = year - 1;
        } else if (endYears == 3) {
            endYears = year - 2;
        } else if (endYears == 21) {
            endYears = year + 1;
        } else if (endYears == 22) {
            endYears = year + 2;
        }
        if (startMonth == 13) {
            startPeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod.getLong("id"));
        } else if (startMonth == 14) {
            startPeriod = currentPeriod;
        } else {
            QFilter startQFilter = new QFilter("periodyear", "=", (Object)startYears);
            startQFilter.and("periodnumber", "=", (Object)startMonth);
            startPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])new QFilter[]{qFilter, startQFilter});
        }
        if (endMonth == 13) {
            endPeriod = PeriodHelper.getPreviousPeriod((Object)currentPeriod.getLong("id"));
        } else if (endMonth == 14) {
            endPeriod = currentPeriod;
        } else {
            QFilter endQFilter = new QFilter("periodyear", "=", (Object)endYears);
            endQFilter.and("periodnumber", "=", (Object)endMonth);
            endPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])new QFilter[]{qFilter, endQFilter});
        }
        if (startPeriod == null || endPeriod == null) {
            return null;
        }
        List startToEndPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        QFilter timeFilter = new QFilter("period", "in", (Object)startToEndPeriodIds);
        return timeFilter;
    }

    private static DynamicObjectCollection getCostTypeOrg(long costType) {
        QFilter costFilter = new QFilter("id", "=", (Object)costType);
        costFilter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        ArrayList costTypeList = new ArrayList(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtypeId", (QFilter[])new QFilter[]{costFilter});
        if (dynamicObjects.isEmpty()) {
            return null;
        }
        dynamicObjects.forEach(r -> costTypeList.add(r.getLong("costtypeId")));
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeList), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        return QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])filters);
    }

    private static DataSet getWorkCenter(DataSet result) {
        result = result.filter("resource is not null");
        Iterator iterator = result.copy().iterator();
        ArrayList<Long> costCenterIds = new ArrayList<Long>(20);
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            costCenterIds.add(next.getLong("costcenter"));
        }
        Date now = new Date();
        QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
        ccFilter.and("effectdate", "<=", (Object)now);
        ccFilter.and("expdate", ">", (Object)now);
        ccFilter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
        DataSet wsDs = QueryServiceHelper.queryDataSet((String)"ResourceRateAutoService_getWorkCenter", (String)"bos_costcentersourcemap", (String)"costcenter,entryentity.sourcedata as workcenter", (QFilter[])new QFilter[]{ccFilter}, null);
        result = !wsDs.isEmpty() ? result.leftJoin(wsDs).on("costcenter", "costcenter").select(result.getRowMeta().getFieldNames(), new String[]{"workcenter"}).finish() : result.addField("'0'", "workcenter");
        return result;
    }
}

