/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.price.Supplier;

public class PurchaseOrderForOutResource
extends AbstractPurchasePrice
implements PurEventPlugin {
    public PurchaseOrderForOutResource() {
        super("cad_outsourceprice", "outsupentry", true);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        this.ruleId = ruleId;
        ArrayList<PricePluginPojo> results = new ArrayList<PricePluginPojo>();
        return results;
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return null;
    }

    private Set<Long> getMaterials(Long costTypeId, List<Long> prodOrgIds) {
        HashSet<Long> materials = new HashSet<Long>(16);
        QFilter purPriceQF = new QFilter("billstatus", "=", (Object)"C");
        DataSet pmPurorderlist = QueryServiceHelper.queryDataSet((String)"PurchasePriceForResourceOut.getMaterials", (String)"pm_purorderbill", (String)"billentry.material.masterid material", (QFilter[])purPriceQF.toArray(), null);
        pmPurorderlist = pmPurorderlist.groupBy(new String[]{"material"}).finish();
        Boolean startBomRule = this.isStartBomRule(costTypeId);
        if (startBomRule.booleanValue()) {
            purPriceQF = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            QFilter matInfoQF = MatBaseDataFilterHelper.getOrgCtrlQfilter(prodOrgIds, (String)"bd_materialmftinfo");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchaseOrderForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{purPriceQF, matInfoQF}, null);
            materialInfos = pmPurorderlist.join(materialInfos, JoinType.LEFT).on("material", "masterid").select(pmPurorderlist.getRowMeta().getFieldNames(), new String[]{"materialattr", "ctrlstrategy", "level"}).finish().orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                String materialAttr = row.getString("materialattr");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                if ("10050".equals(materialAttr)) {
                    materials.add(material);
                }
                existMats.add(material);
            }
        } else {
            purPriceQF = new QFilter("costtype", "=", (Object)costTypeId).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchaseOrderForPurPrices.getMaterials#3", (String)"cad_bomsetting", (String)"material,matcalcprop", (QFilter[])new QFilter[]{purPriceQF}, null);
            materialInfos = materialInfos.groupBy(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = pmPurorderlist.join(materialInfos, JoinType.LEFT).on("material", "material").select(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = materialInfos.filter("matcalcprop='C'");
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
        }
        return materials;
    }

    private void buildPricePojo(List<PricePluginPojo> results, Long currency, List<Row> toDealList) {
        if (toDealList.isEmpty()) {
            return;
        }
        PricePluginPojo pricePluginPojo = new PricePluginPojo();
        pricePluginPojo.setCurrency(currency.longValue());
        pricePluginPojo.setMaterialId(toDealList.get(0).getLong("material").longValue());
        pricePluginPojo.setAuxptyId(toDealList.get(0).getLong("auxpty").longValue());
        List suppliers = pricePluginPojo.getSuppliers();
        BigDecimal qtySum = BigDecimal.ZERO;
        HashMap<Long, BigDecimal[]> supplierQtyCostMap = new HashMap<Long, BigDecimal[]>(16);
        for (Row row : toDealList) {
            BigDecimal[] qtyCost;
            BigDecimal qty = row.get("qty") == null ? BigDecimal.ZERO : row.getBigDecimal("qty");
            BigDecimal amount = row.get("amount") == null ? BigDecimal.ZERO : row.getBigDecimal("amount");
            Long supplierId = row.getLong("supplier");
            if (supplierQtyCostMap.containsKey(supplierId)) {
                qtyCost = (BigDecimal[])supplierQtyCostMap.get(supplierId);
                qtyCost[0] = qtyCost[0].add(qty);
                amount = this.transformRate(currency, row, amount);
                qtyCost[1] = qtyCost[1].add(amount);
                continue;
            }
            qtyCost = new BigDecimal[]{qty, this.transformRate(currency, row, amount)};
            supplierQtyCostMap.put(supplierId, qtyCost);
        }
        for (Row row : toDealList) {
            BigDecimal[] qtyCost;
            Long supplierId = row.getLong("supplier");
            if (!supplierQtyCostMap.containsKey(supplierId) || (qtyCost = (BigDecimal[])supplierQtyCostMap.remove(supplierId)) == null) continue;
            BigDecimal qty = qtyCost[0];
            BigDecimal amount = qtyCost[1];
            Supplier supplier = new Supplier();
            supplier.setSupplierId(row.getLong("supplier").longValue());
            supplier.setQuoaratio(qty);
            BigDecimal price = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(qty, 10, 4);
            supplier.setUnitPrice(price);
            suppliers.add(supplier);
            qtySum = qtySum.add(qty);
        }
        BigDecimal quoaratioAdd = BigDecimal.ZERO;
        for (int i = 0; i < suppliers.size(); ++i) {
            Supplier supplier = (Supplier)suppliers.get(i);
            BigDecimal quoaratio = supplier.getQuoaratio();
            if (i == suppliers.size() - 1) {
                supplier.setQuoaratio(new BigDecimal(100).subtract(quoaratioAdd));
                continue;
            }
            BigDecimal num = quoaratio.multiply(new BigDecimal(100)).divide(qtySum, 10, 4);
            supplier.setQuoaratio(num);
            quoaratioAdd = quoaratioAdd.add(num);
        }
        BigDecimal amount = BigDecimal.ZERO;
        if (!pricePluginPojo.getSuppliers().isEmpty()) {
            for (Supplier supplier : pricePluginPojo.getSuppliers()) {
                BigDecimal amountFactor = supplier.getUnitPrice().multiply(supplier.getQuoaratio()).divide(new BigDecimal(100), 10, 4);
                amount = amount.add(amountFactor);
            }
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        pricePluginPojo.setAmount(amount.setScale(this.priceprecision, 4));
        this.initPricePluginPojo(pricePluginPojo);
        results.add(pricePluginPojo);
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }
}

