/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;

public class PurchasePriceForOutResource
extends AbstractPurchasePrice
implements PurEventPlugin {
    private Long costTypeId = 0L;
    private Map<Long, Long> outSourceEleMap;

    public PurchasePriceForOutResource() {
        super("cad_outsourceprice", "outsupentry", true);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        this.costTypeId = costTypeId;
        this.outSourceEleMap = this.getEleDefaultSubEleMap(ElementConstant.OUTWORK_ID, 773176488857077760L);
        return super.pricingCall(entity, orgId, costTypeId, ruleId);
    }

    @Override
    public List<DynamicObject> pkgFetchPriceParams(List<Map<String, Object>> collectParams, long ruleId, Set<Long> keyIds, Set<Long> purMatIds) {
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map<String, Object> collectParam : collectParams) {
            if (collectParam.get("entry") == null) continue;
            List supplierEntrys = (List)collectParam.get("entry");
            for (Map map : supplierEntrys) {
                Long supplierId = (Long)map.get("supplierId");
                supplierIds.add(supplierId);
            }
        }
        Map supplierDOMap = BusinessDataServiceHelper.loadFromCache((Object[])supplierIds.toArray(), (String)"bd_supplier");
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"cad_calcrule");
        ArrayList<DynamicObject> purPricesDOList = new ArrayList<DynamicObject>(collectParams.size());
        for (Map map : collectParams) {
            DynamicObject cadPurpricesDO = BusinessDataServiceHelper.newDynamicObject((String)"cad_outsourceprice");
            cadPurpricesDO.set("id", map.get("materialId"));
            cadPurpricesDO.set("material", map.get("materialId"));
            cadPurpricesDO.set("pricerule", (Object)rule);
            cadPurpricesDO.set("createtime", (Object)new Date());
            if (map.get("entry") != null) {
                DynamicObjectCollection pursupentrys = cadPurpricesDO.getDynamicObjectCollection("outsupentry");
                List supplierEntrys = (List)map.get("entry");
                for (Map supplierEntry : supplierEntrys) {
                    Long supplierId = (Long)supplierEntry.get("supplierId");
                    DynamicObject pursupentry = pursupentrys.addNew();
                    pursupentry.set("id", (Object)supplierId);
                    pursupentry.set("supplier", supplierDOMap.get(supplierId));
                    pursupentry.set("quotaratio", supplierEntry.get("quotaRate"));
                }
            }
            purPricesDOList.add(cadPurpricesDO);
        }
        return purPricesDOList;
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
        if (this.outSourceEleMap == null) {
            pricePluginPojo.setElementId(ElementConstant.OUTWORK_ID.longValue());
            pricePluginPojo.setSubElementId(773176488857077760L);
        } else {
            pricePluginPojo.setElementId(ElementConstant.OUTWORK_ID.longValue());
            pricePluginPojo.setSubElementId(this.outSourceEleMap.get(ElementConstant.OUTWORK_ID).longValue());
        }
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return this.getMaterials(this.costTypeId, proOrgIds);
    }

    private Set<Long> getMaterials(Long costTypeId, List<Long> proOrgIds) {
        HashSet<Long> materials = new HashSet<Long>(16);
        QFilter purPriceQF = new QFilter("status", "=", (Object)"C");
        purPriceQF.and("enable", "=", (Object)"1");
        DataSet pmPurpricelist = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#1", (String)"pm_purpricelist", (String)"priceentryentity.material.masterid.id material", (QFilter[])purPriceQF.toArray(), null);
        pmPurpricelist = pmPurpricelist.groupBy(new String[]{"material"}).finish();
        Boolean startBomRule = this.isStartBomRule(costTypeId);
        if (startBomRule.booleanValue()) {
            purPriceQF = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            QFilter matInfoQF = MatBaseDataFilterHelper.getOrgCtrlQfilter(proOrgIds, (String)"bd_materialmftinfo");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{purPriceQF, matInfoQF}, null);
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "masterid").select(pmPurpricelist.getRowMeta().getFieldNames(), new String[]{"materialattr", "ctrlstrategy", "level"}).finish().orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                String materialAttr = row.getString("materialattr");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                if ("10050".equals(materialAttr)) {
                    materials.add(material);
                }
                existMats.add(material);
            }
        } else {
            purPriceQF = new QFilter("costtype", "=", (Object)costTypeId).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#3", (String)"cad_bomsetting", (String)"material,matcalcprop", (QFilter[])new QFilter[]{purPriceQF}, null);
            materialInfos = materialInfos.groupBy(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "material").select(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = materialInfos.filter("matcalcprop='C'");
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
        }
        return materials;
    }
}

