/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.price.CostInfoDetail;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.price.Supplier;

public class PurchasePriceForPurPrices
extends AbstractPurchasePrice
implements PurEventPlugin {
    private final Map<Long, PricePluginPojo> material2Pojo = new HashMap<Long, PricePluginPojo>(16);
    private final Map<DynamicObject, Long> priceType2Element = new HashMap<DynamicObject, Long>(16);
    private List<Object> rateSettingSubEles = new ArrayList<Object>(10);
    private Long costTypeId = 0L;

    public PurchasePriceForPurPrices() {
        super("cad_purprices", "pursupentry", true);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        this.rateSettingSubEles = this.getMoreZeroRateSetting(costTypeId);
        this.costTypeId = costTypeId;
        return this.pricingCall(entity, orgId, costTypeId, ruleId);
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return this.getMaterials(this.costTypeId, proOrgIds);
    }

    private Set<Long> getMaterials(Long costTypeId, List<Long> purOrgIds) {
        HashSet<Long> materials = new HashSet<Long>(16);
        QFilter purPriceQF = new QFilter("status", "=", (Object)"C");
        purPriceQF.and("enable", "=", (Object)"1");
        DataSet pmPurpricelist = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#1", (String)"pm_purpricelist", (String)"priceentryentity.material.masterid.id material", (QFilter[])purPriceQF.toArray(), null);
        pmPurpricelist = pmPurpricelist.groupBy(new String[]{"material"}).finish();
        Boolean startBomRule = this.isStartBomRule(costTypeId);
        if (startBomRule.booleanValue()) {
            purPriceQF = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            QFilter matInfoQF = MatBaseDataFilterHelper.getOrgCtrlQfilter(purOrgIds, (String)"bd_materialmftinfo");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{purPriceQF, matInfoQF}, null);
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "masterid").select(pmPurpricelist.getRowMeta().getFieldNames(), new String[]{"materialattr", "ctrlstrategy", "level"}).finish().orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                String materialAttr = row.getString("materialattr");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                if ("10040".equals(materialAttr) || materialAttr == null) {
                    materials.add(material);
                }
                existMats.add(material);
            }
        } else {
            purPriceQF = new QFilter("costtype", "=", (Object)costTypeId).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#3", (String)"cad_bomsetting", (String)"material,matcalcprop", (QFilter[])new QFilter[]{purPriceQF}, null);
            materialInfos = materialInfos.groupBy(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "material").select(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = materialInfos.filter("matcalcprop='B' or matcalcprop is null");
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
        }
        return materials;
    }

    public void initPricePlugin(PricePluginPojo pricePluginPojo) {
    }

    @Override
    public List<DynamicObject> pkgFetchPriceParams(List<Map<String, Object>> collectParams, long ruleId, Set<Long> keyIds, Set<Long> purMatIds) {
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map<String, Object> collectParam : collectParams) {
            if (collectParam.get("entry") == null) continue;
            List supplierEntrys = (List)collectParam.get("entry");
            for (Object supplierEntry : supplierEntrys) {
                Long supplierId = (Long)supplierEntry.get("supplierId");
                supplierIds.add(supplierId);
            }
        }
        Map supplierDOMap = BusinessDataServiceHelper.loadFromCache((Object[])supplierIds.toArray(), (String)"bd_supplier");
        Map<Long, Long> defEleSubEleMap = this.getDefEleSubEleMap();
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"cad_calcrule");
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject pricelisttype = dynamicObject.getDynamicObject("pricelisttype");
            long element = dynamicObject.getLong("element.id");
            this.priceType2Element.put(pricelisttype, element);
        }
        ArrayList<DynamicObject> purPricesDOList = new ArrayList<DynamicObject>(collectParams.size());
        for (Map<String, Object> collectParam : collectParams) {
            long id = (Long)collectParam.get("materialId");
            if (this.priceType2Element.keySet().isEmpty()) {
                DynamicObject cadPurpricesDO = this.buildFetchPriceParam(keyIds, supplierDOMap, rule, collectParam, id, 0L, null);
                purPricesDOList.add(cadPurpricesDO);
                continue;
            }
            for (Map.Entry<DynamicObject, Long> entry : this.priceType2Element.entrySet()) {
                Long subEle;
                DynamicObject priceType = entry.getKey();
                Long elementId = entry.getValue();
                if (defEleSubEleMap.containsKey(elementId) && this.rateSettingSubEles.contains(subEle = defEleSubEleMap.get(elementId))) continue;
                DynamicObject cadPurpricesDO = this.buildFetchPriceParam(keyIds, supplierDOMap, rule, collectParam, id, 0L, priceType);
                purPricesDOList.add(cadPurpricesDO);
            }
        }
        return purPricesDOList;
    }

    private Map<Long, Long> getDefEleSubEleMap() {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("issystem", "=", (Object)Boolean.TRUE));
        DataSet eleDataSet = QueryServiceHelper.queryDataSet((String)"getDefEleSubEleMap#1", (String)"cad_element", (String)"id element,type", (QFilter[])new QFilter[]{filter}, null);
        DataSet subEleDataSet = QueryServiceHelper.queryDataSet((String)"getDefEleSubEleMap#2", (String)"cad_subelement", (String)"id subelement,type", (QFilter[])new QFilter[]{filter}, null);
        DataSet dataSet = eleDataSet.join(subEleDataSet, JoinType.INNER).on("type", "type").select(eleDataSet.getRowMeta().getFieldNames(), new String[]{"subelement"}).finish();
        HashMap<Long, Long> defEleSubEleMap = new HashMap<Long, Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long element = row.getLong("element");
            Long subElement = row.getLong("subelement");
            if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Long)element) || kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Long)subElement)) continue;
            defEleSubEleMap.put(element, subElement);
        }
        return defEleSubEleMap;
    }

    public DynamicObject buildFetchPriceParam(Set<Long> keyIds, Map<Object, DynamicObject> supplierDOMap, DynamicObject rule, Map<String, Object> collectParam, long id, long auxptyId, DynamicObject priceType) {
        DynamicObject cadPurpricesDO = BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices");
        while (!keyIds.add(id)) {
            ++id;
        }
        cadPurpricesDO.set("id", (Object)id);
        cadPurpricesDO.set("material", collectParam.get("materialId"));
        cadPurpricesDO.set("pricerule", (Object)rule);
        cadPurpricesDO.set("createtime", (Object)new Date());
        cadPurpricesDO.set("auxpty", (Object)auxptyId);
        cadPurpricesDO.set("pricelisttype", (Object)priceType);
        DynamicObjectCollection pursupentrys = cadPurpricesDO.getDynamicObjectCollection(this.billEntryIden);
        List supplierEntrys = (List)collectParam.get("entry");
        for (Map supplierEntry : supplierEntrys) {
            Long supplierId = (Long)supplierEntry.get("supplierId");
            DynamicObject pursupentry = pursupentrys.addNew();
            pursupentry.set("id", (Object)supplierId);
            pursupentry.set("supplier", (Object)supplierDOMap.get(supplierId));
            pursupentry.set("quotaratio", supplierEntry.get("quotaRate"));
        }
        return cadPurpricesDO;
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }

    @Override
    public void pkgResultData(List<PricePluginPojo> res, long currency, List<DynamicObject> purPricesDOList, Map<String, Object> featchPriceMap, Map<String, BigDecimal> matToManuPrice, long ruleId) {
        for (DynamicObject purPrices : purPricesDOList) {
            Supplier supplier3;
            PricePluginPojo pricePluginPojo = new PricePluginPojo();
            pricePluginPojo.setCurrency(currency);
            pricePluginPojo.setMaterialId(purPrices.getLong("material"));
            pricePluginPojo.setAuxptyId(0L);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal entrySum = BigDecimal.ZERO;
            DynamicObjectCollection pursupentry = purPrices.getDynamicObjectCollection(this.billEntryIden);
            String splitChar = "$$";
            ArrayList<Supplier> supplierList = new ArrayList<Supplier>();
            if (pursupentry.isEmpty()) {
                String key = this.jointKeyNoEnd(splitChar, purPrices.getString("id"), "0", "0");
                amount = featchPriceMap.get((String)key + "unitprice") == null ? BigDecimal.ZERO : (BigDecimal)featchPriceMap.get((String)key + "unitprice");
                amount = this.transformRate(currency, featchPriceMap, key, amount);
                Long supplierId = (Long)featchPriceMap.get((String)key + "supplier");
                if (supplierId == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                supplier3 = new Supplier();
                supplier3.setSupplierId(supplierId.longValue());
                supplier3.setQuoaratio(new BigDecimal(100));
                entrySum = new BigDecimal(100);
                supplier3.setUnitPrice(amount.setScale(this.priceprecision, RoundingMode.HALF_UP));
                supplier3.setManualPrice(false);
                Map extFieldMap = supplier3.getExtFieldMap();
                extFieldMap.put("pricetype", featchPriceMap.get((String)key + "pricetype"));
                supplierList.add(supplier3);
            } else {
                for (DynamicObject entry : pursupentry) {
                    String key = this.jointKeyNoEnd(splitChar, purPrices.getString("id"), entry.getString("id"), entry.getString("seq"));
                    BigDecimal unitPrice = featchPriceMap.get(key + "unitprice") == null ? BigDecimal.ZERO : (BigDecimal)featchPriceMap.get(key + "unitprice");
                    unitPrice = this.transformRate(currency, featchPriceMap, key, unitPrice);
                    boolean manualPrice = false;
                    if (unitPrice.compareTo(BigDecimal.ZERO) == 0 && this.isManualspecified) {
                        unitPrice = matToManuPrice.get(purPrices.getString("material"));
                        manualPrice = true;
                    }
                    if (unitPrice == null || unitPrice.compareTo(BigDecimal.ZERO) == 0) continue;
                    entrySum = entrySum.add(entry.getBigDecimal("quotaratio"));
                    Supplier supplier2 = new Supplier();
                    supplier2.setSupplierId(entry.getDynamicObject("supplier").getLong("id"));
                    supplier2.setQuoaratio(entry.getBigDecimal("quotaratio"));
                    supplier2.setUnitPrice(unitPrice.setScale(this.priceprecision, RoundingMode.HALF_UP));
                    supplier2.setManualPrice(manualPrice);
                    Map extFieldMap = supplier2.getExtFieldMap();
                    extFieldMap.put("pricetype", featchPriceMap.get(key + "pricetype"));
                    supplierList.add(supplier2);
                }
            }
            BigDecimal quoaratioAdd = BigDecimal.ZERO;
            for (int i = 0; i < supplierList.size(); ++i) {
                supplier3 = (Supplier)supplierList.get(i);
                BigDecimal quoaratio = supplier3.getQuoaratio();
                if (i == supplierList.size() - 1) {
                    supplier3.setQuoaratio(new BigDecimal(100).subtract(quoaratioAdd));
                    continue;
                }
                BigDecimal num = new BigDecimal(100).divide(entrySum, 2, RoundingMode.HALF_UP);
                BigDecimal multiply = quoaratio.multiply(num);
                quoaratioAdd = quoaratioAdd.add(quoaratio.multiply(num));
                supplier3.setQuoaratio(multiply);
            }
            amount = BigDecimal.ZERO;
            pricePluginPojo.setSuppliers(supplierList);
            if (!pricePluginPojo.getSuppliers().isEmpty()) {
                for (Supplier supplier3 : pricePluginPojo.getSuppliers()) {
                    if (entrySum.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal amountFactor = supplier3.getUnitPrice().multiply(supplier3.getQuoaratio()).divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
                    amount = amount.add(amountFactor);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            pricePluginPojo.setAmount(amount.setScale(this.priceprecision, RoundingMode.HALF_UP));
            this.initPricePlugin(pricePluginPojo);
            List costInfoDetailList = pricePluginPojo.getCostInfoDetailList();
            DynamicObject pricelisttype = purPrices.getDynamicObject("pricelisttype");
            Long element = this.priceType2Element.get(pricelisttype);
            CostInfoDetail costInfoDetail = new CostInfoDetail();
            costInfoDetail.setPrice(amount);
            if (element == null) {
                costInfoDetail.setElement(773126985240072192L);
                costInfoDetail.setSubElement(773175233367685120L);
            } else if (element.equals(773141433937984512L)) {
                costInfoDetail.setElement(773141433937984512L);
                costInfoDetail.setSubElement(773175492709890048L);
            } else {
                costInfoDetail.setElement(773126985240072192L);
                costInfoDetail.setSubElement(773175233367685120L);
            }
            costInfoDetailList.add(costInfoDetail);
            PricePluginPojo pricePluginPojoExist = this.material2Pojo.get(purPrices.getLong("material"));
            if (pricePluginPojoExist == null) {
                this.material2Pojo.put(purPrices.getLong("material"), pricePluginPojo);
                res.add(pricePluginPojo);
                continue;
            }
            this.merge(pricePluginPojo, pricePluginPojoExist);
        }
    }

    private void merge(PricePluginPojo pricePluginPojo, PricePluginPojo pricePluginPojoed) {
        List costInfoDetailListeds = pricePluginPojoed.getCostInfoDetailList();
        List costInfoDetailList = pricePluginPojo.getCostInfoDetailList();
        if (costInfoDetailList != null && !costInfoDetailList.isEmpty()) {
            boolean flag = false;
            CostInfoDetail costInfoDetail = (CostInfoDetail)costInfoDetailList.get(0);
            for (CostInfoDetail costInfoDetailed : costInfoDetailListeds) {
                if (costInfoDetailed.getElement() != costInfoDetail.getElement()) continue;
                costInfoDetailed.setPrice(costInfoDetailed.getPrice().add(costInfoDetail.getPrice()));
                flag = true;
            }
            if (!flag) {
                costInfoDetailListeds.add(costInfoDetail);
            }
            pricePluginPojoed.getSuppliers().addAll(pricePluginPojo.getSuppliers());
        }
    }

    private List<Object> getMoreZeroRateSetting(Long costType) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("entryentity.stdrate", ">", (Object)BigDecimal.ZERO));
        DynamicObjectCollection stdRateSettings = QueryServiceHelper.query((String)"cad_stdratesetting", (String)"entryentity.subelement subelement", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getFieldList((DynamicObjectCollection)stdRateSettings, (String)"subelement");
    }
}

