/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.price.AbstractPurchasePrice;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;

public class PurchasePriceForResourceOut
extends AbstractPurchasePrice
implements PurEventPlugin {
    private Long costTypeId = 0L;

    public PurchasePriceForResourceOut() {
        super("cad_resourceout", "ressupentry", true);
    }

    public List<PricePluginPojo> pricingPluginCall(String entity, long orgId, long costTypeId, long ruleId, String appNum, Map<String, Object> map) {
        return new ArrayList<PricePluginPojo>();
    }

    @Override
    public List<DynamicObject> pkgFetchPriceParams(List<Map<String, Object>> collectParams, long ruleId, Set<Long> keyIds, Set<Long> purMatIds) {
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"cad_calcrule");
        ArrayList<DynamicObject> purPricesDOList = new ArrayList<DynamicObject>(purMatIds.size());
        for (Long id : purMatIds) {
            DynamicObject cadPurpricesDO = BusinessDataServiceHelper.newDynamicObject((String)"cad_resourceout");
            cadPurpricesDO.set("id", (Object)id);
            cadPurpricesDO.set("material", (Object)id);
            cadPurpricesDO.set("pricerule", (Object)rule);
            cadPurpricesDO.set("createtime", (Object)new Date());
            purPricesDOList.add(cadPurpricesDO);
        }
        return purPricesDOList;
    }

    @Override
    public void initPricePluginPojo(PricePluginPojo pricePluginPojo) {
    }

    @Override
    public Set<Long> getMaterials(List<Long> proOrgIds) {
        return this.getMaterials(this.costTypeId, proOrgIds);
    }

    private Set<Long> getMaterials(Long costTypeId, List<Long> proOrgIds) {
        HashSet<Long> materials = new HashSet<Long>(16);
        QFilter purPriceQF = new QFilter("status", "=", (Object)"C");
        purPriceQF.and("enable", "=", (Object)"1");
        DataSet pmPurpricelist = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#1", (String)"pm_purpricelist", (String)"priceentryentity.material.masterid.id material", (QFilter[])purPriceQF.toArray(), null);
        pmPurpricelist = pmPurpricelist.groupBy(new String[]{"material"}).finish();
        Boolean startBomRule = this.isStartBomRule(costTypeId);
        if (startBomRule.booleanValue()) {
            purPriceQF = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
            QFilter matInfoQF = MatBaseDataFilterHelper.getOrgCtrlQfilter(proOrgIds, (String)"bd_materialmftinfo");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#2", (String)"bd_materialmftinfo", (String)"masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{purPriceQF, matInfoQF}, null);
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "masterid").select(pmPurpricelist.getRowMeta().getFieldNames(), new String[]{"materialattr", "ctrlstrategy", "level"}).finish().orderBy(new String[]{"ctrlstrategy desc", "level asc"});
            HashSet<Long> existMats = new HashSet<Long>(10);
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                String materialAttr = row.getString("materialattr");
                if (CadEmptyUtils.isEmpty((Long)material) || existMats.contains(material)) continue;
                if ("10020".equals(materialAttr) || "10030".equals(materialAttr)) {
                    materials.add(material);
                }
                existMats.add(material);
            }
        } else {
            purPriceQF = new QFilter("costtype", "=", (Object)costTypeId).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            DataSet materialInfos = QueryServiceHelper.queryDataSet((String)"PurchasePriceForPurPrices.getMaterials#3", (String)"cad_bomsetting", (String)"material,matcalcprop", (QFilter[])new QFilter[]{purPriceQF}, null);
            materialInfos = materialInfos.groupBy(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = pmPurpricelist.join(materialInfos, JoinType.LEFT).on("material", "material").select(new String[]{"material", "matcalcprop"}).finish();
            materialInfos = materialInfos.filter("matcalcprop='A'");
            while (materialInfos.hasNext()) {
                Row row = materialInfos.next();
                Long material = row.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                materials.add(material);
            }
        }
        return materials;
    }
}

