/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.router;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.EntityUtil;

public class SyncRouterHandle {
    private static final Log logger = LogFactory.getLog(SyncRouterHandle.class);

    public static void syncRouter(String entity, List<Object> routerIds) {
        int syncRouterBatchSize = CadBgParamUtils.getCadParamForInt((String)"pushSyncRouteBatchSize", (int)5000);
        Lists.partition(routerIds, (int)syncRouterBatchSize).forEach(routerIdSubList -> {
            Map<DynamicObject, Set<Long>> ruleAndIds = SyncRouterHandle.filterRouterIds(entity, routerIdSubList);
            SyncRouterHandle.doSyncRouter(entity, ruleAndIds);
        });
    }

    private static void doSyncRouter(String entity, Map<DynamicObject, Set<Long>> ruleAndIds) {
        ArrayList<DynamicObject> routers = new ArrayList<DynamicObject>();
        List<DynamicObject> tempCostRouter = null;
        for (Map.Entry<DynamicObject, Set<Long>> entry : ruleAndIds.entrySet()) {
            tempCostRouter = SyncRouterHandle.createCostRouter(entity, entry.getKey(), entry.getValue());
            routers.addAll(tempCostRouter);
        }
        SyncRouterHandle.saveCostRouter(routers);
    }

    private static List<DynamicObject> createCostRouter(String entity, DynamicObject rule, Set<Long> productRouterIds) {
        ArrayList<DynamicObject> costRouters = new ArrayList<DynamicObject>(10);
        QFilter ruleFs = SyncRouterHandle.parseQfilter(rule);
        QFilter fs = new QFilter("id", "in", productRouterIds);
        if (ruleFs != null) {
            fs.and(ruleFs);
        }
        logger.info("\u540c\u6b65\u89c4\u5219\uff1a" + rule + "\uff0c\u89c4\u5219\u8fc7\u6ee4\u6761\u4ef6\uff1a" + fs);
        List proRouterIds = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{fs}, null, (int)-1);
        Object[] processroutes = BusinessDataServiceHelper.load((Object[])proRouterIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        if (CadEmptyUtils.isEmpty((Object[])processroutes)) {
            return costRouters;
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptFilter = new QFilter("isuseauxpty", "=", (Object)Boolean.TRUE);
        DataSet materials = QueryServiceHelper.queryDataSet((String)"material", (String)"bd_material", (String)"id,masterid as masterId", (QFilter[])new QFilter[]{statusFilter, enableFilter, auxptFilter}, null);
        HashSet<Long> matWithAuxpt = new HashSet<Long>(10);
        for (Row material : materials) {
            matWithAuxpt.add(material.getLong("masterId"));
        }
        for (Object processroute : processroutes) {
            DynamicObject cadrouter = BusinessDataServiceHelper.newDynamicObject((String)"cad_router");
            EntityUtil.copyPropertiesWithOutId((DynamicObject)cadrouter, (DynamicObject)processroute);
            SyncRouterHandle.fillBaseInfo(cadrouter, (DynamicObject)processroute, rule, matWithAuxpt);
            costRouters.add(cadrouter);
        }
        return costRouters;
    }

    private static void fillBaseInfo(DynamicObject cadrouter, DynamicObject processRoute, DynamicObject rule, Set<Long> matWithAuxpt) {
        Object org = rule.get("calorg");
        Object syncUser = rule.get("syncuser");
        cadrouter.set("useorg", org);
        cadrouter.set("org", org);
        cadrouter.set("status", (Object)"C");
        cadrouter.set("creator", syncUser);
        cadrouter.set("creator_id", syncUser);
        cadrouter.set("createtime", (Object)new Date());
        cadrouter.set("auditor", syncUser);
        cadrouter.set("auditor_id", syncUser);
        cadrouter.set("audittime", (Object)new Date());
        cadrouter.set("synctime", (Object)processRoute.getDate("audittime"));
        cadrouter.set("ctrlstrategy", (Object)BaseDataServiceHelper.getBdCtrlStrgy((String)"cad_router", (String)String.valueOf(org)));
        DynamicObject createOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        createOrg.set("id", org);
        cadrouter.set("createorg", (Object)createOrg);
        cadrouter.set("sourceid", (Object)processRoute.getLong("id"));
        cadrouter.set("manuorg", processRoute.get("createorg"));
        if (cadrouter.getDynamicObject("material") != null) {
            Object materialId = cadrouter.getDynamicObject("material").getPkValue();
            cadrouter.set("material", materialId);
            if (matWithAuxpt.contains(Long.valueOf(String.valueOf(materialId))) && (processRoute.getDynamicObject("auxproperty") == null || processRoute.getDynamicObject("auxproperty").getLong("id") == 0L)) {
                cadrouter.set("status", (Object)"A");
                cadrouter.set("auditor", (Object)0L);
                cadrouter.set("auditor_id", (Object)0L);
                cadrouter.set("audittime", null);
            }
            cadrouter.set("auxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)cadrouter.get("material"), (Object)cadrouter.get("auxproperty")));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", cadrouter.get("material.masterid"));
            keycolMap.put("auxproperty", cadrouter.get("auxproperty"));
            cadrouter.set("keycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol());
        }
    }

    private static QFilter parseQfilter(DynamicObject rule) {
        String fsStr = rule.getString("filter_tag");
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)fsStr, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)"pdm_route"), condition);
        fb.buildFilter();
        QFilter qFilter = fb.getQFilter();
        QFilter matTypeFilter = new QFilter("material.configproperties", "!=", (Object)"2");
        qFilter.and(matTypeFilter);
        return qFilter;
    }

    private static void saveCostRouter(List<DynamicObject> routers) {
        if (routers.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"kd.macc.cad.business.router.SyncRouterHandle.saveCostRouter");){
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            block14: for (DynamicObject router : routers) {
                ArrayList<DynamicObject> actentrys = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection routersEntry = router.getDynamicObjectCollection("processentry");
                for (DynamicObject routerSubEntry : routersEntry) {
                    DynamicObjectCollection actEntryEntity = routerSubEntry.getDynamicObjectCollection("actentryentity");
                    for (DynamicObject act : actEntryEntity) {
                        actentrys.add(act);
                    }
                }
                if (CadEmptyUtils.isEmpty(actentrys)) continue;
                for (DynamicObject actentry : actentrys) {
                    if (CadEmptyUtils.isEmpty((Long)actentry.getLong("actresource.id"))) continue;
                    list.add(router);
                    continue block14;
                }
            }
            Object[] array = list.toArray(new DynamicObject[0]);
            if (CadEmptyUtils.isEmpty((Object[])array)) {
                return;
            }
            try {
                SaveServiceHelper.save((DynamicObject[])array);
                SyncRouterHandle.insertUseOrgData((DynamicObject[])array);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6210\u672c\u5de5\u827a\u8def\u7ebf\u540c\u6b65\u65f6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
    }

    private static void insertUseOrgData(DynamicObject[] productRouters) {
        IDataEntityType entityType = productRouters[0].getDataEntityType();
        String tb = entityType.getAlias() + "_U";
        String insertSql = "insert into " + tb + " (fuseorgid, FDataID) values (?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (DynamicObject pro : productRouters) {
            params.add(new Object[]{pro.getLong("createorg.id"), pro.getPkValue()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)insertSql, params);
    }

    private static Map<DynamicObject, Set<Long>> filterRouterIds(String entity, List<Object> routerIds) {
        Map<Long, List<Long>> billOrgs = SyncRouterHandle.getCalOrg(entity, routerIds);
        Map<Long, DynamicObject> orgRules = SyncRouterHandle.getOrgSyncRule(billOrgs);
        HashMap<DynamicObject, Set<Long>> idGroup = new HashMap<DynamicObject, Set<Long>>();
        for (Map.Entry<Long, List<Long>> bomEntry : billOrgs.entrySet()) {
            for (Long orgId : bomEntry.getValue()) {
                DynamicObject rule = orgRules.get(orgId);
                if (rule == null) continue;
                HashSet<Long> ids = (HashSet<Long>)idGroup.get(rule);
                if (ids == null) {
                    ids = new HashSet<Long>();
                    idGroup.put(rule, ids);
                }
                ids.add(bomEntry.getKey());
            }
        }
        return idGroup;
    }

    private static Map<Long, DynamicObject> getOrgSyncRule(Map<Long, List<Long>> billOrgs) {
        HashSet<Long> orgIds = new HashSet<Long>();
        for (List<Long> orgs : billOrgs.values()) {
            orgIds.addAll(orgs);
        }
        if (orgIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>();
        }
        HashMap<Long, DynamicObject> ruleMap = new HashMap<Long, DynamicObject>(orgIds.size());
        QFilter fs = new QFilter("calorg", "in", orgIds);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_syncrouter_rule", (String)"calorg,syncuser,filter_tag", (QFilter[])fs.toArray());
        for (DynamicObject rule : rules) {
            ruleMap.put(rule.getLong("calorg"), rule);
        }
        return ruleMap;
    }

    private static Map<Long, List<Long>> getCalOrg(String entity, List<Object> routerIds) {
        QFilter fs = new QFilter("id", "in", routerIds);
        DataSet data = QueryServiceHelper.queryDataSet((String)"", (String)entity, (String)"id,createorg", (QFilter[])fs.toArray(), null);
        HashMap<Long, Long> billOrg = new HashMap<Long, Long>();
        for (Row row : data) {
            billOrg.put(row.getLong("id"), row.getLong("createorg"));
        }
        HashMap<Long, List<Long>> cacheAccOrg = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> findResult = new HashMap<Long, List<Long>>();
        Map<Long, Long> parents = SyncRouterHandle.findParents(new ArrayList<Long>(billOrg.values()));
        for (int count = 0; !parents.isEmpty() && count <= 10; ++count) {
            parents = SyncRouterHandle.findAccOrg(parents, findResult, cacheAccOrg);
            SyncRouterHandle.replaceNextParents(parents);
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        for (Map.Entry entry : billOrg.entrySet()) {
            result.put((Long)entry.getKey(), (List<Long>)findResult.get(entry.getValue()));
        }
        return result;
    }

    private static void replaceNextParents(Map<Long, Long> parents) {
        if (parents.isEmpty()) {
            return;
        }
        Map<Long, Long> nextParent = SyncRouterHandle.findParents(new ArrayList<Long>(parents.values()));
        for (Map.Entry<Long, Long> entry : parents.entrySet()) {
            parents.put(entry.getKey(), nextParent.get(entry.getValue()));
        }
    }

    private static Map<Long, Long> findParents(List<Long> orgIds) {
        return OrgUnitServiceHelper.getDirectSuperiorOrg((String)"04", orgIds);
    }

    private static Map<Long, Long> findAccOrg(Map<Long, Long> parents, Map<Long, List<Long>> findResult, Map<Long, List<Long>> cacheAccOrg) {
        HashMap<Long, Long> notFind = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Long> entry : parents.entrySet()) {
            List<Long> fromOrg = SyncRouterHandle.getFromOrgs(entry.getKey(), cacheAccOrg);
            if (fromOrg == null) {
                Long parentId = entry.getValue();
                if (parentId == null || parentId == 0L) {
                    findResult.put(entry.getKey(), null);
                    continue;
                }
                fromOrg = SyncRouterHandle.getFromOrgs(parentId, cacheAccOrg);
                if (fromOrg == null) {
                    notFind.put(entry.getKey(), parentId);
                    continue;
                }
                findResult.put(entry.getKey(), fromOrg);
                continue;
            }
            findResult.put(entry.getKey(), fromOrg);
        }
        return notFind;
    }

    private static List<Long> getFromOrgs(Long orgId, Map<Long, List<Long>> cacheAccOrg) {
        if (cacheAccOrg.containsKey(orgId)) {
            return cacheAccOrg.get(orgId);
        }
        List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)orgId, (String)"10", (boolean)true);
        if (fromOrgs != null && fromOrgs.isEmpty()) {
            fromOrgs = null;
        }
        cacheAccOrg.put(orgId, fromOrgs);
        return fromOrgs;
    }
}

