/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.macc.cad.business.settle.SettleTaskRunable;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleScheme;
import kd.macc.cad.business.settle.model.SettleTask;
import kd.macc.cad.common.enums.CadCommonEventEnum;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class CalcSettleEngine {
    protected static final Log logger = LogFactory.getLog(CalcSettleEngine.class);
    private static final String BATCH_TASK_CLASS = "kd.macc.cad.business.settle.event.CalcSettleBatchTask";
    private static final int MAXSIZE = 2000;

    public static Map<String, Object> startSettle(SettleScheme scheme, String appnum) {
        try {
            String msg = CalcSettleEngine.checkScheme(scheme);
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                return CalcSettleEngine.getErrorMsgMap(msg);
            }
            long taskId = ID.genLongId();
            List<Long> reportIds = CalcSettleEngine.createSettleReport(scheme, taskId, appnum);
            if (!reportIds.isEmpty()) {
                CalcSettleEngine.launchSettleReport(reportIds);
                return CalcSettleEngine.getSuccMsgMap(ResManager.loadKDString((String)"\u53d1\u8d77\u6838\u7b97\u4efb\u52a1\u6210\u529f\u3002", (String)"CalcSettleEngine_15", (String)"macc-cad-business", (Object[])new Object[0]), taskId, reportIds);
            }
            return CalcSettleEngine.getErrorMsgMap(ResManager.loadKDString((String)"\u53d1\u8d77\u6838\u7b97\u4efb\u52a1\u5931\u8d25\uff0c\u6ca1\u6709\u53ef\u6267\u884c\u7684\u6267\u884c\u9879\uff0c\u8bf7\u9009\u62e9\u540e\u91cd\u65b0\u53d1\u8d77\u3002", (String)"CalcSettleEngine_24", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            return CalcSettleEngine.getErrorMsgMap(ex.getMessage());
        }
    }

    public static Map<String, Object> getErrorMsgMap(String msg) {
        HashMap<String, Object> retMsg = new HashMap<String, Object>(10);
        retMsg.put("code", "0");
        retMsg.put("msg", msg);
        return retMsg;
    }

    public static Map<String, Object> getSuccMsgMap(String msg, long taskId, List<Long> reportIds) {
        HashMap<String, Object> retMsg = new HashMap<String, Object>(10);
        retMsg.put("code", "1");
        retMsg.put("msg", msg);
        retMsg.put("taskId", taskId);
        retMsg.put("reportIds", reportIds);
        return retMsg;
    }

    public static void launchSettleReport(List<Long> reportIds) {
        for (Long reportId : reportIds) {
            CalcSettleEngine.dispatchTask(reportId, 0L, CalcSettleEnum.SETTLE_INTYPE_STARTEXEC.getValue(), null);
        }
    }

    public static void dispatchTask(Long reportId, Long curTaskId, String inType, CalcSettleResult execResult) {
        Tuple2<DynamicObject, List<DynamicObject>> taskDyns = CalcSettleEngine.getNextTask(reportId, curTaskId, inType, execResult);
        CalcSettleEngine.executeTasks((DynamicObject)taskDyns.t1, (List)taskDyns.t2);
    }

    public static Tuple2<DynamicObject, List<DynamicObject>> getNextTask(Long reportId, Long curTaskId, String inType, CalcSettleResult execResult) {
        List<DynamicObject> taskDyns = null;
        String lockId = "CalcSettleNextTask-" + reportId;
        DynamicObject reportDyn = null;
        try (DLock lock = DLock.create((String)lockId, (String)String.format(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u8c03\u5ea6-\u62a5\u544aid-%s", (String)"CalcSettleEngine_17", (String)"macc-cad-business", (Object[])new Object[0]), reportId));){
            lock.lock();
            reportDyn = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"cad_settlereport");
            switch (inType) {
                case "1": {
                    taskDyns = CalcSettleEngine.startRun(reportDyn);
                    break;
                }
                case "2": {
                    taskDyns = CalcSettleEngine.recalcNextStep(reportDyn, curTaskId);
                    break;
                }
                case "3": {
                    taskDyns = CalcSettleEngine.recalcNextClass(reportDyn);
                    break;
                }
                case "4": {
                    taskDyns = CalcSettleEngine.nextTask(reportDyn, curTaskId, execResult);
                    break;
                }
                case "5": {
                    CalcSettleEngine.abortCalc(reportDyn);
                    break;
                }
                case "6": {
                    CalcSettleEngine.cancelTaskCalc(reportDyn, curTaskId);
                }
            }
            CalcSettleEngine.reportUpdate(reportDyn, taskDyns);
        }
        return new Tuple2((Object)reportDyn, taskDyns);
    }

    private static void cancelTaskCalc(DynamicObject reportDyn, Long curTaskId) {
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        DynamicObject curTaskDyn = null;
        for (DynamicObject funcDyn : funcDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                CalcSettleEngine.getExecutionLog(taskDyn, ResManager.loadKDString((String)"\u53d6\u6d88\u8fd0\u7b97", (String)"CalcSettleEngine_20", (String)"macc-cad-business", (Object[])new Object[0]));
                if (!curTaskId.equals(taskDyn.getLong("id"))) continue;
                curTaskDyn = taskDyn;
                break;
            }
            if (curTaskDyn == null) continue;
            break;
        }
        if (curTaskDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_4", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        String substatus = curTaskDyn.getString("substatus");
        if (!CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(substatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u8fd0\u884c\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u3002", (String)"CalcSettleEngine_14", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        CalcSettleResult execResult = new CalcSettleResult();
        execResult.setStatus(CalcSettleEnum.SETTLESUB_FAIL.getValue());
        execResult.setRemark(ResManager.loadKDString((String)"\u53d6\u6d88\u6267\u884c", (String)"CalcSettleEngine_12", (String)"macc-cad-business", (Object[])new Object[0]));
        CalcSettleEngine.nextTask(reportDyn, curTaskId, execResult);
    }

    private static void reportUpdate(DynamicObject reportDyn, List<DynamicObject> runDyns) {
        DynamicObjectCollection entryDyns = reportDyn.getDynamicObjectCollection("entryentity");
        if (!CadEmptyUtils.isEmpty(runDyns)) {
            reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_RUN.getValue());
            String currStep = null;
            for (DynamicObject taskDyn : runDyns) {
                taskDyn.set("substatus", (Object)CalcSettleEnum.SETTLESUB_WAIT.getValue());
                taskDyn.set("subprogress", (Object)0);
                taskDyn.set("remark", (Object)"");
                taskDyn.set("remark_tag", (Object)"");
                taskDyn.set("jumpparam_tag", (Object)"");
                currStep = taskDyn.getString("subfunctype");
            }
            String step = reportDyn.getString("currstep");
            reportDyn.set("currstep", currStep);
            if (!StringUtils.equals(currStep, (CharSequence)step)) {
                reportDyn.set("endtime", null);
            }
        } else {
            String status = reportDyn.getString("status");
            if (!CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status)) {
                boolean containRunTask = false;
                boolean containWarnTask = false;
                boolean containFailTask = false;
                boolean containConfirmTask = false;
                for (DynamicObject funcDyn : entryDyns) {
                    DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject taskDyn : taskDyns) {
                        String entrySubStatus = taskDyn.getString("substatus");
                        boolean confirm = taskDyn.getBoolean("confirm");
                        if (CalcSettleEnum.SETTLESUB_UNEXEC.getValue().equals(entrySubStatus) || CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(entrySubStatus) || CalcSettleEnum.SETTLESUB_RUN.getValue().equals(entrySubStatus)) {
                            containRunTask = true;
                        }
                        if (CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(entrySubStatus) && !confirm) {
                            containConfirmTask = true;
                        }
                        if (CalcSettleEnum.SETTLESUB_WARN.getValue().equals(entrySubStatus) && CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(taskDyn.getString("exemethod")) && !confirm) {
                            containConfirmTask = true;
                        }
                        if (CalcSettleEnum.SETTLESUB_WARN.getValue().equals(entrySubStatus)) {
                            containWarnTask = true;
                        }
                        if (!CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(entrySubStatus) || confirm) continue;
                        containFailTask = true;
                    }
                }
                if (containFailTask) {
                    reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                } else if (containConfirmTask) {
                    reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_CONFIRM.getValue());
                } else if (!containRunTask) {
                    if (containWarnTask) {
                        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_WARN.getValue());
                        reportDyn.set("endtime", (Object)new Date());
                    } else {
                        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_SUCC.getValue());
                        reportDyn.set("endtime", (Object)new Date());
                    }
                    reportDyn.set("currstep", (Object)"");
                }
            }
        }
        CalcSettleEngine.updateProgress(reportDyn);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportDyn});
    }

    private static void updateProgress(DynamicObject reportDyn) {
        DynamicObjectCollection entryDyns = reportDyn.getDynamicObjectCollection("entryentity");
        float total = 0.0f;
        float comp = 0.0f;
        for (int i = 0; i < entryDyns.size(); ++i) {
            DynamicObjectCollection taskDyns = ((DynamicObject)entryDyns.get(i)).getDynamicObjectCollection("subentryentity");
            total += (float)taskDyns.size();
            for (DynamicObject taskDyn : taskDyns) {
                String entrySubStatus = taskDyn.getString("substatus");
                boolean confirm = taskDyn.getBoolean("confirm");
                if (CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(entrySubStatus) && confirm) {
                    comp += 1.0f;
                }
                if (CalcSettleEnum.SETTLESUB_WARN.getValue().equals(entrySubStatus)) {
                    if (CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(taskDyn.getString("exemethod"))) {
                        if (confirm) {
                            comp += 1.0f;
                        }
                    } else if (CalcSettleEnum.EXECUTE_COMPNEXT.getValue().equals(taskDyn.getString("exemethod"))) {
                        comp += 1.0f;
                    }
                }
                if (CalcSettleEnum.SETTLESUB_SUCC.getValue().equals(entrySubStatus)) {
                    comp += 1.0f;
                }
                if (!CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(entrySubStatus) || !confirm) continue;
                comp += 1.0f;
            }
        }
        int process = 100;
        if (total != 0.0f) {
            process = (int)(comp / total * 100.0f);
        }
        reportDyn.set("progress", (Object)process);
    }

    private static void abortCalc(DynamicObject reportDyn) {
        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_ABORT.getValue());
    }

    private static List<DynamicObject> startRun(DynamicObject reportDyn) {
        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_RUN.getValue());
        reportDyn.set("starttime", (Object)new Date());
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        return CalcSettleEngine.getNeedExecNextTasks(funcDyns, null);
    }

    private static long getRecalcNextTaskId(DynamicObject reportDyn, Long curTaskId) {
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject funcDyn : funcDyns) {
            boolean confirm;
            String substatus;
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                substatus = taskDyn.getString("substatus");
                confirm = taskDyn.getBoolean("confirm");
                if (!CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(substatus) || confirm || !CadEmptyUtils.isEmpty((Long)curTaskId) && !curTaskId.equals(taskDyn.getLong("id"))) continue;
                return taskDyn.getLong("id");
            }
            for (DynamicObject taskDyn : taskDyns) {
                substatus = taskDyn.getString("substatus");
                confirm = taskDyn.getBoolean("confirm");
                if (!CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(substatus) || confirm || !CadEmptyUtils.isEmpty((Long)curTaskId) && !curTaskId.equals(taskDyn.getLong("id"))) continue;
                return taskDyn.getLong("id");
            }
            for (DynamicObject taskDyn : taskDyns) {
                substatus = taskDyn.getString("substatus");
                if (!CalcSettleEnum.SETTLESUB_UNEXEC.getValue().equals(substatus) && !CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(substatus) || !CadEmptyUtils.isEmpty((Long)curTaskId) && !curTaskId.equals(taskDyn.getLong("id"))) continue;
                return taskDyn.getLong("id");
            }
        }
        return 0L;
    }

    private static List<DynamicObject> recalcNextStep(DynamicObject reportDyn, Long curTaskId) {
        long nextTaskId = CalcSettleEngine.getRecalcNextTaskId(reportDyn, curTaskId);
        if (CadEmptyUtils.isEmpty((Long)nextTaskId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6267\u884c\u7684\u5b50\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_3", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> nextTasks = new ArrayList<DynamicObject>(10);
        for (DynamicObject funcDyn : funcDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                if (nextTaskId != taskDyn.getLong("id")) continue;
                CalcSettleEngine.getExecutionLog(taskDyn, ResManager.loadKDString((String)"\u91cd\u65b0\u8fd0\u7b97", (String)"CalcSettleEngine_21", (String)"macc-cad-business", (Object[])new Object[0]));
                nextTasks.add(taskDyn);
                break;
            }
            if (nextTasks.isEmpty()) continue;
            break;
        }
        if (nextTasks.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6267\u884c\u7684\u5b50\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_3", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_RUN.getValue());
        reportDyn.set("endtime", null);
        return nextTasks;
    }

    private static List<DynamicObject> recalcNextClass(DynamicObject reportDyn) {
        long nextTaskId = CalcSettleEngine.getRecalcNextTaskId(reportDyn, 0L);
        if (CadEmptyUtils.isEmpty((Long)nextTaskId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6267\u884c\u7684\u5b50\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_3", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        String currStep = null;
        for (DynamicObject funcDyn : funcDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                if (nextTaskId != taskDyn.getLong("id")) continue;
                currStep = taskDyn.getString("subfunctype");
                break;
            }
            if (currStep == null) continue;
            for (DynamicObject taskDyn : taskDyns) {
                taskDyn.set("substatus", (Object)CalcSettleEnum.SETTLESTATUS_UNEXEC.getValue());
                taskDyn.set("confirm", (Object)false);
                taskDyn.set("substarttime", null);
                taskDyn.set("subendtime", null);
                CalcSettleEngine.getExecutionLog(taskDyn, ResManager.loadKDString((String)"\u91cd\u65b0\u8fd0\u7b97", (String)"CalcSettleEngine_21", (String)"macc-cad-business", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isEmpty(currStep)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u6267\u884c\u7684\u5b50\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_3", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        List<DynamicObject> nextTasks = CalcSettleEngine.getNeedExecNextTasks(funcDyns, currStep);
        reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_RUN.getValue());
        reportDyn.set("endtime", null);
        return nextTasks;
    }

    private static List<DynamicObject> getNeedExecNextTasks(DynamicObjectCollection funcDyns, String currStep) {
        ArrayList<DynamicObject> nextTasks = new ArrayList<DynamicObject>(10);
        for (DynamicObject funcDyn : funcDyns) {
            if (!StringUtils.isEmpty((CharSequence)currStep) && !currStep.equals(funcDyn.getString("functype"))) continue;
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (int i = 0; i < taskDyns.size(); ++i) {
                DynamicObject taskDyn = (DynamicObject)taskDyns.get(i);
                if (!CalcSettleEnum.SETTLESTATUS_UNEXEC.getValue().equals(taskDyn.getString("substatus"))) continue;
                DynamicObject nextTaskDyn = null;
                if (i + 1 < taskDyns.size()) {
                    nextTaskDyn = (DynamicObject)taskDyns.get(i + 1);
                }
                nextTasks.add(taskDyn);
                if (nextTaskDyn == null || !nextTaskDyn.getBoolean("parallel")) break;
            }
            if (CadEmptyUtils.isEmpty(nextTasks)) continue;
            break;
        }
        return nextTasks;
    }

    private static List<DynamicObject> nextTask(DynamicObject reportDyn, Long curTaskId, CalcSettleResult execResult) {
        boolean isNext;
        DynamicObjectCollection funcDyns = reportDyn.getDynamicObjectCollection("entryentity");
        DynamicObject curTaskDyn = null;
        DynamicObjectCollection curTaskDyns = null;
        for (DynamicObject funcDyn : funcDyns) {
            DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taskDyn : taskDyns) {
                if (!curTaskId.equals(taskDyn.getLong("id"))) continue;
                curTaskDyn = taskDyn;
                curTaskDyns = taskDyns;
                break;
            }
            if (curTaskDyn == null) continue;
            break;
        }
        if (curTaskDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u4efb\u52a1\u9879\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"CalcSettleEngine_4", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        curTaskDyn.set("subprogress", (Object)100);
        curTaskDyn.set("confirm", (Object)(execResult.isConfirm() ? "1" : "0"));
        if (!execResult.isConfirm()) {
            curTaskDyn.set("jumpparam_tag", (Object)JSON.toJSONString((Object)execResult));
            curTaskDyn.set("substatus", (Object)execResult.getStatus());
            if (CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(execResult.getStatus()) || CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(execResult.getStatus()) || CalcSettleEnum.SETTLESUB_WARN.getValue().equals(execResult.getStatus()) && CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(curTaskDyn.getString("exemethod"))) {
                curTaskDyn.set("subprogress", (Object)0);
            } else {
                curTaskDyn.set("subendtime", (Object)new Date());
            }
            curTaskDyn.set("trycount", (Object)(curTaskDyn.getInt("trycount") + 1));
            curTaskDyn.set("remark", (Object)"");
            curTaskDyn.set("remark_tag", (Object)"");
        } else {
            curTaskDyn.set("subendtime", (Object)new Date());
            CalcSettleEngine.getExecutionLog(curTaskDyn, ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"CalcSettleEngine_22", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)execResult.getRemark())) {
            curTaskDyn.set("remark", (Object)StringUtils.substring((String)execResult.getRemark(), (int)0, (int)200));
        }
        if (!StringUtils.isEmpty((CharSequence)execResult.getRemarkTag())) {
            curTaskDyn.set("remark_tag", (Object)execResult.getRemarkTag());
        }
        if (isNext = CalcSettleEngine.judgeRunNext(reportDyn, curTaskDyns, curTaskDyn)) {
            return CalcSettleEngine.getNeedExecNextTasks(funcDyns, null);
        }
        return null;
    }

    private static void getExecutionLog(DynamicObject curTaskDyn, String executionlog) {
        String userName = RequestContext.get().getUserName();
        String executionLogStr = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u5728%3$s\u6267\u884c\u3002%n%4$s", (String)"CalcSettleEngine_28", (String)"macc-cad-business", (Object[])new Object[0]), executionlog, userName, DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), curTaskDyn.getString("executionlog"));
        curTaskDyn.set("executionlog", (Object)CalcSettleEngine.truncateToSentence(executionLogStr, 2000));
    }

    public static String truncateToSentence(String text, int maxLength) {
        int truncateIndex;
        if (text.length() <= maxLength) {
            return text;
        }
        for (truncateIndex = maxLength; truncateIndex > 0 && text.charAt(truncateIndex - 1) != '\u3002'; --truncateIndex) {
        }
        if (truncateIndex <= 0) {
            return text.substring(0, maxLength);
        }
        return text.substring(0, truncateIndex);
    }

    private static boolean judgeRunNext(DynamicObject reportDyn, DynamicObjectCollection taskDyns, DynamicObject curTaskDyn) {
        String status = reportDyn.getString("status");
        if (CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status)) {
            return false;
        }
        String substatus = curTaskDyn.getString("substatus");
        boolean isConfirm = curTaskDyn.getBoolean("confirm");
        if (!isConfirm) {
            if (CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(substatus) || CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(substatus)) {
                reportDyn.set("status", (Object)substatus);
                return false;
            }
            if (CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(curTaskDyn.getString("exemethod")) && !CalcSettleEnum.SETTLESUB_SUCC.getValue().equals(substatus)) {
                reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_CONFIRM.getValue());
                return false;
            }
        }
        ArrayList<DynamicObject> groupTasks = new ArrayList<DynamicObject>(10);
        boolean curr = false;
        for (int i = 0; i < taskDyns.size(); ++i) {
            DynamicObject taskDyn = (DynamicObject)taskDyns.get(i);
            if (!curr && taskDyn == curTaskDyn) {
                curr = true;
            }
            DynamicObject nextDyn = null;
            if (i + 1 < taskDyns.size()) {
                nextDyn = (DynamicObject)taskDyns.get(i + 1);
            }
            if (nextDyn != null && nextDyn.getBoolean("parallel")) {
                groupTasks.add(taskDyn);
                continue;
            }
            groupTasks.add(taskDyn);
            if (curr) break;
            groupTasks.clear();
        }
        if (groupTasks.isEmpty()) {
            curTaskDyn.set("substatus", (Object)CalcSettleEnum.SETTLESUB_FAIL.getValue());
            curTaskDyn.set("remark", (Object)ResManager.loadKDString((String)"\u8c03\u5ea6\u65f6\u672a\u627e\u5230\u5f53\u524d\u4efb\u52a1\u9879\uff0c\u5f02\u5e38\u3002", (String)"CalcSettleEngine_5", (String)"macc-cad-business", (Object[])new Object[0]));
            reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
            return false;
        }
        for (DynamicObject taskDyn : groupTasks) {
            String gstatus = taskDyn.getString("substatus");
            if (CalcSettleEnum.SETTLESUB_RUN.getValue().equals(gstatus) || CalcSettleEnum.SETTLESUB_UNEXEC.getValue().equals(gstatus) || CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(gstatus)) {
                return false;
            }
            boolean confirm = taskDyn.getBoolean("confirm");
            if (CalcSettleEnum.SETTLESUB_FAIL.getValue().equals(gstatus) && !confirm) {
                return false;
            }
            if (CalcSettleEnum.SETTLESUB_CONFIRM.getValue().equals(gstatus) && !confirm) {
                return false;
            }
            if (!CalcSettleEnum.EXECUTE_SUCCNEXT.getValue().equals(taskDyn.getString("exemethod")) || !CalcSettleEnum.SETTLESUB_WARN.getValue().equals(gstatus) || confirm) continue;
            return false;
        }
        return true;
    }

    public static void executeTasks(DynamicObject reportDyn, List<DynamicObject> taskIds) {
        if (CadEmptyUtils.isEmpty(taskIds) || reportDyn == null) {
            return;
        }
        String settleExecuteStrategy = CadBgParamUtils.getCadBgParamForString((String)"settleExecStrategy", (String)CalcSettleEnum.EXEC_TASK_THREAD.getValue());
        for (DynamicObject task : taskIds) {
            Long taskId = task.getLong("id");
            DynamicObject settleitemDyn = task.getDynamicObject("settleitem");
            boolean mannulconfirm = task.getBoolean("mannulconfirm");
            if (!mannulconfirm && CalcSettleEnum.EXEC_TASK_ASYNCTASK.getValue().equals(settleExecuteStrategy)) {
                String taskName = "";
                String appnum = reportDyn.getString("appnum");
                if (StringUtils.isEmpty((CharSequence)appnum)) {
                    appnum = "aca";
                }
                if (settleitemDyn != null) {
                    taskName = settleitemDyn.getString("name");
                }
                CalcSettleEngine.sendTask(taskName, taskId, appnum);
                continue;
            }
            if (!mannulconfirm && CalcSettleEnum.EXEC_TASK_EVENT.getValue().equals(settleExecuteStrategy)) {
                JSONObject json = new JSONObject();
                json.put((Object)"type", (Object)CadCommonEventEnum.CALC_SETTLE_TASK_EXEC.getValue());
                json.put((Object)"json", (Object)String.format("{\"taskId\":%s}", taskId));
                EventServiceHelper.triggerEventSubscribe((String)"cad.common.busevent", (String)json.toString());
                continue;
            }
            CalcSettleEngine.executeTask(taskId);
        }
    }

    public static void executeTask(Long taskId) {
        ThreadHelper.execute((Runnable)new SettleTaskRunable(taskId), (TaskType)TaskType.CAD_SETTLE);
    }

    private static String sendTask(String taskName, Object params, String appnum) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>(10);
        try {
            if (params instanceof Long) {
                jobParams.put("paramId", params);
            } else {
                jobParams.put("param", JSONUtils.toString((Object)params));
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String opName = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u3010%1$s\u3011\u6267\u884c\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:%2$s", (String)"CalcSettleEngine_18", (String)"macc-cad-business", (Object[])new Object[0]);
        job.setName(String.format(opName, taskName + ",TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, RequestContext.get().getUserName()));
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId(appnum);
        job.setTaskClassname(BATCH_TASK_CLASS);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }

    private static List<Long> createSettleReport(SettleScheme scheme, long taskId, String appnum) {
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        Map<Long, Long> costaccountOrgMap = CalcSettleEngine.getCostaccountOrgIds(scheme.getCostaccountIds());
        TreeMap<String, List> functionTaskMap = new TreeMap<String, List>();
        for (SettleTask settleTask : scheme.getTasks()) {
            if (!settleTask.isExecute()) continue;
            functionTaskMap.computeIfAbsent(settleTask.getFunctype(), t -> new ArrayList(10)).add(settleTask);
        }
        ArrayList<DynamicObject> reportDyns = new ArrayList<DynamicObject>(10);
        for (Long costaccountId : scheme.getCostaccountIds()) {
            if (costaccountOrgMap.get(costaccountId) == null) continue;
            DynamicObject reportDyn = BusinessDataServiceHelper.newDynamicObject((String)"cad_settlereport");
            reportDyn.set("id", (Object)ID.genLongId());
            reportDyn.set("billno", (Object)ID.genStringId());
            reportDyn.set("billstatus", (Object)"C");
            reportDyn.set("creator", (Object)userId);
            reportDyn.set("createtime", (Object)date);
            reportDyn.set("modifier", (Object)userId);
            reportDyn.set("modifytime", (Object)date);
            reportDyn.set("org", (Object)costaccountOrgMap.get(costaccountId));
            reportDyn.set("costaccount", (Object)costaccountId);
            reportDyn.set("period", (Object)scheme.getPeriodId());
            reportDyn.set("status", (Object)CalcSettleEnum.SETTLESTATUS_UNEXEC.getValue());
            reportDyn.set("executor", (Object)userId);
            reportDyn.set("taskid", (Object)taskId);
            reportDyn.set("scheme", (Object)scheme.getSchemeId());
            reportDyn.set("appnum", (Object)appnum);
            reportDyn.set("progress", (Object)0);
            int seq = 0;
            DynamicObjectCollection dynCols = reportDyn.getDynamicObjectCollection("entryentity");
            for (Map.Entry functionTaskEntry : functionTaskMap.entrySet()) {
                DynamicObject entry = dynCols.addNew();
                entry.set("functype", functionTaskEntry.getKey());
                entry.set("seq", (Object)seq++);
                int subseq = 0;
                DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
                for (SettleTask task : (List)functionTaskEntry.getValue()) {
                    if (!task.isExecute()) continue;
                    DynamicObject col = subentryentity.addNew();
                    col.set("subfunctype", functionTaskEntry.getKey());
                    col.set("settleitem", (Object)task.getSettleitem());
                    col.set("substatus", (Object)CalcSettleEnum.SETTLESUB_UNEXEC.getValue());
                    col.set("mannulconfirm", (Object)task.isMannulconfirm());
                    col.set("trycount", (Object)0);
                    col.set("subprogress", (Object)0);
                    col.set("parallel", (Object)task.isParallel());
                    col.set("exemethod", (Object)task.getExemethod());
                    col.set("seq", (Object)subseq++);
                    col.set("defaultparam_tag", (Object)task.getDefaultparam());
                }
            }
            if (dynCols.isEmpty()) continue;
            reportDyns.add(reportDyn);
        }
        if (!reportDyns.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])reportDyns.toArray(new DynamicObject[0]));
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        for (DynamicObject dyn : reportDyns) {
            arrayList.add(dyn.getLong("id"));
        }
        return arrayList;
    }

    private static String checkScheme(SettleScheme scheme) {
        List<Long> costaccountIds = scheme.getCostaccountIds();
        if (CadEmptyUtils.isEmpty(costaccountIds)) {
            return ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6210\u672c\u8d26\u7c3f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CalcSettleEngine_6", (String)"macc-cad-business", (Object[])new Object[0]);
        }
        Map costaccountPeriodMap = PeriodHelper.getAccountCurrentPeriod(new HashSet<Long>(costaccountIds));
        if (costaccountIds.size() != costaccountPeriodMap.size()) {
            HashSet<Long> accountErrIds = new HashSet<Long>(10);
            for (Long l : costaccountIds) {
                if (costaccountPeriodMap.containsKey(l)) continue;
                accountErrIds.add(l);
            }
            if (accountErrIds.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a%s\u672a\u83b7\u53d6\u5230\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"CalcSettleEngine_7", (String)"macc-cad-business", (Object[])new Object[0]), CalcSettleEngine.getCostaccountNames(accountErrIds));
            }
        }
        Long currentPeriodId = 0L;
        HashMap<Long, Long> costaccountPeriodErrMap = new HashMap<Long, Long>(10);
        for (Long costaccountId : costaccountIds) {
            Long periodId = (Long)costaccountPeriodMap.get(costaccountId);
            if (periodId == null) continue;
            if (CadEmptyUtils.isEmpty((Long)currentPeriodId)) {
                currentPeriodId = periodId;
            }
            if (currentPeriodId.equals(periodId)) continue;
            costaccountPeriodErrMap.put(costaccountId, periodId);
        }
        scheme.setPeriodId(currentPeriodId);
        if (!costaccountPeriodErrMap.isEmpty()) {
            Map<Long, String> map = CalcSettleEngine.costaccountName(costaccountPeriodErrMap.keySet());
            HashSet<Long> periodIds = new HashSet<Long>(costaccountPeriodErrMap.values());
            periodIds.add(currentPeriodId);
            Map<Long, String> periodNameMap = CalcSettleEngine.periodName(periodIds);
            String accountMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u6838\u7b97\u671f\u95f4\u3010%2$s\u3011", (String)"CalcSettleEngine_8", (String)"macc-cad-business", (Object[])new Object[0]);
            StringBuilder msgSb = new StringBuilder();
            for (Map.Entry entry : costaccountPeriodErrMap.entrySet()) {
                if (msgSb.length() > 0) {
                    msgSb.append(",");
                }
                msgSb.append(String.format(accountMsg, map.get(entry.getKey()), periodNameMap.get(entry.getValue())));
            }
            return String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u6838\u7b97\u671f\u95f4\u201c%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u540c\u4e00\u65b9\u6848\u6267\u884c\u3002", (String)"CalcSettleEngine_19", (String)"macc-cad-business", (Object[])new Object[0]), msgSb.toString(), periodNameMap.get(currentPeriodId));
        }
        Set<Long> set = CalcSettleEngine.getRunningSettleReport(scheme.getCostaccountIds(), scheme.getPeriodId());
        if (!CadEmptyUtils.isEmpty(set)) {
            String accountMsg = CalcSettleEngine.getCostaccountNames(set);
            return String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fd0\u884c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\u3002", (String)"CalcSettleEngine_11", (String)"macc-cad-business", (Object[])new Object[0]), accountMsg);
        }
        return null;
    }

    public static Set<Long> getRunningSettleReport(List<Long> costaccountIds, Long periodId) {
        HashSet<Long> runCostaccountIds = new HashSet<Long>(10);
        QFilter filter = new QFilter("costaccount", "in", costaccountIds);
        filter.and("period", "=", (Object)periodId);
        filter.and("status", "in", (Object)new String[]{CalcSettleEnum.SETTLESTATUS_UNEXEC.getValue(), CalcSettleEnum.SETTLESTATUS_RUN.getValue(), CalcSettleEnum.SETTLESTATUS_CONFIRM.getValue()});
        DataSet ds = QueryServiceHelper.queryDataSet((String)"settlereport", (String)"cad_settlereport", (String)"id,costaccount", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            runCostaccountIds.add(row.getLong("costaccount"));
        }
        return runCostaccountIds;
    }

    private static Map<Long, Long> getCostaccountOrgIds(Collection<Long> costaccountIds) {
        HashMap<Long, Long> costaccountOrgIdMap = new HashMap<Long, Long>(10);
        Map costaccountDynMap = BusinessDataServiceHelper.loadFromCache((Object[])costaccountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject obj : costaccountDynMap.values()) {
            costaccountOrgIdMap.put(obj.getLong("id"), obj.getLong("calorg.id"));
        }
        return costaccountOrgIdMap;
    }

    private static String getCostaccountNames(Set<Long> costaccountIds) {
        Map<Long, String> costaccountNameMap = CalcSettleEngine.costaccountName(costaccountIds);
        StringBuilder accountMsg = new StringBuilder();
        for (String name : costaccountNameMap.values()) {
            if (accountMsg.length() > 0) {
                accountMsg.append("\uff0c");
            }
            accountMsg.append(name);
        }
        return accountMsg.toString();
    }

    private static Map<Long, String> costaccountName(Collection<Long> costaccountIds) {
        HashMap<Long, String> costaccountNameMap = new HashMap<Long, String>(10);
        Map costaccountDynMap = BusinessDataServiceHelper.loadFromCache((Object[])costaccountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject obj : costaccountDynMap.values()) {
            costaccountNameMap.put(obj.getLong("id"), obj.getString("name"));
        }
        return costaccountNameMap;
    }

    private static Map<Long, String> periodName(Collection<Long> periodIds) {
        HashMap<Long, String> periodNameMap = new HashMap<Long, String>(10);
        Map costaccountDynMap = BusinessDataServiceHelper.loadFromCache((Object[])periodIds.toArray(), (String)"bd_period");
        for (DynamicObject obj : costaccountDynMap.values()) {
            periodNameMap.put(obj.getLong("id"), obj.getString("name"));
        }
        return periodNameMap;
    }
}

