/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.CalcSettleEngine;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.executor.TaskOperExecutor;
import kd.macc.cad.business.settle.executor.TaskPluginExecutor;
import kd.macc.cad.business.settle.model.CalcSettleContext;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.DateUtils;

public class TaskExecuteHelper {
    protected static final Log logger = LogFactory.getLog(TaskExecuteHelper.class);
    private static final String UPDATE_SETTLEREPORT_LOG = "update t_cad_settlereportsub set fsubstatus=?,fsubstarttime=?,fsubendtime=?,finstanceid=? where fdetailid =?";

    public static void taskExecute(Long taskId) {
        DynamicObject taskDyn = TaskExecuteHelper.getTaskDyn(taskId);
        if (!CalcSettleEnum.SETTLESUB_WAIT.getValue().equals(taskDyn.getString("substatus"))) {
            logger.info("\u4efb\u52a1\u672a\u5f85\u6267\u884c\u72b6\u6001\uff0c\u9000\u51fa\u6267\u884c\uff1a{}", (Object)taskId);
            return;
        }
        TaskExecuteHelper.updateTask(taskId);
        CalcSettleResult result = null;
        try {
            String taskMethod = taskDyn.getString("execmethod");
            CalcSettleContext context = TaskExecuteHelper.getCalcContext(taskDyn);
            context.setTaskId(taskId);
            context.setTaskTime(DateUtils.getCurrentSystemTime());
            result = CalcSettleEnum.EXEC_METHOD_OPER.getValue().equals(taskMethod) ? TaskOperExecutor.execute(taskId, taskDyn, context) : TaskPluginExecutor.execute(taskId, taskDyn, context);
        }
        catch (Exception e) {
            result = CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a%s\u3002", (String)"TaskExecuteHelper_0", (String)"macc-cad-business", (Object[])new Object[0]), e.getMessage()), (String)CalcSettleHelper.getExceptionErrorInfo((Exception)e).t2);
        }
        if (result == null) {
            result = CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u6267\u884c\u72b6\u6001\u3002", (String)"TaskExecuteHelper_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        CalcSettleEngine.dispatchTask(taskDyn.getLong("id"), taskId, CalcSettleEnum.SETTLE_INTYPE_NEXT.getValue(), result);
    }

    private static void updateTask(Long taskId) {
        Object[] paramArray = new Object[]{CalcSettleEnum.SETTLESUB_RUN.getValue(), new Date(), null, Instance.getInstanceId(), taskId};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)UPDATE_SETTLEREPORT_LOG, (Object[])paramArray);
    }

    private static CalcSettleContext getCalcContext(DynamicObject taskDyn) {
        CalcSettleContext context = new CalcSettleContext();
        context.setOrgId(taskDyn.getLong("org"));
        context.setCostaccountId(taskDyn.getLong("costaccount"));
        context.setCostaccountNum(taskDyn.getString("costaccountnum"));
        context.setPeriodId(taskDyn.getLong("period"));
        context.setSchemeId(taskDyn.getLong("scheme"));
        context.setCalcparam(taskDyn.getString("calcparam"));
        context.setAppnum(taskDyn.getString("appnum"));
        context.setCurrencyId(CurrencyHelper.getCurrency((Long)context.getCostaccountId()));
        context.setAmtprecision(CurrencyHelper.getAmtprecision((Long)context.getCostaccountId()));
        context.setCosttypeid(taskDyn.getLong("costtypeid"));
        Date[] date = PeriodHelper.getPeriodStartAndEndTime((Long)context.getPeriodId());
        if (date != null) {
            context.setStartDate(date[0]);
            context.setEndDate(date[1]);
        }
        return context;
    }

    private static DynamicObject getTaskDyn(Long taskId) {
        QFilter filter = new QFilter("entryentity.subentryentity.id", "=", (Object)taskId);
        return QueryServiceHelper.queryOne((String)"cad_settlereport", (String)"id,org,costaccount,costaccount.number costaccountnum,costaccount.costtype.id costtypeid,period,taskid,scheme.id scheme,appnum,entryentity.subentryentity.substatus substatus,entryentity.subentryentity.settleitem.id settleitemid,entryentity.subentryentity.settleitem.method execmethod,entryentity.subentryentity.defaultparam_tag calcparam,entryentity.subentryentity.settleitem.plugin plugin,entryentity.subentryentity.parallel parallel,entryentity.subentryentity.mannulconfirm mannulconfirm", (QFilter[])filter.toArray());
    }
}

