/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.settle.ICalcSettleTask;
import kd.macc.cad.business.settle.TaskExecuteHelper;
import kd.macc.cad.business.settle.model.TaskExecuteDto;

public class TaskProgressRunable
implements Runnable {
    protected static final Log logger = LogFactory.getLog(TaskExecuteHelper.class);
    private static final String UPDATE_SETTLEREPORT_PROGRESS = "update t_cad_settlereportsub set fsubprogress=? where fdetailid =?";
    private List<TaskExecuteDto> taskProgressDtos = Collections.synchronizedList(new ArrayList(10));
    public final AtomicBoolean taskProgressThreadRun = new AtomicBoolean(false);
    private static volatile TaskProgressRunable instance;

    private TaskProgressRunable() {
    }

    public void addTaskDto(TaskExecuteDto task) {
        if (TaskProgressRunable.instance.taskProgressDtos.size() < 50) {
            TaskProgressRunable.instance.taskProgressDtos.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskProgressRunable getInstance() {
        if (instance != null) return instance;
        Class<TaskProgressRunable> clazz = TaskProgressRunable.class;
        synchronized (TaskProgressRunable.class) {
            if (instance != null) return instance;
            instance = new TaskProgressRunable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (this.taskProgressDtos.isEmpty()) {
                    this.threadSleep(10000L);
                    if (this.taskProgressDtos.isEmpty()) {
                        break;
                    }
                }
                ArrayList<TaskExecuteDto> needDels = new ArrayList<TaskExecuteDto>(10);
                TaskExecuteDto[] dtos = this.taskProgressDtos.toArray(new TaskExecuteDto[0]);
                for (TaskExecuteDto executeDto : dtos) {
                    if (!executeDto.isStop()) continue;
                    needDels.add(executeDto);
                }
                if (!needDels.isEmpty()) {
                    for (TaskExecuteDto dto : needDels) {
                        this.taskProgressDtos.remove(dto);
                    }
                    dtos = this.taskProgressDtos.toArray(new TaskExecuteDto[0]);
                }
                for (TaskExecuteDto dto : dtos) {
                    int progress = 0;
                    Object task = dto.getTaskPlugin();
                    if (task == null) {
                        dto.setStop(true);
                        continue;
                    }
                    if (task instanceof ICalcSettleTask) {
                        progress = ((ICalcSettleTask)task).getProgress();
                    } else {
                        try {
                            Method getProgressMf = task.getClass().getMethod("getProgress", new Class[0]);
                            progress = (Integer)getProgressMf.invoke(task, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error("\u83b7\u53d6\u8fdb\u5ea6\u503c\u5931\u8d25\uff1a", (Throwable)e);
                            dto.setStop(true);
                        }
                    }
                    this.updateTask(progress, dto.getTaskId());
                }
                this.threadSleep(2000L);
            }
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u6267\u884c\u5b58\u5728\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.taskProgressThreadRun.set(false);
        }
    }

    private void threadSleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception ex) {
            logger.error("\u8fdb\u5ea6\u4e2d\u65ad\u5931\u8d25\uff1a", (Throwable)ex);
        }
    }

    private void updateTask(int progress, long taskId) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        Object[] paramArray = new Object[]{progress, taskId};
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)UPDATE_SETTLEREPORT_PROGRESS, (Object[])paramArray);
    }
}

