/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcSettleHelper {
    public static Tuple2<String, String> getExceptionErrorInfo(Exception ex) {
        String errormsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CalcSettleHelper_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String errInfo = CalcSettleHelper.wrapExceptionErrorInfo(ex);
        if (ex instanceof KDBizException) {
            if (!StringUtils.isEmpty((String)ex.getMessage())) {
                errormsg = ex.getMessage();
            }
        } else if (ex instanceof AlgoException) {
            int i = 5;
            Throwable th = ex;
            while (th.getCause() != null && !((th = th.getCause()) instanceof KDBizException) && --i >= 0) {
            }
            if (th instanceof KDBizException && !StringUtils.isEmpty((String)th.getMessage())) {
                errormsg = th.getMessage();
            }
        }
        return new Tuple2((Object)errormsg, (Object)errInfo);
    }

    private static String wrapExceptionErrorInfo(Exception ex) {
        StringBuilder erroStr = new StringBuilder();
        String errormsg = ex.getCause() == null ? (ex.getLocalizedMessage() == null ? "" : ex.getLocalizedMessage()) : ex.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        erroStr.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        return erroStr.toString();
    }

    public static CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = new CalcSettleResult();
        result.setStatus(status);
        result.setRemark(remark);
        result.setRemarkTag(remarkTag);
        return result;
    }

    public static List<Long> getCheckitemIds(String caltype, String appnum) {
        ArrayList<Long> checkItemIds = new ArrayList<Long>(10);
        QFilter filter = new QFilter("appnum", "=", (Object)appnum);
        filter.and(new QFilter("caltype", "=", (Object)caltype));
        Map tasksMap = BusinessDataServiceHelper.loadFromCache((String)"cad_checktask", (String)"entryentity.seq,entryentity.checkitem,entryentity.isenable,entryentity.level", (QFilter[])filter.toArray(), null);
        for (Map.Entry task : tasksMap.entrySet()) {
            DynamicObject value = (DynamicObject)task.getValue();
            DynamicObjectCollection taskEntryEntity = value.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)taskEntryEntity)) continue;
            for (DynamicObject taskEntry : taskEntryEntity) {
                if (!taskEntry.getBoolean("isenable")) continue;
                checkItemIds.add(taskEntry.getLong("checkitem.id"));
            }
        }
        return checkItemIds;
    }
}

