/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.executor;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.model.CalcSettleContext;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.TaskOperDto;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class TaskOperExecutor {
    private static final Log logger = LogFactory.getLog(TaskOperExecutor.class);
    private static final int MIN_BATCH_SIZE = 10;
    private static final int DEFAULT_BATCH_SIZE = 100;

    public static CalcSettleResult execute(Long taskId, DynamicObject taskDyn, CalcSettleContext context) {
        String operParam = taskDyn.getString("calcparam");
        logger.info("\u6708\u7ed3\u4efb\u52a1-\u64cd\u4f5c\u6267\u884c\uff1ataskId:{},\u53c2\u6570\u4fe1\u606f:{}", (Object)taskId, (Object)operParam);
        if (StringUtils.isEmpty((CharSequence)operParam)) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u83b7\u53d6\u64cd\u4f5c\u53c2\u6570\u5931\u8d25\u3002", (String)"TaskOperExecutor_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        TaskOperDto taskOperParam = null;
        try {
            taskOperParam = (TaskOperDto)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)operParam), TaskOperDto.class);
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362json\u62a5\u9519", (Throwable)ex);
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u83b7\u53d6\u64cd\u4f5c\u53c2\u6570\u5931\u8d25\u3002", (String)"TaskOperExecutor_0", (String)"macc-cad-business", (Object[])new Object[0]), "json parse error:" + operParam);
        }
        if (taskOperParam == null || StringUtils.isEmpty((CharSequence)taskOperParam.getBussiness()) || StringUtils.isEmpty((CharSequence)taskOperParam.getOper())) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u64cd\u4f5c\u6821\u9a8c\u5931\u8d25\u3002", (String)"TaskOperExecutor_1", (String)"macc-cad-business", (Object[])new Object[0]), taskOperParam == null ? "{}" : JSON.toJSONString((Object)taskOperParam));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)taskOperParam.getBussiness());
        if (type == null) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u4e1a\u52a1\u64cd\u4f5c\u5bf9\u5e94\u7684\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u64cd\u4f5c\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"TaskOperExecutor_2", (String)"macc-cad-business", (Object[])new Object[0]), taskOperParam == null ? "{}" : JSON.toJSONString((Object)taskOperParam));
        }
        List<QFilter> qfilterList = TaskOperExecutor.getDataQFilter(taskOperParam, context, type);
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"settleBusBill", (String)taskOperParam.getBussiness(), (String)"id", (QFilter[])qfilterList.toArray(new QFilter[0]), (String)"");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        return TaskOperExecutor.taskExecute(ids, taskOperParam);
    }

    private static CalcSettleResult taskExecute(List<Long> ids, TaskOperDto taskOperParam) {
        int batch = CadBgParamUtils.getCadParamForInt((String)"settleTaskOperBatch", (int)100);
        if (batch < 10) {
            batch = 10;
        }
        boolean isHasFail = false;
        StringBuilder sbMsg = new StringBuilder();
        List splitLists = Lists.partition(new ArrayList<Long>(ids), (int)batch);
        logger.info("\u6708\u7ed3\u4efb\u52a1-\u64cd\u4f5c\u6267\u884c\uff1a\u603b\u5355\u636e\u6570:{},\u6279\u6570:{}", (Object)ids.size(), (Object)splitLists.size());
        for (List list : splitLists) {
            OperationResult result = OperationServiceHelper.executeOperate((String)taskOperParam.getOper(), (String)taskOperParam.getBussiness(), (Object[])list.toArray(), (OperateOption)OperateOption.create());
            if (result.isSuccess()) continue;
            isHasFail = true;
            sbMsg.append(OperationResultHelper.errorMsgHandle((OperationResult)result));
        }
        if (!isHasFail) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_SUCC.getValue(), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u5b8c\u6210\u3002\u6267\u884c\u5355\u636e\u6570\u91cf\uff1a%s\u4e2a\u3002", (String)"TaskOperExecutor_3", (String)"macc-cad-business", (Object[])new Object[0]), ids.size()), null);
        }
        return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u5b58\u5728\u5931\u8d25\u9879\u3002\u6267\u884c\u5355\u636e\u6570\u91cf\uff1a%s\u4e2a\u3002", (String)"TaskOperExecutor_4", (String)"macc-cad-business", (Object[])new Object[0]), ids.size()), sbMsg.toString());
    }

    private static List<QFilter> getDataQFilter(TaskOperDto taskOperParam, CalcSettleContext context, MainEntityType type) {
        QFilter extFilter;
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        if (!StringUtils.isEmpty((CharSequence)taskOperParam.getOrg())) {
            qfilterList.add(new QFilter(taskOperParam.getOrg(), "=", (Object)context.getOrgId()));
        }
        if (!StringUtils.isEmpty((CharSequence)taskOperParam.getCostaccount())) {
            qfilterList.add(new QFilter(taskOperParam.getCostaccount(), "=", (Object)context.getCostaccountId()));
        }
        if (!StringUtils.isEmpty((CharSequence)taskOperParam.getBookdate())) {
            qfilterList.add(new QFilter(taskOperParam.getBookdate(), ">=", (Object)context.getStartDate()));
            qfilterList.add(new QFilter(taskOperParam.getBookdate(), "<=", (Object)context.getEndDate()));
        }
        if ((extFilter = TaskOperExecutor.getFilter(type, taskOperParam.getDatafilter())) != null) {
            qfilterList.add(extFilter);
        }
        return qfilterList;
    }

    private static QFilter getFilter(MainEntityType type, String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return null;
        }
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)filter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getQFilter();
    }
}

