/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.executor;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.settle.ICalcSettleTask;
import kd.macc.cad.business.settle.TaskProgressRunable;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.model.CalcSettleContext;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.model.TaskExecuteDto;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import org.apache.commons.lang3.StringUtils;

public class TaskPluginExecutor {
    private static final Log logger = LogFactory.getLog(TaskPluginExecutor.class);

    public static CalcSettleResult execute(Long taskId, DynamicObject taskDyn, CalcSettleContext context) {
        String plugin = taskDyn.getString("plugin");
        Class<?> pluginClass = null;
        try {
            pluginClass = Class.forName(plugin);
        }
        catch (ClassNotFoundException e) {
            logger.error("\u4efb\u52a1\u53d1\u8d77\u6267\u884c-\u8f6c\u6362\u63d2\u4ef6\u7c7b\u5931\u8d25\uff1a{},{}", (Object)plugin, (Object)e.getMessage());
        }
        if (pluginClass == null) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u83b7\u53d6\u7c7b\u7684\u5b9e\u4f8b\u5931\u8d25\u3002\u8bf7\u786e\u8ba4\u7c7b\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"TaskPluginExecutor_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Object pluginIns = null;
        try {
            pluginIns = pluginClass.newInstance();
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u53d1\u8d77\u6267\u884c-\u83b7\u53d6\u63d2\u4ef6\u7c7b\u5b9e\u4f8b\u5931\u8d25\uff1a{},{}", (Object)pluginClass.toString(), (Object)e.getMessage());
        }
        if (pluginIns == null) {
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u63d2\u4ef6\u7c7b\u7684\u5b9e\u4f8b\u5316\u5931\u8d25\u3002", (String)"TaskPluginExecutor_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        try {
            if (pluginIns instanceof ICalcSettleTask) {
                return TaskPluginExecutor.maccTaskExecute(pluginIns, context, taskDyn, taskId);
            }
            return TaskPluginExecutor.refTaskExecute(pluginClass, pluginIns, context, taskDyn, taskId);
        }
        catch (Exception e) {
            String kdBizMsg = TaskPluginExecutor.getKDBizExeception(e);
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a%s", (String)"TaskPluginExecutor_2", (String)"macc-cad-business", (Object[])new Object[0]), kdBizMsg != null ? kdBizMsg : e.getMessage()), kdBizMsg != null ? "" : (String)CalcSettleHelper.getExceptionErrorInfo((Exception)e).t2);
        }
    }

    private static String getKDBizExeception(Exception e) {
        InvocationTargetException te;
        if (e instanceof KDBizException) {
            return e.getMessage();
        }
        if (e instanceof InvocationTargetException && (te = (InvocationTargetException)e).getTargetException() instanceof KDBizException) {
            return te.getTargetException().getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CalcSettleResult maccTaskExecute(Object pluginIns, CalcSettleContext context, DynamicObject taskDyn, Long taskId) {
        ICalcSettleTask taskPlugin = (ICalcSettleTask)pluginIns;
        taskPlugin.setContext(context);
        boolean mannulconfirm = taskDyn.getBoolean("mannulconfirm");
        if (mannulconfirm) {
            CalcSettleResult result = new CalcSettleResult();
            result.setConfirm(false);
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
            result.setJumpPages(taskPlugin.getSourcePageParam());
            return result;
        }
        TaskExecuteDto taskExecuteDto = null;
        if (taskPlugin.enableProgress()) {
            taskExecuteDto = new TaskExecuteDto();
            taskExecuteDto.setTaskId(taskId);
            taskExecuteDto.setTaskPlugin(taskPlugin);
            TaskProgressRunable.getInstance().addTaskDto(taskExecuteDto);
            TaskPluginExecutor.startTaskExecute();
        }
        try {
            CalcSettleResult result = taskPlugin.doExecute();
            CalcSettleResult calcSettleResult = taskPlugin.doAfterExecute(result);
            return calcSettleResult;
        }
        catch (Exception e) {
            logger.error("\u63d2\u4ef6\u6267\u884c\u62a5\u9519", (Throwable)e);
            String errorMsg = ResManager.loadKDString((String)"\u63d2\u4ef6\u6267\u884c\u62a5\u9519\u3002", (String)"TaskPluginExecutor_3", (String)"macc-cad-business", (Object[])new Object[0]);
            String kdBizMsg = TaskPluginExecutor.getKDBizExeception(e);
            if (kdBizMsg != null) {
                errorMsg = kdBizMsg;
            }
            CalcSettleResult calcSettleResult = CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), errorMsg, kdBizMsg != null ? "" : (String)CalcSettleHelper.getExceptionErrorInfo((Exception)e).t2);
            return calcSettleResult;
        }
        finally {
            if (taskExecuteDto != null) {
                taskExecuteDto.setStop(true);
            }
        }
    }

    public static synchronized void startTaskExecute() {
        if (!TaskProgressRunable.getInstance().taskProgressThreadRun.get()) {
            TaskProgressRunable.getInstance().taskProgressThreadRun.set(true);
            ThreadHelper.execute((Runnable)TaskProgressRunable.getInstance(), (TaskType)TaskType.CAD_SETTLE_PROCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CalcSettleResult refTaskExecute(Class<?> pluginClass, Object pluginIns, CalcSettleContext context, DynamicObject taskDyn, Long taskId) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method doExecuteMf = null;
        Method getSourcePageParamMf = null;
        Method enableProgressMf = null;
        try {
            doExecuteMf = pluginClass.getMethod("doExecute", String.class);
            getSourcePageParamMf = pluginClass.getMethod("getSourcePageParam", String.class);
            enableProgressMf = pluginClass.getMethod("enableProgress", new Class[0]);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53cd\u5c04\u65b9\u6cd5\u62a5\u9519", (Throwable)e);
            return CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u53cd\u5c04\u83b7\u53d6\u65b9\u6cd5\u62a5\u9519\uff1a%s", (String)"TaskPluginExecutor_4", (String)"macc-cad-business", (Object[])new Object[0]), e.getMessage()), null);
        }
        boolean mannulconfirm = taskDyn.getBoolean("mannulconfirm");
        if (mannulconfirm) {
            CalcSettleResult result = new CalcSettleResult();
            result.setConfirm(false);
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
            String sourcePageParam = (String)getSourcePageParamMf.invoke(pluginIns, JSON.toJSONString((Object)context));
            if (StringUtils.isNotEmpty((CharSequence)sourcePageParam)) {
                result.setJumpPages(JSON.parseArray((String)sourcePageParam, SettleJumpPage.class));
            }
            return result;
        }
        boolean enableProgress = (Boolean)enableProgressMf.invoke(pluginIns, new Object[0]);
        TaskExecuteDto taskExecuteDto = null;
        if (enableProgress) {
            taskExecuteDto = new TaskExecuteDto();
            taskExecuteDto.setTaskId(taskId);
            taskExecuteDto.setTaskPlugin(pluginIns);
            TaskPluginExecutor.startTaskExecute();
        }
        try {
            String calcResultStr = (String)doExecuteMf.invoke(pluginIns, JSON.toJSONString((Object)context));
            CalcSettleResult calcSettleResult = (CalcSettleResult)JSON.parseObject((String)calcResultStr, CalcSettleResult.class);
            return calcSettleResult;
        }
        catch (Exception e) {
            String kdBizMsg = TaskPluginExecutor.getKDBizExeception(e);
            logger.error("\u53cd\u5c04\u6267\u884c\u63d2\u4ef6\u5931\u8d25", (Throwable)e);
            CalcSettleResult result = CalcSettleHelper.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u6267\u884c\u62a5\u9519\uff1a%s\u3002", (String)"TaskPluginExecutor_5", (String)"macc-cad-business", (Object[])new Object[0]), kdBizMsg != null ? kdBizMsg : e.getMessage()), kdBizMsg != null ? "" : (String)CalcSettleHelper.getExceptionErrorInfo((Exception)e).t2);
            String sourcePageParam = (String)getSourcePageParamMf.invoke(pluginIns, new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)sourcePageParam)) {
                result.setJumpPages(JSON.parseArray((String)sourcePageParam, SettleJumpPage.class));
            }
            CalcSettleResult calcSettleResult = result;
            return calcSettleResult;
        }
        finally {
            if (taskExecuteDto != null) {
                taskExecuteDto.setStop(true);
            }
        }
    }
}

