/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public abstract class AcaTerminalBaseTask
extends AbstractSettleTask {
    protected volatile long taskRecordId = 0L;
    protected static final String CALC_PERM = "4730fc9f000025ae";
    protected static final String CHECK_PERM = "0K6+MBJCKDS2";
    protected static final String ENTITY = "aca_terminalcalwizards";

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc", (String)"AcaTerminalBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_FORM.getValue());
        page.setSourcepage(ENTITY);
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("orgId", this.context.getOrgId());
        page.setParam(param);
        return Collections.singletonList(page);
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public boolean enableProgress() {
        return true;
    }

    @Override
    public int getProgress() {
        DynamicObject taskRecord;
        if (!CadEmptyUtils.isEmpty((Long)this.taskRecordId) && (taskRecord = BusinessDataServiceHelper.loadSingle((Object)this.taskRecordId, (String)"sca_taskrecord", (String)"progress")) != null) {
            return taskRecord.getInt("progress");
        }
        return 0;
    }

    protected JSONObject buildCalcParam() {
        JSONObject calcParamJs = new JSONObject();
        calcParamJs.put("org", (Object)this.context.getOrgId());
        calcParamJs.put("costaccount", (Object)this.context.getCostaccountId());
        calcParamJs.put("period", (Object)this.context.getPeriodId());
        calcParamJs.put("startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put("endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put("currencyId", (Object)this.context.getCurrencyId());
        calcParamJs.put("allinvmatcalout", (Object)true);
        calcParamJs.put("calcreduct", (Object)false);
        calcParamJs.put("calccmpanal", (Object)false);
        calcParamJs.put("conversionsubdetail", (Object)false);
        calcParamJs.put("nestmatcheck", (Object)4000);
        calcParamJs.put("matlevelonecalout", (Object)true);
        calcParamJs.put("nestmatautorework", (Object)false);
        calcParamJs.put("importfacttransfer", (Object)false);
        calcParamJs.put("calcsize", (Object)1);
        calcParamJs.put("negaunitpricedeal", (Object)false);
        calcParamJs.put("calSchemeId", (Object)0L);
        return calcParamJs;
    }

    protected void mergeCalParam(JSONObject targetObj, String calParam) {
        logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97\u65b9\u6848\u4fe1\u606f\uff1a{}", (Object)calParam);
        if (StringUtils.isEmpty((String)calParam)) {
            return;
        }
        JSONObject srcObj = JSON.parseObject((String)calParam);
        if (srcObj == null) {
            return;
        }
        Long schemeId = srcObj.getLong("calscheme");
        if (CadEmptyUtils.isEmpty((Long)schemeId)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject schemeDyn = QueryServiceHelper.queryOne((String)"cad_query_scheme", (String)"id,formid,schemestr_tag", (QFilter[])new QFilter[]{filter});
        if (schemeDyn == null) {
            logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97\u672a\u627e\u5230\u65b9\u6848\u4fe1\u606f\uff1a{}", (Object)schemeId);
            return;
        }
        String entityId = schemeDyn.getString("formid");
        if (!ENTITY.equals(entityId)) {
            logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97\u7684\u65b9\u6848\u5b9e\u4f53\u4e0d\u5339\u914d\uff1a{}", (Object)entityId);
            return;
        }
        try {
            DynamicObject schemeSrcDyn = this.toDynamicObject(schemeDyn.getString("schemestr_tag"), entityId);
            targetObj.put("allinvmatcalout", (Object)schemeSrcDyn.getBoolean("allinvmatcalout"));
            targetObj.put("calcreduct", (Object)schemeSrcDyn.getBoolean("calcreduct"));
            targetObj.put("calccmpanal", (Object)schemeSrcDyn.getBoolean("calccmpanal"));
            targetObj.put("nestmatcheck", (Object)schemeSrcDyn.getInt("nestmatcheck"));
            targetObj.put("matlevelonecalout", (Object)schemeSrcDyn.getBoolean("matlevelonecalout"));
            targetObj.put("nestmatautorework", (Object)schemeSrcDyn.getBoolean("nestmatautorework"));
            targetObj.put("importfacttransfer", (Object)schemeSrcDyn.getBoolean("importfacttransfer"));
            targetObj.put("calcsize", (Object)schemeSrcDyn.getInt("calcsize"));
            targetObj.put("negaunitpricedeal", (Object)schemeSrcDyn.getBoolean("negaunitpricedeal"));
            DynamicObject calScheme = schemeSrcDyn.getDynamicObject("calscheme");
            if (calScheme != null) {
                targetObj.put("calSchemeId", (Object)calScheme.getLong("id"));
            }
        }
        catch (Exception ex) {
            logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97\u7684\u65b9\u6848\u89e3\u6790\u62a5\u9519\uff1a", (Object)ex);
            throw ex;
        }
    }

    protected DynamicObject getFormDycByScheme(DynamicObject schemeDyc) {
        String filterSchemeStr = schemeDyc.getString("schemestr_tag");
        String entityId = schemeDyc.getString("formid");
        DynamicObject formDyc = this.toDynamicObject(filterSchemeStr, entityId);
        return formDyc;
    }

    private DynamicObject toDynamicObject(String schemeJson, String entityId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        if (StringUtils.isEmpty((String)schemeJson)) {
            return new DynamicObject((DynamicObjectType)type);
        }
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String custfilters = (String)filterMap.get("custfilters");
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject fromDataDyc = (DynamicObject)jser.deserializeFromString(custfilters, null);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{fromDataDyc}, (IDataEntityType)type);
        return fromDataDyc;
    }
}

