/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.AcaTerminalBaseTask;
import kd.macc.cad.business.settle.task.CostRecoveryCalcTask;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.TaskHelper;

public class AcaTerminalCalcTask
extends AcaTerminalBaseTask {
    public static final Long CALCCHECKCONFIGID = 962097724725951488L;

    @Override
    public CalcSettleResult doExecute() {
        JSONObject calcParam = this.buildCalcParam();
        this.mergeCalParam(calcParam, this.context.getCalcparam());
        logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u53c2\u6570\uff1a{}", (Object)calcParam);
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"aca_terminalcalwizards", (String)"4730fc9f000025ae")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc\u201d\u7684\u201c\u8ba1\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AcaTerminalCalcTask_8", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        int calcsize = calcParam.getIntValue("calcsize");
        if (calcsize < 1) {
            calcsize = 1;
        } else if (calcsize > 5) {
            calcsize = 5;
        }
        JSONObject resultObj = null;
        CalcSettleResult result = null;
        for (int i = 0; i < calcsize; ++i) {
            String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)this.context.getCostaccountId());
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                result = this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), lockErrStr, lockErrStr);
                this.getCalcReportListPage(result);
                return result;
            }
            this.taskRecordId = TaskHelper.initTaskRecord((Long)CALCCHECKCONFIGID);
            calcParam.put("taskRecordId", (Object)this.taskRecordId);
            calcParam.put("appNum", (Object)this.context.getAppnum());
            String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"actPeriodEndCalc", (Object[])new Object[]{calcParam.toString()});
            logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u8fd4\u56de\u503c\uff1a{}", (Object)resultInfo);
            if (StringUtils.isEmpty((String)resultInfo)) {
                result = this.getCalcSettleResult(CalcSettleEnum.SETTLESTATUS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u7684\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"AcaTerminalCalcTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
                this.getCalcReportListPage(result);
                return result;
            }
            resultObj = JSON.parseObject((String)resultInfo);
            String recordStatus = this.getCalStatus(resultObj, this.taskRecordId);
            String calcStatus = resultObj.getString("calcStatus");
            if (recordStatus != null) {
                calcStatus = recordStatus;
            }
            result = new CalcSettleResult();
            if ("3".equals(calcStatus)) {
                result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
            } else if ("5".equals(calcStatus)) {
                result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
            }
            if ("3".equals(calcStatus)) break;
        }
        if (result == null) {
            return result;
        }
        if (resultObj != null && resultObj.containsKey((Object)"calcReportId")) {
            Long calcReportId = resultObj.getLongValue("calcReportId");
            SettleJumpPage calcReportPage = new SettleJumpPage();
            calcReportPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            calcReportPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"AcaTerminalCalcTask_1", (String)"macc-cad-business", (Object[])new Object[0]));
            calcReportPage.setSourcepage("aca_calcreport");
            calcReportPage.getParam().put("id", calcReportId);
            result.getJumpPages().add(calcReportPage);
        }
        if ((CalcSettleEnum.SETTLESTATUS_WARN.getValue().equals(result.getStatus()) || CalcSettleEnum.SETTLESTATUS_SUCC.getValue().equals(result.getStatus())) && calcParam.getBooleanValue("calcreduct")) {
            logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u8dd1\u6210\u672c\u8fd8\u539f\uff1a{}", (Object)calcParam);
            this.costRecoveryCalc();
        }
        this.setJumpPage(result);
        result.setRemark(" ");
        result.setRemarkTag(" ");
        return result;
    }

    private void costRecoveryCalc() {
        CostRecoveryCalcTask calcTask = new CostRecoveryCalcTask();
        calcTask.setContext(this.context);
        calcTask.doExecute();
    }

    private void getCalcReportListPage(CalcSettleResult result) {
        SettleJumpPage calcReportPage = new SettleJumpPage();
        calcReportPage.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        calcReportPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a\u5217\u8868", (String)"AcaTerminalCalcTask_7", (String)"macc-cad-business", (Object[])new Object[0]));
        calcReportPage.setSourcepage("aca_calcreport");
        calcReportPage.getParam().put("orgId", this.context.getOrgId());
        result.getJumpPages().add(calcReportPage);
    }

    private void setJumpPage(CalcSettleResult result) {
        SettleJumpPage matCheckPage = new SettleJumpPage();
        matCheckPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        matCheckPage.setName(ResManager.loadKDString((String)"\u6750\u6599\u5206\u914d\u4e0e\u8ba1\u7b97\u5bf9\u8d26\u8868", (String)"AcaTerminalCalcTask_2", (String)"macc-cad-business", (Object[])new Object[0]));
        matCheckPage.setSourcepage("aca_matcalcanalrpt");
        matCheckPage.setQuery(true);
        this.initCalcAnnelParam(matCheckPage);
        result.getJumpPages().add(matCheckPage);
        SettleJumpPage mfgCheckPage = new SettleJumpPage();
        mfgCheckPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        mfgCheckPage.setName(ResManager.loadKDString((String)"\u8d39\u7528\u5206\u914d\u4e0e\u8ba1\u7b97\u5bf9\u8d26\u8868", (String)"AcaTerminalCalcTask_3", (String)"macc-cad-business", (Object[])new Object[0]));
        mfgCheckPage.setSourcepage("aca_mfgcocalcanalrpt");
        mfgCheckPage.setQuery(true);
        this.initCalcAnnelParam(mfgCheckPage);
        result.getJumpPages().add(mfgCheckPage);
        SettleJumpPage report1Page = new SettleJumpPage();
        report1Page.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        report1Page.setName(ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355", (String)"AcaTerminalCalcTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
        report1Page.setSourcepage("aca_calcresultnew");
        report1Page.getParam().put("custparam", this.getCalcReportJsonObj().toString());
        result.getJumpPages().add(report1Page);
        SettleJumpPage report2Page = new SettleJumpPage();
        report2Page.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        report2Page.setName(ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355\uff08\u6a2a\u5411\uff09", (String)"AcaTerminalCalcTask_5", (String)"macc-cad-business", (Object[])new Object[0]));
        report2Page.setSourcepage("aca_costsumquerynew");
        report2Page.getParam().put("custparam", this.getCalcReportJsonObj().toString());
        result.getJumpPages().add(report2Page);
        SettleJumpPage transferPage = new SettleJumpPage();
        transferPage.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        transferPage.setName(ResManager.loadKDString((String)"\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355", (String)"AcaTerminalCalcTask_6", (String)"macc-cad-business", (Object[])new Object[0]));
        transferPage.setSourcepage("aca_finishcosttranfer");
        transferPage.getParam().put("org", this.context.getOrgId());
        transferPage.getParam().put("costaccount", this.context.getCostaccountId());
        transferPage.getParam().put("period", this.context.getPeriodId());
        transferPage.getParam().put("source", "HyperLink");
        result.getJumpPages().add(transferPage);
    }

    private JSONObject getCalcReportJsonObj() {
        JSONObject obj = new JSONObject();
        obj.put("orgId", (Object)this.context.getOrgId());
        obj.put("costAccountId", (Object)this.context.getCostaccountId());
        obj.put("periodId", (Object)this.context.getPeriodId());
        return obj;
    }

    private void initCalcAnnelParam(SettleJumpPage report1Page) {
        report1Page.getParam().put("org", this.context.getOrgId());
        report1Page.getParam().put("costaccount", this.context.getCostaccountId());
        report1Page.getParam().put("period", this.context.getPeriodId());
        report1Page.getParam().put("showsubelement", Boolean.TRUE);
        report1Page.getParam().put("onlyshowdiff", Boolean.TRUE);
        report1Page.getParam().put("showmatdetail", Boolean.TRUE);
    }

    private String getCalStatus(JSONObject resultObj, Long taskRecordId) {
        DynamicObject reportRecord;
        if (resultObj.containsKey((Object)"calcReportId") && (reportRecord = BusinessDataServiceHelper.loadSingle((Object)resultObj.getLongValue("calcReportId"), (String)"aca_calcreport", (String)"type")) != null) {
            return reportRecord.getString("type");
        }
        reportRecord = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"sca_taskrecord", (String)"status");
        if (reportRecord != null) {
            return reportRecord.getString("status");
        }
        return null;
    }
}

