/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.AcaTerminalBaseTask;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.utils.CadPermissionUtil;
import org.apache.commons.lang3.StringUtils;

public class AcaTerminalCheckTask
extends AcaTerminalBaseTask {
    @Override
    public CalcSettleResult doExecute() {
        String caltype = "aca_terminalcalwizards";
        JSONObject calcParamJs = this.buildCalcParam();
        this.mergeCalParam(calcParamJs, this.context.getCalcparam());
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"aca_terminalcalwizards", (String)"0K6+MBJCKDS2")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc\u201d\u7684\u201c\u68c0\u67e5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AcaTerminalCheckTask_3", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        List<Long> checkitemIds = this.getCheckitemIds(caltype);
        calcParamJs.put("checkItemList", checkitemIds);
        String checkType = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"AcaTerminalCheckTask_0", (String)"macc-cad-business", (Object[])new Object[0]);
        this.taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, checkitemIds, (String)caltype, (String)this.context.getAppnum());
        calcParamJs.put("taskRecordId", (Object)this.taskRecordId);
        calcParamJs.put("appNum", (Object)this.context.getAppnum());
        String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"actPeriodEndCalcCheck", (Object[])new Object[]{calcParamJs.toString()});
        logger.info("\u671f\u672b\u5408\u6cd5\u6027\u68c0\u67e5-\u8fd4\u56de\u503c\uff1a{}", (Object)resultInfo);
        if (StringUtils.isEmpty((CharSequence)resultInfo)) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESTATUS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u7684\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"AcaTerminalCheckTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        JSONObject resultObj = JSON.parseObject((String)resultInfo);
        CalcSettleResult result = new CalcSettleResult();
        if ("3".equals(resultObj.getString("calcStatus"))) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
        } else if ("5".equals(resultObj.getString("calcStatus"))) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
        }
        if (resultObj.containsKey((Object)"checkResultId")) {
            Long calcReportId = resultObj.getLongValue("checkResultId");
            SettleJumpPage jumpPage = new SettleJumpPage();
            jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            jumpPage.setName(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"AcaTerminalCheckTask_2", (String)"macc-cad-business", (Object[])new Object[0]));
            jumpPage.setSourcepage("aca_calcreport");
            jumpPage.getParam().put("id", calcReportId);
            result.getJumpPages().add(jumpPage);
        }
        return result;
    }

    private List<Long> getCheckitemIds(String caltype) {
        return CalcSettleHelper.getCheckitemIds(caltype, this.context.getAppnum());
    }
}

