/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONObject;

public abstract class CostRecoveryBaseTask
extends AbstractSettleTask {
    protected volatile long taskRecordId = 0L;
    protected static final String ENTITY = "sca_factcostreduction";
    protected static final String CHECK_PERM = "0K6+MBJCKDS2";
    protected static final String CALC_PERM = "4730fc9f000025ae";
    protected static final Long SCA_CHECKCONFIG_ID = 1158038491649541120L;
    protected static final Long ACA_CHECKCONFIG_ID = 1386108939132735488L;
    protected static final Long CALCTASKID = 1157876764429562880L;

    @Override
    public boolean enableProgress() {
        return true;
    }

    @Override
    public int getProgress() {
        DynamicObject taskRecord;
        if (!CadEmptyUtils.isEmpty((Long)this.taskRecordId) && (taskRecord = BusinessDataServiceHelper.loadSingle((Object)this.taskRecordId, (String)"sca_taskrecord", (String)"progress")) != null) {
            return taskRecord.getInt("progress");
        }
        return 0;
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f", (String)"CostRecoveryBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_FORM.getValue());
        page.setSourcepage(ENTITY);
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("orgId", this.context.getOrgId());
        page.setParam(param);
        return Collections.singletonList(page);
    }

    public static DynamicObject getCostParam(Long orgId, Long costaccountId, String appNum) {
        Map params;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("costaccount", "=", (Object)costaccountId));
        qFilter.and(new QFilter("tab", "=", (Object)"costaccounttabpage"));
        if (!StringUtils.isEmpty((String)appNum)) {
            qFilter.and(new QFilter("appnum", "=", (Object)appNum));
        }
        if ((params = BusinessDataServiceHelper.loadFromCache((String)"cad_sysparam", (QFilter[])qFilter.toArray())).size() > 0) {
            return (DynamicObject)params.values().iterator().next();
        }
        return null;
    }

    protected String getCalStatus(Long calcReportId, Long taskRecordId) {
        DynamicObject reportRecord;
        if (!CadEmptyUtils.isEmpty((Long)calcReportId) && (reportRecord = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_reductreport", (String)"type")) != null) {
            return reportRecord.getString("type");
        }
        reportRecord = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"sca_taskrecord", (String)"status");
        if (reportRecord != null) {
            return reportRecord.getString("status");
        }
        return null;
    }

    protected void setResultStatus(CalcSettleResult result, String calcStatus) {
        String curStatus = CalcSettleEnum.SETTLESUB_SUCC.getValue();
        if ("3".equals(calcStatus)) {
            curStatus = CalcSettleEnum.SETTLESTATUS_FAIL.getValue();
        } else if ("5".equals(calcStatus)) {
            curStatus = CalcSettleEnum.SETTLESTATUS_WARN.getValue();
        }
        if (CalcSettleEnum.SETTLESTATUS_FAIL.getValue().equals(result.getStatus()) || CalcSettleEnum.SETTLESTATUS_FAIL.getValue().equals(curStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
            return;
        }
        if (CalcSettleEnum.SETTLESTATUS_WARN.getValue().equals(result.getStatus()) || CalcSettleEnum.SETTLESTATUS_WARN.getValue().equals(curStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
            return;
        }
        result.setStatus(curStatus);
    }

    protected JSONObject getParam(String restoredimension, String restoreCalcRange, DynamicObjectCollection restoreGetDataRanges) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"calOrgId", (Object)this.context.getOrgId());
        obj.put((Object)"costAccountId", (Object)this.context.getCostaccountId());
        obj.put((Object)"periodId", (Object)this.context.getPeriodId());
        obj.put((Object)"startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        obj.put((Object)"endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        obj.put((Object)"currencyId", (Object)this.context.getCurrencyId());
        obj.put((Object)"taskId", (Object)0L);
        obj.put((Object)"isUsePreConstr", (Object)false);
        obj.put((Object)"checkConfigId", (Object)this.getCheckTaskId());
        obj.put((Object)"periodIsCurrent", (Object)"Y");
        obj.put((Object)"calRange", (Object)restoreCalcRange);
        obj.put((Object)"calDimension", (Object)restoredimension);
        obj.put((Object)"appnum", (Object)this.context.getAppnum());
        HashMap<String, Long> relaOrgCostAccountMap = new HashMap<String, Long>();
        HashSet<Long> allOrgIds = new HashSet<Long>(16);
        HashSet<Long> allCostAccounts = new HashSet<Long>(16);
        allOrgIds.add(this.context.getOrgId());
        allCostAccounts.add(this.context.getCostaccountId());
        relaOrgCostAccountMap.put(String.valueOf(this.context.getOrgId()), this.context.getCostaccountId());
        obj.put((Object)"relationCalOrgIds", allOrgIds);
        obj.put((Object)"relationCostAccountIds", allCostAccounts);
        obj.put((Object)"relaOrgCostAccountMap", relaOrgCostAccountMap);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)restoreGetDataRanges)) {
            ArrayList<Long> costaccountIds = new ArrayList<Long>(10);
            for (DynamicObject dyn : restoreGetDataRanges) {
                Long accountId = dyn.getLong("fbasedataid.id");
                costaccountIds.add(accountId);
            }
            QFilter filter = new QFilter("id", "in", costaccountIds);
            DynamicObjectCollection dynCols = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg.id calorg,id", (QFilter[])filter.toArray());
            for (DynamicObject dyn : dynCols) {
                Long orgId = dyn.getLong("calorg");
                Long accountId = dyn.getLong("id");
                allOrgIds.add(orgId);
                allCostAccounts.add(accountId);
                relaOrgCostAccountMap.put(String.valueOf(orgId), accountId);
            }
        }
        return obj;
    }

    protected void setReportPage(CalcSettleResult result, List<Long> reportIds, String pageName) {
        if (CadEmptyUtils.isEmpty(reportIds)) {
            return;
        }
        for (int i = 0; i < reportIds.size(); ++i) {
            SettleJumpPage jumpPage = new SettleJumpPage();
            jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            if (reportIds.size() == 1) {
                jumpPage.setName(pageName);
            } else {
                jumpPage.setName(pageName + (i + 1));
            }
            jumpPage.setSourcepage("sca_reductreport");
            jumpPage.getParam().put("id", reportIds.get(i));
            result.getJumpPages().add(jumpPage);
        }
    }

    protected List<Long> getCheckitemIds(String caltype) {
        return CalcSettleHelper.getCheckitemIds(caltype, this.context.getAppnum());
    }

    protected long getCheckTaskId() {
        if ("aca".equals(this.context.getAppnum())) {
            return ACA_CHECKCONFIG_ID;
        }
        return SCA_CHECKCONFIG_ID;
    }
}

