/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.CostRecoveryBaseTask;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.TaskHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CostRecoveryCalcTask
extends CostRecoveryBaseTask {
    @Override
    public CalcSettleResult doExecute() {
        DynamicObject costParam = CostRecoveryCalcTask.getCostParam(this.context.getOrgId(), this.context.getCostaccountId(), this.context.getAppnum());
        if (costParam == null) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5728\u6210\u672c\u53c2\u6570-\u6210\u672c\u6838\u7b97\u53c2\u6570\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"CostRecoveryCalcTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"sca_factcostreduction", (String)"4730fc9f000025ae")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u201d\u7684\u201c\u8ba1\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostRecoveryCalcTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        List productOrgs = null;
        String restoredimension = costParam.getString("restoredimension");
        String restoreCalcRange = costParam.getString("restorecalcrange");
        if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(restoredimension) && !restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_TRANSDIRBILL.getValue()) && !restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && CadEmptyUtils.isEmpty((List)(productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)this.context.getOrgId(), (String)"sca_factcostreduction", (String)"4730fc9f000025ae", (String)this.context.getAppnum())))) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u751f\u4ea7\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostRecoveryCalcTask_2", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        DynamicObjectCollection restoreGetDataRanges = costParam.getDynamicObjectCollection("restoregetdatarange");
        if (restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && !restoreGetDataRanges.isEmpty() && ((DynamicObject)restoreGetDataRanges.get(0)).getLong("fbasedataid.id") == 0L) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\u5305\u542b\u91c7\u8d2d\u5165\u5e93\u5355\uff0c\u9700\u8981\u914d\u7f6e\u5173\u8054\u8d26\u7c3f\u3002", (String)"CostRecoveryCalcTask_3", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        return this.reductCalc(restoredimension, restoreCalcRange, restoreGetDataRanges, productOrgs);
    }

    protected void mergeCalParam(JSONObject targetObj, String calParam) {
        logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97\u65b9\u6848\u4fe1\u606f\uff1a{}", (Object)calParam);
        if (StringUtils.isEmpty((String)calParam)) {
            return;
        }
        JSONObject srcObj = JSONObject.fromObject((Object)calParam);
        if (srcObj == null) {
            return;
        }
        if (!srcObj.containsKey((Object)"entryEntityList")) {
            return;
        }
        JSONArray arr = srcObj.getJSONArray("entryEntityList");
        if (arr == null || arr.isEmpty()) {
            return;
        }
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject jsonObj = arr.getJSONObject(i);
            if (jsonObj == null || !"isrecalset".equals(jsonObj.get("key"))) continue;
            if (!"1".equals(jsonObj.getString("value"))) break;
            targetObj.put((Object)"isUsePreConstr", (Object)true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalcSettleResult reductCalc(String restoredimension, String restoreCalcRange, DynamicObjectCollection restoreGetDataRanges, List<Long> productOrgs) {
        ArrayList<Long> reportIds = new ArrayList<Long>(10);
        CalcSettleResult result = new CalcSettleResult();
        JSONObject param = this.getParam(restoredimension, restoreCalcRange, restoreGetDataRanges);
        this.mergeCalParam(param, this.context.getCalcparam());
        String checkName = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CostRecoveryCalcTask_4", (String)"macc-cad-business", (Object[])new Object[0]);
        String calcName = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97", (String)"CostRecoveryCalcTask_5", (String)"macc-cad-business", (Object[])new Object[0]);
        param.put((Object)"appNum", (Object)this.context.getAppnum());
        if (productOrgs != null && !productOrgs.isEmpty()) {
            param.accumulate("calcManuOrgIds", productOrgs);
            for (Long prdOrg : productOrgs) {
                String costAccStr = String.valueOf(this.context.getCostaccountId()) + prdOrg;
                boolean mutexFlag = MutexHelper.require((String)"sca_factcostreduction", (Object)String.valueOf(costAccStr).hashCode(), (String)"reductcalc", (boolean)true, (StringBuilder)new StringBuilder());
                if (!mutexFlag) {
                    return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CostRecoveryCalcTask_6", (String)"macc-cad-business", (Object[])new Object[0]), null);
                }
                try {
                    param.put((Object)"manuOrgId", (Object)prdOrg);
                    Long checkReportId = TaskHelper.initRedutCalcReport((Long)this.getCheckTaskId(), (JSONObject)param, (Date)new Date(), (String)checkName);
                    Long calcReportId = TaskHelper.initRedutCalcReport((Long)CALCTASKID, (JSONObject)param, (Date)new Date(), (String)calcName);
                    this.taskRecordId = TaskHelper.initTaskRecord((Long)CALCTASKID, (boolean)false);
                    reportIds.add(calcReportId);
                    param.put((Object)"taskRecordId", (Object)this.taskRecordId);
                    param.put((Object)"calcReportId", (Object)calcReportId);
                    param.put((Object)"checkReportId", (Object)checkReportId);
                    String resultInfo = this.costCalcReductCalc(param.toString());
                    logger.info("\u6210\u672c\u8fd8\u539f\u8fd4\u56de{}", (Object)resultInfo);
                    String calcStatus = this.getCalStatus(calcReportId, this.taskRecordId);
                    this.setResultStatus(result, calcStatus);
                }
                finally {
                    MutexHelper.release((String)"sca_factcostreduction", (String)"reductcalc", (String)String.valueOf(costAccStr.hashCode()));
                }
            }
        } else {
            String costAccStr = String.valueOf(this.context.getCostaccountId());
            boolean mutexFlag = MutexHelper.require((String)"sca_factcostreduction", (Object)String.valueOf(costAccStr).hashCode(), (String)"reductcalc", (boolean)true, (StringBuilder)new StringBuilder());
            if (!mutexFlag) {
                return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CostRecoveryCalcTask_6", (String)"macc-cad-business", (Object[])new Object[0]), null);
            }
            try {
                Long checkReportId = TaskHelper.initRedutCalcReport((Long)this.getCheckTaskId(), (JSONObject)param, (Date)new Date(), (String)calcName);
                Long calcReportId = TaskHelper.initRedutCalcReport((Long)CALCTASKID, (JSONObject)param, (Date)new Date(), (String)calcName);
                this.taskRecordId = TaskHelper.initTaskRecord((Long)CALCTASKID, (boolean)false);
                reportIds.add(calcReportId);
                param.put((Object)"taskRecordId", (Object)this.taskRecordId);
                param.put((Object)"calcReportId", (Object)calcReportId);
                param.put((Object)"checkReportId", (Object)checkReportId);
                String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"reductCalc", (Object[])new Object[]{param.toString()});
                logger.info("\u6210\u672c\u8fd8\u539f\u8fd4\u56de{}", (Object)resultInfo);
                String calcStatus = this.getCalStatus(calcReportId, this.taskRecordId);
                this.setResultStatus(result, calcStatus);
            }
            finally {
                MutexHelper.release((String)"sca_factcostreduction", (String)"reductcalc", (String)String.valueOf(costAccStr.hashCode()));
            }
        }
        String pageName = ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CostRecoveryCalcTask_7", (String)"macc-cad-business", (Object[])new Object[0]);
        this.setReportPage(result, reportIds, pageName);
        this.addJumpPages(result, reportIds);
        return result;
    }

    private String costCalcReductCalc(String costCalcArgs) {
        return (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"reductCalc", (Object[])new Object[]{costCalcArgs});
    }

    private void addJumpPages(CalcSettleResult result, List<Long> reportIds) {
        Set<Long> prdIds = this.getPrdSetByCalcReportId(reportIds);
        SettleJumpPage levelReportPage = new SettleJumpPage();
        levelReportPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        levelReportPage.setName(ResManager.loadKDString((String)"\u6210\u672c\u8fd8\u539f\u5206\u7ea7\u8868", (String)"CostRecoveryCalcTask_8", (String)"macc-cad-business", (Object[])new Object[0]));
        levelReportPage.setSourcepage("sca_costredlevelrptnew");
        JSONObject obj = this.getReportParam(prdIds);
        levelReportPage.getParam().put("hpParam", obj.toString());
        result.getJumpPages().add(levelReportPage);
        SettleJumpPage itemReportPage = new SettleJumpPage();
        itemReportPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        itemReportPage.setName(ResManager.loadKDString((String)"\u6210\u672c\u8fd8\u539f\u5206\u9879\u8868", (String)"CostRecoveryCalcTask_9", (String)"macc-cad-business", (Object[])new Object[0]));
        itemReportPage.setSourcepage("sca_costreditemrptnew");
        itemReportPage.getParam().put("hpParam", obj.toString());
        result.getJumpPages().add(itemReportPage);
    }

    private JSONObject getReportParam(Set<Long> prdIds) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"orgId", (Object)this.context.getOrgId());
        obj.put((Object)"costaccountId", (Object)this.context.getCostaccountId());
        obj.put((Object)"currency", (Object)this.context.getCurrencyId());
        obj.put((Object)"periodId", (Object)this.context.getPeriodId());
        obj.put((Object)"materials", prdIds);
        obj.put((Object)"appnum", (Object)this.context.getAppnum());
        return obj;
    }

    private Set<Long> getPrdSetByCalcReportId(List<Long> reportIds) {
        String algoKey = "kd.macc.sca.algox.utils.getSucByCalcReportId";
        QFilter qfCalcReport = new QFilter("calcreport", "in", reportIds);
        String selectFields = "material";
        DataSet calcResult = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_costrecovry", (String)selectFields, (QFilter[])new QFilter[]{qfCalcReport}, null);
        HashSet<Long> productIds = new HashSet<Long>();
        for (Row row : calcResult) {
            productIds.add(row.getLong("material"));
        }
        return productIds;
    }
}

