/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public abstract class DataSysImportBaseTask
extends AbstractSettleTask {
    private volatile String progressId;

    protected String generateProgressId() {
        this.progressId = UUID.randomUUID().toString();
        ProgressHelper.setProgressParam((String)this.progressId, (ProgressParamDto)new ProgressParamDto());
        return this.progressId;
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    protected SettleJumpPage getColReportJumpPage(Long reportId) {
        SettleJumpPage jumpPage = new SettleJumpPage();
        jumpPage.setName(ResManager.loadKDString((String)"\u5f52\u96c6\u62a5\u544a", (String)"DataSysImportBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
        jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
        jumpPage.setSourcepage("cad_colreport");
        jumpPage.getParam().put("pkId", reportId);
        return jumpPage;
    }

    protected Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty((String)appId)) {
            appId = "sca";
        }
        HashSet<Long> centerIds = new HashSet<Long>(20);
        HashSet<Long> allCenterIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DataSet costCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIdsByManuOrgIds", (String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
        for (Row costCenter : costCenterDs) {
            allCenterIds.add(costCenter.getLong("costcenterid"));
        }
        if (!CadEmptyUtils.isEmpty(allCenterIds)) {
            QFilter ccFilter = new QFilter("id", "in", allCenterIds);
            ccFilter.and(new QFilter("orgduty", "=", (Object)4L));
            DataSet basicCostCenterDs = QueryServiceHelper.queryDataSet((String)"getCenterIds", (String)"bos_costcenter", (String)"id", (QFilter[])ccFilter.toArray(), null);
            for (Row costCenter : basicCostCenterDs) {
                centerIds.add(costCenter.getLong("id"));
            }
        }
        if (CadEmptyUtils.isEmpty(centerIds)) {
            centerIds.add(-1L);
        }
        return centerIds;
    }

    protected static List<Long> getCostCenterByOrg(Long orgId) {
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)orgId);
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{orgFilter, orgdutyFilter}, null);
        if (costCenters != null) {
            for (DynamicObject costCenter : costCenters) {
                result.add(costCenter.getLong("id"));
            }
        }
        return result;
    }

    @Override
    public boolean enableProgress() {
        return true;
    }

    @Override
    public int getProgress() {
        if (StringUtils.isEmpty((CharSequence)this.progressId)) {
            return 0;
        }
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)this.progressId);
        if (paramDto == null) {
            return 0;
        }
        if (CadEmptyUtils.isEmpty((Integer)paramDto.getTotal()) || CadEmptyUtils.isEmpty((Integer)paramDto.getComplete())) {
            return 0;
        }
        return (int)((double)paramDto.getComplete().intValue() / (double)paramDto.getTotal().intValue() * 100.0);
    }
}

