/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.DataSysImportBaseTask;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.servicehelper.DiyCostDriverServiceHelper;

public class DiyCostDriverTask
extends DataSysImportBaseTask {
    protected static final Log logger = LogFactory.getLog(DiyCostDriverTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalcSettleResult doExecute() {
        Long orgId = this.context.getOrgId();
        String appnum = this.context.getAppnum();
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(orgId), (boolean)false, (String)appnum, (String)"sca_diycostdriver", (String)"47156aff000000ac")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiyCostDriverTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Map resultInfo = null;
        String lockId = "DiyCostDriverTask" + orgId;
        try (DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5de5\u4f5c\u53f0-\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f15\u5165", (String)"DiyCostDriverTask_5", (String)"macc-cad-business", (Object[])new Object[0]));){
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                CalcSettleResult calcSettleResult = this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f15\u5165\uff0c\u8bf7\u7a0d\u5019\u6267\u884c\u3002", (String)"DiyCostDriverTask_3", (String)"macc-cad-business", (Object[])new Object[0]), null);
                return calcSettleResult;
            }
            String progressId = this.generateProgressId();
            List<Long> costCenters = DiyCostDriverTask.getCostCenterByOrg(orgId);
            resultInfo = DiyCostDriverServiceHelper.importDiyCostDriver((Long)orgId, (Long)this.context.getCostaccountId(), costCenters, null, (String)appnum, (String)progressId, (String)"sca_diycostdriver");
            logger.info("\u4f5c\u4e1a\u6570\u91cf\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
        }
        String type = (String)resultInfo.get("type");
        CalcSettleResult result = new CalcSettleResult();
        result.setRemarkTag((String)resultInfo.get("msg"));
        if ("error".equals(type)) {
            result.setStatus(CalcSettleEnum.SETTLESUB_FAIL.getValue());
        } else if ("confirm".equals(type)) {
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
        }
        String colReportId = (String)resultInfo.get("colReportId");
        if (!CadEmptyUtils.isEmpty((String)colReportId)) {
            result.getJumpPages().add(this.getColReportJumpPage(Long.valueOf(colReportId)));
        }
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c", (String)"DiyCostDriverTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("sca_diycostdriver");
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("org", this.context.getOrgId());
        param.put("costaccount", this.context.getCostaccountId());
        param.put("source", "HyperLink");
        page.setParam(param);
        return Collections.singletonList(page);
    }
}

