/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.DataSysImportBaseTask;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;

public class MatAllocSysImportTask
extends DataSysImportBaseTask {
    protected static final Log logger = LogFactory.getLog(MatAllocSysImportTask.class);
    private static final String ACA_CLASSPATH = "kd.macc.aca.algox.alloc.AcaMatAllocHelper";
    private static final String SCA_CLASSPATH = "kd.macc.sca.algox.alloc.ScaMatAllocHelper";
    private static final String ACA_METHODNAME = "toAlloc";
    private static final String SCA_METHODNAME = "toAlloc";

    private String getEntity() {
        String entity = "aca_matalloc";
        if ("sca".equals(this.context.getAppnum())) {
            entity = "sca_matalloc";
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalcSettleResult doExecute() {
        Long orgId = this.context.getOrgId();
        String appnum = this.context.getAppnum();
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(orgId), (boolean)false, (String)appnum, (String)this.getEntity(), (String)"47156aff000000ac")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u6750\u6599\u8017\u7528\u5206\u914d\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MatAllocSysImportTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        HashMap resultInfo = null;
        AllocResult allocResult = new AllocResult();
        String lockId = "PlannedOutputOperExecutor" + orgId;
        try (DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5de5\u4f5c\u53f0-\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165", (String)"MatAllocSysImportTask_5", (String)"macc-cad-business", (Object[])new Object[0]));){
            Method method;
            Object obj;
            Class<?> doClass;
            boolean isLocked = lock.tryLock();
            if (!isLocked) {
                CalcSettleResult calcSettleResult = this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u8fdb\u884c\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\uff0c\u8bf7\u7a0d\u5019\u6267\u884c\u3002", (String)"MatAllocSysImportTask_2", (String)"macc-cad-business", (Object[])new Object[0]), null);
                return calcSettleResult;
            }
            String progressId = this.generateProgressId();
            if ("sca".equals(appnum)) {
                doClass = Class.forName(SCA_CLASSPATH);
                obj = doClass.newInstance();
                method = doClass.getMethod("toAlloc", List.class, String.class);
                List<Map<String, Object>> costAccountList = this.getScaMaps(appnum);
                allocResult = (AllocResult)method.invoke(obj, costAccountList, progressId);
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + allocResult.getReasonMap().toString());
            } else if ("aca".equals(appnum)) {
                doClass = Class.forName(ACA_CLASSPATH);
                obj = doClass.newInstance();
                method = doClass.getMethod("toAlloc", List.class, String.class, Map.class);
                List<Map<String, Object>> costaccountList = this.getAcaMaps(appnum);
                Object object = method.invoke(obj, costaccountList, progressId, null);
                allocResult = (AllocResult)JSON.parseObject((String)JSON.toJSONString((Object)object), AllocResult.class);
            }
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + allocResult.getReasonMap().toString());
        }
        CalcSettleResult result = new CalcSettleResult();
        boolean noConfirm = this.allocStatusFlag(true);
        boolean hasData = this.allocStatusFlag(false);
        String reason = (String)allocResult.getReasonMap().get("false");
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5f15\u5165\u7684\u6570\u636e", (String)"MatAllocSysImportTask_6", (String)"macc-cad-business", (Object[])new Object[0]);
        boolean isTipSucc = false;
        if (reason != null && reason.contains(msg) && hasData) {
            isTipSucc = true;
        }
        if (!noConfirm && (Boolean.TRUE.equals(allocResult.isSuccess()) || isTipSucc)) {
            result.setRemark((String)allocResult.getReasonMap().get("success"));
            result.setRemarkTag((String)allocResult.getReasonMap().get("success"));
            result.setStatus(CalcSettleEnum.SETTLESUB_SUCC.getValue());
        } else {
            if (noConfirm) {
                result.setRemark(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u786e\u8ba4\u7684\u5206\u914d\u5355\u3002", (String)"MatAllocSysImportTask_7", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            if (reason != null) {
                String remark = result.getRemark() == null ? "" : result.getRemark();
                result.setRemark(remark + reason);
                result.setRemarkTag(remark + reason);
            }
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
        }
        this.setAllocReport(result, allocResult);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    private void setAllocReport(CalcSettleResult result, AllocResult allocResult) {
        if (!CadEmptyUtils.isEmpty((List)allocResult.getReportIds())) {
            for (Long reportId : allocResult.getReportIds()) {
                SettleJumpPage page = new SettleJumpPage();
                page.setName(ResManager.loadKDString((String)"\u5206\u914d\u62a5\u544a", (String)"MatAllocSysImportTask_8", (String)"macc-cad-business", (Object[])new Object[0]));
                page.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
                page.setSourcepage("cad_allocreport");
                page.getParam().put("id", reportId);
                result.getJumpPages().add(page);
            }
        }
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"MatAllocSysImportTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage(this.getEntity());
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("org", this.context.getOrgId());
        param.put("costaccount", this.context.getCostaccountId());
        param.put("source", "HyperLink");
        page.setParam(param);
        return Collections.singletonList(page);
    }

    private List<Map<String, Object>> getScaMaps(String appnum) {
        ArrayList<Map<String, Object>> costAccountList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
        costaccountMap.put("org", this.context.getOrgId());
        costaccountMap.put("manuorg", 0L);
        costaccountMap.put("costaccountnum", this.context.getCostaccountNum());
        costaccountMap.put("costaccountId", this.context.getCostaccountId());
        costaccountMap.put("currencyId", this.context.getCurrencyId());
        costaccountMap.put("amtprecision", this.context.getAmtprecision());
        costaccountMap.put("costtypeId", CommonConstant.ACA_COST_TYPE_ID);
        costaccountMap.put("currentperiodId", this.context.getPeriodId());
        costaccountMap.put("appnum", appnum);
        costAccountList.add(costaccountMap);
        return costAccountList;
    }

    private List<Map<String, Object>> getAcaMaps(String appnum) {
        ArrayList<Map<String, Object>> costaccountList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
        costaccountMap.put("org", this.context.getOrgId());
        costaccountMap.put("costaccountnum", this.context.getCostaccountNum());
        costaccountMap.put("costaccountId", this.context.getCostaccountId());
        costaccountMap.put("currencyId", this.context.getCurrencyId());
        costaccountMap.put("costtypeId", this.context.getCosttypeid());
        costaccountMap.put("currentperiodId", this.context.getPeriodId());
        costaccountMap.put("appnum", appnum);
        costaccountList.add(costaccountMap);
        return costaccountList;
    }

    private boolean allocStatusFlag(boolean statusFlag) {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)this.context.getCostaccountId()));
        filter.and(new QFilter("period", "=", (Object)this.context.getPeriodId()));
        if (statusFlag) {
            filter.and(new QFilter("allocstatus", "!=", (Object)"2"));
        }
        return QueryServiceHelper.exists((String)this.getEntity(), (QFilter[])filter.toArray());
    }
}

