/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.DataSysImportBaseTask;
import kd.macc.cad.common.dto.MfgFeeImportReport;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;

public class MfgFeeSysImportTask
extends DataSysImportBaseTask {
    protected static final Log logger = LogFactory.getLog(MfgFeeSysImportTask.class);

    @Override
    public CalcSettleResult doExecute() {
        Long orgId = this.context.getOrgId();
        String appnum = this.context.getAppnum();
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(orgId), (boolean)false, (String)appnum, (String)"cad_mfgfeebill", (String)"47156aff000000ac")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u5236\u9020\u8d39\u7528\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MfgFeeSysImportTask_5", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        ExecuteResult executeResult = null;
        try {
            String progressId = this.generateProgressId();
            QFilter qFilter = new QFilter("accountorg", "=", (Object)orgId);
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)true);
            List costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])qFilter.toArray(), null, (int)-1);
            boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            if (!orgEnableMultiFactory) {
                costCenterIdList.add(0L);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("appnum", appnum);
            HashSet<Long> costAccountSet = new HashSet<Long>();
            costAccountSet.add(this.context.getCostaccountId());
            paramMap.put(String.valueOf(this.context.getCostaccountId()), this.context.getPeriodId());
            paramMap.put("report", this.initializeReport(this.context.getOrgId(), this.context.getAppnum()));
            executeResult = MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)orgId, costAccountSet, (List)costCenterIdList, paramMap, (String)progressId);
            logger.info("\u5236\u9020\u8d39\u7528\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + executeResult);
        }
        catch (Exception e) {
            logger.error("\u5236\u9020\u8d39\u7528\u81ea\u52a8\u5f52\u96c6-\u5f15\u5165", (Throwable)e);
            executeResult = new ExecuteResult();
            executeResult.setSuccess(false);
            executeResult.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeSysImportTask_3", (String)"macc-cad-business", (Object[])new Object[0]), e.toString()));
        }
        CalcSettleResult result = new CalcSettleResult();
        if (executeResult.isSuccess()) {
            result.setStatus(CalcSettleEnum.SETTLESUB_SUCC.getValue());
            Map.Entry info = executeResult.getSuccessInfo().entrySet().iterator().next();
            result.setRemark((String)info.getValue());
            result.setRemarkTag((String)info.getValue());
        } else {
            Map.Entry falseInfo = executeResult.getFalseInfo().entrySet().iterator().next();
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
            if (!executeResult.getFalseInfo().isEmpty()) {
                if ("Error".equals(falseInfo.getKey())) {
                    result.setStatus(CalcSettleEnum.SETTLESUB_FAIL.getValue());
                }
                result.setRemark((String)falseInfo.getValue());
                result.setRemarkTag((String)falseInfo.getValue());
            }
        }
        long colReportId = executeResult.getReportId();
        if (!CadEmptyUtils.isEmpty((Long)colReportId)) {
            result.getJumpPages().add(this.getColReportJumpPage(colReportId));
        }
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    private MfgFeeImportReport initializeReport(Long orgId, String appNum) {
        MfgFeeImportReport report = new MfgFeeImportReport();
        report.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        report.setCreateTime(TimeServiceHelper.now());
        report.setId(Long.valueOf(ID.genLongId()));
        report.setBillNo(ID.genStringId());
        report.setOrgId(orgId);
        report.setAppNum(appNum);
        return report;
    }

    @Override
    protected SettleJumpPage getColReportJumpPage(Long reportId) {
        SettleJumpPage jumpPage = new SettleJumpPage();
        jumpPage.setName(ResManager.loadKDString((String)"\u5f52\u96c6\u62a5\u544a", (String)"MfgFeeSysImportTask_8", (String)"macc-cad-business", (Object[])new Object[0]));
        jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
        jumpPage.setSourcepage("cad_mfgfee_report");
        jumpPage.getParam().put("id", reportId);
        return jumpPage;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"MfgFeeSysImportTask_9", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("cad_mfgfeebill");
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("org", this.context.getOrgId());
        param.put("costaccount", this.context.getCostaccountId());
        page.setParam(param);
        return Collections.singletonList(page);
    }
}

