/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;

public abstract class MfgSysImportBaseTask
extends AbstractSettleTask {
    protected MfgFeeAllocImportParam getPageImportDto(String entityName) {
        MfgFeeAllocImportParam importDto = new MfgFeeAllocImportParam();
        importDto.setAppnum(this.context.getAppnum());
        importDto.setOrg(this.context.getOrgId());
        importDto.setCostaccount(this.context.getCostaccountId());
        List manuorgCombos = ImportServiceHelper.getPermProOrgsByAccOrg((Long)importDto.getOrg(), (String)entityName, (String)importDto.getAppnum());
        ArrayList<Long> manuorgs = new ArrayList<Long>(5);
        for (Object item : manuorgCombos) {
            manuorgs.add(Long.valueOf(item.getValue()));
        }
        importDto.setManuorg(manuorgs);
        importDto.setPeriod(this.context.getPeriodId());
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        importDto.setEnableFactory(enableMulFactory);
        if (enableMulFactory) {
            for (Long manuorgId : importDto.getManuorg()) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)importDto.getOrg(), (Long)manuorgId, (Long)importDto.getCostaccount(), (Long)importDto.getPeriod())) continue;
                String msg = String.format(ResManager.loadKDString((String)"**\u6210\u672c\u8d26\u7c3f\u6838\u7b97\u7684**\u751f\u4ea7\u7ec4\u7ec7\uff0c\u5728\u5bf9\u5e94\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"MfgSysImportBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]), this.getManuOrgName(manuorgId, manuorgCombos));
                throw new KDBizException(msg);
            }
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)importDto.getOrg(), (List)importDto.getManuorg(), (String)importDto.getAppnum());
            importDto.setCostCenterIds(centerIds);
        }
        if ("cad_mfgfeeallocco".equals(entityName)) {
            Boolean isMergeBill = SysParamHelper.isMergeBill((Long)importDto.getOrg(), (Long)importDto.getCostaccount(), (String)importDto.getAppnum());
            importDto.setMergeBill(isMergeBill.booleanValue());
        }
        importDto.setEntityType(entityName);
        return importDto;
    }

    private String getManuOrgName(Long manuOrg, List<ComboItem> manuorgCombos) {
        for (ComboItem item : manuorgCombos) {
            if (!item.getValue().equals(manuOrg.toString())) continue;
            return item.getCaption().toString();
        }
        return "";
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }
}

