/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.DataSysImportBaseTask;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.MsgUtils;

public class ResourceUseSysImportTask
extends DataSysImportBaseTask {
    protected static final Log logger = LogFactory.getLog(ResourceUseSysImportTask.class);

    @Override
    public CalcSettleResult doExecute() {
        Long orgId = this.context.getOrgId();
        String appnum = this.context.getAppnum();
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(orgId), (boolean)false, (String)appnum, (String)"sca_resourceuse", (String)"47156aff000000ac")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResourceUseSysImportTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Map resultInfo = null;
        try {
            String progressId = this.generateProgressId();
            List<Long> costCenters = ResourceUseSysImportTask.getCostCenterByOrg(orgId);
            resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"resourceUseService", (String)"importResourceUse", (Object[])new Object[]{null, null, orgId, costCenters, null, appnum, progressId});
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u81ea\u52a8\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
        }
        catch (Exception e) {
            logger.error("\u8d44\u6e90\u8017\u7528\u91cf\u81ea\u52a8\u5f52\u96c6-\u5f15\u5165", (Throwable)e);
            resultInfo = new HashMap(10);
            MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"ResourceUseSysImportTask_3", (String)"macc-cad-business", (Object[])new Object[0]), e.toString()), resultInfo);
        }
        String type = (String)resultInfo.get("type");
        CalcSettleResult result = new CalcSettleResult();
        result.setRemarkTag((String)resultInfo.get("msg"));
        if ("error".equals(type)) {
            result.setStatus(CalcSettleEnum.SETTLESUB_FAIL.getValue());
        } else if ("confirm".equals(type)) {
            result.setStatus(CalcSettleEnum.SETTLESUB_CONFIRM.getValue());
        }
        String colReportId = (String)resultInfo.get("colReportId");
        if (colReportId != null) {
            result.getJumpPages().add(this.getColReportJumpPage(Long.valueOf(colReportId)));
        }
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6", (String)"ResourceUseSysImportTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("sca_resourceuse");
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("org", this.context.getOrgId());
        param.put("source", "HyperLink");
        page.setParam(param);
        return Collections.singletonList(page);
    }
}

