/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONObject;

public abstract class ScaCalcBaseTask
extends AbstractSettleTask {
    protected static final Log logger = LogFactory.getLog(ScaCalcBaseTask.class);
    protected volatile long taskRecordId = 0L;
    protected volatile boolean setReport = false;
    protected static final String CALC_PERM = "4730fc9f000025ae";
    protected static final String CHECK_PERM = "0K6+MBJCKDS2";
    protected static final String FACT_PAGE = "sca_finishcalwizards";
    protected static final String PERIODEND_PAGE = "sca_wipcalwizards";
    protected static final String SCA_CALC = "kd.macc.cad.business.settle.task.ScaPeriodEndCalcTask";
    protected static final String ACA_CALC = "kd.macc.cad.business.settle.task.AcaTerminalCalcTask";
    protected static final String FACTNED_OUT = "kd.macc.cad.business.settle.task.FactnedOutputSysImportTask";
    protected static final String SCA_RESTORE_CALC = "kd.macc.cad.business.settle.task.ScaRestoreCalcTask";

    protected Set<Long> getCalcRange(String entity, String calcType) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"orgId", (Object)this.context.getOrgId());
        jsonObj.put((Object)"costAcctId", (Object)this.context.getCostaccountId());
        jsonObj.put((Object)"costAccountId", (Object)this.context.getCostaccountId());
        jsonObj.put((Object)"periodId", (Object)this.context.getPeriodId());
        jsonObj.put((Object)"costCenterIds", new ArrayList(1));
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        HashSet<Long> manuorgSet = new HashSet<Long>(10);
        if (enableMulFactory) {
            List<Long> ids = this.getManuorgIds(entity);
            if (CadEmptyUtils.isEmpty(ids)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5728\u5f00\u542f\u591a\u5de5\u5382\u60c5\u51b5\u4e0b\uff0c\u5f53\u524d\u7528\u6237\u672a\u83b7\u53d6\u6709\u6743\u9650\u7684\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"ScaCalcBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            manuorgSet.addAll(ids);
        }
        jsonObj.put((Object)"manuorgSet", manuorgSet);
        Set importResult = (Set)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"getCalcRange", (Object[])new Object[]{jsonObj.toString(), calcType});
        return importResult;
    }

    protected List<Long> getManuorgIds(String entity) {
        return ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)this.context.getOrgId(), (String)entity, (String)CALC_PERM, (String)"sca");
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public boolean enableProgress() {
        return true;
    }

    @Override
    public int getProgress() {
        if (!CadEmptyUtils.isEmpty((Long)this.taskRecordId)) {
            DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)this.taskRecordId, (String)"sca_taskrecord", (String)"progress");
            if (taskRecord == null) {
                return 0;
            }
            try {
                this.setCalReport(taskRecord.getInt("progress"));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            return taskRecord.getInt("progress");
        }
        return 0;
    }

    private void setCalReport(int progress) {
        String name = this.getClass().getName();
        if ((SCA_CALC.equals(name) || ACA_CALC.equals(name) || FACTNED_OUT.equals(name) || SCA_RESTORE_CALC.equals(name)) && !this.setReport && progress < 100) {
            QFilter filter = new QFilter("costaccount", "=", (Object)this.context.getCostaccountId());
            filter.and("costaccount", "=", (Object)this.context.getCostaccountId());
            String entityName = "sca_calcreport";
            if (SCA_RESTORE_CALC.equals(name)) {
                filter.and("org", "=", (Object)this.context.getOrgId());
                entityName = "sca_restore_calcreport";
            } else {
                filter.and("accountorg", "=", (Object)this.context.getOrgId());
            }
            filter.and("period", "=", (Object)this.context.getPeriodId());
            filter.and("modifytime", ">=", (Object)this.context.getTaskTime());
            filter.and("taskname", "not like", (Object)ResManager.loadKDString((String)"%\u5408\u6cd5\u6027\u68c0\u67e5%", (String)"ScaCalcBaseTask_3", (String)"macc-cad-business", (Object[])new Object[0]));
            DynamicObjectCollection createTimeDesc = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"modifytime desc", (int)1);
            if (createTimeDesc != null) {
                long reportId = ((DynamicObject)createTimeDesc.get(0)).getLong("id");
                Long taskId = this.context.getTaskId();
                CalcSettleResult result = new CalcSettleResult();
                if (!CadEmptyUtils.isEmpty((Long)reportId)) {
                    SettleJumpPage jumpPage = new SettleJumpPage();
                    jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
                    jumpPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaCalcBaseTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
                    jumpPage.setSourcepage("sca_calcreport");
                    jumpPage.getParam().put("id", reportId);
                    result.getJumpPages().add(jumpPage);
                    String jumpparamTag = JSON.toJSONString((Object)result);
                    DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_settlereportsub set fjumpparam_tag = '" + jumpparamTag + "' where fdetailid = " + taskId));
                    this.setReport = true;
                }
            }
        }
    }

    protected String getCalStatus(Long calcReportId, Long taskRecordId) {
        DynamicObject reportRecord;
        if (!CadEmptyUtils.isEmpty((Long)calcReportId) && (reportRecord = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_calcreport", (String)"type")) != null) {
            return reportRecord.getString("type");
        }
        reportRecord = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"sca_taskrecord", (String)"status");
        if (reportRecord != null) {
            return reportRecord.getString("status");
        }
        return null;
    }

    protected JSONObject buildFactJSONParam(Set<Long> calcRangeIds, String entity, String checkway) {
        JSONObject calcParamJs = new JSONObject();
        calcParamJs.put((Object)"org", (Object)this.context.getOrgId());
        calcParamJs.put((Object)"costaccount", (Object)this.context.getCostaccountId());
        calcParamJs.put((Object)"calcVersion", (Object)"2");
        calcParamJs.put((Object)"period", (Object)this.context.getPeriodId());
        calcParamJs.put((Object)"startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put((Object)"endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put((Object)"currencyId", (Object)this.context.getCurrencyId());
        List<Long> manuOrgIds = this.getManuorgIds(entity);
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        if (enableMulFactory) {
            calcParamJs.put((Object)"manuOrgIds", manuOrgIds);
        } else {
            calcParamJs.put((Object)"manuOrgIds", new ArrayList(0));
        }
        calcParamJs.put((Object)"manuOrgList", this.getManuorgIds(entity));
        calcParamJs.put((Object)"costcenters", new HashSet(1));
        calcParamJs.put((Object)"entrycostcenters", new HashSet(1));
        calcParamJs.put((Object)"costobjects", calcRangeIds);
        calcParamJs.put((Object)"ccAndCoInfos", this.getCCAndCoInfos(calcRangeIds));
        calcParamJs.put((Object)"checkway", (Object)checkway);
        calcParamJs.put((Object)"matCalType", (Object)"3");
        calcParamJs.put((Object)"mfgCalType", (Object)"4");
        calcParamJs.put((Object)"costtypeid", (Object)0L);
        calcParamJs.put((Object)"maxDiffRate", (Object)-0.1);
        calcParamJs.put((Object)"minDiffRate", (Object)0.1);
        calcParamJs.put((Object)"appNum", (Object)"sca");
        return calcParamJs;
    }

    protected Map<String, Long> getCCAndCoInfos(Set<Long> costobjectIds) {
        HashMap<String, Long> ccAndcoInfos = new HashMap<String, Long>(10);
        QFilter filter = new QFilter("id", "in", costobjectIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"costcenter,id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            String costcenter = row.getString("costcenter");
            if (!ccAndcoInfos.containsKey(costcenter)) {
                ccAndcoInfos.put(costcenter, 1L);
                continue;
            }
            Long costObjectCount = (Long)ccAndcoInfos.get(costcenter);
            costObjectCount = costObjectCount + 1L;
            ccAndcoInfos.put(costcenter, costObjectCount);
        }
        return ccAndcoInfos;
    }

    protected List<SettleJumpPage> getSourcePageParamFromEntity(String entity) {
        SettleJumpPage page = new SettleJumpPage();
        if (FACT_PAGE.equals(entity)) {
            page.setName(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97", (String)"ScaCalcBaseTask_1", (String)"macc-cad-business", (Object[])new Object[0]));
            page.setOpenType(CalcSettleEnum.OPTYPE_FORM.getValue());
            page.setSourcepage(entity);
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("orgId", this.context.getOrgId());
            page.setParam(param);
        } else {
            page.setName(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"ScaCalcBaseTask_2", (String)"macc-cad-business", (Object[])new Object[0]));
            page.setOpenType(CalcSettleEnum.OPTYPE_FORM.getValue());
            page.setSourcepage(entity);
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("orgId", this.context.getOrgId());
            page.setParam(param);
        }
        return Collections.singletonList(page);
    }
}

