/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.ScaCalcBaseTask;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.TaskHelper;
import net.sf.json.JSONObject;

public class ScaFinishCalcTask
extends ScaCalcBaseTask {
    public static final Long CALCTASKID = 878361641283008512L;
    public static final Long CALCCHECKCONFIGID = 886829597906225152L;

    @Override
    public CalcSettleResult doExecute() {
        String lockErrStr;
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"sca_finishcalwizards", (String)"4730fc9f000025ae")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5411\u5bfc\u201d\u7684\u201c\u8ba1\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScaFinishCalcTask_7", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Set<Long> calcRangeIds = this.getCalcRange("sca_finishcalwizards", "2");
        if (CadEmptyUtils.isEmpty(calcRangeIds)) {
            CalcSettleResult result = this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_SUCC.getValue(), ResManager.loadKDString((String)"\u5b8c\u5de5\u7ed3\u7b97\u8303\u56f4\u7684\u6210\u672c\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u3002", (String)"ScaFinishCalcTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
            this.setFactJumpPage(result);
            return result;
        }
        JSONObject jsonObj = this.buildFactJSONParam(calcRangeIds, "sca_finishcalwizards", "0");
        jsonObj.put((Object)"checkConfigId", (Object)CALCCHECKCONFIGID);
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        List<Long> manuOrgIds = this.getManuorgIds("sca_finishcalwizards");
        if (!enableMulFactory) {
            manuOrgIds.clear();
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            for (Long manuOrgId : manuOrgIds) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)this.context.getOrgId(), (Long)manuOrgId, (Long)this.context.getCostaccountId(), (Long)this.context.getPeriodId())) continue;
                return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5b58\u5728\u751f\u4ea7\u7ec4\u7ec7\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u3002", (String)"ScaFinishCalcTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
            }
        }
        if (StringUtils.isNotEmpty((String)(lockErrStr = CalcMutexHelper.checkMutexAndLock((String)"finish", (boolean)enableMulFactory, (Long)this.context.getCostaccountId(), new HashSet<Long>(manuOrgIds))))) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(lockErrStr, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7", (String)"ScaFinishCalcTask_2", (String)"macc-cad-business", (Object[])new Object[0])), null);
        }
        this.taskRecordId = TaskHelper.initTaskRecord((Long)CALCTASKID);
        jsonObj.put((Object)"taskRecordId", (Object)this.taskRecordId);
        String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"finishCalc", (Object[])new Object[]{jsonObj.toString()});
        logger.info("\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97-\u5408\u6cd5\u6027\u68c0\u67e5\uff1a{}", (Object)resultInfo);
        if (StringUtils.isEmpty((String)resultInfo)) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESTATUS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u7684\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"ScaFinishCalcTask_3", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        com.alibaba.fastjson.JSONObject resultObj = JSON.parseObject((String)resultInfo);
        CalcSettleResult result = new CalcSettleResult();
        long calcReportId = 0L;
        if (resultObj.containsKey((Object)"calcReportId")) {
            calcReportId = resultObj.getLongValue("calcReportId");
        }
        String recordStatus = this.getCalStatus(calcReportId, this.taskRecordId);
        String calcStatus = resultObj.getString("status");
        if (recordStatus != null) {
            calcStatus = recordStatus;
        }
        if ("3".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
        } else if ("5".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
        }
        if (!CadEmptyUtils.isEmpty((Long)calcReportId)) {
            SettleJumpPage jumpPage = new SettleJumpPage();
            jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            jumpPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaFinishCalcTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
            jumpPage.setSourcepage("sca_calcreport");
            jumpPage.getParam().put("id", calcReportId);
            result.getJumpPages().add(jumpPage);
        }
        this.setFactJumpPage(result);
        return result;
    }

    private void setFactJumpPage(CalcSettleResult result) {
        SettleJumpPage costconfirmPage = new SettleJumpPage();
        costconfirmPage.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        costconfirmPage.setName(ResManager.loadKDString((String)"\u6210\u672c\u786e\u8ba4\u5355", (String)"ScaFinishCalcTask_5", (String)"macc-cad-business", (Object[])new Object[0]));
        costconfirmPage.setSourcepage("sca_costconfirm");
        costconfirmPage.getParam().put("org", this.context.getOrgId());
        costconfirmPage.getParam().put("costaccount", this.context.getCostaccountId());
        result.getJumpPages().add(costconfirmPage);
        SettleJumpPage calcReportPage = new SettleJumpPage();
        calcReportPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        calcReportPage.setName(ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u6c47\u603b\u8868", (String)"ScaFinishCalcTask_6", (String)"macc-cad-business", (Object[])new Object[0]));
        calcReportPage.setSourcepage("sca_calcresultrpt");
        calcReportPage.getParam().put("fromCalcResultRpt", "1");
        calcReportPage.getParam().put("org", this.context.getOrgId());
        calcReportPage.getParam().put("costaccount", this.context.getCostaccountId());
        calcReportPage.getParam().put("fperiod", Lists.newArrayList((Object[])new Long[]{this.context.getPeriodId()}));
        calcReportPage.getParam().put("currency", this.context.getCurrencyId());
        calcReportPage.getParam().put("fbizstatus", "B");
        result.getJumpPages().add(calcReportPage);
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        return this.getSourcePageParamFromEntity("sca_finishcalwizards");
    }
}

