/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.ScaCalcBaseTask;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.TaskHelper;
import net.sf.json.JSONObject;

public class ScaPeriodEndCalcTask
extends ScaCalcBaseTask {
    public static final Long PDEND_TASKID = 888831469932296192L;

    @Override
    public CalcSettleResult doExecute() {
        String lockErrStr;
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"sca_wipcalwizards", (String)"4730fc9f000025ae")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc\u201d\u7684\u201c\u8ba1\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScaPeriodEndCalcTask_6", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Set<Long> calcRangeIds = this.getCalcRange("sca_wipcalwizards", "1");
        JSONObject jsonObj = this.buildJSONObj(calcRangeIds);
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        List<Long> manuOrgIds = this.getManuorgIds("sca_finishcalwizards");
        if (!enableMulFactory) {
            manuOrgIds.clear();
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            for (Long manuOrgId : manuOrgIds) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)this.context.getOrgId(), (Long)manuOrgId, (Long)this.context.getCostaccountId(), (Long)this.context.getPeriodId())) continue;
                return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5b58\u5728\u751f\u4ea7\u7ec4\u7ec7\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u3002", (String)"ScaPeriodEndCalcTask_0", (String)"macc-cad-business", (Object[])new Object[0]), null);
            }
        }
        if (StringUtils.isNotEmpty((String)(lockErrStr = CalcMutexHelper.checkMutexAndLock((String)"pdend", (boolean)enableMulFactory, (Long)this.context.getCostaccountId(), new HashSet<Long>(manuOrgIds))))) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), String.format(lockErrStr, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7", (String)"ScaPeriodEndCalcTask_1", (String)"macc-cad-business", (Object[])new Object[0])), null);
        }
        this.taskRecordId = TaskHelper.initTaskRecord((Long)PDEND_TASKID);
        jsonObj.put((Object)"taskRecordId", (Object)this.taskRecordId);
        String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"periodEndCalc", (Object[])new Object[]{jsonObj.toString()});
        logger.info("\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97-\u5408\u6cd5\u6027\u68c0\u67e5\uff1a{}", (Object)resultInfo);
        if (StringUtils.isEmpty((String)resultInfo)) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESTATUS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u7684\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"ScaPeriodEndCalcTask_2", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        com.alibaba.fastjson.JSONObject resultObj = JSON.parseObject((String)resultInfo);
        CalcSettleResult result = new CalcSettleResult();
        long calcReportId = 0L;
        if (resultObj.containsKey((Object)"calcReportId")) {
            calcReportId = resultObj.getLongValue("calcReportId");
        }
        String recordStatus = this.getCalStatus(calcReportId, this.taskRecordId);
        String calcStatus = resultObj.getString("status");
        if (recordStatus != null) {
            calcStatus = recordStatus;
        }
        if ("3".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
        } else if ("5".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
        }
        if (!CadEmptyUtils.isEmpty((Long)calcReportId)) {
            SettleJumpPage jumpPage = new SettleJumpPage();
            jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            jumpPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaPeriodEndCalcTask_3", (String)"macc-cad-business", (Object[])new Object[0]));
            jumpPage.setSourcepage("sca_calcreport");
            jumpPage.getParam().put("id", calcReportId);
            result.getJumpPages().add(jumpPage);
        }
        SettleJumpPage calcReportPage = new SettleJumpPage();
        calcReportPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        calcReportPage.setName(ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u6c47\u603b\u8868", (String)"ScaPeriodEndCalcTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
        calcReportPage.setSourcepage("sca_calcresultrpt");
        calcReportPage.getParam().put("fromCalcResultRpt", "1");
        calcReportPage.getParam().put("org", this.context.getOrgId());
        calcReportPage.getParam().put("costaccount", this.context.getCostaccountId());
        calcReportPage.getParam().put("fperiod", Lists.newArrayList((Object[])new Long[]{this.context.getPeriodId()}));
        calcReportPage.getParam().put("currency", this.context.getCurrencyId());
        result.getJumpPages().add(calcReportPage);
        SettleJumpPage unAbsorbPage = new SettleJumpPage();
        unAbsorbPage.setOpenType(CalcSettleEnum.OPTYPE_REPORT.getValue());
        unAbsorbPage.setName(ResManager.loadKDString((String)"\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\u5355\u3002", (String)"ScaPeriodEndCalcTask_5", (String)"macc-cad-business", (Object[])new Object[0]));
        unAbsorbPage.setSourcepage("sca_unabsorbrptnew");
        this.putUnAbsorbRptParam(unAbsorbPage, manuOrgIds);
        result.getJumpPages().add(unAbsorbPage);
        return result;
    }

    private void putUnAbsorbRptParam(SettleJumpPage unAbsorbPage, List<Long> manuOrgIds) {
        String key = "kd.macc.sca.common.rpt.UnabSorbCalcParam";
        JSONObject obj = new JSONObject();
        obj.put((Object)"orgId", (Object)this.context.getOrgId());
        obj.put((Object)"manuOrgIds", manuOrgIds);
        obj.put((Object)"costAccountId", (Object)this.context.getCostaccountId());
        obj.put((Object)"currencyId", (Object)this.context.getCurrencyId());
        obj.put((Object)"level", (Object)1);
        obj.put((Object)"periodIds", (Object)Lists.newArrayList((Object[])new Long[]{this.context.getPeriodId()}));
        unAbsorbPage.getParam().put(key, obj.toString());
        unAbsorbPage.getParam().put("source", "HyperLink");
    }

    private JSONObject buildJSONObj(Set<Long> calcRangeIds) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"time", (Object)System.currentTimeMillis());
        jsonObj.put((Object)"orgId", (Object)this.context.getOrgId());
        jsonObj.put((Object)"costAcctId", (Object)this.context.getCostaccountId());
        jsonObj.put((Object)"currencyId", (Object)this.context.getCurrencyId());
        jsonObj.put((Object)"periodId", (Object)this.context.getPeriodId());
        jsonObj.put((Object)"startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObj.put((Object)"endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        jsonObj.put((Object)"costCenterIds", new ArrayList(0));
        List<Long> manuIdList = this.getManuorgIds("sca_wipcalwizards");
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        if (enableMulFactory) {
            jsonObj.put((Object)"manuOrgIds", manuIdList);
        } else {
            jsonObj.put((Object)"manuOrgIds", new ArrayList(0));
        }
        jsonObj.put((Object)"manuorglist", manuIdList);
        jsonObj.put((Object)"costobjects", calcRangeIds);
        jsonObj.put((Object)"ccAndCoInfos", this.getCCAndCoInfos(calcRangeIds));
        jsonObj.put((Object)"calcVersion", (Object)"2");
        jsonObj.put((Object)"matCalType", (Object)"1");
        jsonObj.put((Object)"mfgCalType", (Object)"2");
        jsonObj.put((Object)"appNum", (Object)"sca");
        return jsonObj;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        return this.getSourcePageParamFromEntity("sca_wipcalwizards");
    }
}

