/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.common.CalcSettleHelper;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.business.settle.task.ScaCalcBaseTask;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class ScaPeriodEndCheckTask
extends ScaCalcBaseTask {
    @Override
    public CalcSettleResult doExecute() {
        if (!CadPermissionUtil.check((Long)RequestContext.get().getCurrUserId(), (String)String.valueOf(this.context.getOrgId()), (boolean)false, (String)this.context.getAppnum(), (String)"sca_wipcalwizards", (String)"0K6+MBJCKDS2")) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESUB_FAIL.getValue(), ResManager.loadKDString((String)"\u65e0\u201c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5411\u5bfc\u201d\u7684\u201c\u68c0\u67e5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScaPeriodEndCheckTask_3", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        Set<Long> calcRangeIds = this.getCalcRange("sca_wipcalwizards", "1");
        JSONObject jsonObj = this.buildCheckParam(calcRangeIds);
        List<Long> checkItemIds = CalcSettleHelper.getCheckitemIds("sca_wipcalwizards", this.context.getAppnum());
        jsonObj.put((Object)"checkItemList", checkItemIds);
        Long checkReport = CalcCheckHelper.initFinWipCalcCheckReport((JSONObject)jsonObj, (String)"1", (Date)new Date());
        String checkType = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"ScaPeriodEndCheckTask_0", (String)"macc-cad-business", (Object[])new Object[0]);
        this.taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList<Long>(checkItemIds), (String)"sca_wipcalwizards", (String)this.context.getAppnum());
        jsonObj.put((Object)"taskRecordId", (Object)this.taskRecordId);
        jsonObj.put((Object)"calcReportId", (Object)0L);
        jsonObj.put((Object)"checkReportId", (Object)checkReport);
        jsonObj.put((Object)"appNum", (Object)this.context.getAppnum());
        String resultInfo = (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"CostCalcService", (String)"periodEndCalcCheck", (Object[])new Object[]{jsonObj.toString()});
        logger.info("\u671f\u672b\u6210\u672c\u8ba1\u7b97-\u5408\u6cd5\u6027\u68c0\u67e5\uff1a{}", (Object)resultInfo);
        if (StringUtils.isEmpty((CharSequence)resultInfo)) {
            return this.getCalcSettleResult(CalcSettleEnum.SETTLESTATUS_FAIL.getValue(), ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u8fd4\u56de\u7684\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"ScaPeriodEndCheckTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null);
        }
        com.alibaba.fastjson.JSONObject resultObj = JSON.parseObject((String)resultInfo);
        CalcSettleResult result = new CalcSettleResult();
        String recordStatus = this.getCalStatus(checkReport, this.taskRecordId);
        String calcStatus = resultObj.getString("status");
        if (recordStatus != null) {
            calcStatus = recordStatus;
        }
        if ("3".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
        } else if ("5".equals(calcStatus)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_WARN.getValue());
        }
        if (!CadEmptyUtils.isEmpty((Long)checkReport)) {
            SettleJumpPage jumpPage = new SettleJumpPage();
            jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
            jumpPage.setName(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"ScaPeriodEndCheckTask_2", (String)"macc-cad-business", (Object[])new Object[0]));
            jumpPage.setSourcepage("sca_calcreport");
            jumpPage.getParam().put("id", checkReport);
            result.getJumpPages().add(jumpPage);
        }
        return result;
    }

    private JSONObject buildCheckParam(Set<Long> calcRangeIds) {
        JSONObject checkParamJs = new JSONObject();
        checkParamJs.accumulate("org", (Object)this.context.getOrgId());
        checkParamJs.accumulate("costaccount", (Object)this.context.getCostaccountId());
        checkParamJs.accumulate("currencyId", (Object)this.context.getCurrencyId());
        List<Long> manuIdList = this.getManuorgIds("sca_wipcalwizards");
        checkParamJs.accumulate("manuorglist", manuIdList);
        checkParamJs.accumulate("costcenters", new ArrayList(1));
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)this.context.getOrgId());
        if (enableMulFactory) {
            checkParamJs.put((Object)"manuOrgIds", manuIdList);
        } else {
            checkParamJs.put((Object)"manuOrgIds", new ArrayList(0));
        }
        checkParamJs.accumulate("period", (Object)this.context.getPeriodId());
        checkParamJs.accumulate("startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        checkParamJs.accumulate("endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        checkParamJs.accumulate("checkway", (Object)"0");
        checkParamJs.accumulate("entrycostcenters", this.getCostcenterIds(calcRangeIds));
        checkParamJs.accumulate("costobjects", calcRangeIds);
        checkParamJs.accumulate("appNum", (Object)"sca");
        return checkParamJs;
    }

    private Set<Long> getCostcenterIds(Set<Long> calcRangeIds) {
        QFilter filter = new QFilter("id", "in", calcRangeIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"costcenter,id", (QFilter[])filter.toArray(), null);
        HashSet<Long> costcenterIds = new HashSet<Long>(10);
        for (Row row : ds) {
            costcenterIds.add(row.getLong("costcenter"));
        }
        return costcenterIds;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        return this.getSourcePageParamFromEntity("sca_wipcalwizards");
    }
}

