/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.settle.task;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.settle.AbstractSettleTask;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.business.settle.model.CalcSettleResult;
import kd.macc.cad.business.settle.model.SettleJumpPage;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONObject;

public abstract class ScaRestoreBaseTask
extends AbstractSettleTask {
    protected volatile long taskRecordId = 0L;
    protected static final String ENTITY = "sca_differencecalcwizards";
    protected static final String CALC_PERM = "4730fc9f000025ae";
    protected static final String CHECK_PERM = "0K6+MBJCKDS2";
    protected static final String SCA_RESTORE_CALC = "kd.macc.cad.business.settle.task.ScaRestoreCalcTask";
    protected volatile boolean setReport = false;

    @Override
    public boolean enableProgress() {
        return true;
    }

    @Override
    public int getProgress() {
        if (!CadEmptyUtils.isEmpty((Long)this.taskRecordId)) {
            DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((Object)this.taskRecordId, (String)"sca_taskrecord", (String)"progress");
            try {
                this.setCalReport(taskRecord.getInt("progress"));
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
            if (taskRecord != null) {
                return taskRecord.getInt("progress");
            }
        }
        return 0;
    }

    private void setCalReport(int progress) {
        String name = this.getClass().getName();
        if (!SCA_RESTORE_CALC.equals(name) || this.setReport || progress >= 100) {
            return;
        }
        QFilter filter = new QFilter("costaccount", "=", (Object)this.context.getCostaccountId());
        filter.and("org", "=", (Object)this.context.getOrgId());
        String entityName = "sca_restore_calcreport";
        filter.and("period", "=", (Object)this.context.getPeriodId());
        filter.and("calcdate", ">=", (Object)this.context.getTaskTime());
        filter.and("taskname", "not like", (Object)ResManager.loadKDString((String)"%\u5408\u6cd5\u6027\u68c0\u67e5%", (String)"ScaRestoreBaseTask_3", (String)"macc-cad-business", (Object[])new Object[0]));
        DynamicObjectCollection createTimeDesc = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"calcdate desc", (int)1);
        if (createTimeDesc != null && !createTimeDesc.isEmpty()) {
            long reportId = ((DynamicObject)createTimeDesc.get(0)).getLong("id");
            Long taskId = this.context.getTaskId();
            CalcSettleResult result = new CalcSettleResult();
            if (!CadEmptyUtils.isEmpty((Long)reportId)) {
                SettleJumpPage jumpPage = new SettleJumpPage();
                jumpPage.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
                jumpPage.setName(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaRestoreBaseTask_4", (String)"macc-cad-business", (Object[])new Object[0]));
                jumpPage.setSourcepage("sca_restore_calcreport");
                jumpPage.getParam().put("id", reportId);
                result.getJumpPages().add(jumpPage);
                JSONObject obj = new JSONObject();
                obj.put((Object)"taskRecordId", (Object)this.taskRecordId);
                result.setRemarkTag(obj.toString());
                String jumpparamTag = JSON.toJSONString((Object)result);
                DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_settlereportsub set fjumpparam_tag = '" + jumpparamTag + "' where fdetailid = " + taskId));
                this.setReport = true;
            }
        }
    }

    @Override
    protected CalcSettleResult getCalcSettleResult(String status, String remark, String remarkTag) {
        CalcSettleResult result = super.getCalcSettleResult(status, remark, remarkTag);
        result.getJumpPages().addAll(this.getSourcePageParam());
        return result;
    }

    @Override
    public List<SettleJumpPage> getSourcePageParam() {
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97", (String)"ScaRestoreBaseTask_0", (String)"macc-cad-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_FORM.getValue());
        page.setSourcepage(ENTITY);
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("org", this.context.getOrgId());
        page.setParam(param);
        return Collections.singletonList(page);
    }

    protected void judgeRestoreStrategy() {
        QFilter filter = new QFilter("costaccount", "=", (Object)this.context.getCostaccountId());
        filter.and("tab", "=", (Object)"costaccounttabpage");
        filter.and("appnum", "=", (Object)"sca");
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_sysparam", (String)"reductstrategy", (QFilter[])filter.toArray());
        if (result.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e\u5dee\u5f02\u5206\u644a\u7b56\u7565\uff0c\u8def\u5f84\uff1a\u6807\u51c6\u6210\u672c\u6838\u7b97>\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u3002", (String)"ScaRestoreBaseTask_1", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        if (((DynamicObject)result.get(0)).get("reductstrategy").equals("OVERALL_REDUCT")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u7528\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\uff0c\u5f53\u524d\u5dee\u5f02\u5206\u644a\u7b56\u7565\u662f\u7efc\u5408\u5206\u644a\uff0c\u9700\u8981\u8c03\u6574\u4e3a\u5206\u9879\u5206\u644a\u624d\u53ef\u4ee5\u542f\u7528\u3002", (String)"ScaRestoreBaseTask_2", (String)"macc-cad-business", (Object[])new Object[0]));
        }
    }

    protected JSONObject buildCalcParam() {
        JSONObject calcParamJs = new JSONObject();
        calcParamJs.accumulate("org", (Object)this.context.getOrgId());
        calcParamJs.accumulate("costaccount", (Object)this.context.getCostaccountId());
        calcParamJs.accumulate("period", (Object)this.context.getPeriodId());
        calcParamJs.accumulate("startDate", (Object)DateUtils.formatDate((Date)this.context.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.accumulate("endDate", (Object)DateUtils.formatDate((Date)this.context.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.accumulate("currencyId", (Object)this.context.getCurrencyId());
        calcParamJs.accumulate("status", (Object)"");
        calcParamJs.accumulate("validitycheck", true);
        calcParamJs.accumulate("domatcoll", true);
        calcParamJs.accumulate("parallel", true);
        calcParamJs.put((Object)"appNum", (Object)this.context.getAppnum());
        return calcParamJs;
    }

    protected String getCalStatus(Long calcReportId, Long taskRecordId) {
        DynamicObject reportRecord;
        if (!CadEmptyUtils.isEmpty((Long)calcReportId) && (reportRecord = BusinessDataServiceHelper.loadSingle((Object)calcReportId, (String)"sca_restore_calcreport", (String)"type")) != null) {
            return reportRecord.getString("type");
        }
        reportRecord = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"sca_taskrecord", (String)"status");
        if (reportRecord != null) {
            return reportRecord.getString("status");
        }
        return null;
    }
}

