/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.strategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.cad.business.strategy.DefaultSelectStrategy;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.TypeSelectStrategy;
import org.apache.commons.lang3.StringUtils;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;
    private Set<String> existFields;
    private boolean secondDevelop;
    private boolean formulaCall;

    public boolean isSecondDevelop() {
        return this.secondDevelop;
    }

    public void setSecondDevelop(boolean secondDevelop) {
        this.secondDevelop = secondDevelop;
    }

    public boolean isFormulaCall() {
        return this.formulaCall;
    }

    public void setFormulaCall(boolean formulaCall) {
        this.formulaCall = formulaCall;
    }

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(this.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    public Set<String> getExistFields() {
        return this.existFields;
    }

    public void setExistFields(Set<String> existFields) {
        this.existFields = existFields;
    }

    private String getMsgMetaHelperError() {
        return ResManager.loadKDString((String)"MetaHelper\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaHelper_1", (String)"macc-cad-business", (Object[])new Object[0]);
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this((IColsSelectStrategy)null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this((IColsSelectStrategy)null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree());
    }

    public TreeNode buildTree() {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode((String)null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        Iterator var6 = allFields.values().iterator();
        Set<String> hideFields = this.getHideFields();
        String name = this.meta.getName();
        while (var6.hasNext()) {
            IDataEntityProperty pro = (IDataEntityProperty)var6.next();
            if (this.existFields != null && this.existFields.contains(pro.getName()) || !this.isFormulaCall() && (hideFields.contains(pro.getName()) || this.isSecondDevelop() && !pro.getName().contains("_")) || StringUtils.isBlank((CharSequence)pro.getAlias())) continue;
            parent = pro.getParent();
            if (("cad_costbom".equals(name) || "pdm_mftbom".equals(name) || "cad_router".equals(name) || "pdm_route".equals(name)) && hideFields.contains(parent.getName())) continue;
            if (pro instanceof BasedataProp && this.strategy instanceof TypeSelectStrategy && !(((TypeSelectStrategy)this.strategy).getProperty() instanceof DateTimeProp)) {
                ((TypeSelectStrategy)this.strategy).setUnLimitFieldName(pro.getName());
            }
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro);
                continue;
            }
            if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
                TreeNode entryNode = this.getEntryNode(nodeMap, parent);
                this.strategy.buildNode4Entry(entryNode, pro);
                if (nodeMap.containsKey(entryNode.getId())) continue;
                nodeMap.put(entryNode.getId(), entryNode);
                root.addChild(entryNode);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof EntryType)) continue;
            EntryType grandParent = (EntryType)parent.getParent();
            if (!this.strategy.filterEntryPro((EntryType)parent)) continue;
            TreeNode subEntryNode = this.getEntryNode(nodeMap, parent);
            TreeNode entryNode = this.getEntryNode(nodeMap, (IDataEntityType)grandParent);
            this.strategy.buildNode4Entry(entryNode, subEntryNode, pro);
            if (nodeMap.containsKey(subEntryNode.getId())) continue;
            nodeMap.put(subEntryNode.getId(), subEntryNode);
            entryNode.addChild(subEntryNode);
        }
        return root;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }

    private Set<String> getHideFields() {
        String name = this.meta.getName();
        HashSet<String> hideFields = new HashSet<String>(20);
        if ("cad_costbom".equals(name) || "pdm_mftbom".equals(name) || "cad_router".equals(name) || "pdm_route".equals(name)) {
            hideFields.add("qtyentry");
            hideFields.add("setupentry");
            hideFields.add("saleorderentity");
            hideFields.add("entryentity");
            hideFields.add("relentryentity");
            hideFields.add("actentryentity");
            hideFields.add("subentryentity");
            hideFields.add("processentry");
            return hideFields;
        }
        hideFields.add("creator");
        hideFields.add("modifier");
        hideFields.add("auditor");
        hideFields.add("billstatus");
        hideFields.add("name");
        hideFields.add("remark");
        if ("cad_costobject".equals(name)) {
            hideFields.add("org");
            hideFields.add("isoutsource");
            hideFields.add("isrework");
            hideFields.add("productgroup");
            hideFields.add("weight");
            hideFields.add("biztype");
            hideFields.add("rule");
            hideFields.add("originype");
            hideFields.add("collconfig");
            hideFields.add("mainproobj");
            hideFields.add("sotype");
            hideFields.add("costobjectrule");
            hideFields.add("pno");
            hideFields.add("multipartcc");
        }
        return hideFields;
    }
}

