/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.business.calc.AutoStandCostCalcHandler;
import kd.macc.cad.business.calc.CalcChangedInfo;
import kd.macc.cad.common.utils.DateUtils;

public class AutoStandCostCalcTask
extends AbstractTask {
    Log logger = LogFactory.getLog(AutoStandCostCalcTask.class);

    public void execute(RequestContext rc, Map<String, Object> map) throws KDException {
        Object retainDays = map.get("retainDays");
        int days = 15;
        if (null != retainDays) {
            days = Integer.parseInt(retainDays.toString());
        }
        this.deleteHisData(rc, days);
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u5377\u7b97\u3011\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u4eba\uff1a%s", rc.getUserName()));
        HashSet<Long> successChangeRecordIds = new HashSet<Long>(16);
        HashSet<Long> failedChangeRecordIds = new HashSet<Long>(16);
        HashSet<Long> successMatIds = new HashSet<Long>(16);
        HashSet<Long> failedMatIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("status", "in", (Object)new String[]{"A", "D"});
        filter.and("keycol", "!=", (Object)" ");
        filter.and("keycolid", ">", (Object)0L);
        Map<Long, CalcChangedInfo> costTypeCalcChangeMap = AutoStandCostCalcHandler.getCostTypeCalcChangeMap(filter);
        for (Map.Entry<Long, CalcChangedInfo> entry : costTypeCalcChangeMap.entrySet()) {
            CalcChangedInfo info = entry.getValue();
            try {
                AutoStandCostCalcHandler.doCalc(info);
                successChangeRecordIds.addAll(info.getChangeRecordId());
                successMatIds.addAll(info.getMatIds());
            }
            catch (Exception ex) {
                this.logger.error(String.format("\u6210\u672c\u7c7b\u578b[%s]\u4e0b\u5bf9\u5e94\u7684\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55: %s \u5904\u7406\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a%s ", info.getCostTypeName(), info.getChangeRecordId().toString(), ex));
                failedChangeRecordIds.addAll(info.getChangeRecordId());
                failedMatIds.addAll(info.getMatIds());
            }
        }
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u5377\u7b97\u3011\u6267\u884c\u7ed3\u675f,\u5171\u5904\u7406  %s \u6761\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55,\u6210\u529f %s \u6761,\u5931\u8d25 %s \u6761\uff1b\u5171\u8ba1\u7b97 %s \u6761\u7269\u6599,\u6210\u529f %s \u6761,\u5931\u8d25 %s \u6761\u3002", successChangeRecordIds.size() + failedChangeRecordIds.size(), successChangeRecordIds.size(), failedChangeRecordIds.size(), successMatIds.size() + failedMatIds.size(), successMatIds.size(), failedMatIds.size()));
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u66f4\u65b0\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u5904\u7406\u72b6\u6001\u3011\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u4eba\uff1a%s", rc.getUserName()));
        AutoStandCostCalcHandler.updateStatus(successChangeRecordIds, "C");
        AutoStandCostCalcHandler.updateStatus(failedChangeRecordIds, "D");
        this.logger.info("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u66f4\u65b0\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u5904\u7406\u72b6\u6001\u3011\u6267\u884c\u7ed3\u675f\u3002");
    }

    private void deleteHisData(RequestContext rc, int logRetainDays) {
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u6e05\u9664\u5386\u53f2\u6570\u636e\u3011\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u4eba\uff1a%s", rc.getUserName()));
        Date date = DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)logRetainDays);
        QFilter dateFilter = new QFilter("createtime", "<=", (Object)date);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"cad_calchangerecord", (String)"id", (QFilter[])new QFilter[]{dateFilter, statusFilter});
        ArrayList delPks = new ArrayList(dyoCol.size());
        dyoCol.forEach(s -> delPks.add(s.get("id")));
        int delSize = DeleteServiceHelper.delete((String)"cad_calchangerecord", (QFilter[])new QFilter[]{new QFilter("id", "in", delPks)});
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u6e05\u9664\u5386\u53f2\u6570\u636e\u3011\u6267\u884c\u7ed3\u675f,\u5171\u6e05\u9664\u5386\u53f2\u6570\u636e  %s \u6761", delSize));
    }
}

