/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AutoUpdateDataService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(AutoUpdateDataService.class);
    private static Map<String, Object> orgOdToOrgId = new HashMap<String, Object>();

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"AutoUpdateDataTask\u6570\u636e\u5347\u7ea7\u5f00\u59cb\u3002", (String)"AutoUpdateDataService_0", (String)"macc-cad-business", (Object[])new Object[0]));
            logger.info("AutoUpdateDataTask\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            this.excetUpdaeData("cad_costbom", "pdm_mftbom");
            this.excetUpdaeData("cad_router", "pdm_route");
            result.setLog(ResManager.loadKDString((String)"AutoUpdateDataTask\u6570\u636e\u5347\u7ea7\u7ed3\u675f\u3002", (String)"AutoUpdateDataService_1", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info(e.getMessage());
            logger.info(result.getErrorInfo());
        }
        return result;
    }

    private void excetUpdaeData(String updateEntityName, String sourceeEntityName) {
        QFilter qFilter = new QFilter("manuorg", "=", (Object)" ").or(new QFilter("manuorg", "=", (Object)"0")).or(new QFilter("manuorg", "is null", null));
        int pageNum = 0;
        int pageSize = 100000;
        int dataSize = 100000;
        while (dataSize >= pageSize) {
            DynamicObject[] costBoms = BusinessDataServiceHelper.load((String)updateEntityName, (String)"number,createorg,manuorg", (QFilter[])new QFilter[]{qFilter}, null, (int)pageNum, (int)pageSize);
            dataSize = costBoms.length;
            ++pageNum;
            if (costBoms == null || costBoms.length <= 0) continue;
            Set numberList = Arrays.stream(costBoms).map(o -> o.get("number")).collect(Collectors.toSet());
            QFilter numberQf = new QFilter("number", "in", numberList);
            DynamicObject[] pdmBoms = BusinessDataServiceHelper.load((String)sourceeEntityName, (String)"number,createorg,ctrlstrategy,useorg", (QFilter[])new QFilter[]{numberQf});
            logger.info("AutoUpdateDataTask\u6570\u636e\u5347\u7ea7" + sourceeEntityName + "\u6570\u91cf" + pdmBoms.length);
            Boolean matchPdmData = null;
            for (DynamicObject costBom : costBoms) {
                DynamicObject createorg;
                String costNumber = costBom.getString("number");
                matchPdmData = false;
                for (DynamicObject pdmBom : pdmBoms) {
                    String pdmNumber = pdmBom.getString("number");
                    if (StringUtils.isEmpty((String)pdmNumber) || !pdmNumber.equals(costNumber)) continue;
                    String ctrlstrategy = pdmBom.getString("ctrlstrategy");
                    if ("5".equals(ctrlstrategy) || "7".equals(ctrlstrategy)) {
                        costBom.set("manuorg", pdmBom.get("createorg"));
                    } else {
                        costBom.set("manuorg", pdmBom.get("useorg"));
                    }
                    matchPdmData = true;
                }
                if (matchPdmData.booleanValue() || (createorg = costBom.getDynamicObject("createorg")) == null) continue;
                String createorgId = String.valueOf(createorg.getPkValue());
                Object orgId = orgOdToOrgId.get(createorgId);
                if (orgId == null) {
                    List useProOrg = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList((Long)createorg.getPkValue()), (String)"04");
                    if (useProOrg != null && useProOrg.size() > 0) {
                        costBom.set("manuorg", costBom.get("createorg"));
                        orgOdToOrgId.put(createorgId, costBom.get("createorg"));
                        continue;
                    }
                    List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)((Long)createorg.getPkValue()), (boolean)false);
                    if (!CadEmptyUtils.isEmpty((List)productOrgs)) {
                        costBom.set("manuorg", productOrgs.get(0));
                        orgOdToOrgId.put(createorgId, productOrgs.get(0));
                        continue;
                    }
                    orgOdToOrgId.put(createorgId, "noOrg");
                    continue;
                }
                if ("noOrg".equals(orgId)) continue;
                costBom.set("manuorg", orgId);
            }
            SaveServiceHelper.save((DynamicObject[])costBoms);
        }
    }
}

