/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.business.update.BatModifyCostInfo;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.CostUpdateTask;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BatModifyCostUpdateService {
    private Log logger = LogFactory.getLog(BatModifyCostUpdateService.class);

    public boolean doUpdateByModifyCost(IFormView view, QFilter filter, Long periodId, boolean isUpdateWizard) {
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,org,storageorg,costaccount,costtype srccosttype,material,configuredcode,tracknumber";
        DataSet batModifyPriceDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.doUpdate", (String)"cad_batmodifyprice", (String)selectFields, (QFilter[])filters, null);
        Date date = TimeServiceHelper.now();
        filters = new QFilter[]{new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DataSet orgCostTypeDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.doUpdate", (String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit,costtype", (QFilter[])filters, null);
        DataSet data = batModifyPriceDataSet.leftJoin(orgCostTypeDataSet).on("org", "calorg").on("costaccount", "costaccount").on("storageorg", "storageorgunit").select(batModifyPriceDataSet.getRowMeta().getFieldNames(), new String[]{"costtype targetcosttype"}).finish();
        data = data.filter("targetcosttype != 0L");
        HashMap<Long, ArrayList<Long>> costTypeIds = new HashMap<Long, ArrayList<Long>>(16);
        HashMap toUpdates = new HashMap(16);
        for (Row row : data) {
            Long srcCostTypeId = row.getLong("srccosttype");
            if (CadEmptyUtils.isEmpty((Long)srcCostTypeId)) continue;
            ArrayList<Long> ids = (ArrayList<Long>)costTypeIds.get(srcCostTypeId);
            if (CadEmptyUtils.isEmpty((List)ids)) {
                ids = new ArrayList<Long>(1);
            }
            ids.add(row.getLong("id"));
            costTypeIds.put(srcCostTypeId, ids);
            Long tarCostTypeId = row.getLong("targetcosttype");
            if (CadEmptyUtils.isEmpty((Long)tarCostTypeId)) continue;
            String key = row.getString("srccosttype") + '@' + row.getString("targetcosttype");
            List<BatModifyCostInfo> batModifyCostInfos = (List)toUpdates.get(key);
            if (CadEmptyUtils.isEmpty((List)batModifyCostInfos)) {
                batModifyCostInfos = new ArrayList<BatModifyCostInfo>(1);
            }
            BatModifyCostInfo batModifyCostInfo = new BatModifyCostInfo();
            batModifyCostInfo.setId(row.getLong("id"));
            batModifyCostInfo.setStorageOrgId(row.getLong("storageorg"));
            batModifyCostInfo.setSrcCostTypeId(row.getLong("srccosttype"));
            batModifyCostInfo.setTarCostTypeId(row.getLong("targetcosttype"));
            batModifyCostInfo.setMaterialId(row.getLong("material"));
            batModifyCostInfo.setConfiguredCodeId(row.getLong("configuredcode"));
            batModifyCostInfo.setTrackNumberId(row.getLong("tracknumber"));
            batModifyCostInfos.add(batModifyCostInfo);
            toUpdates.put(key, batModifyCostInfos);
        }
        for (Map.Entry costTypeId : costTypeIds.entrySet()) {
            CostUpdateEstablishedHelper.doCalcByPurPrices("cad_batmodifyprice", (List)costTypeId.getValue());
        }
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(toUpdates.size());
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null, (int)toUpdates.size());
        int i = 0;
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        HashMap<String, ArrayList<Long>> billNoToSrcIds = new HashMap<String, ArrayList<Long>>(16);
        for (Map.Entry toUpdate : toUpdates.entrySet()) {
            List batModifyCostInfos = (List)toUpdate.getValue();
            if (CadEmptyUtils.isEmpty((List)batModifyCostInfos)) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
            dynamicObject.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
            dynamicObject.set("billno", (Object)numbers[i]);
            dynamicObject.set("billstatus", (Object)"C");
            dynamicObject.set("period_id", (Object)periodId);
            dynamicObject.set("isspecifymaterial", (Object)true);
            dynamicObject.set("iscalccurlevel", (Object)true);
            dynamicObject.set("isallupdate", (Object)false);
            dynamicObject.set("sourcepage", (Object)"batmodifyprice");
            dynamicObject.set("creator_id", (Object)userId);
            dynamicObject.set("createtime", (Object)time);
            dynamicObject.set("modifier_id", (Object)userId);
            dynamicObject.set("modifytime", (Object)time);
            dynamicObject.set("auditor_id", (Object)userId);
            dynamicObject.set("auditdate", (Object)time);
            dynamicObject.set("updatestatus", (Object)"N");
            dynamicObject.set("isquickupdate", (Object)Boolean.TRUE);
            dynamicObject.set("matgrpstd_id", (Object)730148448254487552L);
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            this.generateUpdateBill(dynamicObject, batModifyCostInfos, arrayList);
            billNoToSrcIds.put(numbers[i], arrayList);
            updateBills.add(dynamicObject);
            ++i;
        }
        if (CadEmptyUtils.isEmpty(updateBills)) {
            return false;
        }
        BusinessDataServiceHelper.loadRefence((Object[])updateBills.toArray(new DynamicObject[0]), (IDataEntityType)((DynamicObject)updateBills.get(0)).getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])updateBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        if (isUpdateWizard) {
            HashMap<Long, String> idnumbers = new HashMap<Long, String>(updateBills.size());
            for (DynamicObject dynamicObject : updateBills) {
                idnumbers.put(dynamicObject.getLong("id"), dynamicObject.getString("billno"));
            }
            for (DynamicObject dynamicObject : updateBills) {
                DynamicObject bill = dynamicObject;
                String billNo = (String)idnumbers.get(bill.getLong("id"));
                if (CadEmptyUtils.isEmpty((String)billNo)) {
                    this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5355ID\uff1a{}\u6ca1\u6709\u627e\u5230\u5355\u636e\u7f16\u53f7", (Object)bill.getLong("id"));
                    continue;
                }
                List srcIds = (List)billNoToSrcIds.get(billNo);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("costUpdatePrimaryKey", Collections.singletonList(bill.getLong("id")));
                params.put("quickUpdateFlag", Boolean.TRUE);
                params.put("sourcePage", "cad_batmodifyprice");
                params.put("toUpdatePKs", srcIds);
                params.put("isPurMat", true);
                CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)bill.getLong("id"));
            }
        } else {
            for (Object e : updateBills) {
                DynamicObject dynamicObject = (DynamicObject)e;
                UpdateParam updateParam = new UpdateParam();
                updateParam.setRc(RequestContext.get());
                updateParam.setPageId(null);
                updateParam.setQuickUpdateFlag(Boolean.TRUE);
                updateParam.setIsPurMat(Boolean.TRUE);
                updateParam.setSrcCostTypeId(Long.valueOf(dynamicObject.getLong("srccosttype.id")));
                updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{dynamicObject.getLong("id")}));
                updateParam.setIsTrackUpdate(Boolean.FALSE);
                try {
                    String lockErr = CalcMutexHelper.checkAndRequireXMutexAll((String)"update", Collections.singleton(dynamicObject.getLong("targetcosttype.id")));
                    if (StringUtils.isNotEmpty((String)lockErr)) continue;
                    CostUpdateTask updateTask = new CostUpdateTask(updateParam);
                    ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
                }
                catch (Exception ex) {
                    this.logger.error("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return true;
    }

    public boolean doUpdateByModifyCost(IFormView view, List<Long> sourceIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard) {
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if (!"1".equals(isAttTargetCostType)) {
            return this.doUpdateByModifyCost(view, new QFilter("id", "in", sourceIds), periodId, isUpdateWizard);
        }
        if (CadEmptyUtils.isEmpty((Long)targetCostTypeId)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", sourceIds)};
        String selectFields = "id,org,storageorg,costaccount,costtype srccosttype,material,configuredcode,tracknumber";
        DataSet batModifyPriceDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.doUpdate", (String)"cad_batmodifyprice", (String)selectFields, (QFilter[])filters, null);
        Long srcCostTypeId = 0L;
        ArrayList<BatModifyCostInfo> batModifyCostInfos = new ArrayList<BatModifyCostInfo>(10);
        while (batModifyPriceDataSet.hasNext()) {
            Row row = batModifyPriceDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty((Long)(srcCostTypeId = row.getLong("srccosttype")))) continue;
            BatModifyCostInfo batModifyCostInfo = new BatModifyCostInfo();
            batModifyCostInfo.setId(row.getLong("id"));
            batModifyCostInfo.setStorageOrgId(row.getLong("storageorg"));
            batModifyCostInfo.setSrcCostTypeId(srcCostTypeId);
            batModifyCostInfo.setTarCostTypeId(targetCostTypeId);
            batModifyCostInfo.setMaterialId(row.getLong("material"));
            batModifyCostInfo.setConfiguredCodeId(row.getLong("configuredcode"));
            batModifyCostInfo.setTrackNumberId(row.getLong("tracknumber"));
            batModifyCostInfos.add(batModifyCostInfo);
        }
        CostUpdateEstablishedHelper.doCalcByPurPrices("cad_batmodifyprice", sourceIds);
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("sourcepage", (Object)"batmodifyprice");
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        if (!CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        ArrayList<Long> srcIds = new ArrayList<Long>(16);
        this.generateUpdateBill(updateBill, batModifyCostInfos, srcIds);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        if (isUpdateWizard) {
            if (CadEmptyUtils.isEmpty((String)updateBill.getString("billno"))) {
                this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5355ID\uff1a{}\u6ca1\u6709\u627e\u5230\u5355\u636e\u7f16\u53f7", (Object)updateBill.getLong("id"));
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBill.getLong("id")));
            params.put("quickUpdateFlag", Boolean.TRUE);
            params.put("sourcePage", "cad_batmodifyprice");
            params.put("toUpdatePKs", srcIds);
            params.put("isPurMat", true);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBill.getLong("id"));
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.TRUE);
            updateParam.setIsPurMat(Boolean.TRUE);
            updateParam.setSrcCostTypeId(Long.valueOf(updateBill.getLong("srccosttype.id")));
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBill.getLong("id")}));
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.error("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public boolean doUpdateByModifyCost(IFormView view, List<Long> sourceIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard, Map<String, Object> updateBillExtFieldsMap) {
        if (CadEmptyUtils.isEmpty((Long)targetCostTypeId)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", sourceIds)};
        String selectFields = "id,org,storageorg,costaccount,costtype srccosttype,material,configuredcode,tracknumber";
        DataSet batModifyPriceDataSet = QueryServiceHelper.queryDataSet((String)"BatModifyCostEditPlugin.doUpdate", (String)"cad_batmodifyprice", (String)selectFields, (QFilter[])filters, null);
        Long srcCostTypeId = 0L;
        ArrayList<BatModifyCostInfo> batModifyCostInfos = new ArrayList<BatModifyCostInfo>(10);
        while (batModifyPriceDataSet.hasNext()) {
            Row row = batModifyPriceDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty((Long)(srcCostTypeId = row.getLong("srccosttype")))) continue;
            BatModifyCostInfo batModifyCostInfo = new BatModifyCostInfo();
            batModifyCostInfo.setId(row.getLong("id"));
            batModifyCostInfo.setStorageOrgId(row.getLong("storageorg"));
            batModifyCostInfo.setSrcCostTypeId(srcCostTypeId);
            batModifyCostInfo.setTarCostTypeId(targetCostTypeId);
            batModifyCostInfo.setMaterialId(row.getLong("material"));
            batModifyCostInfo.setConfiguredCodeId(row.getLong("configuredcode"));
            batModifyCostInfo.setTrackNumberId(row.getLong("tracknumber"));
            batModifyCostInfos.add(batModifyCostInfo);
        }
        CostUpdateEstablishedHelper.doCalcByPurPrices("cad_batmodifyprice", sourceIds);
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("sourcepage", (Object)"batmodifyprice");
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if ("1".equals(isAttTargetCostType) && !CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        ArrayList<Long> srcIds = new ArrayList<Long>(16);
        this.generateUpdateBill(updateBill, batModifyCostInfos, srcIds);
        this.setUpdateBillExtFields(updateBill, updateBillExtFieldsMap);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        if (isUpdateWizard) {
            if (CadEmptyUtils.isEmpty((String)updateBill.getString("billno"))) {
                this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5355ID\uff1a{}\u6ca1\u6709\u627e\u5230\u5355\u636e\u7f16\u53f7", (Object)updateBill.getLong("id"));
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBill.getLong("id")));
            params.put("quickUpdateFlag", Boolean.TRUE);
            params.put("sourcePage", "cad_batmodifyprice");
            params.put("toUpdatePKs", srcIds);
            params.put("isPurMat", true);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBill.getLong("id"));
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.TRUE);
            updateParam.setIsPurMat(Boolean.TRUE);
            updateParam.setSrcCostTypeId(Long.valueOf(updateBill.getLong("srccosttype.id")));
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBill.getLong("id")}));
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.error("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public boolean doQuicklyUpdateByPurPrice(IFormView view, List<Long> srcIds, Long targetCostTypeId, Long periodId, boolean isUpdateWizard) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)purPrices)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (DynamicObject purPrice : purPrices) {
            srcCostTypeId = purPrice.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)purPrice.getLong("material"));
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        CostUpdateEstablishedHelper.doCalcByPurPrices("cad_purprices", srcIds);
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", true);
            params.put("sourcePage", "cad_batmodifyprice");
            params.put("toUpdatePKs", srcIds);
            params.put("isPurMat", true);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.TRUE);
            updateParam.setIsPurMat(Boolean.TRUE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5feb\u901f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Object)ex);
            }
        }
        return true;
    }

    public boolean doQuicklyUpdateByPurPrice(IFormView view, List<Long> srcIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard) {
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if (!"1".equals(isAttTargetCostType)) {
            return this.doQuicklyUpdateByPurPrice(view, srcIds, targetCostTypeId, periodId, isUpdateWizard);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)purPrices)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (Object purPrice : purPrices) {
            srcCostTypeId = purPrice.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)purPrice.getLong("material"));
        }
        if (!CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        CostUpdateEstablishedHelper.doCalcByPurPrices("cad_purprices", srcIds);
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", true);
            params.put("sourcePage", "cad_batmodifyprice");
            params.put("toUpdatePKs", srcIds);
            params.put("isPurMat", true);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.TRUE);
            updateParam.setIsPurMat(Boolean.TRUE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5feb\u901f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Object)ex);
            }
        }
        return true;
    }

    public boolean doQuicklyUpdateByPurPrice(IFormView view, List<Long> srcIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard, Map<String, Object> updateBillExtFieldsMap) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)purPrices)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (DynamicObject purPrice : purPrices) {
            srcCostTypeId = purPrice.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)purPrice.getLong("material"));
        }
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if ("1".equals(isAttTargetCostType) && !CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        this.setUpdateBillExtFields(updateBill, updateBillExtFieldsMap);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        CostUpdateEstablishedHelper.doCalcByPurPrices("cad_purprices", srcIds);
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", true);
            params.put("sourcePage", "cad_batmodifyprice");
            params.put("toUpdatePKs", srcIds);
            params.put("isPurMat", true);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.TRUE);
            updateParam.setIsPurMat(Boolean.TRUE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5feb\u901f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Object)ex);
            }
        }
        return true;
    }

    public boolean doQuicklyUpdateByOutPrice(IFormView view, List<Long> srcIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard) {
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection outPrices = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)outPrices)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("isquickupdate", (Object)Boolean.TRUE);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (DynamicObject outPrice : outPrices) {
            srcCostTypeId = outPrice.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)outPrice.getLong("material"));
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        Date effectTime = TimeServiceHelper.now();
        if (!CadEmptyUtils.isEmpty((Long)periodId) && Boolean.TRUE.toString().equals(CostUpdateHelper.getIsUpdateByPeriod((Long)Long.parseLong(targetCostTypeId.toString())))) {
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
            if (dates == null || dates.length != 2) {
                return false;
            }
            effectTime = dates[0];
        }
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        CostUpdateEstablishedHelper.copyOutSourcePrice(updateBill, new HashSet<Long>(srcIds), null, effectTime);
        if (!CadEmptyUtils.isEmpty(attTarCostTypeIds) && "1".equals(isAttTargetCostType)) {
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                updateBill.set("targetcosttype_id", (Object)attTarCostTypeId);
                BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
                CostUpdateEstablishedHelper.copyOutSourcePrice(updateBill, new HashSet<Long>(srcIds), null, effectTime);
            }
        }
        return true;
    }

    public boolean doUpdateByMatCostInfo(IFormView view, List<Long> srcIds, Long targetCostTypeId, Long periodId, boolean isUpdateWizard) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection matCosts = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCosts)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (DynamicObject matCost : matCosts) {
            srcCostTypeId = matCost.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)matCost.getLong("material"));
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", false);
            params.put("isPurMat", false);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.FALSE);
            updateParam.setIsPurMat(Boolean.FALSE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.error("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public boolean doUpdateByMatCostInfo(IFormView view, List<Long> srcIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard) {
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if (!"1".equals(isAttTargetCostType)) {
            return this.doUpdateByMatCostInfo(view, srcIds, targetCostTypeId, periodId, isUpdateWizard);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection matCosts = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCosts)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (Object matCost : matCosts) {
            srcCostTypeId = matCost.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)matCost.getLong("material"));
        }
        if (!CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", false);
            params.put("isPurMat", false);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.FALSE);
            updateParam.setIsPurMat(Boolean.FALSE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.error("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public boolean doUpdateByMatCostInfo(IFormView view, List<Long> srcIds, Long targetCostTypeId, List<Long> attTarCostTypeIds, Long periodId, boolean isUpdateWizard, Map<String, Object> updateBillExtFieldsMap) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcIds)};
        DynamicObjectCollection matCosts = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"costtype,material", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCosts)) {
            return false;
        }
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        String billNo = CodeRuleServiceHelper.getNumber((String)"cad_costupdatenew", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew"), null);
        DynamicObject updateBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
        updateBill.set("id", (Object)DB.genLongId((String)"t_cad_costupdatenew"));
        updateBill.set("billno", (Object)billNo);
        updateBill.set("billstatus", (Object)"C");
        updateBill.set("period_id", (Object)periodId);
        updateBill.set("isspecifymaterial", (Object)true);
        updateBill.set("iscalccurlevel", (Object)true);
        updateBill.set("isallupdate", (Object)false);
        updateBill.set("creator_id", (Object)userId);
        updateBill.set("createtime", (Object)time);
        updateBill.set("modifier_id", (Object)userId);
        updateBill.set("modifytime", (Object)time);
        updateBill.set("auditor_id", (Object)userId);
        updateBill.set("auditdate", (Object)time);
        updateBill.set("targetcosttype_id", (Object)targetCostTypeId);
        updateBill.set("updatestatus", (Object)"N");
        updateBill.set("matgrpstd_id", (Object)730148448254487552L);
        Long srcCostTypeId = 0L;
        for (DynamicObject matCost : matCosts) {
            srcCostTypeId = matCost.getLong("costtype");
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)matCost.getLong("material"));
        }
        String isAttTargetCostType = CadBgParamUtils.getCadBgParamForString((String)"isAttTargetCostType", (String)"0");
        if (!"1".equals(isAttTargetCostType) && !CadEmptyUtils.isEmpty(attTarCostTypeIds)) {
            DynamicObjectCollection attachTargetCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            for (Long attTarCostTypeId : attTarCostTypeIds) {
                DynamicObject dynamicObject = new DynamicObject(attachTargetCostTypes.getDynamicObjectType());
                dynamicObject.set("fbasedataid_id", (Object)attTarCostTypeId);
                attachTargetCostTypes.add((Object)dynamicObject);
            }
            updateBill.set("attachtargetcosttype", (Object)attachTargetCostTypes);
        }
        updateBill.set("srccosttype_id", (Object)srcCostTypeId);
        this.setUpdateBillExtFields(updateBill, updateBillExtFieldsMap);
        BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{updateBill}, (IDataEntityType)updateBill.getDynamicObjectType());
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costupdatenew", (DynamicObject[])new DynamicObject[]{updateBill}, (OperateOption)OperateOption.create());
        int successQty = operateResult.getSuccessPkIds() == null ? 0 : operateResult.getSuccessPkIds().size();
        this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4fdd\u5b58\u540e\u7684\u66f4\u65b0\u7533\u8bf7\uff1a{}\u6761", (Object)successQty);
        if (!operateResult.isSuccess()) {
            this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u5931\u8d25\u8be6\u60c5\uff1a{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
            throw new KDBizException(OperationResultHelper.errorMsgHandle((OperationResult)operateResult));
        }
        Long updateBillId = updateBill.getLong("id");
        if (isUpdateWizard) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("costUpdatePrimaryKey", Collections.singletonList(updateBillId));
            params.put("quickUpdateFlag", false);
            params.put("isPurMat", false);
            CostUpdateHelper.showUpdateWizard((IFormView)view, params, (Object)updateBillId);
        } else {
            UpdateParam updateParam = new UpdateParam();
            updateParam.setRc(RequestContext.get());
            updateParam.setPageId(null);
            updateParam.setQuickUpdateFlag(Boolean.FALSE);
            updateParam.setIsPurMat(Boolean.FALSE);
            updateParam.setSrcCostTypeId(srcCostTypeId);
            updateParam.setUpdatBillIds((List)Lists.newArrayList((Object[])new Long[]{updateBillId}));
            updateParam.setIsConfigUpdate(Boolean.FALSE);
            updateParam.setIsTrackUpdate(Boolean.FALSE);
            CostUpdateTask updateTask = new CostUpdateTask(updateParam);
            try {
                ThreadHelper.execute((Runnable)updateTask, (TaskType)TaskType.CAD_COSTUPDATE);
            }
            catch (Exception ex) {
                this.logger.error("\u7269\u6599\u6210\u672c\u4fe1\u606f\u66f4\u65b0\uff0c\u4e0d\u663e\u793a\u5411\u5bfc\u66f4\u65b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    private void generateUpdateBill(DynamicObject updateBill, List<BatModifyCostInfo> batModifyCostInfos, List<Long> srcIds) {
        for (int i = 0; i < batModifyCostInfos.size(); ++i) {
            BatModifyCostInfo batModifyCostInfo = batModifyCostInfos.get(i);
            if (i == 0) {
                updateBill.set("srccosttype_id", (Object)batModifyCostInfo.getSrcCostTypeId());
                updateBill.set("targetcosttype_id", (Object)batModifyCostInfo.getTarCostTypeId());
            }
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entrys.addNew();
            entry.set("material_id", (Object)batModifyCostInfo.getMaterialId());
            entry.set("configuredcode_id", (Object)batModifyCostInfo.getConfiguredCodeId());
            entry.set("tracknumber_id", (Object)batModifyCostInfo.getTrackNumberId());
            entry.set("salcalclogid", (Object)batModifyCostInfo.getId());
            srcIds.add(batModifyCostInfo.getId());
        }
    }

    private void setUpdateBillExtFields(DynamicObject updateBill, Map<String, Object> updateBillExtFieldsMap) {
        if (CadEmptyUtils.isEmpty(updateBillExtFieldsMap)) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)updateBill.getDataEntityType().getName());
        for (Map.Entry<String, Object> entry : updateBillExtFieldsMap.entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            String entryEntity = "";
            String entryField = "";
            if (field.contains("\\.")) {
                String[] split = field.split("\\.");
                entryEntity = split[0];
                entryField = split[1];
                if (dataEntityType.findProperty(entryField) == null) continue;
                DynamicObjectCollection dynamicObjectCollection = updateBill.getDynamicObjectCollection(entryEntity);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (value instanceof DynamicObject) {
                        dynamicObject.set(entryField + "_id", (Object)((DynamicObject)value).getLong("id"));
                        continue;
                    }
                    dynamicObject.set(entryField, value);
                }
                continue;
            }
            if (dataEntityType.findProperty(field) == null) continue;
            if (value instanceof DynamicObject) {
                updateBill.set(field + "_id", (Object)((DynamicObject)value).getLong("id"));
                continue;
            }
            updateBill.set(field, value);
        }
    }
}

