/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.calc.helper.CostUpdateWipCalServiceHelper;
import kd.macc.cad.algox.calc.helper.NewStdCalculateHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.business.update.MaterialCostProcessor;
import kd.macc.cad.business.update.ProdCostProcessor;
import kd.macc.cad.business.update.StorCostProcessor;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.EntityUtil;
import net.sf.json.JSONObject;

public class CostUpdateEstablishedHelper {
    private static final Log logger = LogFactory.getLog(CostUpdateEstablishedHelper.class);
    private static String[] keyCols = new String[]{"mversion", "assist", "project", "tracknumber", "configuredcode", "lot"};

    public static boolean copyCalcResult(DynamicObject updateBill, Set<Long> keyColIds, Date effectTime, Map<String, Long> matCostInfos, Set<Long> outKeyColIds) {
        Object ctx;
        Object[] param;
        logger.info("copyCalcResult_begin");
        Tuple<Boolean, Boolean> updateWay = CostUpdateEstablishedHelper.getUpdateWay(updateBill.getLong("id"));
        long startTime = System.currentTimeMillis();
        Long tarCostTypeId = updateBill.getLong("targetcosttype.id");
        QFilter filter = new QFilter("costtype", "=", (Object)tarCostTypeId);
        filter.and("keycolid", "in", keyColIds);
        filter.and("expdate", "=", (Object)DateUtils.getDeFaultExpDate());
        Boolean isAllUpdate = updateBill.getBoolean("isallupdate");
        if (Boolean.TRUE.equals(isAllUpdate)) {
            CostUpdateEstablishedHelper.dealNotExistsDataByAll("cad_calceffectiveresult", updateBill, effectTime);
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_calceffectiveresult", (QFilter[])new QFilter[]{filter}, null, (int)-1);
        Lists.partition((List)ids, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_calceffectiveresult", list, effectTime, null, null));
        if (Boolean.TRUE.equals(updateWay.item1)) {
            filter = new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id"));
            filter.and("keycolid", "in", keyColIds);
            filter.and("expdate", "=", (Object)DateUtils.getDeFaultExpDate());
            filter.and("ismaindata", "=", (Object)1);
            filter.and("isleaf", "=", (Object)"0");
            filter.and("entryentity.entrylevel", "=", (Object)0);
            ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])new QFilter[]{filter}, null, (int)-1);
            Lists.partition((List)ids, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_trackstdcalcresult", list, effectTime, null, null));
        }
        Map existMaxEffectDate = NewStdCalculateHelper.getMatCostMaxEffectDate((Long)tarCostTypeId, keyColIds);
        logger.info("copyCalcResult_\u66f4\u65b0\u751f\u6548\u7ed3\u679c\u8868\u7684\u5931\u6548\u65f6\u95f4\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        DBRoute route = DBRoute.of((String)"cal");
        HashMap<Long, Date> trackEffectDates = new HashMap<Long, Date>(16);
        StringBuilder sb = new StringBuilder();
        for (Long r : keyColIds) {
            if (Boolean.FALSE.equals(updateWay.item2) && !CadEmptyUtils.isEmpty(outKeyColIds) && outKeyColIds.contains(r)) continue;
            sb.append(",").append(r);
        }
        if (sb.length() == 0) {
            outKeyColIds.clear();
            outKeyColIds.addAll(keyColIds);
            return true;
        }
        String inKeyColIds = sb.substring(1);
        long fid = ID.genLongId();
        String algoKey = "t_cad_calceffectiveresult_algo";
        DataSet data = null;
        String sql = "";
        sb.setLength(0);
        if (Boolean.FALSE.equals(updateWay.item1)) {
            sb.append("select fid,flevel,fmaterielid,fauxproperty,fmatvers,flot,fconfiguredcodeid,ftracknumberid,fprojectid,fkeycol,fkeycolid,fcalcdimensionid,fbomid,fprocessrouteid,ftreepath,fisleaf,frootnode,fismaindata,fispubmat").append(" from t_cad_calcsimulars").append(" where fcosttypeid=").append(updateBill.getLong("srccosttype.id")).append(" and fcalcrecordid =").append(CadEmptyUtils.isEmpty((Long)updateBill.getLong("calcrecord.id")) ? 0L : updateBill.getLong("calcrecord.id")).append(" and fismaindata=1 and fisleaf = '0' and fkeycolid in (").append(inKeyColIds).append(")");
            sql = sb.toString();
            logger.info(String.format("\u6a21\u62df\u8868sql:%s", sql));
            data = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sql);
        } else {
            sb.append("select y.fid fid,0 flevel,y.fentrymaterialid fmaterielid,y.fentryauxproperty fauxproperty,fentrymatvers fmatvers,fentrylot flot,fentryconfiguredcodeid fconfiguredcodeid,fentrytracknumberid ftracknumberid,fentryprojectid fprojectid,fentrykeycol fkeycol,fentrykeycolid fkeycolid,0 fcalcdimensionid,fentrybomid fbomid,fentryprocessrouteid fprocessrouteid,fentrytreepath ftreepath,fentryisleaf fisleaf,fentryrootnode frootnode,fentryismaindata fismaindata,t.fispubmat fispubmat").append(" from t_cad_trackcalcresut t join t_cad_trackcalcentry y on t.fid = y.fid").append(" where t.fcosttypeid =").append(updateBill.getLong("srccosttype.id")).append(" and t.feffectdate is null").append(" and t.fkeycolid in (").append(inKeyColIds).append(")").append(" and y.fentryismaindata = 1 and y.fentryisleaf = '0' and y.fentrylevel = 0");
            sql = sb.toString();
            logger.info(String.format("\u8ddf\u8e2a\u8868sql:%s", sql));
            try (ShardingHintContext ctx2 = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)updateBill.getLong("srccosttype.id"))});){
                data = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sql);
            }
        }
        HashSet<Long> proKeyColIds = new HashSet<Long>(16);
        String insertSql = "insert into t_cad_calceffectiveresult(fid,flevel,fmaterialid,fauxproperty,fmatvers,flot,fconfiguredcodeid,ftracknumberid,fprojectid,fkeycol,fkeycolid,fcalcdimensionid,fbomid,fprocessrouteid,ftreepath,fisleaf,frootnode,fismaindata,fispubmat,fcosttypeid,fexpdate,feffectdate) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Object row : data) {
            Long object = row.getLong("fkeycolid");
            proKeyColIds.add(object);
            Date date = existMaxEffectDate.get(object) == null ? DateUtils.getDefaultEffectDate() : (Date)existMaxEffectDate.get(object);
            trackEffectDates.put(object, date);
            param = new Object[]{new SqlParameter(":fid", -5, (Object)(row.getLong("fid") + fid)), new SqlParameter(":flevel", -5, (Object)row.getLong("flevel")), new SqlParameter(":fmaterialid", -5, (Object)row.getLong("fmaterielid")), new SqlParameter(":fauxproperty", -5, (Object)row.getLong("fauxproperty")), new SqlParameter(":fmatvers", -5, (Object)row.getLong("fmatvers")), new SqlParameter(":flot", -9, (Object)row.getString("flot")), new SqlParameter(":fconfiguredcodeid", -5, (Object)row.getLong("fconfiguredcodeid")), new SqlParameter(":ftracknumberid", -5, (Object)row.getLong("ftracknumberid")), new SqlParameter(":fprojectid", -5, (Object)row.getLong("fprojectid")), new SqlParameter(":fkeycol", -9, (Object)row.getString("fkeycol")), new SqlParameter(":fkeycolid", -5, (Object)object), new SqlParameter(":fcalcdimensionid", -5, (Object)row.getLong("fcalcdimensionid")), new SqlParameter(":fbomid", -5, (Object)row.getLong("fbomid")), new SqlParameter(":fprocessrouteid", -5, (Object)row.getLong("fprocessrouteid")), new SqlParameter(":ftreepath", -9, (Object)row.getString("ftreepath")), new SqlParameter(":fisleaf", -9, (Object)row.getString("fisleaf")), new SqlParameter(":frootnode", -9, (Object)row.getString("frootnode")), new SqlParameter(":fismaindata", -5, (Object)row.getLong("fismaindata")), new SqlParameter(":fispubmat", -5, (Object)row.getLong("fispubmat")), new SqlParameter(":fcosttypeid", -5, (Object)tarCostTypeId), new SqlParameter(":fexpdate", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":feffectdate", 91, (Object)date)};
            params.add(param);
            CostUpdateEstablishedHelper.savePartDatas(route, insertSql, params);
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
        }
        logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5934t_cad_calceffectiveresult\u6570\u636e\u5904\u7406\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        logger.info("matCostInfo={}", matCostInfos);
        if (matCostInfos.size() > 0) {
            HashMap<Long, Set> costTypeKcMap = new HashMap<Long, Set>(16);
            for (Map.Entry entry : matCostInfos.entrySet()) {
                String[] stringArray = ((String)entry.getKey()).split("@");
                if (stringArray.length != 2) {
                    logger.info("split ={},\u7269\u6599\u6210\u672c\u4fe1\u606fID={},KEY ={}", new Object[]{stringArray, entry.getValue(), entry.getKey()});
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7269\u6599\u6210\u672c\u4fe1\u606f\u8fd4\u56de\u7684\u6210\u672c\u7c7b\u578b\u3001keycol\u6709\u8bef\uff0c\u4e2d\u6b62\u66f4\u65b0\u3002matCost=%s\u3002", (String)"CostUpdateEstablishedHelper_0", (String)"macc-cad-business", (Object[])new Object[0]), entry.getKey()));
                }
                costTypeKcMap.computeIfAbsent(Long.parseLong(stringArray[0]), p -> new HashSet()).add(stringArray[1]);
            }
            for (Map.Entry entry : costTypeKcMap.entrySet()) {
                Long l = (Long)entry.getKey();
                Set keycols = (Set)entry.getValue();
                if (CadEmptyUtils.isEmpty((Set)keycols)) continue;
                for (List keycolList : Lists.partition(new ArrayList(keycols), (int)5000)) {
                    CostUpdateEstablishedHelper.updateMatCostInfo(l, keycolList, matCostInfos);
                }
            }
            costTypeKcMap.clear();
        }
        logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5173\u8054\u7269\u6599\u6210\u672c\u4fe1\u606f(matcostid)\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        int priceprecision = updateBill.getInt("targetcosttype.currency.priceprecision");
        sb.setLength(0);
        if (Boolean.FALSE.equals(updateWay.item1)) {
            sb.append("select se.fid as fid,fcalcbasis,fresourceid,felementid,fsubelementid,SUM(fqty) fqty,SUM(ROUND(fstdprice,").append(priceprecision).append(")) fstdprice,fsubmaterialid,fsubmatvers,fsubauxproperty,fsublot,fsubconfiguredcodeid,fsubtracknumberid,fsubprojectid,fsubcalcdimensionid,fsubkeycol,fsubkeycolid,fdatatype").append(" from t_cad_calcsimulars s ").append(" inner join t_cad_calcsimularsentry se on se.fid=s.fid ").append(" where s.fcosttypeid=").append(updateBill.getLong("srccosttype.id")).append(" and s.fismaindata=1 and s.fisleaf = '0' and s.fkeycolid in (").append(inKeyColIds).append(") ").append(" group by se.fid,fcalcbasis,fresourceid,felementid,fsubelementid,fsubmaterialid,fsubmatvers,fsubauxproperty,fsublot,fsubconfiguredcodeid,fsubtracknumberid,fsubprojectid,fsubcalcdimensionid,fsubkeycol,fsubkeycolid,fdatatype");
            logger.info(String.format("\u6a21\u62df\u8868--\u751f\u6548\u7ed3\u679c\u8868\u5206\u5f55\u67e5\u8be2\u6570\u636esql:%s", sb.toString()));
            ctx = ShardingHintContext.createAndSet((String)"t_cad_calcsimulars", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)updateBill.getLong("srccosttype.id"))});
            Throwable throwable = null;
            try {
                data = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sb.toString());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                if (ctx != null) {
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        sb.append("select y.fid,fcalcbasis,fresourceid,felementid,fsubelementid,SUM(fqty) fqty,SUM(ROUND(fstdprice,").append(priceprecision).append(")) fstdprice,fsubmaterialid,fsubmatvers,fsubauxproperty,fsublot,fsubconfiguredcodeid,fsubtracknumberid,fsubprojectid,0 fsubcalcdimensionid,fsubkeycol,fsubkeycolid,fdatatype").append(" from t_cad_trackcalcresut t ").append(" inner join t_cad_trackcalcentry y on y.fid = t.fid ").append(" inner join t_cad_trackcalcsubentry ry on ry.fentryid = y.fentryid ").append(" where t.fcosttypeid=").append(updateBill.getLong("srccosttype.id")).append(" and t.feffectdate is null").append(" and y.fentrykeycolid in (").append(inKeyColIds).append(")").append(" and y.fentryismaindata = 1 and y.fentryisleaf = '0' and y.fentrylevel = 0").append(" group by y.fid,fcalcbasis,fresourceid,felementid,fsubelementid,fsubmaterialid,fsubmatvers,fsubauxproperty,fsublot,fsubconfiguredcodeid,fsubtracknumberid,fsubprojectid,fsubcalcdimensionid,fsubkeycol,fsubkeycolid,fdatatype");
        logger.info(String.format("\u8ddf\u8e2a\u8868--\u751f\u6548\u7ed3\u679c\u8868\u5206\u5f55\u67e5\u8be2\u6570\u636esql:%s", sb.toString()));
        ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)updateBill.getLong("srccosttype.id"))});
        Throwable throwable = null;
        try {
            data = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sb.toString());
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        finally {
            if (ctx != null) {
                if (throwable != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        params.clear();
        insertSql = "insert into t_cad_calceffectrsentry(fid,fentryid,fcalcbasis,fresourceid,felementid,fsubelementid,fqty,fprice,fstdprice,fsubmaterialid,fsubmatvers,fsubauxproperty,fsublot,fsubconfiguredcodeid,fsubtracknumberid,fsubprojectid,fsubcalcdimensionid,fsubkeycol,fsubkeycolid,fdatatype) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        for (Row row : data) {
            BigDecimal bigDecimal = row.getBigDecimal("fqty");
            BigDecimal stdPrice = row.getBigDecimal("fstdprice");
            BigDecimal price = BigDecimal.ZERO;
            if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                price = stdPrice.divide(bigDecimal, priceprecision, 4);
            }
            if (stdPrice != null && stdPrice.abs().compareTo(new BigDecimal("100000000")) > 0) {
                logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5206\u5f55 t_cad_calceffectrsentry \u6570\u636e\u8d85\u5927\u5f02\u5e38 fstdprice {},fprice {}", (Object)stdPrice, (Object)price);
            }
            Object[] param2 = new Object[]{new SqlParameter(":fid", -5, (Object)(row.getLong("fid") + fid)), new SqlParameter(":fentryid", -5, (Object)CostUpdateEstablishedHelper.genDbLongId("t_cad_calceffectrsentry")), new SqlParameter(":fcalcbasis", -9, (Object)row.getString("fcalcbasis")), new SqlParameter(":fresourceid", -5, (Object)row.getLong("fresourceid")), new SqlParameter(":felementid", -5, (Object)row.getLong("felementid")), new SqlParameter(":fsubelementid", -5, (Object)row.getLong("fsubelementid")), new SqlParameter(":fqty", 3, (Object)bigDecimal), new SqlParameter(":fprice", 3, (Object)price), new SqlParameter(":fstdprice", 3, (Object)stdPrice), new SqlParameter(":fsubmaterialid", -5, (Object)row.getLong("fsubmaterialid")), new SqlParameter(":fsubmatvers", -5, (Object)row.getLong("fsubmatvers")), new SqlParameter(":fsubauxproperty", -5, (Object)row.getLong("fsubauxproperty")), new SqlParameter(":fsublot", -9, (Object)row.getString("fsublot")), new SqlParameter(":fsubconfiguredcodeid", -5, (Object)row.getLong("fsubconfiguredcodeid")), new SqlParameter(":fsubtracknumberid", -5, (Object)row.getLong("fsubtracknumberid")), new SqlParameter(":fsubprojectid", -5, (Object)row.getLong("fsubprojectid")), new SqlParameter(":fsubcalcdimensionid", -5, (Object)row.getLong("fsubcalcdimensionid")), new SqlParameter(":fsubkeycol", -9, (Object)row.getString("fsubkeycol")), new SqlParameter(":fsubkeycolid", -5, (Object)row.getLong("fsubkeycolid")), new SqlParameter(":fdatatype", -9, (Object)row.getString("fdatatype"))};
            params.add(param2);
            CostUpdateEstablishedHelper.savePartEntryDatas(route, insertSql, params, tarCostTypeId);
        }
        if (!params.isEmpty()) {
            ctx = ShardingHintContext.createAndSet((String)"t_cad_calceffectiveresult", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)tarCostTypeId)});
            Throwable throwable8 = null;
            try {
                DB.executeBatch((DBRoute)route, (String)insertSql, params);
            }
            catch (Throwable throwable9) {
                Throwable throwable10 = throwable9;
                throw throwable9;
            }
            finally {
                if (ctx != null) {
                    if (throwable8 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable11) {
                            throwable8.addSuppressed(throwable11);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5206\u5f55t_cad_calceffectrsentry\u6570\u636e\u5904\u7406\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        if (Boolean.TRUE.equals(updateWay.item1) && !CadEmptyUtils.isEmpty(trackEffectDates)) {
            startTime = System.currentTimeMillis();
            String updateSql = "update t_cad_trackcalcresut set feffectdate = ?, fexpdate = ? where fcosttypeid = " + updateBill.getLong("srccosttype.id") + " and fkeycolid = ? and fismaindata = 1 and fisleaf = '0' and feffectdate is null;";
            params.clear();
            for (Map.Entry entry : trackEffectDates.entrySet()) {
                param = new Object[]{new SqlParameter(":feffectdate", 91, entry.getValue()), new SqlParameter(":fexpdate", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":fkeycolid", -5, entry.getKey())};
                params.add(param);
                CostUpdateEstablishedHelper.saveTrackPartDatas(route, updateSql, params);
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)route, (String)updateSql, params);
            }
            logger.info("\u53cd\u5199\u8ddf\u8e2a\u7ed3\u679c\u8868\u7684\u751f\u6548\u3001\u5931\u6548\u65f6\u95f4\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime));
        }
        HashSet<Long> allKeyColIds = new HashSet<Long>(keyColIds.size());
        allKeyColIds.addAll(keyColIds);
        allKeyColIds.removeAll(proKeyColIds);
        if (!CadEmptyUtils.isEmpty(allKeyColIds)) {
            outKeyColIds.addAll(allKeyColIds);
        }
        return true;
    }

    private static void updateMatCostInfo(Long costType, List<String> keycols, Map<String, Long> matCostInfos) {
        DynamicObject[] dynamicObjects;
        long startTimeTmp = System.currentTimeMillis();
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("keycol", "in", keycols));
        filter.and(new QFilter("isleaf", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("ismaindata", "=", (Object)1));
        filter.and(new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()));
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_calceffectiveresult", (String)"costtype,keycol,matcostid", (QFilter[])new QFilter[]{filter})) {
            Long costTypeId = dynamicObject.getLong("costtype.id");
            String keycol = dynamicObject.getString("keycol");
            String key = costTypeId + "@" + keycol;
            dynamicObject.set("matcostid", (Object)matCostInfos.getOrDefault(key, 0L));
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5934t_cad_calceffectiveresult\u6570\u636e\u5904\u7406\u5206\u6279-\u5173\u8054\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTimeTmp));
    }

    private static long genDbLongId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    public static void dealNotExistsDataByAll(String entityName, DynamicObject updateBill, Date effectTime) {
        if ("cad_routersetting".equalsIgnoreCase(entityName)) {
            return;
        }
        Long tarCostTypeId = updateBill.getLong("targetcosttype.id");
        Long srcCostTypeId = updateBill.getLong("srccosttype.id");
        if ("cad_calceffectiveresult".equals(entityName)) {
            String sql = "SELECT FKEYCOLID FROM T_CAD_CALCSIMULARS WHERE FCOSTTYPEID = " + srcCostTypeId;
            DataSet calcDatas = DB.queryDataSet((String)"dealExistsDataByAll_cad_calceffectiveresult", (DBRoute)new DBRoute("cal"), (String)sql);
            ArrayList<String> colIds = new ArrayList<String>(16);
            for (Row calcData : calcDatas) {
                colIds.add(calcData.getString("fkeycolid"));
            }
            String updateSql = "UPDATE T_CAD_CALCEFFECTIVERESULT SET FEXPDATE = ? WHERE FCOSTTYPEID = ? AND FEXPDATE = ? ";
            sql = CadEmptyUtils.isEmpty(colIds) ? updateSql : updateSql + " AND FKEYCOLID NOT IN (" + String.join((CharSequence)",", colIds) + ")";
            Object[] params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime), new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate())};
            logger.info(sql);
            DB.execute((DBRoute)new DBRoute("cal"), (String)sql, (Object[])params);
            return;
        }
        String tarTableName = null;
        String srcTableName = null;
        switch (entityName) {
            case "cad_matcostinfo": {
                tarTableName = "T_BD_MATCOSTINFO";
                srcTableName = "T_BD_MATCOSTINFO";
                break;
            }
            case "cad_calceffectiveresult": {
                tarTableName = "T_CAD_CALCEFFECTIVERESULT";
                srcTableName = "T_CAD_CALCSIMULARS";
                break;
            }
            case "cad_trackstdcalcresult": {
                tarTableName = "T_CAD_TRACKCALCRESUT";
                srcTableName = "T_CAD_TRACKCALCRESUT";
                break;
            }
            case "cad_bomsetting": {
                tarTableName = "T_CAD_BOMSETTING";
                srcTableName = "T_CAD_BOMSETTING";
                break;
            }
            case "cad_routersetting": {
                tarTableName = "T_CAD_ROUTERSETTING";
                break;
            }
            case "cad_calcpurprices": {
                tarTableName = "T_CAD_PURPRICES";
                srcTableName = "T_CAD_CALCPURPRICES";
                break;
            }
            case "cad_resourcerate": {
                tarTableName = "T_CAD_RESOURCERATE";
                srcTableName = "T_CAD_RESOURCERATE";
                break;
            }
            case "cad_resourceout": {
                tarTableName = "T_CAD_RESOURCEOUT";
                srcTableName = "T_CAD_RESOURCEOUT";
                break;
            }
            case "cad_outsourceprice": {
                tarTableName = "T_CAD_OUTSOURCEPRICE";
                srcTableName = "T_CAD_OUTSOURCEPRICE";
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)tarTableName)) {
            return;
        }
        String strSql = "";
        Object[] params = null;
        switch (entityName) {
            case "cad_resourcerate": 
            case "cad_resourceout": {
                strSql = "UPDATE " + tarTableName + " SET FEXPDATE = ? WHERE FCOSTTYPEID = ? AND FEXPDATE = ? AND FRESOURCEID NOT IN (SELECT A.FRESOURCEID FROM (SELECT FRESOURCEID FROM " + srcTableName + " WHERE FCOSTTYPEID = ? AND FEXPDATE = ?)A )";
                params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime), new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":FCOSTTYPEID", -5, (Object)srcCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate())};
                break;
            }
            case "cad_calcpurprices": {
                strSql = "UPDATE " + tarTableName + " SET FEXPDATE = ? WHERE FCOSTTYPEID = ? AND FEXPDATE = ? AND FKEYCOLID NOT IN (SELECT A.FKEYCOLID FROM (SELECT FKEYCOLID FROM " + srcTableName + " WHERE FCOSTTYPEID = ?)A )";
                params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime), new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":FCOSTTYPEID", -5, (Object)srcCostTypeId)};
                break;
            }
            case "cad_outsourceprice": {
                strSql = "UPDATE " + tarTableName + " SET FEXPDATE = ? WHERE FCOSTTYPEID = ? AND FEXPDATE = ? AND FKEYCOLID NOT IN (SELECT A.FKEYCOLID FROM (SELECT FKEYCOLID FROM " + srcTableName + " WHERE FCOSTTYPEID = ? AND FEXPDATE = ?)A )";
                params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime), new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":FCOSTTYPEID", -5, (Object)srcCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate())};
                break;
            }
            default: {
                strSql = "UPDATE " + tarTableName + " SET FEXPDATE = ? WHERE FCOSTTYPEID = ? AND FEXPDATE = ? AND FKEYCOLID NOT IN (SELECT A.FKEYCOLID FROM (SELECT FKEYCOLID FROM " + srcTableName + " WHERE FCOSTTYPEID = ?)A )";
                params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime), new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId), new SqlParameter(":FEXPDATE", 91, (Object)DateUtils.getDeFaultExpDate()), new SqlParameter(":FCOSTTYPEID", -5, (Object)srcCostTypeId)};
            }
        }
        logger.info(strSql);
        DB.execute((DBRoute)new DBRoute("cal"), (String)strSql, (Object[])params);
    }

    public static void dealAgainExistsDataByAll(String entityName, DynamicObject updateBill, Set<Long> keyColIds) {
        if ("cad_routersetting".equalsIgnoreCase(entityName)) {
            return;
        }
        Long tarCostTypeId = updateBill.getLong("targetcosttype.id");
        Long srcCostTypeId = updateBill.getLong("srccosttype.id");
        String tarTableName = null;
        switch (entityName) {
            case "cad_matcostinfo": {
                tarTableName = "T_BD_MATCOSTINFO";
                break;
            }
            case "cad_calceffectiveresult": {
                tarTableName = "T_CAD_CALCEFFECTIVERESULT";
                break;
            }
            case "cad_trackstdcalcresult": {
                tarTableName = "T_CAD_TRACKCALCRESUT";
                break;
            }
            case "cad_bomsetting": {
                tarTableName = "T_CAD_BOMSETTING";
                break;
            }
            case "cad_calcpurprices": {
                tarTableName = "T_CAD_PURPRICES";
                break;
            }
            case "cad_resourcerate": {
                tarTableName = "T_CAD_RESOURCERATE";
                break;
            }
            case "cad_resourceout": {
                tarTableName = "T_CAD_RESOURCEOUT";
                break;
            }
            case "cad_outsourceprice": {
                tarTableName = "T_CAD_OUTSOURCEPRICE";
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)tarTableName)) {
            return;
        }
        String strSql = null;
        Object[] params = null;
        switch (entityName) {
            case "cad_matcostinfo": {
                strSql = "SELECT FKEYCOLID,MAX(FEXPDATE) FEXPDATE FROM " + tarTableName + " WHERE FCOSTTYPEID = ? AND FKEYCOLID NOT IN (" + StringUtils.join((Object[])keyColIds.toArray(), (String)",") + ") GROUP BY FKEYCOLID";
                params = new Object[]{new SqlParameter(":FCOSTTYPEID", -5, (Object)tarCostTypeId)};
                break;
            }
        }
        if (CadEmptyUtils.isEmpty(strSql)) {
            return;
        }
        HashMap<Long, Date> keyColIdMaxExpdates = new HashMap<Long, Date>(16);
        DataSet data = DB.queryDataSet((String)"dealAgainExistsDataByAll", (DBRoute)new DBRoute("cal"), strSql, params);
        for (Row row : data) {
            Date expdate = row.getDate("FEXPDATE");
            if (DateUtils.getDeFaultExpDate().compareTo(expdate) == 0) continue;
            keyColIdMaxExpdates.put(row.getLong("FKEYCOLID"), expdate);
        }
        if (CadEmptyUtils.isEmpty(keyColIdMaxExpdates)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)srcCostTypeId), new QFilter("keycolid", "in", keyColIdMaxExpdates.keySet())};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        Lists.partition((List)ids, (int)1000).forEach(list -> CostUpdateEstablishedHelper.saveCalcInfoByAll(updateBill, "cad_matcostinfo", "currency,material,lot,configuredcode,tracknumber,project,matversion,auxpty,keycol,keycolid,status,enable,bomtype,bom,processroute,processversion,consideryieldrate,considersubmaterialloss,considerpreparetime,considervalidperiod,iscalccurlevel,entryentity.element,entryentity.subelement,entryentity.standardcost,entryentity.stepamt", list, keyColIdMaxExpdates, true));
    }

    private static void saveCalcInfoByAll(DynamicObject updateBill, String entityName, String copyfields, List<Object> ids, Map<Long, Date> keyColIdMaxExpdates, boolean isbaseData) {
        ArrayList<DynamicObject> tarObjlist = new ArrayList<DynamicObject>(10);
        String remark = ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u66f4\u65b0\u5355%1$s\u590d\u5236\u751f\u6210\uff0c\u65f6\u95f4\uff1a%2$s\u3002", (String)"CostUpdateEstablishedHelper_6", (String)"macc-cad-business", (Object[])new Object[0]);
        QFilter qfIds = new QFilter("id", "in", ids);
        DynamicObject[] fromObjs = BusinessDataServiceHelper.load((String)entityName, (String)copyfields, (QFilter[])new QFilter[]{qfIds});
        Object[] numbers = CodeRuleServiceHelper.getBatchNumber((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName), (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName)), null, (int)fromObjs.length);
        String curTime = DateUtils.formatDate((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss");
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        for (int index = 0; index < fromObjs.length; ++index) {
            DynamicObject fromObjTmp = fromObjs[index];
            DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName));
            EntityUtil.copyPropertiesWithOutId((DynamicObject)tarObj, (DynamicObject)fromObjTmp);
            if (isbaseData) {
                Long id = DBServiceHelper.genGlobalLongId();
                tarObj.set("id", (Object)id);
                tarObj.set("masterid", (Object)id);
                if (!CadEmptyUtils.isEmpty((Object[])numbers)) {
                    tarObj.set("number", numbers[index]);
                }
            } else {
                tarObj.set("billno", (Object)numbers[index]);
            }
            tarObj.set("costtype", updateBill.get("targetcosttype"));
            tarObj.set("effectdate", (Object)keyColIdMaxExpdates.get(fromObjTmp.getLong("keycolid.id")));
            tarObj.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            tarObj.set("remark", (Object)String.format(remark, updateBill.get("billno"), curTime));
            tarObj.set("creator", (Object)userId);
            tarObj.set("createtime", (Object)time);
            tarObj.set("modifier", (Object)userId);
            tarObj.set("modifytime", (Object)time);
            tarObj.set("auditor", (Object)userId);
            tarObj.set("audittime", (Object)time);
            tarObjlist.add(tarObj);
        }
        if (!tarObjlist.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])tarObjlist.toArray(new DynamicObject[0]));
        }
    }

    public static void dealExistsDataByPart(String entityName, List<Object> ids, Date effectTime, String selectFields, Set<String> tarExistsData) {
        if (ids.isEmpty()) {
            return;
        }
        String tableName = null;
        switch (entityName) {
            case "cad_matcostinfo": {
                tableName = "T_BD_MATCOSTINFO";
                break;
            }
            case "cad_calceffectiveresult": {
                tableName = "T_CAD_CALCEFFECTIVERESULT";
                break;
            }
            case "cad_trackstdcalcresult": {
                tableName = "T_CAD_TRACKCALCRESUT";
                break;
            }
            case "cad_bomsetting": {
                tableName = "T_CAD_BOMSETTING";
                break;
            }
            case "cad_routersetting": {
                tableName = "T_CAD_ROUTERSETTING";
                break;
            }
            case "cad_calcpurprices": {
                tableName = "T_CAD_PURPRICES";
                break;
            }
            case "cad_resourcerate": {
                tableName = "T_CAD_RESOURCERATE";
                break;
            }
            case "cad_resourceout": {
                tableName = "T_CAD_RESOURCEOUT";
                break;
            }
            case "cad_outsourceprice": {
                tableName = "T_CAD_OUTSOURCEPRICE";
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        String strSql = "UPDATE " + tableName + " SET FEXPDATE = ? WHERE FID IN (" + StringUtils.join((Object[])ids.toArray(), (String)",") + ")";
        Object[] params = new Object[]{new SqlParameter(":FEXPDATE", 91, (Object)effectTime)};
        logger.info(strSql);
        DB.execute((DBRoute)new DBRoute("cal"), (String)strSql, (Object[])params);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            return;
        }
        List splitLists = Lists.partition(ids, (int)2000);
        for (List idsSp : splitLists) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)idsSp)};
            DynamicObject[] datas = BusinessDataServiceHelper.load((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName), (String)selectFields, (QFilter[])filters);
            String[] fields = selectFields.split(",");
            for (DynamicObject data : datas) {
                tarExistsData.add(CostUpdateEstablishedHelper.getKey(fields, data));
            }
        }
    }

    private static String getKey(String[] fields, DynamicObject data) {
        StringBuilder sg = new StringBuilder();
        for (String field : fields) {
            sg.append(data.get(field) != null ? data.getString(field) : "0");
            sg.append("#");
        }
        return sg.toString();
    }

    public static void copyBomSetting(DynamicObject bill, Set<String> keycols, Date effectTime) {
        QFilter filter = new QFilter("keycol", "in", keycols);
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        String selectFields = "keycol";
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_bomsetting", "costtype,number,remark,material,bomversion,auxprop,keycol,keycolid,project,tracknumber,configuredcode,lot,bomtype,bom,status,enable,creator,createtime,modifier,modifytime,audit,auditdate,bizctrl,chargedefsubelement,chargestdrate,isbomversion,isauxprop,consideryieldrate,considersubmaterialloss,considervalidperiod,lossrateformula,isdowncalc", filter, selectFields, effectTime, true, true, null);
    }

    public static void copyRoutersetting(DynamicObject bill, Set<String> keyCols, Date effectTime) {
        QFilter filter = new QFilter("materialentry.keycol", "in", keyCols);
        filter.and(new QFilter("status", "=", (Object)"C"));
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_routersetting", "costtype,number,remark,router,version,routertype,matgroup,considerpreparetime,status,enable,creator,createtime,modifier,modifytime,audit,auditdate,materialentry.material,materialentry.auxpty,materialentry.configuredcode,materialentry.tracknumber,materialentry.project,materialentry.lot,materialentry.bizctrl,materialentry.seq,materialentry.keycol,materialentry.keycolid", filter, null, effectTime, true, false, null);
        filter = new QFilter("routertype", "=", (Object)"C");
        filter.and(new QFilter("status", "=", (Object)"C"));
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_routersetting", "costtype,number,remark,router,version,routertype,matgroup,considerpreparetime,status,enable,creator,createtime,modifier,modifytime,audit,auditdate,materialentry.material,materialentry.auxpty,materialentry.configuredcode,materialentry.tracknumber,materialentry.project,materialentry.lot,materialentry.bizctrl,materialentry.seq,materialentry.keycol,materialentry.keycolid", filter, null, effectTime, true, false, null);
    }

    public static void copyPurPrices(DynamicObject bill, Set<Long> keyColIds, Set<Long> outKeyColIds, Date effectTime, Map<String, Long> matCostInfos) {
        if (CadEmptyUtils.isEmpty(outKeyColIds)) {
            return;
        }
        QFilter filter = new QFilter("keycolid", "in", keyColIds);
        filter.and("keycolid", "in", outKeyColIds);
        String selectFields = "keycolid.id";
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_calcpurprices", "costtype,billno,currency,remark,material,matversion,auxpty,keycol,keycolid,project,tracknumber,configuredcode,lot,pricerule,amount,creator,createtime,modifier,modifytime,auditor,auditdate,entryentity.element,entryentity.subelement,entryentity.price,entryentity.rate,entryentity.seq,billstatus", filter, selectFields, effectTime, false, true, matCostInfos);
    }

    public static void copyOutSourcePrice(DynamicObject updateBill, Set<Long> ids, Set<Long> keyColIds, Date effectTime) {
        QFilter filter = new QFilter("id", "in", ids);
        if (!CadEmptyUtils.isEmpty(keyColIds)) {
            filter.and("keycolid", "in", keyColIds);
        }
        filter.and("billstatus", "=", (Object)"C");
        String selectFields = "keycolid.id";
        CostUpdateEstablishedHelper.updateBillData(updateBill, "cad_outsourceprice", "costtype,billno,currency,remark,material,matversion,auxpty,keycol,keycolid,project,tracknumber,configuredcode,lot,bat,element,subelement,pricerule,price,creator,createtime,modifier,modifytime,auditor,auditdate,billstatus,entryentity.extelement,entryentity.extsubelement,entryentity.amount", filter, selectFields, effectTime, false, true, null);
    }

    public static void copyResourceRate(DynamicObject bill, Date effectTime, Set<Long> ids) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("id", "in", ids);
        String selectFields = "workcenter.id,resource.id";
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_resourcerate", "costtype,billno,currency,remark,datasrc,workcenter,resource,pricerule,workhourunit,element,subelement,preworkhourprice,realworkhourprice,creator,createtime,modifier,modifytime,auditor,auditdate,billstatus,calcbasis,qty,amount,resourceunit,entryentity.attaelement,entryentity.attasubelement,entryentity.seq,entryentity.attaqty,entryentity.attaamt", filter, selectFields, effectTime, false, true, null);
    }

    public static void copyResourceOut(DynamicObject bill, Date effectTime, Set<Long> ids) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("id", "in", ids);
        String selectFields = "material.id,auxpty.id,resource.id,manuorg.id,srcroute,route.id,pdmrouteid,processseq,operationno,operation.id,operationdesc,workstation.id";
        CostUpdateEstablishedHelper.updateBillData(bill, "cad_resourceout", "costtype,billno,currency,datasrc,material,auxpty,resource,element,subelement,pricerule,calcbasis,resourceunit,qty,amount,creator,createtime,modifier,modifytime,auditor,auditdate,billstatus,entryentity.attaelement,entryentity.attasubelement,entryentity.attaqty,entryentity.attaamt,ressupentry.supplier,ressupentry.quotaratio,ressupentry.unitprice,manuorg,srcroute,route,pdmrouteid,processseq,operationno,operation,operationdesc,workstation", filter, selectFields, effectTime, false, true, null);
    }

    private static void updateBillData(DynamicObject updateBill, String entityName, String copyfields, QFilter filter, String selectFields, Date effectTime, boolean isbaseData, boolean isInitDate, Map<String, Long> matCostInfos) {
        String key;
        Long resource;
        DynamicObjectCollection dynamicObjects;
        QFilter defSrcQfilter = new QFilter("costtype", "=", updateBill.get("srccosttype.id"));
        if (("cad_outsourceprice".equals(entityName) || "cad_resourcerate".equals(entityName) || "cad_resourceout".equals(entityName)) && filter != null && "id".equals(filter.getProperty())) {
            defSrcQfilter = null;
        }
        QFilter[] filters = new QFilter[]{defSrcQfilter, filter};
        List fromIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        QFilter resourceQFilter = null;
        if ("cad_outsourceprice".equals(entityName) || "cad_resourcerate".equals(entityName) || "cad_resourceout".equals(entityName)) {
            Long resource2;
            DynamicObjectCollection dynamicObjects2;
            HashSet<Long> ids;
            QFilter[] fs = filter.recombine();
            QFilter newFilter = null;
            QFilter filterId = null;
            for (QFilter f : fs) {
                if (!"id".equals(f.getProperty())) {
                    if (newFilter == null) {
                        newFilter = f;
                        continue;
                    }
                    newFilter.and(f);
                    continue;
                }
                filterId = f;
            }
            filter = newFilter;
            if ("cad_resourcerate".equals(entityName)) {
                DynamicObjectCollection resourceRates = QueryServiceHelper.query((String)"cad_resourcerate", (String)"workcenter,resource", (QFilter[])new QFilter[]{filterId});
                HashSet<Long> workCenterIds = new HashSet<Long>(10);
                HashMap<Long, Set> resWorkCenterMap = new HashMap<Long, Set>(16);
                for (DynamicObject resourceRate : resourceRates) {
                    resWorkCenterMap.computeIfAbsent(resourceRate.getLong("resource"), p -> new HashSet()).add(resourceRate.getLong("workcenter"));
                    workCenterIds.add(resourceRate.getLong("workcenter"));
                }
                filters = new QFilter[]{new QFilter("costtype", "=", updateBill.get("targetcosttype.id")), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()), filter, new QFilter("resource", "in", resWorkCenterMap.keySet()), new QFilter("workcenter", "in", workCenterIds)};
                ids = new HashSet(10);
                dynamicObjects2 = QueryServiceHelper.query((String)entityName, (String)"id,workcenter,resource", (QFilter[])filters);
                workCenterIds.clear();
                for (DynamicObject dynamicObject : dynamicObjects2) {
                    resource2 = dynamicObject.getLong("resource");
                    Long workcenter = dynamicObject.getLong("workcenter");
                    if (!resWorkCenterMap.containsKey(resource2) || !((Set)resWorkCenterMap.get(resource2)).contains(workcenter)) continue;
                    ids.add(dynamicObject.getLong("id"));
                }
                resWorkCenterMap.clear();
                resourceQFilter = new QFilter("id", "in", ids);
            } else if ("cad_resourceout".equals(entityName)) {
                DynamicObjectCollection resourceOuts = QueryServiceHelper.query((String)"cad_resourceout", (String)"resource,route,processseq,operationno", (QFilter[])new QFilter[]{filterId});
                HashSet<Long> routeIds = new HashSet<Long>(10);
                HashMap<Long, Set> resRouteInfoMap = new HashMap<Long, Set>(16);
                for (DynamicObject resourceOut : resourceOuts) {
                    resRouteInfoMap.computeIfAbsent(resourceOut.getLong("resource"), p -> new HashSet()).add(resourceOut.getString("route") + "@" + resourceOut.getString("processseq") + "@" + resourceOut.getString("operationno"));
                    routeIds.add(resourceOut.getLong("route"));
                }
                filters = new QFilter[]{new QFilter("costtype", "=", updateBill.get("targetcosttype.id")), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()), filter, new QFilter("resource", "in", resRouteInfoMap.keySet()), new QFilter("route", "in", routeIds)};
                ids = new HashSet<Long>(10);
                dynamicObjects2 = QueryServiceHelper.query((String)entityName, (String)"id,resource,route,processseq,operationno", (QFilter[])filters);
                routeIds.clear();
                for (DynamicObject dynamicObject : dynamicObjects2) {
                    resource2 = dynamicObject.getLong("resource");
                    String routeInfo = dynamicObject.getString("route") + "@" + dynamicObject.getString("processseq") + "@" + dynamicObject.getString("operationno");
                    if (!resRouteInfoMap.containsKey(resource2) || !((Set)resRouteInfoMap.get(resource2)).contains(routeInfo)) continue;
                    ids.add(dynamicObject.getLong("id"));
                }
                resRouteInfoMap.clear();
                resourceQFilter = new QFilter("id", "in", ids);
            }
        }
        filters = new QFilter[]{new QFilter("costtype", "=", updateBill.get("targetcosttype.id")), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()), filter, resourceQFilter};
        List toIds = QueryServiceHelper.queryPrimaryKeys((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName), (QFilter[])filters, null, (int)-1);
        HashSet tarExistsData = new HashSet(10);
        Boolean isAllUpdate = updateBill.getBoolean("isallupdate");
        if (Boolean.TRUE.equals(isAllUpdate)) {
            CostUpdateEstablishedHelper.dealNotExistsDataByAll(entityName, updateBill, effectTime);
        }
        Lists.partition((List)toIds, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart(entityName, list, effectTime, selectFields, tarExistsData));
        if ("cad_resourcerate".equals(entityName)) {
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id,billno,workcenter,resource", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fromIds)}, (String)"billno desc");
            fromIds.clear();
            HashSet<String> existResStr = new HashSet<String>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                resource = dynamicObject.getLong("resource");
                Long workcenter = dynamicObject.getLong("workcenter");
                key = resource + "@" + workcenter;
                if (!existResStr.add(key)) continue;
                fromIds.add(dynamicObject.getLong("id"));
            }
        } else if ("cad_resourceout".equals(entityName)) {
            dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id,billno,resource,route,processseq,operationno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fromIds)}, (String)"billno desc");
            fromIds.clear();
            HashSet<String> existResStr = new HashSet<String>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                resource = dynamicObject.getLong("resource");
                String routeInfo = dynamicObject.getString("route") + "@" + dynamicObject.getString("processseq") + "@" + dynamicObject.getString("operationno");
                key = resource + "@" + routeInfo;
                if (!existResStr.add(key)) continue;
                fromIds.add(dynamicObject.getLong("id"));
            }
        }
        ArrayList<Long> newIds = new ArrayList<Long>(fromIds.size());
        Lists.partition((List)fromIds, (int)1000).forEach(list -> {
            List<Long> ids = CostUpdateEstablishedHelper.saveCalcInfo(updateBill, entityName, copyfields, selectFields, list, effectTime, tarExistsData, isbaseData, isInitDate, matCostInfos);
            newIds.addAll(ids);
        });
        if ("cad_calcpurprices".equals(entityName) || "cad_resourceout".equals(entityName) || "cad_resourcerate".equals(entityName) || "cad_outsourceprice".equals(entityName)) {
            return;
        }
        CostUpdateEstablishedHelper.cleanUpDeal(toIds, newIds, entityName, effectTime);
    }

    private static void cleanUpDeal(List<Object> toIds, List<Long> newIds, String entityName, Date effectTime) {
        Row row;
        String algoStr = "cleanUpDeal";
        String peekStr = "";
        String field = "";
        switch (entityName) {
            case "cad_bomsetting": {
                peekStr = "costtype,material,bomtype,bom,chargedefsubelement,chargestdrate,isdowncalc";
                break;
            }
            case "cad_routersetting": {
                peekStr = "costtype,router,considerpreparetime";
                field = "materialentry.material material";
                break;
            }
            case "cad_resourcerate": {
                peekStr = "costtype,workcenter,resource,element,subelement,calcbasis,resourceunit,qty,pricerule,amount";
                field = "entryentity.attaelement attaelement,entryentity.attasubelement attasubelement,entryentity.attaqty attaqty,entryentity.attaamt attaamt";
                break;
            }
            case "cad_outsourceprice": {
                peekStr = "costtype,material,matversion,auxpty,element,subelement,bat,price";
                field = "entryentity.extelement extelement,entryentity.extsubelement extsubelement,entryentity.amount amount";
                break;
            }
        }
        if (CadEmptyUtils.isEmpty((String)field)) {
            return;
        }
        QFilter oldFielter = new QFilter("id", "in", toIds);
        oldFielter.and(new QFilter("expdate", "=", (Object)effectTime));
        DataSet oldDS = QueryServiceHelper.queryDataSet((String)algoStr, (String)entityName, (String)("id oldid," + peekStr), (QFilter[])oldFielter.toArray(), null);
        QFilter newFielter = new QFilter("id", "in", newIds);
        DataSet newDS = QueryServiceHelper.queryDataSet((String)algoStr, (String)entityName, (String)("id newid," + peekStr), (QFilter[])newFielter.toArray(), null);
        String[] fieldArr = peekStr.split(",");
        JoinDataSet joinDataSet = oldDS.join(newDS);
        for (int i = 0; i < fieldArr.length; ++i) {
            joinDataSet = joinDataSet.on(fieldArr[i], fieldArr[i]);
        }
        DataSet joinRes = joinDataSet.select(new String[]{"oldid", "newid"}).finish();
        Iterator ite = joinRes.iterator();
        HashSet<Long> oldSet = new HashSet<Long>(8);
        HashSet<Long> newSet = new HashSet<Long>(8);
        if ("cad_bomsetting".equals(entityName)) {
            while (ite.hasNext()) {
                row = (Row)ite.next();
                oldSet.add(row.getLong("oldid"));
                newSet.add(row.getLong("newid"));
            }
        } else {
            while (ite.hasNext()) {
                row = (Row)ite.next();
                DynamicObjectCollection oldEntryCol = QueryServiceHelper.query((String)entityName, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)row.getLong("oldid"))});
                DynamicObjectCollection newEntryCol = QueryServiceHelper.query((String)entityName, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)row.getLong("newid"))});
                if (oldEntryCol == null && newEntryCol == null) {
                    oldSet.add(row.getLong("oldid"));
                    newSet.add(row.getLong("newid"));
                    continue;
                }
                if (oldEntryCol == null && newEntryCol != null && newEntryCol.isEmpty() || newEntryCol == null && oldEntryCol != null && oldEntryCol.isEmpty()) {
                    oldSet.add(row.getLong("oldid"));
                    newSet.add(row.getLong("newid"));
                    continue;
                }
                if (oldEntryCol != null && newEntryCol != null && oldEntryCol.size() != newEntryCol.size()) continue;
                boolean notSameFlag = false;
                block17 : switch (entityName) {
                    case "cad_routersetting": {
                        DynamicObject newDyn;
                        DynamicObject oldDyn;
                        int i;
                        if (oldEntryCol == null || newEntryCol == null) break;
                        for (i = 0; i < oldEntryCol.size(); ++i) {
                            long newmaterial;
                            oldDyn = (DynamicObject)oldEntryCol.get(i);
                            newDyn = (DynamicObject)newEntryCol.get(i);
                            long oldmaterial = oldDyn.getLong("material");
                            if (oldmaterial == (newmaterial = newDyn.getLong("material"))) continue;
                            notSameFlag = true;
                            break block17;
                        }
                        break;
                    }
                    case "cad_resourcerate": {
                        DynamicObject newDyn;
                        DynamicObject oldDyn;
                        int i;
                        if (oldEntryCol == null || newEntryCol == null) break;
                        for (i = 0; i < oldEntryCol.size(); ++i) {
                            oldDyn = (DynamicObject)oldEntryCol.get(i);
                            newDyn = (DynamicObject)newEntryCol.get(i);
                            long oldattaelement = oldDyn.getLong("attaelement");
                            long newattaelement = newDyn.getLong("attaelement");
                            long oldattasubelement = oldDyn.getLong("attasubelement");
                            long newattasubelement = newDyn.getLong("attasubelement");
                            BigDecimal oldattaqty = oldDyn.getBigDecimal("attaqty");
                            BigDecimal newattaqty = newDyn.getBigDecimal("attaqty");
                            BigDecimal oldattaamt = oldDyn.getBigDecimal("attaamt");
                            BigDecimal newattaamt = newDyn.getBigDecimal("attaamt");
                            if (oldattaelement == newattaelement && oldattasubelement == newattasubelement && oldattaqty.compareTo(newattaqty) == 0 && oldattaamt.compareTo(newattaamt) == 0) continue;
                            notSameFlag = true;
                            break block17;
                        }
                        break;
                    }
                    case "cad_outsourceprice": {
                        DynamicObject newDyn;
                        DynamicObject oldDyn;
                        int i;
                        if (oldEntryCol == null || newEntryCol == null) break;
                        for (i = 0; i < oldEntryCol.size(); ++i) {
                            BigDecimal newAmount;
                            oldDyn = (DynamicObject)oldEntryCol.get(i);
                            newDyn = (DynamicObject)newEntryCol.get(i);
                            long oldExtElement = oldDyn.getLong("extelement");
                            long newExtElement = newDyn.getLong("extelement");
                            long oldExtSubElement = oldDyn.getLong("extsubelement");
                            long newExtSubElement = newDyn.getLong("extsubelement");
                            BigDecimal oldAmount = oldDyn.getBigDecimal("amount") == null ? BigDecimal.ZERO : oldDyn.getBigDecimal("amount");
                            BigDecimal bigDecimal = newAmount = newDyn.getBigDecimal("amount") == null ? BigDecimal.ZERO : newDyn.getBigDecimal("amount");
                            if (oldExtElement == newExtElement && oldExtSubElement == newExtSubElement && oldAmount.compareTo(newAmount) == 0) continue;
                            notSameFlag = true;
                            break block17;
                        }
                        break;
                    }
                }
                if (notSameFlag) continue;
                oldSet.add(row.getLong("oldid"));
                newSet.add(row.getLong("newid"));
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("entityName\uff1a");
        sb.append(entityName);
        if (!oldSet.isEmpty()) {
            DynamicObject[] oldDynArr = BusinessDataServiceHelper.load((Object[])oldSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            for (int i = 0; i < oldDynArr.length; ++i) {
                oldDynArr[i].set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            }
            SaveServiceHelper.update((DynamicObject[])oldDynArr);
            String info = String.format(ResManager.loadKDString((String)" old\u5355\u636eID\uff1a%s", (String)"CostUpdateEstablishedHelper_9", (String)"macc-cad-business", (Object[])new Object[0]), CostUpdateEstablishedHelper.getIdsLog(oldSet));
            sb.append(info);
        }
        if (!newSet.isEmpty()) {
            String info = String.format(ResManager.loadKDString((String)" new\u5355\u636eID\uff1a%s", (String)"CostUpdateEstablishedHelper_10", (String)"macc-cad-business", (Object[])new Object[0]), CostUpdateEstablishedHelper.getIdsLog(newSet));
            sb.append(info);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityName), (Object[])newSet.toArray());
        }
        logger.info(String.format("\u5220\u9664\u6ca1\u6709\u53d8\u5316\u6570\u636e\u64cd\u4f5c\u7ed3\u675f\uff0c%s", sb));
    }

    private static StringBuilder getIdsLog(Set<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(String.valueOf(id));
            sb.append(' ');
        }
        return sb;
    }

    private static List<Long> saveCalcInfo(DynamicObject updateBill, String entityName, String copyfields, String selectFields, List<Object> ids, Date effectTime, Set<String> tarExistsData, boolean isbaseData, boolean isInitDate, Map<String, Long> matCostInfos) {
        ArrayList<Long> resultList = new ArrayList<Long>(10);
        ArrayList<DynamicObject> tarObjlist = new ArrayList<DynamicObject>(10);
        String remark = ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u66f4\u65b0\u5355%1$s\u590d\u5236\u751f\u6210\uff0c\u6e90\u5355\u5355\u636e\u201c%2$s\u201d\u3002", (String)"CostUpdateEstablishedHelper_7", (String)"macc-cad-business", (Object[])new Object[0]);
        QFilter qfIds = new QFilter("id", "in", ids);
        DynamicObject[] fromObjs = BusinessDataServiceHelper.load((String)entityName, (String)copyfields, (QFilter[])new QFilter[]{qfIds});
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName), (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName)), null, (int)fromObjs.length);
        Map existExpdates = null;
        existExpdates = "cad_calcpurprices".equals(entityName) ? NewStdCalculateHelper.getMatCostMaxEffectDate((Long)updateBill.getLong("targetcosttype.id"), CostUpdateEstablishedHelper.getKeyColIds(entityName, fromObjs)) : NewStdCalculateHelper.getExistMaxExpdate((String)entityName, (Long)updateBill.getLong("targetcosttype.id"), CostUpdateEstablishedHelper.getKeyColIds(entityName, fromObjs));
        Map existExpdatesByResource = NewStdCalculateHelper.getExistMaxExpdateByResource((String)entityName, (Long)updateBill.getLong("targetcosttype.id"));
        String srcBillNo = "";
        for (int index = 0; index < fromObjs.length; ++index) {
            DynamicObject fromObjTmp = fromObjs[index];
            DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)("cad_calcpurprices".equals(entityName) ? "cad_purprices" : entityName));
            EntityUtil.copyPropertiesWithOutId((DynamicObject)tarObj, (DynamicObject)fromObjTmp);
            if (isbaseData) {
                Long id = DBServiceHelper.genGlobalLongId();
                tarObj.set("id", (Object)id);
                tarObj.set("masterid", (Object)id);
                tarObj.set("number", (Object)numbers[index]);
                resultList.add(id);
                srcBillNo = fromObjTmp.getString("number");
            } else {
                tarObj.set("billno", (Object)numbers[index]);
                srcBillNo = fromObjTmp.getString("billno");
            }
            tarObj.set("costtype", updateBill.get("targetcosttype"));
            if ("cad_calcpurprices".equals(entityName)) {
                tarObj.set("datasrc", (Object)"costupdate");
                tarObj.set("matcostid", (Object)CostUpdateEstablishedHelper.getMatCostIdByPrice(matCostInfos, tarObj));
            }
            if (isInitDate) {
                String key;
                Boolean isInit = CostUpdateEstablishedHelper.isInitEffectDate(selectFields, tarExistsData, tarObj);
                Date effectDate = null;
                effectDate = Boolean.TRUE.equals(isInit) ? ("cad_resourcerate".equals(entityName) || "cad_resourceout".equals(entityName) ? ((effectDate = (Date)existExpdatesByResource.get(key = CostUpdateEstablishedHelper.getKey(selectFields.split(","), tarObj))) == null ? effectTime : effectDate) : ("cad_calcpurprices".equals(entityName) ? ((effectDate = (Date)existExpdates.get(fromObjTmp.getLong("keycolid.id"))) == null ? TimeUtils.getDefaultEffectDate() : effectDate) : ((effectDate = (Date)existExpdates.get(fromObjTmp.getLong("keycolid.id"))) == null ? effectTime : effectDate))) : ("cad_resourcerate".equals(entityName) || "cad_resourceout".equals(entityName) || "cad_outsourceprice".equals(entityName) ? effectTime : TimeUtils.getDefaultEffectDate());
                tarObj.set("effectdate", (Object)effectDate);
            } else {
                tarObj.set("effectdate", (Object)effectTime);
            }
            tarObj.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            tarObj.set("remark", (Object)String.format(remark, updateBill.get("billno"), srcBillNo));
            tarObj.set("createtime", (Object)new Date());
            tarObj.set("auditdate", (Object)new Date());
            tarObjlist.add(tarObj);
        }
        if (!tarObjlist.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])tarObjlist.toArray(new DynamicObject[0]));
        }
        if (!isbaseData) {
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)numbers)}, null, (int)-1);
            List pkIdList = pkIds.stream().map(r -> Long.valueOf(String.valueOf(r))).collect(Collectors.toList());
            resultList.addAll(pkIdList);
        }
        return resultList;
    }

    private static boolean isInitEffectDate(String selectFields, Set<String> tarExistsData, DynamicObject tarObj) {
        if (CadEmptyUtils.isEmpty(tarExistsData)) {
            return false;
        }
        String[] fields = selectFields.split(",");
        return tarExistsData.contains(CostUpdateEstablishedHelper.getKey(fields, tarObj));
    }

    private static Long getMatCostIdByPrice(Map<String, Long> matCostInfos, DynamicObject tarObj) {
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return 0L;
        }
        Long val = matCostInfos.get(tarObj.getString("costtype.id") + "@" + tarObj.getString("keycol"));
        return val != null ? val : 0L;
    }

    public static void doCheck(UpdateParam updateParam, Set<Long> failKeycolIds) {
        List checkItemList = updateParam.getCheckItemIds().stream().collect(Collectors.toList());
        Long costTypeId = updateParam.getSrcCostTypeId();
        Long taskId = updateParam.getTaskId();
        String taskType = "cad_costupdatenew";
        CalcCheckContext context = new CalcCheckContext();
        context.setCheckResultId(taskId);
        context.setTaskType(taskType);
        context.setGlobalId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        context.setCheckMode(1);
        context.setCostTypeId(costTypeId);
        context.setCheckParamJs(CostUpdateEstablishedHelper.getUpdateJs(updateParam));
        context.setAppNum("sca");
        context.getParams().put("calcDate", TimeServiceHelper.now());
        List checkActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)context, checkItemList, (String)taskType, (String)"sca");
        Integer i = checkActionList.size();
        if (i == 0) {
            return;
        }
        i = 100 / i;
        int j = 1;
        for (AbstractCalcCheckAction action : checkActionList) {
            action.execute();
            CostUpdateEstablishedHelper.logProgress(updateParam.getPageId(), "progress", String.valueOf(i * j));
        }
        TaskServiceHelper.updateProgress((Long)costTypeId, (Long)taskId, (int)100, (int)3);
        if (!updateParam.getIsAllUpdate().booleanValue() && failKeycolIds != null) {
            DynamicObjectCollection keycolObjs = CostUpdateEstablishedHelper.getKeycolObjs(context.getFailProductKeycols(), "id");
            failKeycolIds.addAll(DynamicObjectHelper.getIdSet((DynamicObjectCollection)keycolObjs, (String)"id"));
        }
        String process = "1".equals(updateParam.getOpMode()) ? "100" : "5";
        CostUpdateEstablishedHelper.logProgress(updateParam.getPageId(), "progress", process);
    }

    private static JSONObject getUpdateJs(UpdateParam updateParam) {
        JSONObject param = new JSONObject();
        param.accumulate("updatebillid", updateParam.getUpdateBillIds().get(0));
        param.accumulate("srccosttype", (Object)updateParam.getSrcCostTypeId());
        param.accumulate("tarcosttype", (Object)updateParam.getTarCostTypeId());
        param.accumulate("isallupdate", (Object)updateParam.getIsAllUpdate());
        param.accumulate("keycolids", (Object)updateParam.getKeyColIds());
        param.accumulate("effecttime", (Object)updateParam.getEffectTime());
        param.accumulate("checkitemids", (Object)updateParam.getCheckItemIds());
        param.accumulate("purOuts", (Object)updateParam.getPurOutIds());
        param.accumulate("resourceRates", (Object)updateParam.getResourceRateIds());
        param.accumulate("resourceOuts", (Object)updateParam.getResourceOutIds());
        return param;
    }

    private static void logProgress(String pageId, String cacheKey, String progress) {
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(cacheKey, progress);
    }

    public static int getNoPassCheckItem(UpdateParam updateParam, boolean isCurLevel, boolean isAllFail) {
        QFilter filter = new QFilter("costtype", "=", (Object)updateParam.getSrcCostTypeId());
        filter.and("calctaskrecord", "=", (Object)updateParam.getTaskId());
        filter.and("checkresult", "=", (Object)String.valueOf(2));
        if (isCurLevel && !isAllFail) {
            filter.and("checkitem", "!=", (Object)1513865504593529856L);
        }
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cad_calccheckresult", (String)"checkitem", (QFilter[])new QFilter[]{filter});
        return checkItems.size();
    }

    public static Set<Long> getCheckItemIds() {
        QFilter[] filters = new QFilter[]{new QFilter("caltype", "=", (Object)"cad_costupdatenew"), new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection checkTasks = QueryServiceHelper.query((String)"cad_checktask", (String)"entryentity.checkitem AS checkitem", (QFilter[])filters);
        HashSet<Long> ids = new HashSet<Long>(checkTasks.size());
        checkTasks.forEach(p -> ids.add(p.getLong("checkitem")));
        return ids;
    }

    public static Set<Long> initEstablishedBill(DynamicObject updateBill, DynamicObject establishedBill) {
        long time = System.currentTimeMillis();
        Map relatedKeyColMap = CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
        logger.info("\u521d\u59cb\u5316\u786e\u8ba4\u5355\u83b7\u53d6keycolid(ms)\uff1a" + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        String number = CodeRuleServiceHelper.getNumber((String)"cad_costupdateestablished", (DynamicObject)establishedBill, null);
        if (CadEmptyUtils.isEmpty((String)number)) {
            number = "no-code_rule-settings";
        }
        logger.info("\u521d\u59cb\u5316\u786e\u8ba4\u5355\u5355\u636e\u7f16\u53f7(ms)\uff1a" + (System.currentTimeMillis() - time));
        establishedBill.set("billno", (Object)number);
        establishedBill.set("srccosttype", updateBill.get("srccosttype"));
        establishedBill.set("targetcosttype", updateBill.get("targetcosttype"));
        establishedBill.set("attachtargetcosttype", updateBill.get("attachtargetcosttype"));
        DynamicObject srcCostType = CostTypeHelper.getCostType((Long)updateBill.getLong("srccosttype.id"), null);
        establishedBill.set("currency", (Object)BusinessDataServiceHelper.loadSingle((Object)srcCostType.getLong("currency.id"), (String)"bd_currency"));
        establishedBill.set("effectperiod", updateBill.get("period"));
        MaterialCostProcessor matCostProcessor = new MaterialCostProcessor();
        time = System.currentTimeMillis();
        Set<Long> keyColIds = matCostProcessor.genCostInfo(updateBill, establishedBill, relatedKeyColMap);
        logger.info("\u521d\u59cb\u5316\u786e\u8ba4\u5355\u7269\u6599\u6210\u672c\u4fe1\u606f\u9875\u7b7e(ms)\uff1a{}", (Object)(System.currentTimeMillis() - time));
        if (updateBill.getLong("targetcosttype.type") == 0L) {
            StorCostProcessor storCostProcessor = new StorCostProcessor();
            storCostProcessor.genStorageCostInfo(updateBill, establishedBill);
            ProdCostProcessor prodCostProcessor = new ProdCostProcessor();
            prodCostProcessor.genProCostInfo(updateBill, establishedBill);
        }
        return keyColIds;
    }

    public static void doWipCalc(Long updateBillId, Boolean isFirst) {
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)updateBillId, (String)"cad_costupdatenew");
        DynamicObject establishedBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdateestablished");
        CostUpdateEstablishedHelper.initEstablishedBill(updateBill, establishedBill);
        DynamicObjectCollection productEntrys = establishedBill.getDynamicObjectCollection("productentry");
        CostUpdateWipCalServiceHelper costUpdateWipCalServiceHelper = new CostUpdateWipCalServiceHelper(updateBill, productEntrys, isFirst);
        costUpdateWipCalServiceHelper.doCalc();
    }

    private static Set<Long> getKeyColIds(String entityName, DynamicObject[] fromObjs) {
        HashSet<Long> keyColIds = new HashSet<Long>(fromObjs.length);
        if ("cad_routersetting".equals(entityName) || "cad_resourcerate".equals(entityName) || "cad_resourceout".equals(entityName)) {
            return keyColIds;
        }
        for (DynamicObject fromObj : fromObjs) {
            keyColIds.add(fromObj.getLong("keycolid.id"));
        }
        return keyColIds;
    }

    public static String checkDimension(Long costTypeId, Set<Long> keyColIds) {
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"material,matvers mversion,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])filters);
        HashMap<Long, String> matKeyCols = new HashMap<Long, String>(dyKeyCols.size());
        StringBuilder sg = new StringBuilder();
        for (DynamicObject dyKeyCol : dyKeyCols) {
            sg.setLength(0);
            String[] stringArray = keyCols;
            int n = stringArray.length;
            block15: for (int i = 0; i < n; ++i) {
                String keyCol;
                switch (keyCol = stringArray[i]) {
                    case "mversion": 
                    case "assist": 
                    case "project": 
                    case "tracknumber": 
                    case "configuredcode": {
                        if (CadEmptyUtils.isEmpty((Long)dyKeyCol.getLong(keyCol))) continue block15;
                        sg.append(",");
                        sg.append(keyCol);
                        continue block15;
                    }
                    case "lot": {
                        if (CadEmptyUtils.isEmpty((String)dyKeyCol.getString(keyCol))) continue block15;
                        sg.append(",");
                        sg.append(keyCol);
                        continue block15;
                    }
                }
            }
            if (sg.length() <= 0) continue;
            matKeyCols.put(dyKeyCol.getLong("material"), sg.substring(1));
        }
        logger.info(String.format("\u6838\u7b97\u7ef4\u5ea6\u6821\u9a8c\u6210\u672c\u7c7b\u578b\uff1a%s\uff0c\u53c2\u6570\uff1a%s", costTypeId, matKeyCols));
        if (CadEmptyUtils.isEmpty(matKeyCols)) {
            return null;
        }
        Object[] params = new Object[]{costTypeId, matKeyCols};
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"checkCaldimensioncols", (Object[])params);
            Set matIds = (Set)result;
            if (CadEmptyUtils.isEmpty((Set)matIds)) {
                return null;
            }
            filters = new QFilter[]{new QFilter("id", "in", (Object)matIds)};
            DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"number,name", (QFilter[])filters);
            sg.setLength(0);
            for (DynamicObject material : materials) {
                sg.append("\u3001[");
                sg.append(material.getString("number"));
                sg.append("/");
                sg.append(material.getString("name"));
                sg.append("]");
            }
            if (sg.length() > 0) {
                return String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u7684\u7ef4\u5ea6\u5728\u6838\u7b97\u7ef4\u5ea6\u4e2d\u4e0d\u5305\u542b\uff0c\u8bf7\u68c0\u67e5\uff0c\u66f4\u65b0\u4e2d\u6b62\u3002", (String)"CostUpdateEstablishedHelper_4", (String)"macc-cad-business", (Object[])new Object[0]), sg.substring(1));
            }
        }
        catch (Exception ex) {
            logger.info(String.format("\u8c03\u7528\u6838\u7b97\u7ef4\u5ea6\u68c0\u67e5\u5931\u8d25\u3002%s", ex.getMessage()));
            return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6838\u7b97\u7ef4\u5ea6\u68c0\u67e5\u63a5\u53e3\u5931\u8d25\uff0c\u66f4\u65b0\u4e2d\u6b62\uff0c%s\u3002", (String)"CostUpdateEstablishedHelper_8", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage());
        }
        return null;
    }

    public static void updateId(Long updateBillId, Long establishedBillId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        Object[] updateBills = BusinessDataServiceHelper.load((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((Object[])updateBills)) {
            return;
        }
        Object updateBill = updateBills[0];
        if (establishedBillId == 0L) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_costupdateestablished"), (Object[])new Long[]{updateBill.getLong("updatebillid")});
        }
        updateBill.set("updatebillid", (Object)establishedBillId);
        SaveServiceHelper.update((DynamicObject)updateBill);
    }

    public static Tuple<Boolean, Boolean> getUpdateWay(Long updateBillId) {
        Boolean isTrackUpdate = Boolean.FALSE;
        Boolean isConfigured = Boolean.FALSE;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"cad_costupdatenew", (String)"id,billno,srccosttype,sourcepage,entryentity.tracknumber,entryentity.configuredcode,isquickupdate", (QFilter[])filters);
        String sourcePage = bill.getString("sourcepage");
        boolean isquickupdate = bill.getBoolean("isquickupdate");
        if (!"batmodifyprice".equals(sourcePage) && !isquickupdate) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (!CadEmptyUtils.isEmpty((Long)entry.getLong("tracknumber.id")) || !CadEmptyUtils.isEmpty((Long)entry.getLong("configuredcode.id"))) {
                    isTrackUpdate = Boolean.TRUE;
                }
                if (CadEmptyUtils.isEmpty((Long)entry.getLong("configuredcode.id"))) continue;
                isConfigured = Boolean.TRUE;
            }
            if (Boolean.TRUE.equals(isTrackUpdate)) {
                isConfigured = Boolean.FALSE;
            }
        }
        logger.info(String.format("\u66f4\u65b0\u7533\u8bf7\u5355%s\uff0csourcePage = %s,isquickupdate=%s,\u8ddf\u8e2a\u53f7\u66f4\u65b0=%s\uff0c\u914d\u7f6e\u53f7\u66f4\u65b0=%s", bill.getString("billno"), sourcePage, isquickupdate, isTrackUpdate, isConfigured));
        return new Tuple((Object)isTrackUpdate, (Object)isConfigured);
    }

    public static Map<String, Set<Long>> getPriceIds(Long costTypeId, Tuple<Boolean, Boolean> updateWay, Long calcRecordId, Map<Long, String> relatedKeyColMap) {
        HashMap<String, Set<Long>> results = new HashMap<String, Set<Long>>(16);
        HashSet<Long> resourceRates = new HashSet<Long>(16);
        HashSet<Long> resourceOuts = new HashSet<Long>(16);
        HashSet<Long> purOuts = new HashSet<Long>(16);
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("calcrecord", "=", (Object)(CadEmptyUtils.isEmpty((Long)calcRecordId) ? Long.valueOf("0") : calcRecordId));
        if (relatedKeyColMap.size() != 0) {
            filter.and("keycolid", "in", relatedKeyColMap.keySet());
        }
        filter.and("ismaindata", "=", (Object)1);
        filter.and("isleaf", "=", (Object)"0");
        if (Boolean.FALSE.equals(updateWay.item1)) {
            Set<Long> notDownKeyColIds;
            if (Boolean.FALSE.equals(updateWay.item2) && !CadEmptyUtils.isEmpty(notDownKeyColIds = CostUpdateEstablishedHelper.getOutKeyColIds(costTypeId, null))) {
                filter.and("keycolid", "not in", notDownKeyColIds);
            }
            filter.and("entryentity.datatype", "in", Arrays.asList("2", "3"));
            logger.info(String.format("\u6839\u636e\u6a21\u62df\u8868\u53d6\u4ef7\u76ee\u8868\u7684\u6761\u4ef6\uff1a%s", filter));
            DynamicObjectCollection calcSimulations = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"entryentity.resourcetype resourcetype,entryentity.priceid priceid", (QFilter[])new QFilter[]{filter});
            for (DynamicObject calcSimulation : calcSimulations) {
                Long priceId = calcSimulation.getLong("priceid");
                if (CadEmptyUtils.isEmpty((Long)priceId)) continue;
                String resourceType = calcSimulation.getString("resourcetype");
                if ("1".equals(resourceType)) {
                    resourceRates.add(priceId);
                } else if ("2".equals(resourceType)) {
                    resourceOuts.add(priceId);
                }
                purOuts.add(priceId);
            }
        }
        logger.info(String.format("\u6839\u636e\u6a21\u62df\u8868\u53d6\u4ef7\u76ee\u8868\u81ea\u5236\u8d44\u6e90\uff1a%s", resourceRates));
        results.put("resourceRates", resourceRates);
        logger.info(String.format("\u6839\u636e\u6a21\u62df\u8868\u53d6\u4ef7\u76ee\u8868\u5916\u534f\u8d44\u6e90\uff1a%s", resourceOuts));
        results.put("resourceOuts", resourceOuts);
        logger.info(String.format("\u6839\u636e\u6a21\u62df\u8868\u53d6\u4ef7\u76ee\u8868\u5916\u8d2d\u3001\u59d4\u5916\uff1a%s\uff0c\u6570\u636e\u5927\u5c0f=%s", purOuts, purOuts.size()));
        results.put("purOuts", purOuts);
        return results;
    }

    public static void doCalcByPurPrices(String entityName, List<Long> ids) {
        if (CadEmptyUtils.isEmpty(ids)) {
            logger.info("\u65e0\u76f8\u5e94\u7684\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u7684ID\u9700\u8981\u5feb\u901f\u66f4\u65b0" + entityName);
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject purPrices = QueryServiceHelper.queryOne((String)entityName, (String)"costtype", (QFilter[])filters);
        if (purPrices == null) {
            return;
        }
        Long costTypeId = purPrices.getLong("costtype");
        try {
            StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
            standCostCalculateService.calculateForPurMaterial(costTypeId, ids, TimeServiceHelper.now(), entityName);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logger.info("\u8c03\u7528\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5377\u7b97\u63a5\u53e3\u5931\u8d25" + entityName);
        }
    }

    public static Set<Long> getOutKeyColIds(Long costTypeId, Set<Long> keyColIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection bomRuleSettings = QueryServiceHelper.query((String)"cad_bomrulesetting", (String)"srcbom", (QFilter[])filters, (String)"default desc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bomRuleSettings)) {
            return CostUpdateEstablishedHelper.getOutKeyColIdsByCostBom(costTypeId, keyColIds);
        }
        DynamicObject bomRuleSetting = (DynamicObject)bomRuleSettings.get(0);
        String srcBom = bomRuleSetting.getString("srcbom");
        if ("cad_costbom".equals(srcBom)) {
            return CostUpdateEstablishedHelper.getOutKeyColIdsByCostBom(costTypeId, keyColIds);
        }
        if ("pdm_mftbom".equals(srcBom)) {
            return CostUpdateEstablishedHelper.getOutKeyColIdsByMftBom(costTypeId, keyColIds);
        }
        return result;
    }

    private static Set<Long> getOutKeyColIdsByCostBom(Long costTypeId, Set<Long> keyColIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("isdowncalc", "=", (Object)Boolean.FALSE));
        if (!CadEmptyUtils.isEmpty(keyColIds)) {
            filters.add(new QFilter("keycolid", "in", keyColIds));
        }
        HashSet<Long> notDownKeyColIds = new HashSet<Long>(1);
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"keycolid", (QFilter[])filters.toArray(new QFilter[0]));
        bomSettings.forEach(p -> notDownKeyColIds.add(p.getLong("keycolid")));
        return notDownKeyColIds;
    }

    private static Set<Long> getOutKeyColIdsByMftBom(Long costTypeId, Set<Long> keyColIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return result;
        }
        Set productOrgs = StdCalculateHelper.getProductOrgsByImitateCostType((Long)costTypeId, (Date)TimeServiceHelper.now());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection keyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"id,material", (QFilter[])filters);
        HashMap<Long, ArrayList<Long>> keyColMats = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject keyCol : keyCols) {
            Long matId = keyCol.getLong("material");
            ArrayList<Long> colIds = (ArrayList<Long>)keyColMats.get(matId);
            if (CadEmptyUtils.isEmpty((List)colIds)) {
                colIds = new ArrayList<Long>(1);
            }
            colIds.add(keyCol.getLong("id"));
            keyColMats.put(matId, colIds);
        }
        if (CadEmptyUtils.isEmpty(keyColMats)) {
            return result;
        }
        Set allMatIds = keyColMats.keySet();
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList(productOrgs), (String)"bd_materialmftinfo");
        QFilter matInfoFilter = new QFilter("masterid", "in", allMatIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        ArrayList<Long> matIds = new ArrayList<Long>(16);
        DynamicObjectCollection matInfos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"masterid,materialattr", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter});
        for (DynamicObject matInfo : matInfos) {
            Long matId = matInfo.getLong("masterid");
            matIds.add(matId);
            String matAttr = matInfo.getString("materialattr");
            if (!"10040".equals(matAttr) || !allMatIds.contains(matId)) continue;
            result.addAll((Collection)keyColMats.get(matId));
        }
        for (Map.Entry entry : keyColMats.entrySet()) {
            Long allMatId = (Long)entry.getKey();
            List value = (List)entry.getValue();
            if (matIds.contains(allMatId)) continue;
            result.addAll(value);
        }
        return result;
    }

    public static boolean isTrackUpdate(Set<Long> keyColIds) {
        boolean isTrack = false;
        if (!CadEmptyUtils.isEmpty(keyColIds)) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds), new QFilter("tracknumber", ">", (Object)0L).or("configuredcode", ">", (Object)0L)};
            isTrack = QueryServiceHelper.exists((String)"cad_keycol", (QFilter[])filters);
        }
        return isTrack;
    }

    private static void savePartDatas(DBRoute route, String insertSql, List<Object[]> params) {
        if (params.size() > 5000) {
            long startTimeTmp = System.currentTimeMillis();
            DB.executeBatch((DBRoute)route, (String)insertSql, params);
            logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5934t_cad_calceffectiveresult\u6570\u636e\u5904\u7406\u5206\u6279\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTimeTmp));
            params.clear();
        }
    }

    private static void savePartEntryDatas(DBRoute route, String insertSql, List<Object[]> params, Long tarCostTypeId) {
        if (params.size() > 5000) {
            long startTimeTmp = System.currentTimeMillis();
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cad_calceffectiveresult", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)tarCostTypeId)});){
                DB.executeBatch((DBRoute)route, (String)insertSql, params);
            }
            logger.info("\u751f\u6548\u7ed3\u679c\u8868\u5934t_cad_calceffectrsentry\u6570\u636e\u5904\u7406\u5206\u6279\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTimeTmp));
            params.clear();
        }
    }

    private static void saveTrackPartDatas(DBRoute route, String sql, List<Object[]> params) {
        if (params.size() > 5000) {
            long startTimeTmp = System.currentTimeMillis();
            DB.executeBatch((DBRoute)route, (String)sql, params);
            logger.info("\u8ddf\u8e2a\u53f7\u5377\u7b97\u7ed3\u679c\u8868t_cad_trackcalcresut\u6570\u636e\u5904\u7406\u5206\u6279\uff0c\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTimeTmp));
            params.clear();
        }
    }

    public static DynamicObjectCollection getKeycolObjs(Set<String> keycols, String fields) {
        QFilter filter = new QFilter("keycol", "in", keycols);
        DynamicObjectCollection keyCols = QueryServiceHelper.query((String)"cad_keycol", (String)fields, (QFilter[])new QFilter[]{filter});
        return keyCols;
    }
}

