/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.algox.utils.DataSetUtils;
import kd.macc.cad.business.calc.AutoStandCostCalcHandler;
import kd.macc.cad.business.calc.CalcChangedInfo;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.MaterialCostProcessor;
import kd.macc.cad.business.update.ProdCostProcessor;
import kd.macc.cad.business.update.StorCostProcessor;
import kd.macc.cad.business.update.UpdateLog;
import kd.macc.cad.business.update.UpdateLogInfo;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.EntityUtil;
import kd.sdk.macc.cad.extpoint.IDealMatCostInfoAfterUpdate;

public class CostUpdateTask
implements Runnable {
    private Log logger = LogFactory.getLog(CostUpdateTask.class);
    private UpdateParam updateParam;

    public CostUpdateTask(UpdateParam updateParam) {
        this.updateParam = updateParam;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.updateParam.getRc());
        this.doTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() {
        String errTip;
        Set<Object> keyColIds;
        TXHandle txHandle;
        Long startTime;
        DynamicObject establishedBill;
        String exceptionTip;
        ArrayList<UpdateLogInfo> logs;
        List<DynamicObject> checkResults;
        UpdateLog updateLog;
        HashSet<Long> targetCostTypeIds;
        HashSet<Long> lockCostTypeIds;
        boolean isCurLevel;
        DynamicObject updateBill;
        Long updateBillId;
        boolean isAllFail;
        HashSet<Long> failKeycolIds;
        block46: {
            this.logProgress(this.updateParam.getPageId(), "progress", "2");
            failKeycolIds = new HashSet<Long>(10);
            isAllFail = false;
            updateBillId = (Long)this.updateParam.getUpdateBillIds().get(0);
            updateBill = BusinessDataServiceHelper.loadSingle((Object)updateBillId, (String)"cad_costupdatenew");
            this.logger.info(String.format("\u6267\u884c\u6210\u672c\u66f4\u65b0pageId\uff1a%s\uff0c\u66f4\u65b0\u7533\u8bf7\u5355\u7f16\u53f7\uff1a%s", this.updateParam.getPageId(), updateBill.getString("billno")));
            isCurLevel = updateBill.getBoolean("iscalccurlevel");
            if (Boolean.FALSE.equals(this.updateParam.getIsTrackUpdate())) {
                boolean isAutoEndPeriodCal;
                if (Boolean.FALSE.equals(isCurLevel)) {
                    long startTime2 = System.currentTimeMillis();
                    this.logger.info("\u66f4\u65b0\u65f6\u57fa\u7840\u8d44\u6599\u53d8\u52a8\u8c03\u7528\u5377\u7b97\u8017\u65f6(ms)\uff1a" + (System.currentTimeMillis() - startTime2));
                    this.logProgress(this.updateParam.getPageId(), "progress", "5");
                }
                if (isAutoEndPeriodCal = CostUpdateHelper.isAutoEndPeriodCalPage()) {
                    CostUpdateEstablishedHelper.doWipCalc(updateBillId, Boolean.TRUE);
                }
            }
            if (Boolean.TRUE.equals(this.updateParam.getQuickUpdateFlag()) && Boolean.TRUE.equals(this.updateParam.getIsPurMat())) {
                CostUpdateEstablishedHelper.doCalcByPurPrices("cad_purprices", this.updateParam.getSourceBillIds());
            }
            this.logProgress(this.updateParam.getPageId(), "progress", "10");
            lockCostTypeIds = new HashSet<Long>(16);
            targetCostTypeIds = new HashSet<Long>(1);
            updateLog = this.initUpdateLog(updateBill);
            this.logProgress(this.updateParam.getPageId(), "taskid", String.valueOf(updateLog.getTaskId()));
            checkResults = null;
            logs = new ArrayList<UpdateLogInfo>(16);
            exceptionTip = ResManager.loadKDString((String)"\u8c03\u7528\u6838\u7b97 %1$s \u5fae\u670d\u52a1\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a%2$s\u3002", (String)"CostUpdateTask_0", (String)"macc-cad-business", (Object[])new Object[0]);
            establishedBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdateestablished");
            this.logger.info("\u521d\u59cb\u5316\u6210\u672c\u786e\u8ba4\u5355");
            startTime = System.currentTimeMillis();
            txHandle = TX.required();
            keyColIds = new HashSet(16);
            keyColIds = CostUpdateEstablishedHelper.initEstablishedBill(updateBill, establishedBill);
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u4fe1\u606f", (String)"CostUpdateTask_1", (String)"macc-cad-business", (Object[])new Object[0]), null, String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5f85\u66f4\u65b0\u6570\u91cf\uff1a%s\u4e2a\u3002", (String)"CostUpdateTask_2", (String)"macc-cad-business", (Object[])new Object[0]), keyColIds.size()), 3);
            startTime = System.currentTimeMillis();
            targetCostTypeIds.add(establishedBill.getLong("targetcosttype.id"));
            DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
            for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
                targetCostTypeIds.add(attachTargetCostType.getDynamicObject("fbasedataid").getLong("id"));
            }
            if (Boolean.FALSE.equals(isCurLevel)) {
                lockCostTypeIds.add(establishedBill.getLong("srccosttype.id"));
            }
            lockCostTypeIds.addAll(targetCostTypeIds);
            if (!CadEmptyUtils.isEmpty(keyColIds)) break block46;
            this.logProgress(this.updateParam.getPageId(), "tip_fail", ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u7269\u6599\u3002", (String)"CostUpdateTask_3", (String)"macc-cad-business", (Object[])new Object[0]));
            this.logProgress(this.updateParam.getPageId(), "startprogress", "false");
            this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
            targetCostTypeIds.clear();
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u3002", (String)"CostUpdateTask_33", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u7269\u6599\u3002", (String)"CostUpdateTask_5", (String)"macc-cad-business", (Object[])new Object[0]), 2);
            updateLog.setIsSuc(Boolean.FALSE);
            startTime = System.currentTimeMillis();
            this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
            txHandle.close();
            Tuple<Boolean, String> result = new StorCostProcessor().startSyncBizBill(establishedBill, failKeycolIds);
            if (Boolean.FALSE.equals(result.item1)) {
                String errTip2 = String.format(exceptionTip, "startSyncBizBill", result.item2);
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip2, 2);
                this.logger.error(errTip2);
            } else {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u6210\u529f", (String)"CostUpdateTask_22", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            }
            if (checkResults != null && !checkResults.isEmpty() && Boolean.FALSE.equals(updateLog.getIsSuc())) {
                SaveServiceHelper.save((DynamicObject[])checkResults.toArray(new DynamicObject[0]));
            }
            this.writeUpdateLog(updateLog, logs);
            if (Boolean.FALSE.equals(updateLog.getIsSuc())) {
                CostUpdateEstablishedHelper.updateId(updateBillId, 0L);
            }
            StdCalculateHelper.updateRecordInfo((DynamicObject)updateBill, failKeycolIds, (Long)updateLog.getTaskId(), (Long)this.updateParam.getTaskId(), (Boolean)isAllFail, (Boolean)updateLog.getIsSuc());
            this.updateSalCalcLogStatu(updateBillId, updateLog);
            return;
        }
        try {
            Boolean isUpdateByPeriod;
            Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
            String dimensionMsg = CostUpdateEstablishedHelper.checkDimension(targetCostTypeId, keyColIds);
            if (StringUtils.isNotEmpty((CharSequence)dimensionMsg)) {
                this.logProgress(this.updateParam.getPageId(), "tip_fail", dimensionMsg);
                this.logProgress(this.updateParam.getPageId(), "startprogress", "false");
                this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
                targetCostTypeIds.clear();
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u3002", (String)"CostUpdateTask_33", (String)"macc-cad-business", (Object[])new Object[0]), null, dimensionMsg, 2);
                updateLog.setIsSuc(Boolean.FALSE);
                startTime = System.currentTimeMillis();
                throw new KDBizException(dimensionMsg);
            }
            Set<Long> costTypeIds = this.getHasCostType(updateBill);
            StorCostProcessor storCostProcessor = new StorCostProcessor();
            Date effectTime = DateUtils.getTimeServiceNow();
            this.logger.info("\u8c03\u7528\u5173\u95ed\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf\u63a5\u53e3");
            ThreeTuple<Boolean, Date, String> stopInfo = null;
            if (costTypeIds.contains(targetCostTypeId)) {
                stopInfo = storCostProcessor.stopSyncBizBill(updateBill, establishedBill, effectTime);
                if (Boolean.FALSE.equals(stopInfo.item1)) {
                    String errTip3 = String.format(exceptionTip, "stopSyncBizBill", stopInfo.item3);
                    updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5173\u95ed\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_6", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip3, 2);
                    startTime = System.currentTimeMillis();
                    throw new KDBizException(errTip3);
                }
            }
            if (Boolean.TRUE.equals(isUpdateByPeriod = Boolean.valueOf(establishedBill.getDynamicObject("effectperiod") != null && CostUpdateHelper.isUpdateByPeriod((Long)targetCostTypeId)))) {
                Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)establishedBill.getLong("effectperiod.id"));
                if (dates == null || dates.length != 2) {
                    updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u6309\u671f\u66f4\u65b0\u751f\u6548\u671f\u95f4", (String)"CostUpdateTask_7", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostUpdateTask_8", (String)"macc-cad-business", (Object[])new Object[0]), 2);
                    startTime = System.currentTimeMillis();
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u8be5\u4f1a\u8ba1\u671f\u95f4\u662f\u5426\u5b58\u5728\u3002", (String)"CostUpdateTask_8", (String)"macc-cad-business", (Object[])new Object[0]));
                }
                effectTime = dates[0];
                establishedBill.set("effecttime", (Object)effectTime);
            } else {
                effectTime = stopInfo != null ? (Date)stopInfo.item2 : effectTime;
                establishedBill.set("effecttime", null);
            }
            this.logProgress(this.updateParam.getPageId(), "progress", "13");
            this.initUpdateParam(updateBill, this.updateParam, keyColIds, effectTime.getTime());
            CostUpdateEstablishedHelper.doCheck(this.updateParam, failKeycolIds);
            if (!isCurLevel) {
                failKeycolIds.clear();
            }
            isAllFail = failKeycolIds.size() == keyColIds.size();
            int failCount = CostUpdateEstablishedHelper.getNoPassCheckItem(this.updateParam, isCurLevel, isAllFail);
            int actFailCount = failCount + failKeycolIds.size() > 0 ? 1 : 0;
            StdCalculateHelper.updateRecord((DynamicObject)updateBill, (Long)updateLog.getTaskId(), (Long)this.updateParam.getTaskId(), (Long)1L, (Long)Long.valueOf(actFailCount), (int[])new int[]{actFailCount, 0});
            if (failCount > 0) {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CostUpdateTask_10", (String)"macc-cad-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CostUpdateTask_34", (String)"macc-cad-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 2);
                this.logProgress(this.updateParam.getPageId(), "tip_fail", ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u66f4\u65b0\u62a5\u544a-\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"CostUpdateTask_35", (String)"macc-cad-business", (Object[])new Object[0]));
                this.logProgress(this.updateParam.getPageId(), "startprogress", "false");
                this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
                targetCostTypeIds.clear();
                updateLog.setIsSuc(Boolean.FALSE);
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u8bf7\u67e5\u770b\u66f4\u65b0\u62a5\u544a-\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"CostUpdateTask_36", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            if (!CadEmptyUtils.isEmpty(failKeycolIds)) {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CostUpdateTask_10", (String)"macc-cad-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CostUpdateTask_34", (String)"macc-cad-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 2);
            } else {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CostUpdateTask_10", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            }
            keyColIds.removeAll(failKeycolIds);
            this.removeEstablishedBillInfo(establishedBill, failKeycolIds);
            DynamicObject updateBillNew = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdatenew");
            EntityUtil.copyPropertiesWithOutId((DynamicObject)updateBillNew, (DynamicObject)updateBill);
            updateBillNew.set("id", (Object)updateBill.getLong("id"));
            this.removeUpdateBillInfo(updateBillNew, failKeycolIds);
            HashMap<String, Long> matCostInfos = new HashMap<String, Long>(10);
            this.logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f");
            if (!MaterialCostProcessor.updateMatCostInfo(this.updateParam, effectTime, updateBill, keyColIds, matCostInfos)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\u5931\u8d25\u3002", (String)"CostUpdateTask_11", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u7269\u6599\u6210\u672c\u4fe1\u606f", (String)"CostUpdateTask_12", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "15");
            if (!MaterialCostProcessor.updateAttachCostType(updateBill, establishedBill, effectTime, matCostInfos)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9644\u52a0\u6210\u672c\u7c7b\u578b\u66f4\u65b0\u5931\u8d25\u3002", (String)"CostUpdateTask_37", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u9644\u52a0\u6210\u672c\u7c7b\u578b", (String)"CostUpdateTask_38", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "20");
            this.logger.info("\u590d\u5236\u6e90\u6210\u672c\u7c7b\u578b\u6570\u636e\u5230\u76ee\u6807\u6210\u672c\u7c7b\u578b");
            if (!this.copyCalcRelateData(this.updateParam, keyColIds, effectTime, updateBillNew, matCostInfos)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u76ee\u6807\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\u5931\u8d25\u3002", (String)"CostUpdateTask_14", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u76f8\u5173\u8bbe\u7f6e\u53ca\u4ef7\u76ee\u8868", (String)"CostUpdateTask_15", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "45");
            this.logger.info("\u68c0\u67e5\u7269\u6599\u6210\u672c\u4fe1\u606f\u3001\u751f\u6548\u7ed3\u679c\u8868\u3001\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u6570\u636e\u4e00\u81f4\u6027");
            String checkMsg = this.checkMatCostData(matCostInfos);
            if (!CadEmptyUtils.isEmpty((String)checkMsg)) {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u68c0\u67e5\u7269\u6599\u6210\u672c\u4fe1\u606f\u3001\u751f\u6548\u7ed3\u679c\u8868\u3001\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u6570\u636e\u4e00\u81f4\u6027", (String)"CostUpdateTask_39", (String)"macc-cad-business", (Object[])new Object[0]), null, checkMsg, 2);
                throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u6210\u672c\u4fe1\u606f\u3001\u751f\u6548\u7ed3\u679c\u8868\u3001\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u6570\u636e\u4e00\u81f4\u6027\u4e0d\u6ee1\u8db3\u8981\u6c42\u3002", (String)"CostUpdateTask_40", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u68c0\u67e5\u7269\u6599\u6210\u672c\u4fe1\u606f\u3001\u751f\u6548\u7ed3\u679c\u8868\u3001\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u6570\u636e\u4e00\u81f4\u6027", (String)"CostUpdateTask_39", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "46");
            this.logger.info("\u68c0\u67e5\u7269\u6599\u6807\u51c6\u6210\u672c\u4e3a\u6b63\u6570");
            checkMsg = this.checkMatCostLessZeroData(matCostInfos);
            if (!CadEmptyUtils.isEmpty((String)checkMsg)) {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u68c0\u67e5\u7269\u6599\u6807\u51c6\u6210\u672c\u4e3a\u6b63\u6570", (String)"CostUpdateTask_52", (String)"macc-cad-business", (Object[])new Object[0]), null, checkMsg, 2);
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u7269\u6599\u6807\u51c6\u6210\u672c\u5c0f\u4e8e0\u7684\u6570\u636e\u3002", (String)"CostUpdateTask_53", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u68c0\u67e5\u7269\u6599\u6807\u51c6\u6210\u672c\u4e3a\u6b63\u6570", (String)"CostUpdateTask_52", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "50");
            String updateStorCost = CadBgParamUtils.getCadBgParamForString((String)"updateStorCost", (String)"1");
            if ("1".equals(updateStorCost)) {
                this.logger.info("\u8c03\u7528\u6838\u7b97\u6210\u672c\u66f4\u65b0");
                Tuple<Boolean, String> result = storCostProcessor.updateStorCostByMul(updateBill, establishedBill);
                if (Boolean.FALSE.equals(result.item1)) {
                    String errTip4 = String.format(exceptionTip, "updateCost", result.item2);
                    updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c", (String)"CostUpdateTask_19", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip4, 2);
                    startTime = System.currentTimeMillis();
                    throw new KDBizException(errTip4);
                }
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u66f4\u65b0", (String)"CostUpdateTask_20", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            }
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "60");
            this.logger.info("\u4fdd\u5b58\u786e\u8ba4\u5355");
            Long establishedId = this.saveBillData(effectTime, updateBill.getLong("id"), establishedBill);
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u66f4\u65b0\u786e\u8ba4\u5355", (String)"CostUpdateTask_23", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"CostUpdateTask_24", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "85");
            this.logger.info("\u53cd\u5199\u6210\u672c\u7533\u8bf7\u5355\u6570\u636e");
            this.writeBackCostUpdatBill(establishedId, effectTime, updateBill);
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u53cd\u5199\u66f4\u65b0\u7533\u8bf7\u5355", (String)"CostUpdateTask_26", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u66f4\u65b0\u72b6\u6001\u5df2\u5b8c\u6210\u3002", (String)"CostUpdateTask_27", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "95");
            this.delBatModifyPriceData(updateBill);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "96");
            this.logger.info("\u6267\u884c\u7269\u6599\u6210\u672c\u4fe1\u606f\u6269\u5c55\u63d2\u4ef6");
            boolean extResult = this.execExtPluginByMatCost(matCostInfos);
            if (!extResult) {
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u7269\u6599\u6210\u672c\u4fe1\u606f\u6269\u5c55\u63d2\u4ef6\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostUpdateTask_41", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u6267\u884c\u6269\u5c55\u7269\u6599\u6210\u672c\u4fe1\u606f\u63d2\u4ef6", (String)"CostUpdateTask_42", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u5b8c\u6210", (String)"CostUpdateTask_13", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            startTime = System.currentTimeMillis();
            this.logProgress(this.updateParam.getPageId(), "progress", "100");
            this.logProgress(this.updateParam.getPageId(), "startprogress", "false");
            updateLog.setSucMatCount(keyColIds.size());
            updateLog.setIsSuc(Boolean.TRUE);
            this.logger.info("\u5373\u65f6\u66f4\u65b0\u5b8c\u6210");
            this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
        }
        catch (Exception e) {
            try {
                checkResults = this.getCheckResults();
                txHandle.markRollback();
                updateLog.setIsSuc(Boolean.FALSE);
                if (isCurLevel && !CadEmptyUtils.isEmpty(keyColIds)) {
                    failKeycolIds.addAll(keyColIds);
                }
                this.logger.error((Throwable)e);
                this.logProgress(this.updateParam.getPageId(), "tip_fail", ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u66f4\u65b0\u62a5\u544a\u3002", (String)"CostUpdateTask_43", (String)"macc-cad-business", (Object[])new Object[0]));
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u3002", (String)"CostUpdateTask_33", (String)"macc-cad-business", (Object[])new Object[0]), e.getMessage(), e.getMessage(), 2);
                this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
            }
            catch (Throwable throwable) {
                this.releaseMutex(targetCostTypeIds, lockCostTypeIds);
                txHandle.close();
                Tuple<Boolean, String> result = new StorCostProcessor().startSyncBizBill(establishedBill, failKeycolIds);
                if (Boolean.FALSE.equals(result.item1)) {
                    String errTip5 = String.format(exceptionTip, "startSyncBizBill", result.item2);
                    updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip5, 2);
                    this.logger.error(errTip5);
                } else {
                    updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u6210\u529f", (String)"CostUpdateTask_22", (String)"macc-cad-business", (Object[])new Object[0]), 3);
                }
                if (checkResults != null && !checkResults.isEmpty() && Boolean.FALSE.equals(updateLog.getIsSuc())) {
                    SaveServiceHelper.save((DynamicObject[])checkResults.toArray(new DynamicObject[0]));
                }
                this.writeUpdateLog(updateLog, logs);
                if (Boolean.FALSE.equals(updateLog.getIsSuc())) {
                    CostUpdateEstablishedHelper.updateId(updateBillId, 0L);
                }
                StdCalculateHelper.updateRecordInfo((DynamicObject)updateBill, failKeycolIds, (Long)updateLog.getTaskId(), (Long)this.updateParam.getTaskId(), (Boolean)isAllFail, (Boolean)updateLog.getIsSuc());
                this.updateSalCalcLogStatu(updateBillId, updateLog);
                throw throwable;
            }
            txHandle.close();
            Tuple<Boolean, String> result = new StorCostProcessor().startSyncBizBill(establishedBill, failKeycolIds);
            if (Boolean.FALSE.equals(result.item1)) {
                errTip = String.format(exceptionTip, "startSyncBizBill", result.item2);
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip, 2);
                this.logger.error(errTip);
            } else {
                updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u6210\u529f", (String)"CostUpdateTask_22", (String)"macc-cad-business", (Object[])new Object[0]), 3);
            }
            if (checkResults != null && !checkResults.isEmpty() && Boolean.FALSE.equals(updateLog.getIsSuc())) {
                SaveServiceHelper.save((DynamicObject[])checkResults.toArray(new DynamicObject[0]));
            }
            this.writeUpdateLog(updateLog, logs);
            if (Boolean.FALSE.equals(updateLog.getIsSuc())) {
                CostUpdateEstablishedHelper.updateId(updateBillId, 0L);
            }
            StdCalculateHelper.updateRecordInfo((DynamicObject)updateBill, failKeycolIds, (Long)updateLog.getTaskId(), (Long)this.updateParam.getTaskId(), (Boolean)isAllFail, (Boolean)updateLog.getIsSuc());
            this.updateSalCalcLogStatu(updateBillId, updateLog);
        }
        txHandle.close();
        Tuple<Boolean, String> result = new StorCostProcessor().startSyncBizBill(establishedBill, failKeycolIds);
        if (Boolean.FALSE.equals(result.item1)) {
            errTip = String.format(exceptionTip, "startSyncBizBill", result.item2);
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, errTip, 2);
            this.logger.error(errTip);
        } else {
            updateLog.addLogInfo(logs, startTime, ResManager.loadKDString((String)"\u5f00\u542f\u4e1a\u52a1\u5355\u636e\u8fdb\u6838\u7b97\u7cfb\u7edf", (String)"CostUpdateTask_21", (String)"macc-cad-business", (Object[])new Object[0]), null, ResManager.loadKDString((String)"\u6210\u529f", (String)"CostUpdateTask_22", (String)"macc-cad-business", (Object[])new Object[0]), 3);
        }
        if (checkResults != null && !checkResults.isEmpty() && Boolean.FALSE.equals(updateLog.getIsSuc())) {
            SaveServiceHelper.save((DynamicObject[])checkResults.toArray(new DynamicObject[0]));
        }
        this.writeUpdateLog(updateLog, logs);
        if (Boolean.FALSE.equals(updateLog.getIsSuc())) {
            CostUpdateEstablishedHelper.updateId(updateBillId, 0L);
        }
        StdCalculateHelper.updateRecordInfo((DynamicObject)updateBill, failKeycolIds, (Long)updateLog.getTaskId(), (Long)this.updateParam.getTaskId(), (Boolean)isAllFail, (Boolean)updateLog.getIsSuc());
        this.updateSalCalcLogStatu(updateBillId, updateLog);
    }

    private void writeUpdateDiffBill(Long establishedId, DynamicObject updateBill) {
        if (CadEmptyUtils.isEmpty((Long)establishedId)) {
            return;
        }
        DataSet resultDs = this.getDataSet(establishedId);
        List<List<DynamicObject>> billList = this.dealDataSet(resultDs, updateBill);
        if (billList != null && billList.size() > 0) {
            billList.forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
        }
    }

    private DataSet getDataSet(Long pkId) {
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        String selectFields = "billno,currency,effecttime,productentry.period period,productentry.period.begindate begindate,productentry.period.enddate enddate,productentry.org org,productentry.costaccountbook costbook,productentry.costcenter costcenter,productentry.costobject costobject,productentry.costobject.material material,productentry.updatediff updatediff,productentry.procsubelement.type type,productentry.costobject.auxpty auxpty";
        DataSet baseDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_costupdateestablished", (String)selectFields, (QFilter[])filter.toArray(), null);
        String sql = "select billno,currency,effecttime,period,begindate,enddate,org,costbook,costcenter,costobject,material,auxpty,sum(updatediff) as totalAmt,sum(case when type='001' then updatediff else 0 end) as materialamt,sum(case when type='002' then updatediff else 0 end) as materialfee,sum(case when type='003' then updatediff else 0 end) as makeamt,sum(case when type='004' then updatediff else 0 end) as resourceamt,sum(case when type='005' then updatediff else 0 end) as additionamt  group by billno,currency,effecttime,period,begindate,enddate,org,costbook,costcenter,costobject,material,auxpty  having (materialamt !=0 and materialamt !=null) or (materialfee !=0 and materialfee !=null)  or (makeamt !=0 and makeamt !=null) or (resourceamt !=0 and resourceamt !=null)  or (additionamt !=0 and additionamt !=null) ";
        return baseDs.executeSql(sql);
    }

    private List<List<DynamicObject>> dealDataSet(DataSet resultDs, DynamicObject updateBill) {
        ArrayList<List<DynamicObject>> resList = null;
        if (resultDs == null || resultDs.isEmpty()) {
            return null;
        }
        HashSet costBookPkSet = new HashSet(3);
        DataSet copyDS = resultDs.copy();
        copyDS.forEach(row -> costBookPkSet.add(row.getLong("costbook")));
        resList = new ArrayList<List<DynamicObject>>(costBookPkSet.size());
        Iterator numIte = costBookPkSet.iterator();
        DataSet iteDS = null;
        DataSet costBookDS = null;
        while (numIte.hasNext()) {
            Long pkId = (Long)numIte.next();
            if (pkId == 0L) continue;
            iteDS = resultDs.copy();
            costBookDS = iteDS.filter("costbook=" + pkId);
            List<DynamicObject> billList = this.dealSingleCostBook(costBookDS, updateBill);
            resList.add(billList);
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{costBookDS, iteDS, copyDS, resultDs});
        return resList;
    }

    private List<DynamicObject> dealSingleCostBook(DataSet costBookDS, DynamicObject updateBill) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(8);
        int i = 0;
        int priceprecision = 6;
        DynamicObject difDyn = null;
        DynamicObjectCollection difEntry = null;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date currentDate = TimeServiceHelper.now();
        for (Row row : costBookDS) {
            if (i % 1000 == 0) {
                difDyn = BusinessDataServiceHelper.newDynamicObject((String)"cad_costrenewaldif");
                difEntry = difDyn.getDynamicObjectCollection("entryentity");
                difEntry.clear();
                Long curPkId = (Long)row.get("currency");
                priceprecision = CostTypeHelper.getPriceprecision((Long)curPkId);
                difDyn.set("renewreqno", (Object)updateBill.getString("billno"));
                String numbers = CodeRuleServiceHelper.getNumber((String)"cad_costrenewaldif", (DynamicObject)difDyn, null);
                if (StringUtils.isBlank((CharSequence)numbers)) {
                    numbers = "CBGXCYD-" + System.currentTimeMillis();
                }
                difDyn.set("billno", (Object)numbers);
                Date effecttime = row.getDate("effecttime");
                Date begindate = row.getDate("begindate");
                Date enddate = row.getDate("enddate");
                if (effecttime.compareTo(begindate) >= 0 && effecttime.compareTo(enddate) <= 0) {
                    difDyn.set("effecttime", (Object)effecttime);
                } else {
                    difDyn.set("effecttime", (Object)enddate);
                }
                difDyn.set("period", row.get("period"));
                difDyn.set("org", row.get("org"));
                difDyn.set("costaccountbook", row.get("costbook"));
                difDyn.set("currency", (Object)curPkId);
                difDyn.set("costcenter", row.get("costcenter"));
                difDyn.set("billstatus", (Object)"C");
                difDyn.set("creator", (Object)currentUserId);
                difDyn.set("createtime", (Object)currentDate);
                difDyn.set("auditor", (Object)currentUserId);
                difDyn.set("auditdate", (Object)currentDate);
                billList.add(difDyn);
            }
            if (difEntry == null) continue;
            DynamicObject aNew = difEntry.addNew();
            aNew.set("costobject", row.get("costobject"));
            BigDecimal totalAmt = row.getBigDecimal("totalAmt");
            aNew.set("updatediff", (Object)(totalAmt != null ? totalAmt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal materialAmt = row.getBigDecimal("materialamt");
            aNew.set("materialamt", (Object)(materialAmt != null ? materialAmt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal materialFee = row.getBigDecimal("materialfee");
            aNew.set("materialfee", (Object)(materialFee != null ? materialFee.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal resourceAmt = row.getBigDecimal("resourceamt");
            aNew.set("resourceamt", (Object)(resourceAmt != null ? resourceAmt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal makeAmt = row.getBigDecimal("makeamt");
            aNew.set("makeamt", (Object)(makeAmt != null ? makeAmt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            BigDecimal additionAmt = row.getBigDecimal("additionamt");
            aNew.set("additionamt", (Object)(additionAmt != null ? additionAmt.setScale(priceprecision, 4) : BigDecimal.ZERO.setScale(priceprecision)));
            aNew.set("productcode", row.get("material"));
            aNew.set("auxpty", row.get("auxpty"));
            ++i;
        }
        return billList;
    }

    private void updateProdCost(DynamicObject updateBill, DynamicObject establishedBill) {
        ProdCostProcessor prodCostProcessor = new ProdCostProcessor();
        prodCostProcessor.genCalcResult(updateBill, establishedBill);
    }

    private void writeBackCostUpdatBill(Long establishedId, Date effectTime, DynamicObject updateBill) {
        updateBill.set("updatetime", (Object)effectTime);
        updateBill.set("updatestatus", (Object)"Y");
        updateBill.set("updatebillid", (Object)establishedId);
        SaveServiceHelper.update((DynamicObject)updateBill);
    }

    private Long saveBillData(Date effectTime, Long updateBillId, DynamicObject establishedBill) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])filters);
        Long establishedId = updateBill.getLong("updatebillid");
        if (!CadEmptyUtils.isEmpty((Long)establishedId)) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cad_costupdateestablished"), (Object[])new Long[]{establishedId});
        }
        DynamicObject targetCostType = establishedBill.getDynamicObject("targetcosttype");
        Long id = DBServiceHelper.genGlobalLongId();
        DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_costupdateestablished");
        EntityUtil.copyPropertiesWithOutId((DynamicObject)tarObj, (DynamicObject)establishedBill);
        tarObj.set("effecttime", (Object)effectTime);
        tarObj.set("id", (Object)id);
        tarObj.set("targetcosttype", (Object)targetCostType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tarObj});
        return id;
    }

    private boolean copyCalcRelateData(UpdateParam updateParam, Set<Long> keyColIds, Date effectTime, DynamicObject updateBill, Map<String, Long> matCostInfos) {
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return false;
        }
        boolean quickUpdateFlag = updateBill.getBoolean("isquickupdate");
        Set<Long> outKeyColIds = CostUpdateEstablishedHelper.getOutKeyColIds(updateBill.getLong("srccosttype.id"), keyColIds);
        if (quickUpdateFlag) {
            outKeyColIds.addAll(keyColIds);
        }
        this.logger.info("\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e2d\u7684\u5916\u8d2doutKeyColIds={}", outKeyColIds);
        this.logger.info("\u62f7\u8d1d\u8ba1\u7b97\u7ed3\u679c\u5230\u76ee\u6807\u6210\u672c\u7c7b\u578b\u4e0b");
        this.logProgress(updateParam.getPageId(), "progress", "20");
        if (!quickUpdateFlag) {
            boolean isSuc = CostUpdateEstablishedHelper.copyCalcResult(updateBill, keyColIds, effectTime, matCostInfos, outKeyColIds);
            this.logger.info("\u751f\u6548\u7ed3\u679c\u8868\u540e\u7684\u5916\u8d2doutKeyColIds={}", outKeyColIds);
            if (!isSuc) {
                return false;
            }
            if (Boolean.TRUE.equals(updateParam.getIsTrackUpdate())) {
                return true;
            }
            Set<String> keycols = this.getKeyColById(keyColIds);
            if (!CadEmptyUtils.isEmpty(keycols)) {
                this.logProgress(updateParam.getPageId(), "progress", "30");
                this.logger.info("\u590d\u5236\u6210\u672cBOM\u8bbe\u7f6e");
                CostUpdateEstablishedHelper.copyBomSetting(updateBill, keycols, effectTime);
                this.logProgress(updateParam.getPageId(), "progress", "33");
                this.logger.info("\u590d\u5236\u6210\u672c\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e");
                CostUpdateEstablishedHelper.copyRoutersetting(updateBill, keycols, effectTime);
            }
        }
        this.logProgress(updateParam.getPageId(), "progress", "35");
        this.logger.info("\u590d\u5236\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868");
        CostUpdateEstablishedHelper.copyPurPrices(updateBill, keyColIds, outKeyColIds, effectTime, matCostInfos);
        Tuple<Boolean, Boolean> updateWay = CostUpdateEstablishedHelper.getUpdateWay(updateBill.getLong("id"));
        Map relatedKeyColMap = CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
        Map<String, Set<Long>> priceIds = CostUpdateEstablishedHelper.getPriceIds(updateBill.getLong("srccosttype.id"), updateWay, updateBill.getLong("calcrecord.id"), relatedKeyColMap);
        if (!CadEmptyUtils.isEmpty(priceIds)) {
            Set<Long> ids = priceIds.get("purOuts");
            if (!CadEmptyUtils.isEmpty(ids)) {
                this.logger.info("\u590d\u5236\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868");
                CostUpdateEstablishedHelper.copyOutSourcePrice(updateBill, ids, keyColIds, effectTime);
            }
            if (!CadEmptyUtils.isEmpty(ids = priceIds.get("resourceRates"))) {
                this.logProgress(updateParam.getPageId(), "progress", "40");
                this.logger.info("\u590d\u5236\u81ea\u5236\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868");
                CostUpdateEstablishedHelper.copyResourceRate(updateBill, effectTime, ids);
            }
            if (!CadEmptyUtils.isEmpty(ids = priceIds.get("resourceOuts"))) {
                this.logger.info("\u590d\u5236\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868");
                CostUpdateEstablishedHelper.copyResourceOut(updateBill, effectTime, ids);
            }
        }
        return true;
    }

    private void logProgress(String pageId, String cacheKey, String progress) {
        PageCache pageCache = new PageCache(pageId);
        pageCache.put(cacheKey, progress);
    }

    private void releaseMutex(Set<Long> targetCostTypeIds, Set<Long> lockCostTypeIds) {
        if (targetCostTypeIds.isEmpty()) {
            return;
        }
        Boolean isMult = CostTypeHelper.isMultFactoryByCostType(targetCostTypeIds);
        if (Boolean.TRUE.equals(isMult)) {
            CalcMutexHelper.releaseXMutex((String)"update", lockCostTypeIds);
        } else {
            Set accountIds = CostTypeHelper.getCostAcctIdSetFromCostType(targetCostTypeIds);
            CalcMutexHelper.releaseXMutex((String)"update", (Set)accountIds);
            CalcMutexHelper.releaseXMutex((String)"update", lockCostTypeIds);
        }
    }

    private void changeMatCalcProp(DynamicObject updateBill, Date effectTime, Set<Long> failKeycolIds) {
        Map relatedKeyColMap = CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
        if (!CadEmptyUtils.isEmpty(failKeycolIds)) {
            failKeycolIds.forEach(relatedKeyColMap::remove);
        }
        if (relatedKeyColMap.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id")), new QFilter("keycolid", "in", relatedKeyColMap.keySet()), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("expdate", "=", (Object)TimeUtils.getDeFaultExpDate())};
        DynamicObjectCollection matCalcProps = QueryServiceHelper.query((String)"cad_bomsetting", (String)"matcalcprop,keycolid", (QFilter[])filters);
        if (matCalcProps.isEmpty()) {
            return;
        }
        Long tarCostTypeId = updateBill.getLong("targetcosttype.id");
        String purSql = "update t_cad_purprices set fexpdate = ? where fcosttypeid = ? and fkeycolid = ? and fexpdate = ?";
        ArrayList<SqlParameter[]> purParams = new ArrayList<SqlParameter[]>(10);
        String outSql = "update t_cad_outsourceprice set fexpdate = ? where fcosttypeid = ? and fkeycolid = ? and fexpdate = ?";
        ArrayList<SqlParameter[]> outParams = new ArrayList<SqlParameter[]>(10);
        for (DynamicObject matCalcProp : matCalcProps) {
            String matProp = matCalcProp.getString("matcalcprop");
            if ("A".equals(matProp)) {
                purParams.add(new SqlParameter[]{new SqlParameter(":fexpdate", 91, (Object)effectTime), new SqlParameter(":fcosttypeid", -5, (Object)tarCostTypeId), new SqlParameter(":fkeycolid", -5, (Object)matCalcProp.getLong("keycolid")), new SqlParameter(":fexpdate", 91, (Object)TimeUtils.getDeFaultExpDate())});
                outParams.add(new SqlParameter[]{new SqlParameter(":fexpdate", 91, (Object)effectTime), new SqlParameter(":fcosttypeid", -5, (Object)tarCostTypeId), new SqlParameter(":fkeycolid", -5, (Object)matCalcProp.getLong("keycolid")), new SqlParameter(":fexpdate", 91, (Object)TimeUtils.getDeFaultExpDate())});
                continue;
            }
            if ("B".equals(matProp)) {
                outParams.add(new SqlParameter[]{new SqlParameter(":fexpdate", 91, (Object)effectTime), new SqlParameter(":fcosttypeid", -5, (Object)tarCostTypeId), new SqlParameter(":fkeycolid", -5, (Object)matCalcProp.getLong("keycolid")), new SqlParameter(":fexpdate", 91, (Object)TimeUtils.getDeFaultExpDate())});
                continue;
            }
            if (!"C".equals(matProp)) continue;
            purParams.add(new SqlParameter[]{new SqlParameter(":fexpdate", 91, (Object)effectTime), new SqlParameter(":fcosttypeid", -5, (Object)tarCostTypeId), new SqlParameter(":fkeycolid", -5, (Object)matCalcProp.getLong("keycolid")), new SqlParameter(":fexpdate", 91, (Object)TimeUtils.getDeFaultExpDate())});
        }
        if (!purParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)purSql, purParams);
        }
        if (!outParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)outSql, outParams);
        }
    }

    private Set<Long> getHasCostType(DynamicObject updateBill) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)updateBill.getLong("targetcosttype.id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection costAccount = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id costtype", (QFilter[])filters);
        HashSet<Long> costTypeIds = new HashSet<Long>(costAccount.size());
        costAccount.forEach(p -> costTypeIds.add(p.getLong("costtype")));
        return costTypeIds;
    }

    private UpdateLog initUpdateLog(DynamicObject updateBill) {
        Long costTypeId = updateBill.getLong("targetcosttype.id");
        Long taskId = TaskServiceHelper.createTask((Long)costTypeId, (String)ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"CostUpdateTask_44", (String)"macc-cad-business", (Object[])new Object[0]));
        UpdateLog updateLog = new UpdateLog();
        updateLog.setCostTypeId(costTypeId);
        updateLog.setTaskId(taskId);
        return updateLog;
    }

    private void writeUpdateLog(UpdateLog updateLog, List<UpdateLogInfo> logs) {
        try {
            for (UpdateLogInfo log : logs) {
                updateLog.write(log.getErrorType(), log.getStartTime(), log.getCatalog(), log.getErrDesc(), log.getTipContent());
            }
            if (Boolean.TRUE.equals(updateLog.getIsSuc())) {
                TaskServiceHelper.updateProgress((Long)updateLog.getCostTypeId(), (Long)updateLog.getTaskId(), (int)100);
            } else {
                TaskServiceHelper.updateProgress((Long)updateLog.getCostTypeId(), (Long)updateLog.getTaskId(), (int)100, (int)2);
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private void initUpdateParam(DynamicObject updateBill, UpdateParam updateParam, Set<Long> keyColIds, Long effecttime) {
        updateParam.setSrcCostTypeId(Long.valueOf(updateBill.getLong("srccosttype.id")));
        updateParam.setTarCostTypeId(Long.valueOf(updateBill.getLong("targetcosttype.id")));
        updateParam.setIsAllUpdate(Boolean.valueOf(updateBill.getBoolean("isallupdate")));
        if (Boolean.TRUE.equals(updateParam.getIsAllUpdate())) {
            updateParam.setIsTrackUpdate(Boolean.FALSE);
        }
        updateParam.setKeyColIds(keyColIds);
        updateParam.setEffectTime(effecttime);
        updateParam.setCheckItemIds(CostUpdateEstablishedHelper.getCheckItemIds());
        updateParam.setTaskId(TaskServiceHelper.createTask((Long)updateParam.getTarCostTypeId(), (String)ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CostUpdateTask_45", (String)"macc-cad-business", (Object[])new Object[0])));
        Tuple<Boolean, Boolean> updateWay = CostUpdateEstablishedHelper.getUpdateWay(updateBill.getLong("id"));
        Long calcRecordId = updateBill.getLong("calcrecord.id");
        Map relatedKeyColMap = CostUpdateHelper.getRelatedKeyCols((DynamicObject)updateBill);
        Map<String, Set<Long>> priceIds = CostUpdateEstablishedHelper.getPriceIds(updateBill.getLong("srccosttype.id"), updateWay, calcRecordId, relatedKeyColMap);
        if (!CadEmptyUtils.isEmpty(priceIds)) {
            updateParam.setPurOutIds(priceIds.get("purOuts"));
            updateParam.setResourceRateIds(priceIds.get("resourceRates"));
            updateParam.setResourceOutIds(priceIds.get("resourceOuts"));
        }
    }

    private void autoStandardCostCalc(Long srcCostTypeId) {
        RequestContext rc = RequestContext.getOrCreate();
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u5377\u7b97\u3011\u5f00\u59cb\u6267\u884c\uff0c\u6267\u884c\u4eba\uff1a%s", rc.getUserName()));
        HashSet<Long> successChangeRecordIds = new HashSet<Long>(16);
        HashSet<Long> failedChangeRecordIds = new HashSet<Long>(16);
        HashSet<Long> successMatIds = new HashSet<Long>(16);
        HashSet<Long> failedMatIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("costtype", "=", (Object)srcCostTypeId);
        filter.and("status", "in", (Object)new String[]{"A", "D"});
        filter.and("keycol", "!=", (Object)" ");
        filter.and("keycolid", ">", (Object)0L);
        Map<Long, CalcChangedInfo> costTypeCalcChangeMap = AutoStandCostCalcHandler.getCostTypeCalcChangeMap(filter);
        for (Map.Entry<Long, CalcChangedInfo> entry : costTypeCalcChangeMap.entrySet()) {
            CalcChangedInfo info = entry.getValue();
            try {
                AutoStandCostCalcHandler.doCalc(info);
                successChangeRecordIds.addAll(info.getChangeRecordId());
                successMatIds.addAll(info.getMatIds());
            }
            catch (Exception ex) {
                this.logger.error(String.format("\u6210\u672c\u7c7b\u578b[%s]\u4e0b\u5bf9\u5e94\u7684\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\uff1a %s \u5904\u7406\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s ", info.getCostTypeName(), info.getChangeRecordId().toString(), ex));
                failedChangeRecordIds.addAll(info.getChangeRecordId());
                failedMatIds.addAll(info.getMatIds());
            }
        }
        this.logger.info(String.format("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u5377\u7b97\u3011\u6267\u884c\u7ed3\u675f,\u5171\u5904\u7406 %s\u6761\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55,\u6210\u529f %s\u6761,\u5931\u8d25 %s\u6761\uff1b\u5171\u8ba1\u7b97 %s\u6761\u7269\u6599,\u6210\u529f %s\u6761,\u5931\u8d25 %s\u6761\u3002", successChangeRecordIds.size() + failedChangeRecordIds.size(), successChangeRecordIds.size(), failedChangeRecordIds.size(), successMatIds.size() + failedMatIds.size(), successMatIds.size(), failedMatIds.size()));
        AutoStandCostCalcHandler.updateStatus(successChangeRecordIds, "C");
        AutoStandCostCalcHandler.updateStatus(failedChangeRecordIds, "D");
        this.logger.info("\u81ea\u52a8\u5377\u7b97\u4efb\u52a1\u3010\u66f4\u65b0\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u5904\u7406\u72b6\u6001\u3011\u6267\u884c\u7ed3\u675f\u3002");
    }

    private void updateSalCalcLogStatu(Long updateBillId, UpdateLog updateLog) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno,entryentity.salcalclogid salcalclogid", (QFilter[])filters);
        ArrayList<Long> calcIds = new ArrayList<Long>(bills.size());
        String billNo = "";
        for (DynamicObject bill : bills) {
            billNo = bill.getString("billno");
            Long calcId = bill.getLong("salcalclogid");
            if (CadEmptyUtils.isEmpty((Long)calcId)) continue;
            calcIds.add(calcId);
        }
        if (CadEmptyUtils.isEmpty(calcIds)) {
            return;
        }
        filters = new QFilter[]{new QFilter("id", "in", calcIds)};
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"id,operationtype,trytimes,execlog,updatestatu,updatelog,updatetaskid", (QFilter[])filters);
        String updateStatu = updateLog.getIsSuc() ? "S" : "F";
        String tip = ResManager.loadKDString((String)"\u8054\u67e5\u66f4\u65b0\u62a5\u544a", (String)"CostUpdateTask_46", (String)"macc-cad-business", (Object[])new Object[0]);
        for (DynamicObject log : logs) {
            log.set("operationtype", (Object)"2");
            log.set("trytimes", (Object)(log.getInt("trytimes") + 1));
            log.set("updatestatu", (Object)updateStatu);
            if ("F".equals(updateStatu)) {
                log.set("updatelog", (Object)tip);
                log.set("execlog", (Object)" ");
            } else {
                log.set("updatelog", (Object)" ");
                log.set("execlog", (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f\u3002", (String)"CostUpdateTask_47", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            log.set("updatetaskid", (Object)updateLog.getTaskId());
        }
        SaveServiceHelper.update((DynamicObject[])logs);
    }

    private boolean execExtPluginByMatCost(Map<String, Long> matCostInfos) {
        ArrayList<Long> matCostIds = new ArrayList<Long>(matCostInfos.size());
        for (Map.Entry<String, Long> matCostInfo : matCostInfos.entrySet()) {
            matCostIds.add(matCostInfo.getValue());
        }
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IDealMatCostInfoAfterUpdate.class, (String)"MACC_CAD_UPDATE_MATCOSTINFO", null);
            this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u6269\u5c55\u63d2\u4ef6\uff0cpluginList\uff1a{}", (Object)pluginProxy.getPlugins());
            pluginProxy.callReplace(p -> {
                boolean result = p.dealMatCostInfoByIds(matCostIds);
                this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u6269\u5c55\u63d2\u4ef6{}\uff0c\u53c2\u6570matCostIds.size() = {}\uff0c\u8fd4\u56de\u503cresult = {}\uff0cmatCostIds = {}", new Object[]{p.getClass().getName(), matCostIds.size(), result, matCostIds});
                return result;
            });
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            return false;
        }
        this.logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u6269\u5c55\u63d2\u4ef6\uff0c\u8fd4\u56detrue");
        return true;
    }

    private void delBatModifyPriceData(DynamicObject updateBill) {
        if ("batmodifyprice".equals(updateBill.getString("sourcepage"))) {
            DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
            ArrayList batModifyPriceIds = new ArrayList(entrys.size());
            entrys.forEach(p -> batModifyPriceIds.add(p.getLong("salcalclogid")));
            if (!CadEmptyUtils.isEmpty(batModifyPriceIds)) {
                DynamicObject[] batModifyPrices;
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", batModifyPriceIds)};
                for (DynamicObject batModifyPrice : batModifyPrices = BusinessDataServiceHelper.load((String)"cad_batmodifyprice", (String)"id,isupdate", (QFilter[])filters)) {
                    batModifyPrice.set("isupdate", (Object)true);
                }
                SaveServiceHelper.update((DynamicObject[])batModifyPrices);
                this.logger.info("\u6279\u91cf\u4fee\u6539\u6807\u51c6\u6210\u672c\uff0c\u66f4\u65b0\u6210\u529f\u7684ID\u96c6\u5408\uff1a{}", batModifyPriceIds);
            }
        }
    }

    private String checkMatCostData(Map<String, Long> matCostInfos) {
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u7684\u6838\u7b97\u5c5e\u6027\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CostUpdateTask_48", (String)"macc-cad-business", (Object[])new Object[0]);
        }
        ArrayList<Long> matCostIds = new ArrayList<Long>(matCostInfos.size());
        for (Map.Entry<String, Long> matCostInfo : matCostInfos.entrySet()) {
            matCostIds.add(matCostInfo.getValue());
        }
        this.logger.info(String.format("checkMatCostData matCostIds:%s", matCostIds));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", matCostIds)};
        DataSet matCostInfoDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "matCostInfo"), (String)"cad_matcostinfo", (String)"id,material.number materialnumber,material.name materialname,entryentity.standardcost standardcost", (QFilter[])filters, null);
        matCostInfoDataSet = matCostInfoDataSet.executeSql("select id,materialnumber,materialname,sum(standardcost) standardcost group by id,materialnumber,materialname");
        filters = new QFilter[]{new QFilter("matcostid", "in", matCostIds), new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"})};
        DataSet effectDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "effectResult"), (String)"cad_calceffectiveresult", (String)"matcostid,entryentity.datatype datatype,entryentity.stdprice stdprice,'effect' source", (QFilter[])filters, null);
        DataSet subEffectDataSet = effectDataSet.filter("datatype in ('2','3')");
        DataSet comEffectDataSet = effectDataSet.filter("datatype in ('2','4')");
        subEffectDataSet = subEffectDataSet.executeSql("select matcostid,sum(stdprice) stdprice,source group by matcostid,source");
        comEffectDataSet = comEffectDataSet.executeSql("select matcostid,sum(stdprice) stdprice,source group by matcostid,source");
        filters = new QFilter[]{new QFilter("matcostid", "in", matCostIds)};
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "purprice"), (String)"cad_purprices", (String)"matcostid,entryentity.price stdprice,'pur' source", (QFilter[])filters, null);
        purDataSet = purDataSet.executeSql("select matcostid,sum(stdprice) stdprice,source group by matcostid,source");
        DataSet effectPurDataSet = DataSetUtils.union((DataSet)subEffectDataSet, (DataSet)purDataSet);
        effectPurDataSet = DataSetUtils.union((DataSet)effectPurDataSet, (DataSet)comEffectDataSet).groupBy(effectPurDataSet.getRowMeta().getFieldNames()).finish();
        HashSet<String> notInEffects = new HashSet<String>(16);
        HashSet<String> notInPurs = new HashSet<String>(16);
        HashSet<String> notInEffectPur = new HashSet<String>(16);
        DataSet allDataSet = matCostInfoDataSet.leftJoin(effectPurDataSet).on("id", "matcostid").select(matCostInfoDataSet.getRowMeta().getFieldNames(), new String[]{"matcostid", "stdprice", "source"}).finish();
        for (Row row : allDataSet) {
            String source;
            BigDecimal stdPrice;
            String matInfo = row.getString("materialnumber") + "/" + row.getString("materialname");
            Long matCostId = row.getLong("matcostid");
            if (CadEmptyUtils.isEmpty((Long)matCostId)) {
                notInEffectPur.add(matInfo);
                continue;
            }
            BigDecimal standardCost = row.getBigDecimal("standardcost");
            if (standardCost.subtract(stdPrice = row.getBigDecimal("stdprice")).abs().compareTo(new BigDecimal("0.01")) <= 0) continue;
            switch (source = row.getString("source")) {
                case "effect": {
                    notInEffects.add(matInfo);
                    this.logger.info(String.format("%s\uff0c\u7269\u6599\u6210\u672c\u4fe1\u606f\u5408\u8ba1\u91d1\u989d%s\uff0c\u751f\u6548\u7ed3\u679c\u8868\u5408\u8ba1\u91d1\u989d%s", matInfo, standardCost, stdPrice));
                    break;
                }
                case "pur": {
                    notInPurs.add(matInfo);
                    this.logger.info(String.format("%s\uff0c\u7269\u6599\u6210\u672c\u4fe1\u606f\u5408\u8ba1\u91d1\u989d%s\uff0c\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u5408\u8ba1\u91d1\u989d%s", matInfo, standardCost, stdPrice));
                    break;
                }
            }
        }
        StringBuilder sg = new StringBuilder();
        if (!CadEmptyUtils.isEmpty(notInEffects)) {
            sg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0e\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868\u4e0d\u4e00\u81f4\u3002", (String)"CostUpdateTask_49", (String)"macc-cad-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", notInEffects)));
        }
        if (!CadEmptyUtils.isEmpty(notInPurs)) {
            sg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0e\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u4e0d\u4e00\u81f4\u3002", (String)"CostUpdateTask_50", (String)"macc-cad-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", notInPurs)));
        }
        if (!CadEmptyUtils.isEmpty(notInEffectPur)) {
            sg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7269\u6599\u6210\u672c\u4fe1\u606f\u672a\u8bc6\u522b\u5230\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868/\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u3002", (String)"CostUpdateTask_51", (String)"macc-cad-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", notInEffectPur)));
        }
        return sg.toString();
    }

    private String checkMatCostLessZeroData(Map<String, Long> matCostInfos) {
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return ResManager.loadKDString((String)"\u672c\u6b21\u66f4\u65b0\u7684\u6838\u7b97\u5c5e\u6027\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"CostUpdateTask_48", (String)"macc-cad-business", (Object[])new Object[0]);
        }
        ArrayList<Long> matCostIds = new ArrayList<Long>(matCostInfos.size());
        for (Map.Entry<String, Long> matCostInfo : matCostInfos.entrySet()) {
            matCostIds.add(matCostInfo.getValue());
        }
        this.logger.info(String.format("checkMatCostData matCostIds:%s", matCostIds));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", matCostIds)};
        DataSet matCostInfoDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "matCostInfo"), (String)"cad_matcostinfo", (String)"id,keycol,auxpty,entryentity.standardcost standardcost", (QFilter[])filters, null);
        matCostInfoDataSet = matCostInfoDataSet.executeSql("select id,keycol,auxpty,sum(standardcost) standardcost group by id,keycol,auxpty");
        DataSet lessZeroDataSet = matCostInfoDataSet.filter("standardcost < 0");
        if (lessZeroDataSet.isEmpty()) {
            return null;
        }
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        HashSet<String> lessZeroMatKcs = new HashSet<String>(16);
        while (lessZeroDataSet.hasNext()) {
            Row row = lessZeroDataSet.next();
            String keycol = row.getString("keycol");
            Long auxpty = row.getLong("auxpty");
            if (!CadEmptyUtils.isEmpty((Long)auxpty)) {
                auxptyIds.add(auxpty);
            }
            lessZeroMatKcs.add(keycol);
        }
        HashMap auxptyMap = new HashMap(16);
        HashMap typeNameMap = new HashMap(16);
        HashMap auxpValueMap = new HashMap(16);
        BomRuleSettingStdCalcHelper.getMatAuxptyInfo(auxptyIds, auxptyMap, typeNameMap, auxpValueMap);
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(lessZeroMatKcs);
        String number = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a", (String)"CostUpdateTask_56", (String)"macc-cad-business", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\uff1b\u7269\u6599\u540d\u79f0\uff1a", (String)"CostUpdateTask_57", (String)"macc-cad-business", (Object[])new Object[0]);
        HashSet<String> errorInfos = new HashSet<String>(10);
        while (bomMatDataSetByKeyCol.hasNext()) {
            Row row = bomMatDataSetByKeyCol.next();
            String matNumber = row.getString("matnumber");
            String matName = row.getString("matname");
            Long auxproperty = row.getLong("auxproperty");
            String configuredcode = row.getString("configuredcodenum");
            String tracknumber = row.getString("tracknumbernum");
            String project = row.getString("projectnum");
            String lot = row.getString("lot");
            StringBuilder sg = new StringBuilder();
            sg.append("\u201c");
            sg.append(number);
            sg.append(matNumber);
            sg.append(name);
            sg.append(matName);
            if (!CadEmptyUtils.isEmpty((Long)auxproperty)) {
                String auxValueStr = (String)auxptyMap.get(auxproperty);
                JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
                if (value == null) continue;
                StringBuilder auxStr = new StringBuilder();
                for (Map.Entry val : value.entrySet()) {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(':');
                    if (String.valueOf(val.getValue()).matches("[0-9]+") && auxpValueMap.containsKey(Long.parseLong(val.getValue().toString()))) {
                        auxStr.append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                        continue;
                    }
                    auxStr.append(val.getValue()).append(';');
                }
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%s", (String)"CostUpdateTask_58", (String)"macc-cad-business", (Object[])new Object[0]), auxStr));
            }
            if (!CadEmptyUtils.isEmpty((String)configuredcode)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u914d\u7f6e\u53f7\uff1a%s", (String)"CostUpdateTask_59", (String)"macc-cad-business", (Object[])new Object[0]), configuredcode));
            }
            if (!CadEmptyUtils.isEmpty((String)tracknumber)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u8ddf\u8e2a\u53f7\uff1a%s", (String)"CostUpdateTask_60", (String)"macc-cad-business", (Object[])new Object[0]), tracknumber));
            }
            if (!CadEmptyUtils.isEmpty((String)project)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u9879\u76ee\u53f7\uff1a%s", (String)"CostUpdateTask_61", (String)"macc-cad-business", (Object[])new Object[0]), project));
            }
            if (!CadEmptyUtils.isEmpty((String)lot)) {
                sg.append(String.format(ResManager.loadKDString((String)"\uff1b\u6279\u53f7\uff1a%s", (String)"CostUpdateTask_62", (String)"macc-cad-business", (Object[])new Object[0]), lot));
            }
            sg.append("\u201d");
            errorInfos.add(sg.toString());
        }
        if (!CadEmptyUtils.isEmpty(errorInfos)) {
            return String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u7269\u6599\u7684\u6807\u51c6\u6210\u672c\u4e0d\u4e3a\u6b63\u6570\uff1a%s\u3002", (String)"CostUpdateTask_55", (String)"macc-cad-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorInfos));
        }
        return null;
    }

    private Set<String> getKeyColById(Set<Long> keyColIds) {
        HashSet<String> keyCols = new HashSet<String>(keyColIds.size());
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return keyCols;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"keycol", (QFilter[])filters);
        dyKeyCols.forEach(p -> keyCols.add(p.getString("keycol")));
        return keyCols;
    }

    private List<DynamicObject> getCheckResults() {
        QFilter filter = new QFilter("costtype", "=", (Object)this.updateParam.getSrcCostTypeId());
        filter.and("calctaskrecord", "=", (Object)this.updateParam.getTaskId());
        String selectFeilds = "id,costtype,calctaskrecord,checkitem,checkresult,createtime,mainorg,calctime,cnsmtime,entryentity.id,entryentity.seq,entryentity.errordesc,entryentity.suggest";
        DynamicObject[] fromObjs = BusinessDataServiceHelper.load((String)"cad_calccheckresult", (String)selectFeilds, (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> checkResults = new ArrayList<DynamicObject>(fromObjs.length);
        for (DynamicObject fromObj : fromObjs) {
            DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_calccheckresult");
            EntityUtil.copyPropertiesWithOutId((DynamicObject)tarObj, (DynamicObject)fromObj);
            checkResults.add(tarObj);
        }
        return checkResults;
    }

    private void removeEstablishedBillInfo(DynamicObject establishedBill, Set<Long> failKeycolIds) {
        if (establishedBill == null || CadEmptyUtils.isEmpty(failKeycolIds)) {
            return;
        }
        DynamicObjectCollection costUpdateEntrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        ArrayList<Object> deleteEntrys = new ArrayList<Object>(10);
        for (Object costUpdateEntry : costUpdateEntrys) {
            long keycolId = costUpdateEntry.getLong("keycolid.id");
            if (!failKeycolIds.contains(keycolId)) continue;
            deleteEntrys.add(costUpdateEntry);
        }
        costUpdateEntrys.removeAll(deleteEntrys);
        deleteEntrys.clear();
        DynamicObjectCollection storageCostEntrys = establishedBill.getDynamicObjectCollection("storagecostentry");
        for (DynamicObject storageCostEntry : storageCostEntrys) {
            long keycolId = storageCostEntry.getLong("storkeycolid.id");
            if (!failKeycolIds.contains(keycolId)) continue;
            deleteEntrys.add(storageCostEntry);
        }
        storageCostEntrys.removeAll(deleteEntrys);
        deleteEntrys.clear();
        DynamicObjectCollection acctEntrys = establishedBill.getDynamicObjectCollection("acctentry");
        for (DynamicObject acctEntry : acctEntrys) {
            long keycolId = acctEntry.getLong("acctkeycolid.id");
            if (!failKeycolIds.contains(keycolId)) continue;
            deleteEntrys.add(acctEntry);
        }
        acctEntrys.removeAll(deleteEntrys);
        deleteEntrys.clear();
        DynamicObjectCollection productEntrys = establishedBill.getDynamicObjectCollection("productentry");
        for (DynamicObject productEntry : productEntrys) {
            long keycolId = productEntry.getLong("storkeycolid.id");
            if (!failKeycolIds.contains(keycolId)) continue;
            deleteEntrys.add(productEntry);
        }
        productEntrys.removeAll(deleteEntrys);
        deleteEntrys.clear();
    }

    private void removeUpdateBillInfo(DynamicObject updateBillNew, Set<Long> failKeycolIds) {
        if (updateBillNew == null || CadEmptyUtils.isEmpty(failKeycolIds)) {
            return;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(7);
        DynamicObjectCollection costUpdateEntrys = updateBillNew.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> deleteEntrys = new ArrayList<DynamicObject>(10);
        for (DynamicObject entry : costUpdateEntrys) {
            values.clear();
            values.put("material", entry.getLong("material.id"));
            values.put("matvers", entry.getLong("matversion.id"));
            values.put("auxproperty", entry.getLong("auxprop.id"));
            values.put("project", entry.getLong("project.id"));
            values.put("tracknumber", entry.getLong("tracknumber.id"));
            values.put("configuredcode", entry.getLong("configuredcode.id"));
            values.put("lot", entry.getString("lot"));
            Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
            if (!failKeycolIds.contains(keyColId)) continue;
            deleteEntrys.add(entry);
        }
        costUpdateEntrys.removeAll(deleteEntrys);
    }
}

