/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.calc.helper.NewStdCalculateHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.algox.utils.DataSetUtils;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.business.update.UpdateMatInfo;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.EntityUtil;

public class MaterialCostProcessor {
    private static final Log logger = LogFactory.getLog(MaterialCostProcessor.class);

    public Set<Long> genCostInfo(DynamicObject updateBill, DynamicObject establishedBill, Map<Long, String> relatedKeyColMap) {
        DynamicObjectCollection matGroupColl = establishedBill.getDynamicObjectCollection("costupdateentry");
        matGroupColl.clear();
        long startTime = System.currentTimeMillis();
        HashSet<Long> keyColIds = new HashSet<Long>(10);
        Tuple<Map<String, BigDecimal>, Map<String, BigDecimal>> info = this.getCostInfoAll(updateBill, relatedKeyColMap);
        this.subCostInfo(info, keyColIds, updateBill, matGroupColl, relatedKeyColMap);
        DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
        DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
            info = this.getCostInfoAll(updateBill, relatedKeyColMap);
            this.subCostInfo(info, keyColIds, updateBill, matGroupColl, relatedKeyColMap);
        }
        updateBill.set("targetcosttype", (Object)originalTargetCostType);
        BusinessDataServiceHelper.loadRefence((Object[])matGroupColl.toArray((Object[])new DynamicObject[0]), (IDataEntityType)matGroupColl.getDynamicObjectType());
        logger.info("\u7ed3\u675f\u6210\u672c\u4fe1\u606f\u754c\u9762\u52a0\u8f7d\uff0c\u8017\u65f6{}\uff08ms\uff09:", (Object)(System.currentTimeMillis() - startTime));
        return keyColIds;
    }

    private void subCostInfo(Tuple<Map<String, BigDecimal>, Map<String, BigDecimal>> info, Set<Long> keyColIds, DynamicObject updatebill, DynamicObjectCollection matGroupColl, Map<Long, String> relatedKeyColMap) {
        HashSet keys = new HashSet(16);
        keys.addAll(((Map)info.item1).keySet());
        keys.addAll(((Map)info.item2).keySet());
        if (CadEmptyUtils.isEmpty(keys)) {
            return;
        }
        logger.info("\u6210\u672c\u4fe1\u606f\u6570\u636e\u91cf\uff1a" + keys.size());
        Map srcCostTypeCalc = (Map)info.item1;
        Map tarCostTypeCalc = (Map)info.item2;
        long startTime = System.currentTimeMillis();
        Long targetCostTypeId = updatebill.getLong("targetcosttype.id");
        logger.info("\u5f00\u59cb\u6210\u672c\u4fe1\u606f\u754c\u9762\u52a0\u8f7d");
        int index = 0;
        int priceprecision = (Integer)updatebill.get("srccosttype.currency.priceprecision");
        BigDecimal zero = BigDecimal.ZERO.setScale(priceprecision, 4);
        for (String key : keys) {
            UpdateMatInfo matInfo = this.getMatInfoByKey(key);
            if (matInfo == null) {
                logger.info("key =" + key);
                continue;
            }
            BigDecimal newPrice = (BigDecimal)srcCostTypeCalc.get(key);
            newPrice = newPrice != null ? newPrice.setScale(priceprecision, 4) : zero;
            BigDecimal oldPrice = (BigDecimal)tarCostTypeCalc.get(key);
            BigDecimal bigDecimal = oldPrice = oldPrice != null ? oldPrice.setScale(priceprecision, 4) : zero;
            if (zero.compareTo(newPrice) == 0 && zero.compareTo(oldPrice) == 0) continue;
            if (CadEmptyUtils.isEmpty((Long)matInfo.getKeyColId())) {
                logger.info("\u5b58\u5728keycolid\u5f02\u5e38\u60c5\u51b5\uff0c\u7269\u6599id:{}", (Object)matInfo.getMatId());
                continue;
            }
            keyColIds.add(matInfo.getKeyColId());
            DynamicObject advconap = matGroupColl.addNew();
            advconap.set("seq", (Object)index++);
            advconap.set("costtype_id", (Object)targetCostTypeId);
            advconap.set("material_id", (Object)matInfo.getMatId());
            advconap.set("matversion_id", (Object)matInfo.getMatVersionId());
            advconap.set("auxprop_id", (Object)matInfo.getAuxptyId());
            advconap.set("keycolid_id", (Object)matInfo.getKeyColId());
            advconap.set("element_id", (Object)matInfo.getElementId());
            advconap.set("subelement_id", (Object)matInfo.getSubElementId());
            advconap.set("newprice", (Object)newPrice);
            advconap.set("oldprice", (Object)oldPrice);
            advconap.set("diffprice", (Object)newPrice.subtract(oldPrice));
            advconap.set("srctype", (Object)(relatedKeyColMap.get(matInfo.getKeyColId()) == null ? "2" : relatedKeyColMap.get(matInfo.getKeyColId())));
        }
        logger.info(String.format("\u6210\u672c\u7c7b\u578b%s\u52a0\u8f7d\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u8017\u65f6(ms):%s", updatebill.getString("targetcosttype.name"), System.currentTimeMillis() - startTime));
    }

    private UpdateMatInfo getMatInfoByKey(String key) {
        if (CadEmptyUtils.isEmpty((String)key)) {
            return null;
        }
        String[] values = key.split("#");
        if (values.length != 6) {
            logger.info("\u7b2c\u4e00\u9875\u7b7e\u5b57\u6bb5\u957f\u5ea6\u4e0d\u6ee1\u8db3\uff1a{}", (Object)key);
            return null;
        }
        UpdateMatInfo matInfo = new UpdateMatInfo();
        matInfo.setMatId(CadEmptyUtils.isEmpty((String)values[0]) ? 0L : Long.parseLong(values[0]));
        matInfo.setMatVersion(CadEmptyUtils.isEmpty((String)values[1]) ? 0L : Long.parseLong(values[1]));
        matInfo.setAuxptyId(CadEmptyUtils.isEmpty((String)values[2]) ? 0L : Long.parseLong(values[2]));
        matInfo.setKeyColId(CadEmptyUtils.isEmpty((String)values[3]) ? 0L : Long.parseLong(values[3]));
        matInfo.setElementId(CadEmptyUtils.isEmpty((String)values[4]) ? 0L : Long.parseLong(values[4]));
        matInfo.setSubElementId(CadEmptyUtils.isEmpty((String)values[5]) ? 0L : Long.parseLong(values[5]));
        return matInfo;
    }

    public void genCostInfo2Export(DynamicObject updatebill, DynamicObject establishedBill, Map<Long, String> relatedKeyColMap, Tuple<Map<String, BigDecimal>, Map<String, BigDecimal>> info, int startIndex, int endIndex) {
        HashSet keys = new HashSet(16);
        keys.addAll(((Map)info.item1).keySet());
        keys.addAll(((Map)info.item2).keySet());
        if (CadEmptyUtils.isEmpty(keys)) {
            return;
        }
        logger.info("\u6210\u672c\u4fe1\u606f\u6570\u636e\u91cf\uff1a" + keys.size());
        Map srcCostTypeCalc = (Map)info.item1;
        Map tarCostTypeCalc = (Map)info.item2;
        Set materialIds = CostTypeHelper.getMaterialByCostType((Long)updatebill.getLong("targetcosttype.id"));
        if (CadEmptyUtils.isEmpty((Set)materialIds)) {
            return;
        }
        int priceprecision = (Integer)updatebill.get("srccosttype.currency.priceprecision");
        BigDecimal zero = BigDecimal.ZERO.setScale(priceprecision, 4);
        DynamicObjectCollection matGroupColl = establishedBill.getDynamicObjectCollection("costupdateentry");
        matGroupColl.clear();
        logger.info("\u5f00\u59cb\u6210\u672c\u4fe1\u606f\u754c\u9762\u52a0\u8f7d");
        int i = -1;
        int index = 0;
        for (String key : keys) {
            UpdateMatInfo matInfo = this.getMatInfoByKey(key);
            if (matInfo == null || !materialIds.contains(matInfo.getMatId())) continue;
            BigDecimal newPrice = (BigDecimal)srcCostTypeCalc.get(key);
            newPrice = newPrice != null ? newPrice.setScale(priceprecision, 4) : zero;
            BigDecimal oldPrice = (BigDecimal)tarCostTypeCalc.get(key);
            BigDecimal bigDecimal = oldPrice = oldPrice != null ? oldPrice.setScale(priceprecision, 4) : zero;
            if (zero.compareTo(newPrice) == 0 && zero.compareTo(oldPrice) == 0 || ++i < startIndex) continue;
            if (i >= endIndex) break;
            DynamicObject advconap = matGroupColl.addNew();
            advconap.set("seq", (Object)index++);
            advconap.set("material_id", (Object)matInfo.getMatId());
            advconap.set("matversion_id", (Object)matInfo.getMatVersionId());
            advconap.set("auxprop_id", (Object)matInfo.getAuxptyId());
            advconap.set("element_id", (Object)matInfo.getElementId());
            advconap.set("subelement_id", (Object)matInfo.getSubElementId());
            advconap.set("newprice", (Object)newPrice);
            advconap.set("oldprice", (Object)oldPrice);
            advconap.set("diffprice", (Object)newPrice.subtract(oldPrice));
            advconap.set("srctype", (Object)(relatedKeyColMap.get(matInfo.getKeyColId()) == null ? Integer.valueOf(2) : (Serializable)((Object)relatedKeyColMap.get(matInfo.getKeyColId()))));
        }
        BusinessDataServiceHelper.loadRefence((Object[])matGroupColl.toArray((Object[])new DynamicObject[0]), (IDataEntityType)matGroupColl.getDynamicObjectType());
        logger.info("\u7ed3\u675f\u6210\u672c\u4fe1\u606f\u754c\u9762\u52a0\u8f7d");
    }

    /*
     * WARNING - void declaration
     */
    private static Boolean compareData(DynamicObject srcDynamicObject, DynamicObject tarDynamicObject) {
        void var10_14;
        String srcEntityName = srcDynamicObject.getDataEntityType().getName();
        String tarEntityName = tarDynamicObject.getDataEntityType().getName();
        String isCompareDataForPreUpdate = CadBgParamUtils.getCadBgParamForString((String)"isCompareDataForPreUpdate", (String)"1");
        if (!"1".equals(isCompareDataForPreUpdate)) {
            return Boolean.FALSE;
        }
        if (!("cad_calcsimulationresult".equals(srcEntityName) && "cad_matcostinfo".equals(tarEntityName) || "cad_trackstdcalcresult".equals(srcEntityName) && "cad_matcostinfo".equals(tarEntityName) || "cad_calcpurprices".equals(srcEntityName) && "cad_matcostinfo".equals(tarEntityName))) {
            return Boolean.FALSE;
        }
        DynamicObjectCollection srcEntrys = null;
        DynamicObjectCollection tarEntrys = null;
        HashMap srcMap = new HashMap(16);
        HashMap tarMap = new HashMap(16);
        String string = srcEntityName;
        int n = -1;
        switch (string.hashCode()) {
            case -2140368878: {
                if (!string.equals("cad_calcsimulationresult")) break;
                boolean bl = false;
                break;
            }
            case -1207233853: {
                if (!string.equals("cad_trackstdcalcresult")) break;
                boolean bl = true;
                break;
            }
            case -1328709079: {
                if (!string.equals("cad_calcpurprices")) break;
                int n2 = 2;
            }
        }
        switch (var10_14) {
            case 0: {
                DynamicObject tarEntry;
                BigDecimal value;
                DynamicObject srcEntry;
                int i;
                srcMap = Maps.newHashMapWithExpectedSize((int)16);
                tarMap = Maps.newHashMapWithExpectedSize((int)16);
                srcEntrys = srcDynamicObject.getDynamicObjectCollection("entryentity");
                tarEntrys = tarDynamicObject.getDynamicObjectCollection("entryentity");
                for (i = 0; i < srcEntrys.size(); ++i) {
                    srcEntry = (DynamicObject)srcEntrys.get(i);
                    String srcKey = srcEntry.getLong("element.id") + "@" + srcEntry.getLong("subelement.id");
                    value = (BigDecimal)srcMap.get(srcKey);
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    srcMap.put(srcKey, value.add(srcEntry.getBigDecimal("stdprice")));
                }
                for (i = 0; i < tarEntrys.size(); ++i) {
                    tarEntry = (DynamicObject)tarEntrys.get(i);
                    String tarKey = tarEntry.getLong("element.id") + "@" + tarEntry.getLong("subelement.id");
                    tarMap.put(tarKey, tarEntry.getBigDecimal("standardcost"));
                }
                break;
            }
            case 1: {
                int j;
                DynamicObject tarEntry;
                BigDecimal value;
                DynamicObject srcEntry;
                srcEntrys = srcDynamicObject.getDynamicObjectCollection("entryentity");
                if (srcEntrys.size() != 1) {
                    logger.info(String.format("\u8ddf\u8e2a\u7ed3\u679c\u8868ID:%s\uff0c\u7ea7\u6b21\u4e3a0\u7684\u6570\u636e\u6761\u6570\u4e0d\u7b49\u4e8e1", srcEntrys.size()));
                    return Boolean.FALSE;
                }
                srcEntrys = ((DynamicObject)srcEntrys.get(0)).getDynamicObjectCollection("subentryentity");
                tarEntrys = tarDynamicObject.getDynamicObjectCollection("entryentity");
                srcMap = Maps.newHashMapWithExpectedSize((int)16);
                tarMap = Maps.newHashMapWithExpectedSize((int)16);
                for (j = 0; j < srcEntrys.size(); ++j) {
                    srcEntry = (DynamicObject)srcEntrys.get(j);
                    String srcSubKey = srcEntry.getLong("element.id") + "@" + srcEntry.getLong("subelement.id");
                    value = (BigDecimal)srcMap.get(srcSubKey);
                    if (value == null) {
                        value = BigDecimal.ZERO;
                    }
                    srcMap.put(srcSubKey, value.add(srcEntry.getBigDecimal("stdprice")));
                }
                for (j = 0; j < tarEntrys.size(); ++j) {
                    tarEntry = (DynamicObject)tarEntrys.get(j);
                    String tarSubKey = tarEntry.getLong("element.id") + "@" + tarEntry.getLong("subelement.id");
                    tarMap.put(tarSubKey, tarEntry.getBigDecimal("standardcost"));
                }
                break;
            }
            case 2: {
                DynamicObject srcEntry;
                int i;
                srcEntrys = srcDynamicObject.getDynamicObjectCollection("entryentity");
                tarEntrys = tarDynamicObject.getDynamicObjectCollection("entryentity");
                if (srcEntrys.size() != tarEntrys.size()) {
                    return Boolean.FALSE;
                }
                srcMap = Maps.newHashMapWithExpectedSize((int)16);
                tarMap = Maps.newHashMapWithExpectedSize((int)16);
                for (i = 0; i < srcEntrys.size(); ++i) {
                    srcEntry = (DynamicObject)srcEntrys.get(i);
                    DynamicObject tarEntry = (DynamicObject)tarEntrys.get(i);
                    srcMap.put(srcEntry.getString("subelement.id"), srcEntry.getBigDecimal("price"));
                    tarMap.put(tarEntry.getString("subelement.id"), tarEntry.getBigDecimal("standardcost"));
                }
                break;
            }
        }
        if (tarMap.size() > srcMap.size()) {
            return Boolean.FALSE;
        }
        for (Map.Entry entry : srcMap.entrySet()) {
            String srckey = (String)entry.getKey();
            if (tarMap.get(srckey) == null) {
                logger.info(String.format("\u6a21\u62df\u8868ID:%s \u6a21\u62df\u8868key\uff1a%s\uff0c\u751f\u6548\u8868ID:%s", srcDynamicObject.getPkValue(), srckey, tarDynamicObject.getPkValue()));
                return Boolean.FALSE;
            }
            BigDecimal srcDecimal = (BigDecimal)entry.getValue();
            if (srcDecimal.compareTo((BigDecimal)tarMap.get(srckey)) == 0) continue;
            logger.info(String.format("\u6a21\u62df\u8868ID:%s \u6a21\u62df\u8868key\uff1a%s \u503c\uff1a%s\uff0c\u751f\u6548\u8868ID:%s \u503c:%s", srcDynamicObject.getPkValue(), srckey, srcDecimal.toString(), tarDynamicObject.getPkValue(), ((BigDecimal)tarMap.get(srckey)).toString()));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Tuple<Map<String, BigDecimal>, Map<String, BigDecimal>> getCostInfoAll(DynamicObject updatebill, Map<Long, String> relatedKeyColMap) {
        Tuple<Boolean, Boolean> updateWay = CostUpdateEstablishedHelper.getUpdateWay(updatebill.getLong("id"));
        boolean isquickupdate = updatebill.getBoolean("isquickupdate");
        long time = System.currentTimeMillis();
        Map<Long, DynamicObject> srcCostTypeCalc = this.getCalcResultData(updatebill.getLong("srccosttype.id"), updateWay, updatebill.getLong("calcrecord.id"), CostTypePtyEnum.SIMULATED, relatedKeyColMap, isquickupdate);
        logger.info("\u83b7\u53d6\u6a21\u62df\u6570\u636e(ms)\uff1a" + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Map<Long, DynamicObject> tarCostTypeCalc = this.getCalcResultData(updatebill.getLong("targetcosttype.id"), updateWay, null, CostTypePtyEnum.CALCULATING, relatedKeyColMap, isquickupdate);
        logger.info("\u83b7\u53d6\u6838\u7b97\u6570\u636e(ms)\uff1a" + (System.currentTimeMillis() - time));
        HashSet<Long> removeKeys = new HashSet<Long>(16);
        time = System.currentTimeMillis();
        for (Map.Entry<Long, DynamicObject> srcCalc : srcCostTypeCalc.entrySet()) {
            DynamicObject srcValue = srcCalc.getValue();
            DynamicObject tarValue = tarCostTypeCalc.get(srcCalc.getKey());
            if (tarValue == null || !MaterialCostProcessor.compareData(srcValue, tarValue).booleanValue()) continue;
            removeKeys.add(srcCalc.getKey());
        }
        logger.info("\u5dee\u5f02\u6bd4\u8f83(ms)\uff1a" + (System.currentTimeMillis() - time));
        HashSet<Long> srcKeys = new HashSet<Long>(srcCostTypeCalc.keySet());
        HashSet<Long> tarKeys = new HashSet<Long>(tarCostTypeCalc.keySet());
        logger.info(String.format("removeKeys:%s", removeKeys));
        logger.info(String.format("srcKeys:%s", srcKeys));
        logger.info(String.format("tarKeys:%s", tarKeys));
        tarKeys.removeAll(srcKeys);
        if (!CadEmptyUtils.isEmpty(tarKeys)) {
            removeKeys.addAll(tarKeys);
        }
        if (!CadEmptyUtils.isEmpty(removeKeys)) {
            srcCostTypeCalc.keySet().removeIf(p -> removeKeys.contains(p));
            tarCostTypeCalc.keySet().removeIf(p -> removeKeys.contains(p));
        }
        time = System.currentTimeMillis();
        Map<String, BigDecimal> srcData = this.getUpateMatInfo(srcCostTypeCalc.values());
        Map<String, BigDecimal> tarData = this.getUpateMatInfo(tarCostTypeCalc.values());
        logger.info("\u6570\u636e\u5408\u5e76(ms)\uff1a" + (System.currentTimeMillis() - time));
        return new Tuple(srcData, tarData);
    }

    private Map<String, BigDecimal> getUpateMatInfo(Collection<DynamicObject> values) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(values.size());
        block16: for (DynamicObject value : values) {
            String entityName;
            switch (entityName = value.getDataEntityType().getName()) {
                case "cad_calcsimulationresult": 
                case "cad_calceffectiveresult": {
                    BigDecimal val;
                    String key;
                    Object matInfo;
                    DynamicObjectCollection entrys = value.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        matInfo = new UpdateMatInfo();
                        ((UpdateMatInfo)matInfo).setMatId(value.getLong("material.id"));
                        ((UpdateMatInfo)matInfo).setMatVersion(value.getLong("matvers.id"));
                        ((UpdateMatInfo)matInfo).setAuxptyId(value.getLong("auxproperty.id"));
                        ((UpdateMatInfo)matInfo).setKeyColId(value.getLong("keycolid.id"));
                        ((UpdateMatInfo)matInfo).setElementId(entry.getLong("element.id"));
                        ((UpdateMatInfo)matInfo).setSubElementId(entry.getLong("subelement.id"));
                        key = ((UpdateMatInfo)matInfo).toString();
                        val = (BigDecimal)result.get(key);
                        if (val == null) {
                            val = BigDecimal.ZERO;
                        }
                        val = val.add(entry.getBigDecimal("stdprice"));
                        result.put(key, val);
                    }
                    continue block16;
                }
                case "cad_trackstdcalcresult": {
                    DynamicObjectCollection entrys = value.getDynamicObjectCollection("entryentity");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) break;
                    Iterator entry = (DynamicObject)entrys.get(0);
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntry : subEntrys) {
                        UpdateMatInfo matInfo = new UpdateMatInfo();
                        matInfo.setMatId(value.getLong("material.id"));
                        matInfo.setMatVersion(value.getLong("matvers.id"));
                        matInfo.setAuxptyId(value.getLong("auxproperty.id"));
                        matInfo.setKeyColId(value.getLong("keycolid.id"));
                        matInfo.setElementId(subEntry.getLong("element.id"));
                        matInfo.setSubElementId(subEntry.getLong("subelement.id"));
                        String key = matInfo.toString();
                        BigDecimal val = (BigDecimal)result.get(key);
                        if (val == null) {
                            val = BigDecimal.ZERO;
                        }
                        val = val.add(subEntry.getBigDecimal("stdprice"));
                        result.put(key, val);
                    }
                    continue block16;
                }
                case "cad_calcpurprices": 
                case "cad_purprices": {
                    BigDecimal val;
                    String key;
                    Object matInfo;
                    DynamicObjectCollection entrys = value.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        matInfo = new UpdateMatInfo();
                        ((UpdateMatInfo)matInfo).setMatId(value.getLong("material.id"));
                        ((UpdateMatInfo)matInfo).setMatVersion(value.getLong("matversion.id"));
                        ((UpdateMatInfo)matInfo).setAuxptyId(value.getLong("auxpty.id"));
                        ((UpdateMatInfo)matInfo).setKeyColId(value.getLong("keycolid.id"));
                        ((UpdateMatInfo)matInfo).setElementId(entry.getLong("element.id"));
                        ((UpdateMatInfo)matInfo).setSubElementId(entry.getLong("subelement.id"));
                        key = ((UpdateMatInfo)matInfo).toString();
                        val = (BigDecimal)result.get(key);
                        if (val == null) {
                            val = BigDecimal.ZERO;
                        }
                        val = val.add(entry.getBigDecimal("price"));
                        result.put(key, val);
                    }
                    continue block16;
                }
                case "cad_matcostinfo": {
                    BigDecimal val;
                    String key;
                    Object matInfo;
                    DynamicObjectCollection entrys = value.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        matInfo = new UpdateMatInfo();
                        ((UpdateMatInfo)matInfo).setMatId(value.getLong("material.id"));
                        ((UpdateMatInfo)matInfo).setMatVersion(value.getLong("matversion.id"));
                        ((UpdateMatInfo)matInfo).setAuxptyId(value.getLong("auxpty.id"));
                        ((UpdateMatInfo)matInfo).setKeyColId(value.getLong("keycolid.id"));
                        ((UpdateMatInfo)matInfo).setElementId(entry.getLong("element.id"));
                        ((UpdateMatInfo)matInfo).setSubElementId(entry.getLong("subelement.id"));
                        key = ((UpdateMatInfo)matInfo).toString();
                        val = (BigDecimal)result.get(key);
                        if (val == null) {
                            val = BigDecimal.ZERO;
                        }
                        val = val.add(entry.getBigDecimal("standardcost"));
                        result.put(key, val);
                    }
                    continue block16;
                }
                case "cad_outsourceprice": {
                    UpdateMatInfo matInfo = new UpdateMatInfo();
                    matInfo.setMatId(value.getLong("material.id"));
                    matInfo.setMatVersion(value.getLong("matversion.id"));
                    matInfo.setAuxptyId(value.getLong("auxpty.id"));
                    matInfo.setKeyColId(value.getLong("keycolid.id"));
                    matInfo.setElementId(value.getLong("element.id"));
                    matInfo.setSubElementId(value.getLong("subelement.id"));
                    String key = matInfo.toString();
                    BigDecimal val = (BigDecimal)result.get(key);
                    if (val == null) {
                        val = BigDecimal.ZERO;
                    }
                    val = val.add(value.getBigDecimal("price"));
                    result.put(key, val);
                    break;
                }
            }
        }
        return result;
    }

    public static boolean updateMatCostInfo(UpdateParam updateParam, Date effectTime, DynamicObject updateBill, Set<Long> keyColIds, Map<String, Long> matCostInfos) {
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return true;
        }
        boolean quickUpdateFlag = updateBill.getBoolean("isquickupdate");
        Set<Long> outKeyColIds = CostUpdateEstablishedHelper.getOutKeyColIds(updateBill.getLong("srccosttype.id"), keyColIds);
        if (quickUpdateFlag) {
            outKeyColIds.addAll(keyColIds);
        }
        logger.info("update outKeyColIds {}", outKeyColIds);
        String algokey = "kd.macc.cad.formplugin.costestablished.MaterialCostProcessor.updateMatCostInfo";
        boolean iscalccurlevel = updateBill.getBoolean("iscalccurlevel");
        ArrayList calcResult = new ArrayList(10);
        DataSet dealedDateSet = null;
        logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u5f85\u53d6\u6a21\u62df\u7ed3\u679c\u8868\u6570\u636e");
        QFilter srccostTypeFilter = new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id"));
        if (!quickUpdateFlag) {
            List ids;
            QFilter[] filters;
            if (Boolean.FALSE.equals(updateParam.getIsTrackUpdate())) {
                filters = new ArrayList(1);
                filters.add(new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id")));
                filters.add(new QFilter("keycolid", "in", keyColIds));
                if (Boolean.FALSE.equals(updateParam.getIsConfigUpdate()) && !CadEmptyUtils.isEmpty(outKeyColIds)) {
                    logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u53d6\u6a21\u62df\u8868\uff0c\u4e0d\u53d6\u5916\u8d2d\u7269\u6599keycolid\uff1a{}", outKeyColIds);
                    filters.add(new QFilter("keycolid", "not in", outKeyColIds));
                }
                filters.add(new QFilter("calcrecord", "=", (Object)(CadEmptyUtils.isEmpty((Long)updateBill.getLong("calcrecord.id")) ? Long.parseLong("0") : updateBill.getLong("calcrecord.id"))));
                filters.add(new QFilter("ismaindata", "=", (Object)1));
                filters.add(new QFilter("isleaf", "=", (Object)"0"));
                ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_calcsimulationresult", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u53d6\u6a21\u62df\u7ed3\u679c\u8868\u6570\u636e\u3002\u5171{}\u6761\u3002", (Object)ids);
                Lists.partition((List)ids, (int)1000).forEach(list -> {
                    OrmInput data = MaterialCostProcessor.getSimulationData("cad_calcsimulationresult", list, "calcdate,costtype,costtype.currency,level,keycol,keycolid,ismaindata,material,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,processroute,treepath,isleaf,rootnode,entryentity.calcbasis,entryentity.resource,entryentity.element,entryentity.subelement,entryentity.qty,entryentity.price,entryentity.stdprice,entryentity.subkeycol,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.subproject,entryentity.subtracknumber,entryentity.subconfiguredcode,entryentity.sublot,entryentity.datatype");
                    calcResult.add(data);
                });
            } else {
                filters = new QFilter[]{new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id")), new QFilter("keycolid", "in", keyColIds), new QFilter("ismaindata", "=", (Object)1), new QFilter("isleaf", "=", (Object)"0"), new QFilter("effectdate", "is null", null)};
                ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])filters, null, (int)-1);
                Lists.partition((List)ids, (int)1000).forEach(list -> {
                    OrmInput data = MaterialCostProcessor.getTrackSimulationData("cad_trackstdcalcresult", list, "calcdate,costtype,costtype.currency,entryentity.entrykeycol keycol,entryentity.entrykeycolid keycolid,entryentity.entryismaindata ismaindata,entryentity.entrymaterial material,entryentity.entryauxproperty auxproperty,entryentity.entrymatvers matvers,entryentity.entryproject project,entryentity.entrytracknumber tracknumber,entryentity.entryconfiguredcode configuredcode,entryentity.entrylot lot,entryentity.entrybomid bom,entryentity.entryprocessrouteid processroute,entryentity.entrytreepath treepath,entryentity.entryisleaf isleaf,entryentity.entryrootnode rootnode,entryentity.subentryentity.calcbasis entryentity.calcbasis,entryentity.subentryentity.resource entryentity.resource,entryentity.subentryentity.element entryentity.element,entryentity.subentryentity.subelement entryentity.subelement,entryentity.subentryentity.qty entryentity.qty,entryentity.subentryentity.price entryentity.price,entryentity.subentryentity.stdprice entryentity.stdprice,entryentity.subentryentity.subkeycol entryentity.subkeycol,entryentity.subentryentity.submaterial entryentity.submaterial,entryentity.subentryentity.submatvers entryentity.submatvers,entryentity.subentryentity.subauxproperty entryentity.subauxproperty,entryentity.subentryentity.subproject entryentity.subproject,entryentity.subentryentity.subtracknumber entryentity.subtracknumber,entryentity.subentryentity.subconfiguredcode entryentity.subconfiguredcode,entryentity.subentryentity.sublot entryentity.sublot,entryentity.subentryentity.datatype entryentity.datatype");
                    calcResult.add(data);
                });
            }
            logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u6a21\u62df\u7ed3\u679c\u8868\u6570\u636e\u5408\u5e76\u3002\u5171{}\u6761\u3002", (Object)calcResult.size());
            if (!CadEmptyUtils.isEmpty(calcResult)) {
                Algo algo = Algo.create((String)(algokey + ".calcResult"));
                DataSet calcResultDateSet = algo.createDataSet((Input[])calcResult.toArray(new OrmInput[calcResult.size()]));
                StringBuilder sb = new StringBuilder("select ");
                sb.append("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,entryentity.element,entryentity.subelement").append(',');
                sb.append("sum(case when entryentity.datatype in ('2','3') then entryentity.stdprice else 0 end) as stdprice,");
                sb.append("sum(case when entryentity.datatype in ('2','4') then entryentity.stdprice else 0 end) as stepamt ");
                sb.append("group by ");
                sb.append("calcdate,costtype,costtype.currency,keycol,keycolid,material,isleaf,auxproperty,matvers,project,tracknumber,configuredcode,lot,bom,entryentity.element,entryentity.subelement");
                sb.append(" having stdprice != 0 ");
                dealedDateSet = calcResultDateSet.executeSql(sb.toString());
                DataSetUtils.colse((DataSet)calcResultDateSet);
            }
            logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u6a21\u62df\u7ed3\u679c\u8868\u6570\u636e\u5408\u5e76\u5b8c\u6210");
            if ((dealedDateSet == null || dealedDateSet.isEmpty()) && !QueryServiceHelper.exists((String)"cad_calcpurprices", (QFilter[])new QFilter[]{srccostTypeFilter})) {
                PageCache pageCache = new PageCache(updateParam.getPageId());
                pageCache.put("costupdatetip", "TIP_A");
                pageCache.put("startprogress", "false");
                return false;
            }
        }
        DynamicObject targetcostype = updateBill.getDynamicObject("targetcosttype");
        Long targetCostTypeId = targetcostype.getLong("id");
        Boolean isAllUpdate = updateBill.getBoolean("isallupdate");
        if (Boolean.TRUE.equals(isAllUpdate)) {
            CostUpdateEstablishedHelper.dealNotExistsDataByAll("cad_matcostinfo", updateBill, effectTime);
            CostUpdateEstablishedHelper.dealAgainExistsDataByAll("cad_matcostinfo", updateBill, keyColIds);
        }
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)targetCostTypeId), new QFilter("keycolid", "in", keyColIds), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate())};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_matcostinfo", (QFilter[])filters, null, (int)-1);
        Lists.partition((List)ids, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_matcostinfo", list, effectTime, null, null));
        logger.info("\u66f4\u65b0\u7269\u6599\u6210\u672c\u4fe1\u606f\u5931\u6548\u65e5\u671f,{}", (Object)ids);
        if (ids != null && ids.size() > 0) {
            QFilter[] qf = new QFilter[]{new QFilter("costtype", "=", (Object)targetCostTypeId), new QFilter("matcostid", "in", (Object)ids), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate())};
            List ids2 = QueryServiceHelper.queryPrimaryKeys((String)"cad_calceffectiveresult", (QFilter[])qf, null, (int)-1);
            Lists.partition((List)ids2, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_calceffectiveresult", list, effectTime, null, null));
            logger.info("\u66f4\u65b0\u751f\u6548\u5377\u7b97\u7ed3\u679c\u8868\u5931\u6548\u65e5\u671f,{}", (Object)ids2);
        }
        Map bomSetRelatParam = NewStdCalculateHelper.getBomSetRelatPara((Long)updateBill.getLong("srccosttype.id"));
        Map ruteSetRelatParam = NewStdCalculateHelper.getRuteSetRelatPara((Long)updateBill.getLong("srccosttype.id"));
        if (dealedDateSet != null && !dealedDateSet.isEmpty()) {
            logger.info("\u590d\u5236\u6570\u636e\u6e90dealedDateSet");
            DataSet dealDataSet = dealedDateSet.copy();
            logger.info("\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f-\u6570\u636e\u6765\u6e90\uff1a\u6a21\u62df\u5377\u7b97\u7ed3\u679c\u8868");
            Map matCost = NewStdCalculateHelper.saveMatCostInfo((DataSet)dealDataSet, (Map)bomSetRelatParam, (Map)ruteSetRelatParam, (DynamicObject)targetcostype, (boolean)false, (Date)effectTime, (boolean)iscalccurlevel, (boolean)true);
            DataSetUtils.colse((DataSet)dealDataSet);
            matCostInfos.putAll(matCost);
            logger.info("\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f-dealedDateSet-\u5b8c\u6210\u3002\u5171{}\u6761\u3002", (Object)matCost.size());
        }
        if (Boolean.TRUE.equals(updateParam.getIsTrackUpdate())) {
            return true;
        }
        HashSet<Long> proKeyColIds = new HashSet<Long>(16);
        if (dealedDateSet != null && !dealedDateSet.isEmpty()) {
            DataSet dealDataSet = dealedDateSet.executeSql("select keycolid");
            for (Row row : dealDataSet) {
                proKeyColIds.add(row.getLong("keycolid"));
            }
            DataSetUtils.colse((DataSet)dealDataSet);
        }
        HashSet<Long> allKeyColIds = new HashSet<Long>(keyColIds.size());
        allKeyColIds.addAll(keyColIds);
        allKeyColIds.removeAll(proKeyColIds);
        if (!CadEmptyUtils.isEmpty(allKeyColIds)) {
            QFilter qfPurMat = new QFilter("keycolid", "in", allKeyColIds);
            DataSet purPriceDateSet = QueryServiceHelper.queryDataSet((String)algokey, (String)"cad_calcpurprices", (String)"costtype,costtype.currency,material,matversion matvers,auxpty auxproperty,project,tracknumber,configuredcode,lot,keycol,keycolid,entryentity.element,entryentity.subelement,entryentity.price stdprice,entryentity.price stepamt", (QFilter[])new QFilter[]{srccostTypeFilter, qfPurMat}, null);
            if (purPriceDateSet != null && !purPriceDateSet.isEmpty()) {
                logger.info("\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f-\u6570\u636e\u6765\u6e90\uff1a\u5916\u8d2d\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868");
                Map matCost = NewStdCalculateHelper.saveMatCostInfo((DataSet)purPriceDateSet, (Map)bomSetRelatParam, (Map)ruteSetRelatParam, (DynamicObject)targetcostype, (boolean)true, (Date)effectTime, (boolean)iscalccurlevel, (boolean)true);
                matCostInfos.putAll(matCost);
                logger.info("\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f-\u6570\u636e\u6765\u6e90\uff1a\u5916\u8d2d\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868-\u5b8c\u6210\u3002\u5171{}\u6761\u3002", (Object)matCostInfos.size());
            }
            DataSetUtils.colse((DataSet)purPriceDateSet);
        }
        logger.info("\u4fdd\u5b58\u7269\u6599\u6210\u672c\u4fe1\u606f\u5b8c\u6bd5");
        DataSetUtils.colse((DataSet[])new DataSet[]{dealedDateSet});
        return true;
    }

    private Map<Long, DynamicObject> getCalcResultData(Long costTypeId, Tuple<Boolean, Boolean> updateWay, Long calcRecordId, CostTypePtyEnum srcType, Map<Long, String> relatedKeyColMap, boolean isquickupdate) {
        Map<Long, DynamicObject> purPriceInfo;
        List ids;
        Map<Long, DynamicObject> costInfo = new HashMap<Long, DynamicObject>(1);
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        if (CostTypePtyEnum.SIMULATED == srcType) {
            filter.and("calcrecord", "=", (Object)(CadEmptyUtils.isEmpty((Long)calcRecordId) ? Long.valueOf("0") : calcRecordId));
        }
        if (relatedKeyColMap.size() != 0) {
            filter.and("keycolid", "in", relatedKeyColMap.keySet());
        }
        filter.and("ismaindata", "=", (Object)1);
        filter.and("isleaf", "=", (Object)"0");
        QFilter expdateFilter = new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate());
        if (CostTypePtyEnum.SIMULATED == srcType) {
            if (!isquickupdate) {
                if (Boolean.FALSE.equals(updateWay.item1)) {
                    Set<Long> notDownKeyColIds;
                    if (Boolean.FALSE.equals(updateWay.item2) && !CadEmptyUtils.isEmpty(notDownKeyColIds = CostUpdateEstablishedHelper.getOutKeyColIds(costTypeId, null))) {
                        filter.and("keycolid", "not in", notDownKeyColIds);
                    }
                    ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{filter}, null, (int)-1);
                    costInfo = this.getCostData("cad_calcsimulationresult", ids, "material,auxproperty,matvers,bom,keycolid,entryentity.datatype,entryentity.calcbasis,entryentity.resource,entryentity.element,entryentity.subelement,entryentity.submaterial,entryentity.qty,entryentity.stdprice,entryentity.subkeycolid");
                } else if (!CadEmptyUtils.isEmpty(relatedKeyColMap)) {
                    filter = new QFilter("costtype", "=", (Object)costTypeId);
                    filter.and("keycolid", "in", relatedKeyColMap.keySet());
                    filter.and("ismaindata", "=", (Object)1);
                    filter.and("isleaf", "=", (Object)"0");
                    filter.and("effectdate", "is null", null);
                    filter.and("entryentity.entrylevel", "=", (Object)0);
                    ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])new QFilter[]{filter}, null, (int)-1);
                    costInfo.putAll(this.getCostData("cad_trackstdcalcresult", ids, "material,auxproperty,matvers,bomid,keycolid,entryentity.entrykeycolid,entryentity.entrylevel,subentryentity.datatype,subentryentity.calcbasis,subentryentity.resource,subentryentity.element,subentryentity.subelement,subentryentity.submaterial,subentryentity.qty,subentryentity.stdprice,subentryentity.subkeycolid"));
                }
            }
        } else {
            filter = new QFilter("costtype", "=", (Object)costTypeId);
            if (relatedKeyColMap.size() != 0) {
                filter.and("keycolid", "in", relatedKeyColMap.keySet());
            }
            filter.and(expdateFilter);
            ids = QueryServiceHelper.queryPrimaryKeys((String)"cad_matcostinfo", (QFilter[])new QFilter[]{filter}, null, (int)-1);
            costInfo = this.getCostData("cad_matcostinfo", ids, "currency,material,lot,configuredcode,tracknumber,project,matversion,auxpty,keycol,keycolid,status,enable,bomtype,bom,processroute,processversion,consideryieldrate,considersubmaterialloss,considerpreparetime,considervalidperiod,iscalccurlevel,entryentity.element,entryentity.subelement,entryentity.standardcost,entryentity.stepamt");
        }
        if (Boolean.TRUE.equals(updateWay.item1)) {
            logger.info("\u8ddf\u8e2a\u53f7\u4e0d\u5904\u7406\u5916\u8d2d\u4ef6\uff0c{}", updateWay.item2);
            return costInfo;
        }
        HashSet<Long> productKeyColIds = new HashSet<Long>(16);
        for (Map.Entry info : costInfo.entrySet()) {
            productKeyColIds.add(((DynamicObject)info.getValue()).getLong("keycolid.id"));
        }
        filter = new QFilter("costtype", "=", (Object)costTypeId);
        HashSet newIds = Sets.newHashSet(relatedKeyColMap.keySet());
        newIds.removeAll(productKeyColIds);
        if (relatedKeyColMap.size() != 0) {
            filter.and("keycolid", "in", (Object)newIds);
        }
        if (CostTypePtyEnum.SIMULATED == srcType) {
            List ids2 = QueryServiceHelper.queryPrimaryKeys((String)"cad_calcpurprices", (QFilter[])new QFilter[]{filter}, null, (int)-1);
            purPriceInfo = this.getCostData("cad_calcpurprices", ids2, "material,auxpty,matversion,keycolid,entryentity.element,entryentity.subelement,entryentity.price");
        } else {
            filter.and(expdateFilter);
            List ids3 = QueryServiceHelper.queryPrimaryKeys((String)"cad_matcostinfo", (QFilter[])new QFilter[]{filter}, null, (int)-1);
            purPriceInfo = this.getCostData("cad_matcostinfo", ids3, "currency,material,lot,configuredcode,tracknumber,project,matversion,auxpty,keycol,keycolid,status,enable,bomtype,bom,processroute,processversion,consideryieldrate,considersubmaterialloss,considerpreparetime,considervalidperiod,iscalccurlevel,entryentity.element,entryentity.subelement,entryentity.standardcost,entryentity.stepamt");
        }
        purPriceInfo.putAll(costInfo);
        return purPriceInfo;
    }

    private Map<Long, DynamicObject> getCostData(String entityName, List<Object> ids, String selectFields) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        Lists.partition(ids, (int)1000).forEach(id -> result.putAll(this.getData(entityName, (List<Object>)id, selectFields)));
        return result;
    }

    private Map<Long, DynamicObject> getData(String entityName, List<Object> ids, String selectFields) {
        DynamicObject[] datas;
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(16);
        ArrayList<QFilter> newFilters = new ArrayList<QFilter>(10);
        newFilters.add(new QFilter("id", "in", ids));
        if ("cad_calcsimulationresult".equals(entityName) || "cad_calceffectiveresult".equals(entityName)) {
            newFilters.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3"}));
        }
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])newFilters.toArray(new QFilter[0]), null)) {
            DynamicObjectCollection entrys;
            if ("cad_calcsimulationresult".equals(entityName) || "cad_calceffectiveresult".equals(entityName)) {
                entrys = data.getDynamicObjectCollection("entryentity");
                entrys.removeIf(p -> !"2".equals(p.getString("datatype")) && !"3".equals(p.getString("datatype")));
            } else if ("cad_trackstdcalcresult".equals(entityName)) {
                entrys = data.getDynamicObjectCollection("entryentity");
                entrys.removeIf(p -> p.getInt("entrylevel") != 0);
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    subEntrys.removeIf(p -> !"2".equals(p.getString("datatype")) && !"3".equals(p.getString("datatype")));
                }
            }
            result.put(this.getCalcKey(data), data);
        }
        return result;
    }

    private Long getCalcKey(DynamicObject data) {
        Long keyColId = data.getLong("keycolid.id");
        if (!CadEmptyUtils.isEmpty((Long)keyColId)) {
            return keyColId;
        }
        logger.info(String.format("\u5f02\u5e38\u6570\u636e%s\uff0c\u7269\u6599id=%s", data.getDataEntityType().getName(), data.getString("material.id")));
        return -1L;
    }

    private static OrmInput getSimulationData(String entityName, List<Object> ids, String selectFields) {
        String algoKey = "kd.macc.cad.formplugin.costestablished.MaterialCostProcessor.getSimulationData";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "3", "4"})};
        return new OrmInput(algoKey, entityName, selectFields, filters);
    }

    private static OrmInput getTrackSimulationData(String entityName, List<Object> ids, String selectFields) {
        String algoKey = "kd.macc.cad.formplugin.costestablished.MaterialCostProcessor.getTrackSimulationData";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("entryentity.entrylevel", "=", (Object)0), new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"2", "3", "4"})};
        return new OrmInput(algoKey, entityName, selectFields, filters);
    }

    public static boolean updateAttachCostType(DynamicObject updateBill, DynamicObject establishedBill, Date effectTime, Map<String, Long> matCostInfos) {
        ArrayList<Long> srcMatCostInfoIds = new ArrayList<Long>(matCostInfos.size());
        for (Map.Entry<String, Long> matCost : matCostInfos.entrySet()) {
            srcMatCostInfoIds.add(matCost.getValue());
        }
        if (CadEmptyUtils.isEmpty(srcMatCostInfoIds)) {
            logger.info("\u9644\u52a0\u6210\u672c\u7c7b\u578b\u83b7\u53d6\u6838\u7b97\u5c5e\u6027\u4e0b\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e3a\u7a7a\u3002");
            return true;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", srcMatCostInfoIds)};
        Object[] srcMatCostInfos = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)"currency,material,lot,configuredcode,tracknumber,project,matversion,auxpty,keycol,keycolid,status,enable,bomtype,bom,processroute,processversion,consideryieldrate,considersubmaterialloss,considerpreparetime,considervalidperiod,iscalccurlevel,entryentity.element,entryentity.subelement,entryentity.standardcost,entryentity.stepamt", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((Object[])srcMatCostInfos)) {
            return true;
        }
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        HashMap<Long, Set> costTypeKeyColIds = new HashMap<Long, Set>(entrys.size());
        for (DynamicObject entry : entrys) {
            costTypeKeyColIds.computeIfAbsent(entry.getLong("costtype.id"), val -> new HashSet()).add(entry.getLong("keycolid.id"));
        }
        DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
        DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
            Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
            Set targetKeyColIds = (Set)costTypeKeyColIds.get(targetCostTypeId);
            if (CadEmptyUtils.isEmpty((Set)targetKeyColIds)) continue;
            HashSet tarExistsData = new HashSet(10);
            Boolean isAllUpdate = updateBill.getBoolean("isallupdate");
            if (Boolean.TRUE.equals(isAllUpdate)) {
                CostUpdateEstablishedHelper.dealNotExistsDataByAll("cad_matcostinfo", updateBill, effectTime);
                CostUpdateEstablishedHelper.dealAgainExistsDataByAll("cad_matcostinfo", updateBill, targetKeyColIds);
                CostUpdateEstablishedHelper.dealNotExistsDataByAll("cad_calcpurprices", updateBill, effectTime);
            }
            filters = new QFilter[]{new QFilter("costtype", "=", (Object)updateBill.getLong("targetcosttype.id")), new QFilter("keycolid", "in", (Object)targetKeyColIds), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("effectdate", "<=", (Object)effectTime), new QFilter("expdate", ">", (Object)effectTime)};
            List toIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_matcostinfo", (QFilter[])filters, null, (int)-1);
            Lists.partition((List)toIds, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_matcostinfo", list, effectTime, "keycolid", tarExistsData));
            filters = new QFilter[]{new QFilter("costtype", "=", (Object)updateBill.getLong("targetcosttype.id")), new QFilter("keycolid", "in", (Object)targetKeyColIds), new QFilter("billstatus", "=", (Object)"C")};
            toIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_purprices", (QFilter[])filters, null, (int)-1);
            Lists.partition((List)toIds, (int)1000).forEach(list -> CostUpdateEstablishedHelper.dealExistsDataByPart("cad_calcpurprices", list, effectTime, "keycolid", tarExistsData));
            Map matExistExpdates = NewStdCalculateHelper.getExistMaxExpdate((String)"cad_matcostinfo", (Long)updateBill.getLong("targetcosttype.id"), (Set)targetKeyColIds);
            List<Object> srcMatCosts = Arrays.asList(srcMatCostInfos);
            Lists.partition(srcMatCosts, (int)1000).forEach(list -> {
                ArrayList<DynamicObject> fromObjs = new ArrayList<DynamicObject>(list.size());
                for (DynamicObject lt : list) {
                    if (!targetKeyColIds.contains(lt.getLong("keycolid.id"))) continue;
                    fromObjs.add(lt);
                }
                HashMap<Long, Long> subMatCostInfo = new HashMap<Long, Long>(fromObjs.size());
                MaterialCostProcessor.saveMatCostInfo(fromObjs, updateBill, matExistExpdates, subMatCostInfo, matCostInfos);
                MaterialCostProcessor.savePurPrice(fromObjs, updateBill, matExistExpdates, subMatCostInfo);
            });
        }
        updateBill.set("targetcosttype", (Object)originalTargetCostType);
        return true;
    }

    private static boolean saveMatCostInfo(List<DynamicObject> fromObjs, DynamicObject updateBill, Map<Long, Date> matExistExpdates, Map<Long, Long> subMatCostInfo, Map<String, Long> matCostInfosMap) {
        ArrayList<DynamicObject> matCostInfos = new ArrayList<DynamicObject>(fromObjs.size());
        long[] ids = DBServiceHelper.genLongIds((String)"t_bd_matcostinfo", (int)fromObjs.size());
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        for (int i = 0; i < fromObjs.size(); ++i) {
            DynamicObject fromObj = fromObjs.get(i);
            subMatCostInfo.put(fromObj.getLong("id"), ids[i]);
            DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_matcostinfo");
            EntityUtil.copyPropertiesWithOutId((DynamicObject)tarObj, (DynamicObject)fromObj);
            tarObj.set("id", (Object)ids[i]);
            tarObj.set("masterid", (Object)ids[i]);
            tarObj.set("costtype", updateBill.get("targetcosttype"));
            tarObj.set("datasource", (Object)"syscopy");
            Date effectTime = matExistExpdates.get(tarObj.getLong("keycolid.id"));
            if (effectTime == null) {
                effectTime = TimeUtils.getDefaultEffectDate();
            }
            tarObj.set("effectdate", (Object)effectTime);
            tarObj.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            tarObj.set("remark", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6309\u76ee\u6807\u6210\u672c\u7c7b\u578b\u6210\u672c\u590d\u5236\u751f\u6210\u3002", (String)"MaterialCostProcessor_0", (String)"macc-cad-business", (Object[])new Object[0]));
            tarObj.set("creator", (Object)userId);
            tarObj.set("createtime", (Object)time);
            tarObj.set("modifier", (Object)userId);
            tarObj.set("modifytime", (Object)time);
            tarObj.set("auditor", (Object)userId);
            tarObj.set("audittime", (Object)time);
            Long costTypeId = 0L;
            costTypeId = tarObj.get("costtype") instanceof DynamicObject ? Long.valueOf(tarObj.getLong("costtype.id")) : Long.valueOf(tarObj.getLong("costtype"));
            String key = costTypeId + "@" + tarObj.getString("keycol");
            matCostInfosMap.put(key, tarObj.getLong("id"));
            matCostInfos.add(tarObj);
        }
        if (!CadEmptyUtils.isEmpty(matCostInfos)) {
            SaveServiceHelper.save((DynamicObject[])matCostInfos.toArray(new DynamicObject[0]));
        }
        return true;
    }

    private static boolean savePurPrice(List<DynamicObject> fromObjs, DynamicObject updateBill, Map<Long, Date> matExistExpdates, Map<Long, Long> subMatCostInfo) {
        ArrayList<DynamicObject> purPrices = new ArrayList<DynamicObject>(fromObjs.size());
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"cad_purprices", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices"), null, (int)fromObjs.size());
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date time = TimeServiceHelper.now();
        for (int i = 0; i < fromObjs.size(); ++i) {
            DynamicObject fromObj = fromObjs.get(i);
            DynamicObject tarObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_purprices");
            tarObj.set("costtype", updateBill.get("targetcosttype"));
            tarObj.set("billno", (Object)numbers[i]);
            tarObj.set("currency", (Object)fromObj.getLong("currency.id"));
            tarObj.set("remark", (Object)ResManager.loadKDString((String)"\u7269\u6599\u6210\u672c\u4fe1\u606f\u590d\u5236\u751f\u6210\u3002", (String)"MaterialCostProcessor_1", (String)"macc-cad-business", (Object[])new Object[0]));
            tarObj.set("datasrc", (Object)"costupdate");
            tarObj.set("material", (Object)fromObj.getLong("material.id"));
            tarObj.set("lot", (Object)fromObj.getString("lot"));
            tarObj.set("configuredcode", (Object)fromObj.getLong("configuredcode.id"));
            tarObj.set("tracknumber", (Object)fromObj.getLong("tracknumber.id"));
            tarObj.set("project", (Object)fromObj.getLong("project.id"));
            tarObj.set("matversion", (Object)fromObj.getLong("matversion.id"));
            tarObj.set("auxpty", (Object)fromObj.getLong("auxpty.id"));
            tarObj.set("pricerule", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
            tarObj.set("keycol", (Object)fromObj.getString("keycol"));
            tarObj.set("keycolid", (Object)fromObj.getLong("keycolid.id"));
            Date effectTime = matExistExpdates.get(fromObj.getLong("keycolid.id"));
            if (effectTime == null) {
                effectTime = TimeUtils.getDefaultEffectDate();
            }
            tarObj.set("effectdate", (Object)effectTime);
            tarObj.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
            DynamicObjectCollection purEntrys = tarObj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection matEntrys = fromObj.getDynamicObjectCollection("entryentity");
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject matEntry : matEntrys) {
                DynamicObject entry = purEntrys.addNew();
                entry.set("element", (Object)matEntry.getLong("element.id"));
                entry.set("subelement", (Object)matEntry.getLong("subelement.id"));
                BigDecimal standardCost = matEntry.getBigDecimal("standardcost");
                entry.set("price", (Object)standardCost);
                amount = amount.add(standardCost);
            }
            tarObj.set("amount", (Object)amount);
            tarObj.set("billstatus", (Object)"C");
            Long matCostInfoId = subMatCostInfo.get(fromObj.getLong("id"));
            if (CadEmptyUtils.isEmpty((Long)matCostInfoId)) {
                matCostInfoId = 0L;
            }
            tarObj.set("matcostid", (Object)matCostInfoId);
            tarObj.set("creator", (Object)userId);
            tarObj.set("createtime", (Object)time);
            tarObj.set("modifier", (Object)userId);
            tarObj.set("modifytime", (Object)time);
            tarObj.set("auditor", (Object)userId);
            tarObj.set("auditdate", (Object)time);
            purPrices.add(tarObj);
        }
        if (!CadEmptyUtils.isEmpty(purPrices)) {
            SaveServiceHelper.save((DynamicObject[])purPrices.toArray(new DynamicObject[0]));
        }
        return true;
    }
}

