/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.business.update.CostUpdateEstablishedHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang.StringUtils;

public class ProdCostProcessor {
    private Log logger = LogFactory.getLog(ProdCostProcessor.class);

    public void genProCostInfo(DynamicObject updateBill, DynamicObject establishedBill) {
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("productentry");
        entrys.clear();
        boolean isAutoEndPeriodCal = CostUpdateHelper.isAutoEndPeriodCalPage();
        if (Boolean.FALSE.equals(isAutoEndPeriodCal)) {
            return;
        }
        if (Boolean.TRUE.equals(this.isNeedProdData(establishedBill))) {
            return;
        }
        DataSet diffDataSet = null;
        try {
            diffDataSet = this.getDiffData(updateBill, establishedBill);
            DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
            DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
            for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
                updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
                DataSet attachdiffDataSet = this.getDiffData(updateBill, establishedBill);
                if (attachdiffDataSet == null || attachdiffDataSet.isEmpty()) continue;
                diffDataSet = DataSetUtils.union((DataSet)diffDataSet, (DataSet)attachdiffDataSet);
            }
            updateBill.set("targetcosttype", (Object)originalTargetCostType);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        if (diffDataSet == null || diffDataSet.isEmpty()) {
            return;
        }
        int amtprecision = establishedBill.getInt("srccosttype.currency.amtprecision");
        for (Row row : diffDataSet) {
            BigDecimal newCost;
            DynamicObject entry;
            String newClacBasis;
            String oldClacBasis = row.getString("oldcalcbasis") == null ? "" : row.getString("oldcalcbasis");
            String string = newClacBasis = row.getString("newcalcbasis") == null ? "" : row.getString("newcalcbasis");
            if (oldClacBasis.equals(newClacBasis)) {
                entry = entrys.addNew();
                entry.set("org_id", row.get("orgid"));
                entry.set("period_id", row.get("periodid"));
                entry.set("costaccountbook_id", row.get("costaccountid"));
                entry.set("costcenter_id", row.get("costcenterid"));
                entry.set("costobject_id", row.get("costobjectid"));
                entry.set("manuorg_id", row.get("manuorgid"));
                entry.set("procelement_id", row.get("elementid"));
                entry.set("procsubelement_id", row.get("subelementid"));
                entry.set("prosubmaterial_id", row.get("submaterialid"));
                entry.set("promatversion_id", row.get("submatverid"));
                entry.set("proauxpty_id", row.get("subauxptyid"));
                entry.set("prokeycolid_id", row.get("subkeycolid"));
                entry.set("resource_id", row.get("resourceid"));
                entry.set("costlevel", row.get("oldcostlevel"));
                entry.set("calcbasis", (Object)newClacBasis);
                entry.set("productcost", (Object)this.convertBigDecimal(row.getBigDecimal("oldcost"), amtprecision));
                entry.set("updatedcost", (Object)this.convertBigDecimal(row.getBigDecimal("newcost"), amtprecision));
                entry.set("updatediff", (Object)this.convertBigDecimal(row.getBigDecimal("diffcost"), amtprecision));
                continue;
            }
            entry = entrys.addNew();
            BigDecimal oldCost = this.convertBigDecimal(row.getBigDecimal("oldcost"), amtprecision);
            if (BigDecimal.ZERO.compareTo(oldCost) != 0) {
                entry.set("org_id", row.get("orgid"));
                entry.set("period_id", row.get("periodid"));
                entry.set("costaccountbook_id", row.get("costaccountid"));
                entry.set("costcenter_id", row.get("costcenterid"));
                entry.set("costobject_id", row.get("costobjectid"));
                entry.set("manuorg_id", row.get("manuorgid"));
                entry.set("procelement_id", row.get("elementid"));
                entry.set("procsubelement_id", row.get("subelementid"));
                entry.set("prosubmaterial_id", row.get("submaterialid"));
                entry.set("promatversion_id", row.get("submatverid"));
                entry.set("proauxpty_id", row.get("subauxptyid"));
                entry.set("prokeycolid_id", row.get("subkeycolid"));
                entry.set("resource_id", row.get("resourceid"));
                entry.set("costlevel", row.get("oldcostlevel"));
                entry.set("calcbasis", (Object)oldClacBasis);
                entry.set("productcost", (Object)oldCost);
                entry.set("updatedcost", (Object)BigDecimal.ZERO);
                entry.set("updatediff", (Object)BigDecimal.ZERO.subtract(oldCost));
            }
            if (BigDecimal.ZERO.compareTo(newCost = this.convertBigDecimal(row.getBigDecimal("newcost"), amtprecision)) == 0) continue;
            entry = entrys.addNew();
            entry.set("org_id", row.get("orgid"));
            entry.set("period_id", row.get("periodid"));
            entry.set("costaccountbook_id", row.get("costaccountid"));
            entry.set("costcenter_id", row.get("costcenterid"));
            entry.set("costobject_id", row.get("costobjectid"));
            entry.set("manuorg_id", row.get("manuorgid"));
            entry.set("procelement_id", row.get("elementid"));
            entry.set("procsubelement_id", row.get("subelementid"));
            entry.set("prosubmaterial_id", row.get("submaterialid"));
            entry.set("promatversion_id", row.get("submatverid"));
            entry.set("proauxpty_id", row.get("subauxptyid"));
            entry.set("prokeycolid_id", row.get("subkeycolid"));
            entry.set("resource_id", row.get("resourceid"));
            entry.set("costlevel", row.get("newcostlevel"));
            entry.set("calcbasis", (Object)newClacBasis);
            entry.set("productcost", (Object)BigDecimal.ZERO);
            entry.set("updatedcost", (Object)newCost);
            entry.set("updatediff", (Object)newCost);
        }
        DataSetUtils.colse((DataSet)diffDataSet);
        BusinessDataServiceHelper.loadRefence((Object[])entrys.toArray((Object[])new DynamicObject[0]), (IDataEntityType)entrys.getDynamicObjectType());
    }

    public void genCalcResult(DynamicObject updateBill, DynamicObject establishedBill) {
        DynamicObjectCollection prodCostEntrys = establishedBill.getDynamicObjectCollection("productentry");
        HashMap<String, Map<String, BigDecimal>> prodCostDiffInfoMap = new HashMap<String, Map<String, BigDecimal>>();
        for (DynamicObject prodCostEntry : prodCostEntrys) {
            StringBuilder key = new StringBuilder();
            List<String> keyFields = Arrays.asList("org.id", "costaccountbook.id", "costcenter.id", "costobject.id");
            for (int index = 0; index < keyFields.size(); ++index) {
                key.append(prodCostEntry.getString(keyFields.get(index))).append("@");
            }
            String calcBasis = "".equals(prodCostEntry.getString("calcbasis")) ? "0" : prodCostEntry.getString("calcbasis");
            String diffInfoKey = "2@" + prodCostEntry.getString("procelement.masterid") + "@" + prodCostEntry.getString("procsubelement.masterid") + "@" + prodCostEntry.getString("prosubmaterial.masterid") + "@" + prodCostEntry.getString("promatversion.id") + "@" + prodCostEntry.getString("proauxpty.id") + "@" + prodCostEntry.get("resource.masterid") + "@" + prodCostEntry.getString("costlevel") + "@" + calcBasis;
            String diffInfoKey1 = "1@" + prodCostEntry.getString("procelement.masterid") + "@" + prodCostEntry.getString("procsubelement.masterid") + "@" + prodCostEntry.getString("prosubmaterial.masterid") + "@" + prodCostEntry.getString("promatversion.id") + "@" + prodCostEntry.getString("proauxpty.id") + "@" + prodCostEntry.get("resource.masterid") + "@" + prodCostEntry.getString("costlevel") + "@" + calcBasis;
            BigDecimal diffcost = prodCostEntry.getBigDecimal("updatediff");
            if (BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
            if (!prodCostDiffInfoMap.containsKey(key.toString())) {
                HashMap<String, BigDecimal> diffInfos = new HashMap<String, BigDecimal>();
                diffInfos.put(diffInfoKey, diffcost);
                diffInfos.put(diffInfoKey1, diffcost);
                prodCostDiffInfoMap.put(key.toString(), diffInfos);
                continue;
            }
            ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey, diffcost);
            ((Map)prodCostDiffInfoMap.get(key.toString())).put(diffInfoKey1, diffcost);
        }
        this.saveWipCalcData(updateBill, prodCostDiffInfoMap);
        DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
        DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
            this.saveWipCalcData(updateBill, prodCostDiffInfoMap);
        }
        updateBill.set("targetcosttype", (Object)originalTargetCostType);
    }

    private void saveWipCalcData(DynamicObject updateBill, Map<String, Map<String, BigDecimal>> prodCostDiffInfoMap) {
        QFilter filter = this.getwipcalcRsFilter(updateBill, new ArrayList<QFilter>(1));
        Object[] wipCalcResults = BusinessDataServiceHelper.load((String)"sca_calcresult", (String)"org,costaccount.id,period.id,costcenter.id,costobject.id,entryentity.element,entryentity.subelement,entryentity.pdstartamount,entryentity.pdendamount,entryentity.datatype,entryentity.caltype,entryentity.difftype,entryentity.obj,entryentity.producttype,entryentity.material,entryentity.auxpty,entryentity.matversion,entryentity.resource,entryentity.costlevel,entryentity.calcbasis,entryentity.pdcurramount,entryentity.pdendamount,entryentity.costupdatediffamt", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((Object[])wipCalcResults)) {
            return;
        }
        for (Object wipCalcResult : wipCalcResults) {
            Map<String, BigDecimal> diffInfos;
            Long costObjectId = wipCalcResult.getLong("costobject.id");
            DynamicObjectCollection wipCalcResultEntrys = wipCalcResult.getDynamicObjectCollection("entryentity");
            StringBuilder key = new StringBuilder();
            List<String> keyFields = Arrays.asList("org.id", "costaccount.id", "costcenter.id", "costobject.id");
            for (int index = 0; index < keyFields.size(); ++index) {
                key.append(wipCalcResult.getString(keyFields.get(index))).append("@");
            }
            if (!prodCostDiffInfoMap.containsKey(key.toString()) || (diffInfos = prodCostDiffInfoMap.get(key.toString())) == null || diffInfos.size() == 0) continue;
            for (Map.Entry<String, BigDecimal> entrySet : diffInfos.entrySet()) {
                BigDecimal diffcost = entrySet.getValue();
                if (diffcost == null || BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
                String[] diffInfosStrs = entrySet.getKey().split("@");
                DynamicObject entry = wipCalcResultEntrys.addNew();
                entry.set("caltype", (Object)1);
                entry.set("datatype", (Object)diffInfosStrs[0]);
                entry.set("difftype", (Object)"3");
                entry.set("obj", (Object)costObjectId);
                entry.set("producttype", (Object)"C");
                entry.set("element", (Object)diffInfosStrs[1]);
                entry.set("subelement", (Object)diffInfosStrs[2]);
                entry.set("material", diffInfosStrs[3] == null ? Long.valueOf(0L) : diffInfosStrs[3]);
                entry.set("auxpty", diffInfosStrs[4] == null ? Long.valueOf(0L) : diffInfosStrs[4]);
                entry.set("matversion", diffInfosStrs[5] == null ? Long.valueOf(0L) : diffInfosStrs[5]);
                entry.set("resource", diffInfosStrs[6] == null ? Long.valueOf(0L) : diffInfosStrs[6]);
                entry.set("costlevel", (Object)diffInfosStrs[7]);
                entry.set("calcbasis", (Object)("0".equals(diffInfosStrs[8]) ? "" : diffInfosStrs[8]));
                entry.set("pdcurramount", (Object)diffcost);
                entry.set("pdendamount", (Object)diffcost);
                entry.set("costupdatediffamt", (Object)diffcost);
            }
            BigDecimal totalDiff = BigDecimal.ZERO;
            BigDecimal pdendTotalDiff = BigDecimal.ZERO;
            BigDecimal pdCurrTotalDiff = BigDecimal.ZERO;
            DynamicObject totalEntry = null;
            for (DynamicObject wipCalcResultEntry : wipCalcResultEntrys) {
                if ("3".equals(wipCalcResultEntry.getString("difftype")) && "2".equals(wipCalcResultEntry.getString("datatype"))) {
                    totalDiff = totalDiff.add(wipCalcResultEntry.getBigDecimal("pdendamount"));
                }
                if ("2".equals(wipCalcResultEntry.getString("datatype"))) {
                    pdendTotalDiff = pdendTotalDiff.add(wipCalcResultEntry.getBigDecimal("pdendamount"));
                    pdCurrTotalDiff = pdCurrTotalDiff.add(wipCalcResultEntry.getBigDecimal("pdcurramount"));
                }
                if (!"5".equals(wipCalcResultEntry.getString("caltype"))) continue;
                totalEntry = wipCalcResultEntry;
            }
            if (totalEntry == null) continue;
            totalEntry.set("costupdatediffamt", (Object)totalDiff);
            totalEntry.set("pdendamount", (Object)pdendTotalDiff);
            totalEntry.set("pdcurramount", (Object)pdCurrTotalDiff);
        }
        SaveServiceHelper.save((DynamicObject[])wipCalcResults);
    }

    private QFilter getwipcalcRsFilter(DynamicObject updateBill, List<QFilter> costObjectFilters) {
        DynamicObject targetCostType = updateBill.getDynamicObject("targetcosttype");
        HashSet<Long> targetCostTypeIds = new HashSet<Long>(5);
        targetCostTypeIds.add(targetCostType.getLong("id"));
        Set costaccountIds = CostTypeHelper.getCostAcctIdSetFromCostType(targetCostTypeIds);
        if (CadEmptyUtils.isEmpty((Set)costaccountIds)) {
            return null;
        }
        QFilter costaccountFilter = new QFilter("entryentity.costaccount", "in", (Object)costaccountIds);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection startstdcosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.masterid orgid,entryentity.costaccount.id costaccountid", (QFilter[])new QFilter[]{costaccountFilter, isInitFilter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)startstdcosts)) {
            return null;
        }
        QFilter filter = null;
        for (DynamicObject startstdcost : startstdcosts) {
            QFilter itemFilter = new QFilter("org", "=", (Object)startstdcost.getLong("orgid"));
            itemFilter.and("entry.costaccount", "=", (Object)startstdcost.getLong("costaccountid"));
            if (filter == null) {
                filter = itemFilter;
                continue;
            }
            filter.or(itemFilter);
        }
        DynamicObjectCollection sysCtrlInfos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,org.id orgid,entry.costaccount.id costaccountid, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)sysCtrlInfos)) {
            return null;
        }
        Map<String, List<Long>> multFactoryManu = this.getMultFactoryManuInfo(targetCostTypeIds);
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0-\u751f\u4ea7\u6210\u672c\u9875\u7b7e\u8ba1\u7b97\u7ed3\u679c\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a", (String)"ProdCostProcessor_0", (String)"macc-cad-business", (Object[])new Object[0]));
        filter = null;
        for (DynamicObject sysCtrlInfo : sysCtrlInfos) {
            QFilter itemFilter = new QFilter("org", "=", (Object)sysCtrlInfo.getLong("orgid"));
            QFilter costObjectFilter = new QFilter("org", "=", (Object)sysCtrlInfo.getLong("orgid"));
            sb.append("\r\n").append("org = ").append(sysCtrlInfo.getLong("orgid"));
            itemFilter.and("costaccount", "=", (Object)sysCtrlInfo.getLong("costaccountid"));
            sb.append("\r\n").append("costaccount = ").append(sysCtrlInfo.getLong("costaccountid"));
            itemFilter.and("period", "=", (Object)sysCtrlInfo.getLong("currentperiod"));
            sb.append("\r\n").append("period = ").append(sysCtrlInfo.getLong("currentperiod"));
            String[] values = new String[]{sysCtrlInfo.getString("costaccountid"), sysCtrlInfo.getString("orgid")};
            List<Long> manuOrgIds = multFactoryManu.get(this.getKeyInfo(values));
            if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
                itemFilter.and("costobject.manuorg", "in", (Object)manuOrgIds.toArray());
                sb.append("\r\n").append("costobject.manuorg in ").append(StringUtils.join((Object[])manuOrgIds.toArray(), (String)","));
                costObjectFilter.and("manuorg", "in", (Object)manuOrgIds.toArray());
            }
            if (filter == null) {
                filter = itemFilter;
            } else {
                filter.or(itemFilter);
            }
            costObjectFilters.add(costObjectFilter);
        }
        this.logger.info(sb.toString());
        return filter;
    }

    private DataSet getDiffData(DynamicObject updateBill, DynamicObject establishedBill) {
        DataSet purUpdateDataSet;
        DataSet costObjectDataSet;
        ArrayList<Long> costObjectIds;
        QFilter[] filters;
        QFilter wipcalcRsFilter;
        String algokey;
        Long srcCostTypeId;
        Tuple<Boolean, Boolean> updateWay;
        HashSet<Long> keyColIds;
        block29: {
            DynamicObjectCollection costEntityColl = establishedBill.getDynamicObjectCollection("costupdateentry");
            Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
            keyColIds = new HashSet<Long>(16);
            for (DynamicObject costentity : costEntityColl) {
                if (!targetCostTypeId.equals(costentity.getLong("costtype.id"))) continue;
                keyColIds.add(costentity.getLong("keycolid.id"));
            }
            if (CadEmptyUtils.isEmpty(keyColIds)) {
                return null;
            }
            updateWay = CostUpdateEstablishedHelper.getUpdateWay(updateBill.getLong("id"));
            srcCostTypeId = establishedBill.getLong("srccosttype.id");
            algokey = "kd.macc.cad.formplugin.costestablished.ProdCostProcessor.getDiffData";
            ArrayList<QFilter> costObjectFilters = new ArrayList<QFilter>(1);
            wipcalcRsFilter = this.getwipcalcRsFilter(updateBill, costObjectFilters);
            if (wipcalcRsFilter == null) {
                return null;
            }
            QFilter objectFilter = null;
            for (QFilter costObjectFilter : costObjectFilters) {
                if (objectFilter == null) {
                    objectFilter = costObjectFilter;
                    continue;
                }
                objectFilter.or(costObjectFilter);
            }
            filters = new QFilter[]{objectFilter, new QFilter("bizstatus", "=", (Object)"A")};
            String selectFields = "id,org,manuorg,material,bomversion,auxpty,configuredcode,tracknumber,projectnumber,lot";
            DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)selectFields, (QFilter[])filters);
            costObjectIds = new ArrayList<Long>(costObjects.size());
            RowMeta rowMeta = this.getCostObjectRowMeta();
            ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
            Field[] rowFields = rowMeta.getFields();
            Object[] rowData = null;
            for (DynamicObject costObject : costObjects) {
                HashMap<String, Object> values = new HashMap<String, Object>(7);
                values.put("material", costObject.getLong("material"));
                values.put("matvers", costObject.getLong("bomversion"));
                values.put("auxproperty", costObject.getLong("auxpty"));
                values.put("project", costObject.getLong("projectnumber"));
                values.put("tracknumber", costObject.getLong("tracknumber"));
                values.put("configuredcode", costObject.getLong("configuredcode"));
                values.put("lot", costObject.getString("lot"));
                Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)false).getId();
                if (!keyColIds.contains(keyColId)) continue;
                costObjectIds.add(costObject.getLong("id"));
                rowData = new Object[rowFields.length];
                rowData[rowMeta.getFieldIndex((String)"costobject")] = costObject.getLong("id");
                rowData[rowMeta.getFieldIndex((String)"org")] = costObject.getLong("org");
                rowData[rowMeta.getFieldIndex((String)"manuorg")] = costObject.getLong("manuorg");
                rowData[rowMeta.getFieldIndex((String)"keycolid")] = keyColId;
                dataList.add(rowData);
            }
            if (CadEmptyUtils.isEmpty(costObjectIds) || CadEmptyUtils.isEmpty(dataList)) {
                return null;
            }
            costObjectDataSet = null;
            try {
                costObjectDataSet = Algo.create((String)"macc.cad.ProdCostProcessor.getCostObjectDataSet").createDataSet(dataList.iterator(), rowMeta);
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
                if (costObjectDataSet == null) break block29;
                costObjectDataSet.close();
            }
        }
        filters = new QFilter[]{wipcalcRsFilter, new QFilter("costobject", "in", costObjectIds), new QFilter("entryentity.caltype", "in", Arrays.asList("1", "3")), new QFilter("entryentity.datatype", "=", (Object)"2")};
        DataSet calcResultDataSet = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_calcresult", (String)"org.id orgid,costaccount.id costaccountid,period.id periodid,costcenter.id costcenterid,costobject.id costobjectid,costobject.manuorg manuorgid,costobject.material.id materialid,costobject.bomversion.id matverid,costobject.auxpty.id auxptyid,entryentity.material.masterid submaterialid,entryentity.matversion.id submatverid,entryentity.auxpty.id subauxptyid,entryentity.keycolid.id subkeycolid,entryentity.element.id elementid,entryentity.subelement.id subelementid,entryentity.pdendamount pdendamount, 0 newcost,0 stdcost,entryentity.pdendqty pdendqty,entryentity.difftype difftype,entryentity.resource.id resourceid,entryentity.costlevel oldcostlevel,entryentity.calcbasis oldcalcbasis", (QFilter[])filters, null);
        if (calcResultDataSet.isEmpty()) {
            DataSetUtils.colse((DataSet)costObjectDataSet);
            return null;
        }
        calcResultDataSet = calcResultDataSet.leftJoin(costObjectDataSet).on("orgid", "org").on("costobjectid", "costobject").on("manuorgid", "manuorg").select(calcResultDataSet.getRowMeta().getFieldNames(), new String[]{"keycolid"}).finish();
        DataSetUtils.colse((DataSet)costObjectDataSet);
        DataSet qtyDataSet = calcResultDataSet.copy().executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,keycolid,manuorgid,submaterialid,subkeycolid,oldcostlevel,max(pdendqty) pdendqtybak group by orgid,costaccountid,periodid,costcenterid,costobjectid,keycolid,manuorgid,submaterialid,subkeycolid,oldcostlevel").where("submaterialid is not null and pdendqtybak != 0");
        calcResultDataSet = calcResultDataSet.leftJoin(qtyDataSet).on("orgid", "orgid").on("costaccountid", "costaccountid").on("periodid", "periodid").on("costcenterid", "costcenterid").on("costobjectid", "costobjectid").on("keycolid", "keycolid").on("manuorgid", "manuorgid").on("subkeycolid", "subkeycolid").on("oldcostlevel", "oldcostlevel").select(calcResultDataSet.getRowMeta().getFieldNames(), new String[]{"pdendqtybak"}).finish();
        DataSet stdCostDataSet = null;
        if (Boolean.FALSE.equals(updateWay.item1)) {
            filters = new QFilter[]{new QFilter("costtype", "=", (Object)srcCostTypeId), new QFilter("keycolid", "in", keyColIds), new QFilter("ismaindata", "=", (Object)1), new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3"))};
            stdCostDataSet = QueryServiceHelper.queryDataSet((String)algokey, (String)"cad_calcsimulationresult", (String)"costtype.id costtypeid,material.id materialid,matvers.id matverid,auxproperty.id auxptyid,keycolid.id keycolid,entryentity.element.id elementid,entryentity.subelement.id subelementid,entryentity.submaterial.id submaterialid,entryentity.submatvers.id submatverid,entryentity.subauxproperty.id subauxptyid,entryentity.subkeycolid.id subkeycolid,entryentity.price price,entryentity.stdprice stdprice,entryentity.resource.id resourceid,entryentity.datatype newcostlevel,entryentity.calcbasis newcalcbasis", (QFilter[])filters, null);
        } else {
            ArrayList lstKeyColIds = new ArrayList(keyColIds.size());
            keyColIds.forEach(p -> lstKeyColIds.add(p.toString()));
            String sql = "select t.fcosttypeid costtypeid,y.fentrymaterialid materialid,y.fentrymatvers matverid,y.fentryauxproperty auxptyid,y.fentrykeycolid keycolid,sy.felementid elementid,sy.fsubelementid subelementid,sy.fsubmaterialid submaterialid,sy.fsubmatvers submatverid,sy.fsubauxproperty subauxptyid,sy.fsubkeycolid subkeycolid,sy.fprice price,sy.fstdprice stdprice,sy.fresourceid resourceid,sy.fdatatype newcostlevel,sy.fcalcbasis newcalcbasis  from t_cad_trackcalcresut t left join t_cad_trackcalcentry y on t.fid = y.fid  left join t_cad_trackcalcsubentry sy on y.fentryid = sy.fentryid  where t.fcosttypeid = ? and t.fismaindata = 1 and t.fisleaf = '0'  and t.feffectdate is null and t.fkeycolid in (" + String.join((CharSequence)",", lstKeyColIds) + ") and y.fentrylevel = 0 and sy.fdatatype in ('2','3') ";
            Object[] params = new Object[]{new SqlParameter(":fcosttypeid", -5, (Object)srcCostTypeId)};
            this.logger.info("track sql:{}", (Object)sql);
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_cad_trackcalcresut", (HintCondition[])new HintCondition[]{new HintCondition("fcosttypeid", "=", (Object)srcCostTypeId)});){
                stdCostDataSet = DB.queryDataSet((String)algokey, (DBRoute)DBRoute.of((String)"cal"), (String)sql, (Object[])params);
            }
        }
        GroupbyDataSet groupDataSet = stdCostDataSet.groupBy(new String[]{"costtypeid", "materialid", "matverid", "auxptyid", "keycolid", "elementid", "subelementid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "resourceid", "newcostlevel", "newcalcbasis"});
        groupDataSet.max("price");
        groupDataSet.sum("stdprice");
        stdCostDataSet = groupDataSet.finish();
        JoinDataSet leftJoinDataSet = calcResultDataSet.join(stdCostDataSet, JoinType.LEFT);
        leftJoinDataSet.on("keycolid", "keycolid");
        leftJoinDataSet.on("elementid", "elementid").on("subelementid", "subelementid");
        leftJoinDataSet.on("subkeycolid", "subkeycolid");
        leftJoinDataSet.on("resourceid", "resourceid");
        JoinDataSet simuJoin = stdCostDataSet.join(calcResultDataSet, JoinType.LEFT);
        simuJoin.on("keycolid", "keycolid");
        simuJoin.on("elementid", "elementid").on("subelementid", "subelementid");
        simuJoin.on("subkeycolid", "subkeycolid");
        simuJoin.on("resourceid", "resourceid");
        stdCostDataSet = leftJoinDataSet.select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "keycolid", "manuorgid", "materialid", "matverid", "auxptyid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "elementid", "subelementid", "pdendamount", "pdendqty", "pdendqtybak", "newcost", "resourceid", "oldcostlevel", "oldcalcbasis"}, new String[]{"price", "newcostlevel", "newcalcbasis"}).finish();
        stdCostDataSet = stdCostDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,keycolid,manuorgid,materialid,matverid,auxptyid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,pdendamount oldcost,case when pdendqty = 0 then pdendqtybak*price else pdendqty*price end newcost,pdendqty,pdendqtybak,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis");
        groupDataSet = stdCostDataSet.groupBy(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "keycolid", "manuorgid", "materialid", "matverid", "auxptyid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "elementid", "subelementid", "resourceid", "oldcostlevel", "oldcalcbasis", "newcostlevel", "newcalcbasis"});
        DataSet simuResult = simuJoin.select(new String[]{"materialid", "matverid", "auxptyid", "keycolid", "elementid", "subelementid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "resourceid", "newcostlevel", "price", "newcalcbasis"}, new String[]{"orgid org"}).finish();
        simuResult = simuResult.executeSql("select org,materialid,matverid,auxptyid,keycolid,elementid,subelementid,submaterialid,submatverid,subauxptyid,subkeycolid,resourceid,case when resourceid = 0 or resourceid is null then ' ' else newcostlevel end newcostlevel,max(price) price,newcalcbasis where org is null group by org,materialid,matverid,auxptyid,keycolid,elementid,subelementid,submaterialid,submatverid,subauxptyid,subkeycolid,resourceid,newcostlevel,newcalcbasis");
        groupDataSet.sum("newcost");
        groupDataSet.sum("oldcost");
        groupDataSet.max("pdendqty");
        groupDataSet.max("pdendqtybak");
        groupDataSet.max("price");
        DataSet diffDataSet = groupDataSet.finish().select("orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,materialid,matverid,auxptyid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,newcost,pdendqty,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis");
        diffDataSet = diffDataSet.select("orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,materialid,matverid,auxptyid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,newcost,newcost-oldcost diffcost,pdendqty,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis").orderBy(new String[]{"orgid", "costaccountid", "costcenterid", "costobjectid", "manuorgid", "elementid", "subelementid"});
        DataSet delSubElementDataSet = this.getDiffMatInfo(updateBill, establishedBill);
        DataSet dataSet = purUpdateDataSet = delSubElementDataSet == null ? null : delSubElementDataSet.copy();
        if (delSubElementDataSet != null && !delSubElementDataSet.isEmpty()) {
            this.logger.info("\u5b58\u5728\u6210\u672c\u5b50\u8981\u7d20\u88ab\u5220\u9664");
            diffDataSet = diffDataSet.leftJoin(delSubElementDataSet).on("subkeycolid", "keycolid").on("elementid", "element").on("subelementid", "subelement").select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "manuorgid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "elementid", "subelementid", "oldcost", "newcost", "diffcost", "pdendqty", "price", "resourceid", "oldcostlevel", "oldcalcbasis", "newcostlevel", "newcalcbasis"}, new String[]{"subelement"}).finish();
            diffDataSet = diffDataSet.executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,case when newcost is null and subelement is not null then 0 else newcost end newcost,case when newcost is null and subelement is not null then 0-oldcost else diffcost end diffcost,pdendqty,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis");
        } else {
            diffDataSet = diffDataSet.executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,newcost,diffcost,pdendqty,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis");
        }
        DataSet purCalcDataSet = diffDataSet.copy().executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,newcost,diffcost,pdendqty,price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis where price is null and submaterialid > 0");
        DataSet subKeyColDataSet = purCalcDataSet.copy().executeSql("select subkeycolid");
        DataSet purDataSet = this.getPurDataSet(srcCostTypeId, subKeyColDataSet, purUpdateDataSet);
        if (purDataSet != null && !purDataSet.isEmpty()) {
            purDataSet = purCalcDataSet.leftJoin(purDataSet).on("subkeycolid", "keycolid").on("elementid", "element").on("subelementid", "subelement").select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "manuorgid", "submaterialid", "submatverid", "subauxptyid", "subkeycolid", "elementid", "subelementid", "oldcost", "newcost", "diffcost", "pdendqty", "resourceid", "oldcostlevel", "oldcalcbasis", "newcostlevel", "newcalcbasis"}, new String[]{"newprice"}).finish();
            purDataSet = purDataSet.executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,oldcost,pdendqty*newprice newcost,(pdendqty*newprice-oldcost) diffcost,pdendqty,newprice price,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis where newprice is not null");
            diffDataSet = diffDataSet.union(purDataSet);
        }
        if (simuResult != null && !simuResult.isEmpty()) {
            this.logger.info("\u5b58\u5728\u67d0\u4e00\u5b50\u8981\u7d20\u5b58\u5728\u6a21\u62df\u6570\u636e\uff0c\u4f46\u4e0d\u5b58\u5728\u671f\u672b\u5728\u4ea7\u54c1");
            DataSet calcResult = calcResultDataSet.executeSql("select orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,materialid,matverid,auxptyid,submaterialid,submatverid,subauxptyid,subkeycolid,resourceid,case when oldcostlevel is null or oldcostlevel = '' then ' ' else oldcostlevel end oldcostlevel,max(pdendqty) pdendqty,oldcalcbasis where pdendqty is not null and pdendqty != 0 group by orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,materialid,matverid,auxptyid,submaterialid,submatverid,subauxptyid,subkeycolid,resourceid,oldcostlevel,oldcalcbasis");
            DataSet newResult = simuResult.leftJoin(calcResult).on("materialid", "materialid").on("matverid", "matverid").on("auxptyid", "auxptyid").on("subkeycolid", "subkeycolid").on("resourceid", "resourceid").on("newcostlevel", "oldcostlevel").on("newcalcbasis", "oldcalcbasis").select(new String[]{"orgid", "costaccountid", "periodid", "costcenterid", "costobjectid", "manuorgid"}, new String[]{"submaterialid", "submatverid", "subauxptyid", "subkeycolid", "elementid", "subelementid", "0 oldcost", "price*pdendqty newcost", "price*pdendqty diffcost", "pdendqty", "price", "resourceid", "case when resourceid = 0 or resourceid is null then ' ' else oldcostlevel end oldcostlevel", "newcalcbasis oldcalcbasis", "case when resourceid = 0 or resourceid is null then ' ' else newcostlevel end newcostlevel", "newcalcbasis"}).finish().filter("orgid is not null");
            diffDataSet = diffDataSet.union(newResult);
            DataSetUtils.colse((DataSet[])new DataSet[]{calcResult, newResult});
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{calcResultDataSet, stdCostDataSet, qtyDataSet, delSubElementDataSet, purUpdateDataSet, purCalcDataSet, subKeyColDataSet, purDataSet, simuResult});
        DataSet result = diffDataSet.filter("orgid is not null and orgid != 0 and diffcost is not null");
        DataSet costLevelDataSet = result.copy().filter(" oldcalcbasis != newcalcbasis ");
        if (costLevelDataSet.isEmpty()) {
            DataSetUtils.colse((DataSet)costLevelDataSet);
            return result;
        }
        DataSet levelDataSet = this.getCostLevelDataSet(costLevelDataSet);
        DataSet costDataSet = result.filter("oldcalcbasis = newcalcbasis");
        DataSet allDataSet = DataSetUtils.union((DataSet)costDataSet, (DataSet)levelDataSet);
        DataSetUtils.colse((DataSet[])new DataSet[]{levelDataSet, result, costDataSet, diffDataSet});
        String fields = "orgid,costaccountid,periodid,costcenterid,costobjectid,manuorgid,submaterialid,submatverid,subauxptyid,subkeycolid,elementid,subelementid,resourceid,oldcostlevel,oldcalcbasis,newcostlevel,newcalcbasis";
        allDataSet = allDataSet.groupBy(fields.split(",")).sum("oldcost").sum("newcost").sum("diffcost").sum("pdendqty").sum("price").finish();
        return allDataSet;
    }

    private DataSet getPurDataSet(Long costTypeId, DataSet subKeyColDataSet, DataSet purUpdateDataSet) {
        if (purUpdateDataSet == null) {
            return null;
        }
        HashSet<Long> keyColIds = new HashSet<Long>(16);
        Iterator it = subKeyColDataSet.iterator();
        while (it.hasNext()) {
            keyColIds.add(((Row)it.next()).getLong("subkeycolid"));
        }
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return null;
        }
        this.logger.info("subkeycolid\uff1a" + StringUtils.join((Object[])keyColIds.toArray(), (String)","));
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("keycolid", "in", keyColIds), new QFilter("billstatus", "=", (Object)"C"), new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate())};
        String algoxKey = this.getClass().getName() + ".getPurDataSet";
        String selectFields = "keycolid,entryentity.element element,entryentity.subelement subelement,entryentity.price newprice";
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)algoxKey, (String)"cad_purprices", (String)selectFields, (QFilter[])filters, null);
        purDataSet = purUpdateDataSet.join(purDataSet).on("keycolid", "keycolid").on("element", "element").on("subelement", "subelement").select(new String[]{"keycolid", "element", "subelement"}, new String[]{"newprice"}).finish();
        return purDataSet;
    }

    private DataSet getDiffMatInfo(DynamicObject updateBill, DynamicObject establishedBill) {
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        RowMeta rowMeta = this.getRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        Object[] rowData = null;
        Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
        for (DynamicObject entry : entrys) {
            if (!targetCostTypeId.equals(entry.getLong("costtype.id")) || BigDecimal.ZERO.compareTo(entry.getBigDecimal("diffprice")) == 0) continue;
            rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                rowData[i] = entry.getLong(fields[i].getName() + ".id");
            }
            dataList.add(rowData);
        }
        if (CadEmptyUtils.isEmpty(dataList)) {
            return null;
        }
        return Algo.create((String)"macc.cad.ProdCostProcessor").createDataSet(dataList.iterator(), rowMeta);
    }

    private RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("keycolid", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType)};
        return new RowMeta(fields);
    }

    private Map<String, List<Long>> getMultFactoryManuInfo(Set<Long> costTypeIds) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(16);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costaccount.id costaccount,calorg,storageorgunit invorg", (QFilter[])filters);
        boolean multiFactory = false;
        HashSet orgIds = new HashSet(16);
        costTypeOrgs.forEach(p -> orgIds.add(p.getLong("calorg")));
        for (Long orgId : orgIds) {
            if (!OrgHelper.isOrgEnableMultiFactory((Long)orgId)) continue;
            multiFactory = true;
            break;
        }
        if (!multiFactory) {
            return result;
        }
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            Long invOrgId = costTypeOrg.getLong("invorg");
            boolean isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)invOrgId, (String)"04");
            List manuOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)invOrgId, (boolean)isProduce);
            String[] values = new String[]{costTypeOrg.getString("costaccount"), costTypeOrg.getString("calorg")};
            result.put(this.getKeyInfo(values), manuOrgIds);
        }
        return result;
    }

    private String getKeyInfo(String[] values) {
        StringBuilder sg = new StringBuilder();
        for (String value : values) {
            sg.append(value);
            sg.append("#");
        }
        return sg.toString();
    }

    private Boolean isNeedProdData(DynamicObject establishedBill) {
        DynamicObject targetCostType = establishedBill.getDynamicObject("targetcosttype");
        HashSet<Long> targetCostTypeIds = new HashSet<Long>(5);
        targetCostTypeIds.add(targetCostType.getLong("id"));
        DynamicObject effectPeriod = establishedBill.getDynamicObject("effectperiod");
        if (effectPeriod != null && CostUpdateHelper.isUpdateByPeriod((Long)((Long)targetCostTypeIds.iterator().next()))) {
            Set costaccountIds = CostTypeHelper.getCostAcctIdSetFromCostType(targetCostTypeIds);
            if (CadEmptyUtils.isEmpty((Set)costaccountIds)) {
                return Boolean.FALSE;
            }
            QFilter costaccountFilter = new QFilter("entryentity.costaccount", "in", (Object)costaccountIds);
            DynamicObjectCollection startstdcosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.masterid orgid,entryentity.costaccount.id costaccountid", (QFilter[])new QFilter[]{costaccountFilter});
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)startstdcosts)) {
                return Boolean.FALSE;
            }
            QFilter filter = null;
            for (DynamicObject startstdcost : startstdcosts) {
                QFilter itemFilter = new QFilter("org", "=", (Object)startstdcost.getLong("orgid"));
                itemFilter.and(new QFilter("entry.costaccount", "=", (Object)startstdcost.getLong("costaccountid")));
                if (filter == null) {
                    filter = itemFilter;
                    continue;
                }
                filter.or(itemFilter);
            }
            DynamicObjectCollection sysCtrlInfos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{filter});
            for (DynamicObject sysCtrlInfo : sysCtrlInfos) {
                if (sysCtrlInfo.getLong("currentperiod") == effectPeriod.getLong("id")) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private BigDecimal convertBigDecimal(BigDecimal val, int amtprecision) {
        BigDecimal data = val != null ? val : BigDecimal.ZERO;
        return data.setScale(amtprecision, 4);
    }

    private DataSet getCostLevelDataSet(DataSet costLevelDataSet) {
        RowMeta rowMeta = this.getCostLevelRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        Object[] rowData = null;
        for (Row row : costLevelDataSet) {
            BigDecimal newCost;
            BigDecimal oldCost;
            BigDecimal bigDecimal = oldCost = row.getBigDecimal("oldcost") != null ? row.getBigDecimal("oldcost") : BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(oldCost) != 0) {
                rowData = new Object[fields.length];
                rowData[rowMeta.getFieldIndex((String)"orgid")] = row.getLong("orgid");
                rowData[rowMeta.getFieldIndex((String)"costaccountid")] = row.getLong("costaccountid");
                rowData[rowMeta.getFieldIndex((String)"periodid")] = row.getLong("periodid");
                rowData[rowMeta.getFieldIndex((String)"costcenterid")] = row.getLong("costcenterid");
                rowData[rowMeta.getFieldIndex((String)"costobjectid")] = row.getLong("costobjectid");
                rowData[rowMeta.getFieldIndex((String)"manuorgid")] = row.getLong("manuorgid");
                rowData[rowMeta.getFieldIndex((String)"submaterialid")] = row.getLong("submaterialid");
                rowData[rowMeta.getFieldIndex((String)"submatverid")] = row.getLong("submatverid");
                rowData[rowMeta.getFieldIndex((String)"subauxptyid")] = row.getLong("subauxptyid");
                rowData[rowMeta.getFieldIndex((String)"subkeycolid")] = row.getLong("subkeycolid");
                rowData[rowMeta.getFieldIndex((String)"elementid")] = row.getLong("elementid");
                rowData[rowMeta.getFieldIndex((String)"subelementid")] = row.getLong("subelementid");
                rowData[rowMeta.getFieldIndex((String)"oldcost")] = row.getBigDecimal("oldcost");
                rowData[rowMeta.getFieldIndex((String)"newcost")] = BigDecimal.ZERO;
                rowData[rowMeta.getFieldIndex((String)"diffcost")] = BigDecimal.ZERO.subtract(oldCost);
                rowData[rowMeta.getFieldIndex((String)"pdendqty")] = row.getBigDecimal("pdendqty");
                rowData[rowMeta.getFieldIndex((String)"price")] = row.getBigDecimal("price");
                rowData[rowMeta.getFieldIndex((String)"resourceid")] = row.getLong("resourceid");
                rowData[rowMeta.getFieldIndex((String)"oldcostlevel")] = row.getString("oldcostlevel");
                rowData[rowMeta.getFieldIndex((String)"oldcalcbasis")] = row.getString("oldcalcbasis");
                rowData[rowMeta.getFieldIndex((String)"newcostlevel")] = row.getString("oldcostlevel");
                rowData[rowMeta.getFieldIndex((String)"newcalcbasis")] = row.getString("oldcalcbasis");
                dataList.add(rowData);
            }
            if (BigDecimal.ZERO.compareTo(newCost = row.getBigDecimal("newcost") != null ? row.getBigDecimal("newcost") : BigDecimal.ZERO) == 0) continue;
            rowData = new Object[fields.length];
            rowData[rowMeta.getFieldIndex((String)"orgid")] = row.getLong("orgid");
            rowData[rowMeta.getFieldIndex((String)"costaccountid")] = row.getLong("costaccountid");
            rowData[rowMeta.getFieldIndex((String)"periodid")] = row.getLong("periodid");
            rowData[rowMeta.getFieldIndex((String)"costcenterid")] = row.getLong("costcenterid");
            rowData[rowMeta.getFieldIndex((String)"costobjectid")] = row.getLong("costobjectid");
            rowData[rowMeta.getFieldIndex((String)"manuorgid")] = row.getLong("manuorgid");
            rowData[rowMeta.getFieldIndex((String)"submaterialid")] = row.getLong("submaterialid");
            rowData[rowMeta.getFieldIndex((String)"submatverid")] = row.getLong("submatverid");
            rowData[rowMeta.getFieldIndex((String)"subauxptyid")] = row.getLong("subauxptyid");
            rowData[rowMeta.getFieldIndex((String)"subkeycolid")] = row.getLong("subkeycolid");
            rowData[rowMeta.getFieldIndex((String)"elementid")] = row.getLong("elementid");
            rowData[rowMeta.getFieldIndex((String)"subelementid")] = row.getLong("subelementid");
            rowData[rowMeta.getFieldIndex((String)"oldcost")] = BigDecimal.ZERO;
            rowData[rowMeta.getFieldIndex((String)"newcost")] = newCost;
            rowData[rowMeta.getFieldIndex((String)"diffcost")] = newCost;
            rowData[rowMeta.getFieldIndex((String)"pdendqty")] = row.getBigDecimal("pdendqty");
            rowData[rowMeta.getFieldIndex((String)"price")] = row.getBigDecimal("price");
            rowData[rowMeta.getFieldIndex((String)"resourceid")] = row.getLong("resourceid");
            rowData[rowMeta.getFieldIndex((String)"oldcostlevel")] = row.getString("newcostlevel");
            rowData[rowMeta.getFieldIndex((String)"oldcalcbasis")] = row.getString("newcalcbasis");
            rowData[rowMeta.getFieldIndex((String)"newcostlevel")] = row.getString("newcostlevel");
            rowData[rowMeta.getFieldIndex((String)"newcalcbasis")] = row.getString("newcalcbasis");
            dataList.add(rowData);
        }
        if (CadEmptyUtils.isEmpty(dataList)) {
            return null;
        }
        return Algo.create((String)"macc.cad.ProdCostProcessor.getCostLevelDataSet").createDataSet(dataList.iterator(), rowMeta);
    }

    private RowMeta getCostLevelRowMeta() {
        Field[] fields = new Field[]{new Field("orgid", (DataType)DataType.LongType), new Field("costaccountid", (DataType)DataType.LongType), new Field("periodid", (DataType)DataType.LongType), new Field("costcenterid", (DataType)DataType.LongType), new Field("costobjectid", (DataType)DataType.LongType), new Field("manuorgid", (DataType)DataType.LongType), new Field("submaterialid", (DataType)DataType.LongType), new Field("submatverid", (DataType)DataType.LongType), new Field("subauxptyid", (DataType)DataType.LongType), new Field("subkeycolid", (DataType)DataType.LongType), new Field("elementid", (DataType)DataType.LongType), new Field("subelementid", (DataType)DataType.LongType), new Field("oldcost", (DataType)DataType.BigDecimalType), new Field("newcost", (DataType)DataType.BigDecimalType), new Field("diffcost", (DataType)DataType.BigDecimalType), new Field("pdendqty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("resourceid", (DataType)DataType.LongType), new Field("oldcostlevel", (DataType)DataType.StringType), new Field("oldcalcbasis", (DataType)DataType.StringType), new Field("newcostlevel", (DataType)DataType.StringType), new Field("newcalcbasis", (DataType)DataType.StringType)};
        return new RowMeta(fields);
    }

    private RowMeta getCostObjectRowMeta() {
        Field[] fields = new Field[]{new Field("costobject", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("manuorg", (DataType)DataType.LongType), new Field("keycolid", (DataType)DataType.LongType)};
        return new RowMeta(fields);
    }
}

