/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.DateUtils;

public class StorCostProcessor {
    private Log logger = LogFactory.getLog(StorCostProcessor.class);

    public void genStorageCostInfo(DynamicObject updateBill, DynamicObject establishedBill) {
        this.logger.info("\u52a0\u8f7d\u5e93\u5b58\u9875\u7b7e");
        DynamicObjectCollection storageDataColl = establishedBill.getDynamicObjectCollection("acctentry");
        storageDataColl.clear();
        DynamicObjectCollection acctDataColl = establishedBill.getDynamicObjectCollection("storagecostentry");
        acctDataColl.clear();
        this.genStorageCostInfo(updateBill, establishedBill, storageDataColl, acctDataColl);
        DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
        DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
            this.genStorageCostInfo(updateBill, establishedBill, storageDataColl, acctDataColl);
        }
        updateBill.set("targetcosttype", (Object)originalTargetCostType);
        BusinessDataServiceHelper.loadRefence((Object[])storageDataColl.toArray((Object[])new DynamicObject[0]), (IDataEntityType)storageDataColl.getDynamicObjectType());
        BusinessDataServiceHelper.loadRefence((Object[])acctDataColl.toArray((Object[])new DynamicObject[0]), (IDataEntityType)acctDataColl.getDynamicObjectType());
    }

    private void genStorageCostInfo(DynamicObject updateBill, DynamicObject establishedBill, DynamicObjectCollection storageDataColl, DynamicObjectCollection acctDataColl) {
        List<Map<String, Map<String, BigDecimal>>> storageDatas = this.getStorMatInfos(updateBill, establishedBill);
        if (CadEmptyUtils.isEmpty(storageDatas)) {
            this.logger.info("storageDatas \u4e3a\u7a7a");
            return;
        }
        int amtprecision = establishedBill.getInt("srccosttype.currency.amtprecision");
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
        ArrayList<Object> matCostInfos = new ArrayList<Object>(entrys.size());
        for (Object entry : entrys) {
            if (!targetCostTypeId.equals(entry.getLong("costtype.id"))) continue;
            matCostInfos.add(entry);
        }
        if (CadEmptyUtils.isEmpty(matCostInfos)) {
            return;
        }
        HashMap<Object, Object> matCostInfosMap = new HashMap<Object, Object>();
        for (DynamicObject dynamicObject : matCostInfos) {
            Object matElementsCostInfosMap;
            Long keyColId = dynamicObject.getLong("keycolid.id");
            if (CadEmptyUtils.isEmpty((Long)keyColId)) {
                this.logger.info(String.format("\u786e\u8ba4\u5355\u7269\u6599=%s\uff0c\u5b50\u8981\u7d20=%s\u5b58\u5728keycolid\u4e3a\u7a7a", dynamicObject.getString("material.id"), dynamicObject.getString("subelement.id")));
                continue;
            }
            String elementKey = this.stringConvert(dynamicObject.getString("element.id")) + "@" + this.stringConvert(dynamicObject.getString("subelement.id"));
            String oldprice = dynamicObject.getString("oldprice");
            String newprice = dynamicObject.getString("newprice");
            if (!matCostInfosMap.containsKey(keyColId)) {
                matElementsCostInfosMap = new HashMap();
                matElementsCostInfosMap.put(elementKey, oldprice + "@" + newprice);
                matCostInfosMap.put(keyColId, matElementsCostInfosMap);
                continue;
            }
            matElementsCostInfosMap = (Map)matCostInfosMap.get(keyColId);
            String val = (String)matElementsCostInfosMap.get(elementKey);
            if (val == null) {
                matElementsCostInfosMap.put(elementKey, oldprice + "@" + newprice);
                continue;
            }
            CharSequence[] vals = val.split("@");
            if (vals.length != 2) {
                this.logger.info(String.format("\u65b0\u65e7\u5355\u4ef7\u5f02\u5e38 %s", String.join((CharSequence)",", vals)));
                continue;
            }
            BigDecimal oldPrice = new BigDecimal(oldprice).add(new BigDecimal(vals[0]));
            BigDecimal newPrice = new BigDecimal(newprice).add(new BigDecimal((String)vals[1]));
            matElementsCostInfosMap.put(elementKey, oldPrice + "@" + newPrice);
        }
        int seq = 0;
        Map<String, Map<String, BigDecimal>> map = storageDatas.get(0);
        for (String costAccountKey : map.keySet()) {
            String[] costAccountKeyStrs = costAccountKey.split("@");
            Map<String, BigDecimal> matQtyInfos = storageDatas.get(0).get(costAccountKey);
            for (Map.Entry<String, BigDecimal> entrySet : matQtyInfos.entrySet()) {
                String[] matKeyStrs = entrySet.getKey().split("@");
                Long keyColId = this.getKeyColId(matKeyStrs);
                this.logger.info(String.format("entrySet.getKey()\uff1a%s\uff0ckeycolId=%s", entrySet.getKey(), keyColId));
                BigDecimal qty = entrySet.getValue();
                Map matElementCostinfos = (Map)matCostInfosMap.get(keyColId);
                if (matElementCostinfos == null) continue;
                for (Map.Entry entry : matElementCostinfos.entrySet()) {
                    String[] matElementKeyStrs = ((String)entry.getKey()).split("@");
                    String[] prices = ((String)entry.getValue()).split("@");
                    BigDecimal oldprice = new BigDecimal(prices[0]);
                    BigDecimal newprice = new BigDecimal(prices[1]);
                    DynamicObject storageDataEntity = storageDataColl.addNew();
                    storageDataEntity.set("seq", (Object)seq++);
                    storageDataEntity.set("acctaccountorg_id", (Object)Long.valueOf(costAccountKeyStrs[0]));
                    storageDataEntity.set("acctcostaccount_id", (Object)Long.valueOf(costAccountKeyStrs[1]));
                    storageDataEntity.set("acctmaterial_id", (Object)Long.valueOf(matKeyStrs[0]));
                    storageDataEntity.set("acctmatversion_id", (Object)Long.valueOf(matKeyStrs[1]));
                    storageDataEntity.set("acctauxprop_id", (Object)Long.valueOf(matKeyStrs[2]));
                    storageDataEntity.set("acctkeycolid_id", (Object)keyColId);
                    storageDataEntity.set("acctelement_id", (Object)Long.valueOf(matElementKeyStrs[0]));
                    storageDataEntity.set("acctsubelement_id", (Object)Long.valueOf(matElementKeyStrs[1]));
                    storageDataEntity.set("acctnewprice", (Object)newprice);
                    storageDataEntity.set("acctoldprice", (Object)oldprice);
                    storageDataEntity.set("acctqty", (Object)qty);
                    BigDecimal acctnewcost = qty.multiply(newprice).setScale(amtprecision, 4);
                    BigDecimal acctoldcost = qty.multiply(oldprice).setScale(amtprecision, 4);
                    storageDataEntity.set("acctnewcost", (Object)acctnewcost);
                    storageDataEntity.set("acctoldcost", (Object)acctoldcost);
                    storageDataEntity.set("acctdiffcost", (Object)acctnewcost.subtract(acctoldcost));
                }
            }
        }
        Map<String, Map<String, BigDecimal>> warehouseDatas = storageDatas.get(1);
        int seq2 = 0;
        for (String costAccountKey : warehouseDatas.keySet()) {
            String[] costAccountKeyStrs = costAccountKey.split("@");
            Map<String, BigDecimal> matQtyInfos = storageDatas.get(1).get(costAccountKey);
            for (Map.Entry<String, BigDecimal> entry : matQtyInfos.entrySet()) {
                String[] matKeyStrs = entry.getKey().split("@");
                Long keyColId = this.getKeyColId(matKeyStrs);
                BigDecimal qty = entry.getValue();
                Map matElementCostinfos = (Map)matCostInfosMap.get(keyColId);
                if (matElementCostinfos == null) continue;
                for (Map.Entry entrySet : matElementCostinfos.entrySet()) {
                    String[] matElementKeyStrs = ((String)entrySet.getKey()).split("@");
                    String[] prices = ((String)entrySet.getValue()).split("@");
                    BigDecimal oldprice = new BigDecimal(prices[0]);
                    BigDecimal newprice = new BigDecimal(prices[1]);
                    DynamicObject storageDataEntity = acctDataColl.addNew();
                    storageDataEntity.set("seq", (Object)seq2++);
                    storageDataEntity.set("accountorg_id", (Object)Long.valueOf(costAccountKeyStrs[0]));
                    storageDataEntity.set("costaccount_id", (Object)Long.valueOf(costAccountKeyStrs[1]));
                    storageDataEntity.set("warehouse_id", (Object)Long.valueOf(costAccountKeyStrs[2]));
                    storageDataEntity.set("stormaterial_id", (Object)Long.valueOf(matKeyStrs[0]));
                    storageDataEntity.set("stormatverisoin_id", (Object)Long.valueOf(matKeyStrs[1]));
                    storageDataEntity.set("storauxprop_id", (Object)Long.valueOf(matKeyStrs[2]));
                    storageDataEntity.set("storkeycolid_id", (Object)keyColId);
                    storageDataEntity.set("storelement_id", (Object)Long.valueOf(matElementKeyStrs[0]));
                    storageDataEntity.set("storsubelement_id", (Object)Long.valueOf(matElementKeyStrs[1]));
                    storageDataEntity.set("stornewprice", (Object)newprice);
                    storageDataEntity.set("storoldprice", (Object)oldprice);
                    storageDataEntity.set("qty", (Object)qty);
                    BigDecimal newcost = qty.multiply(newprice).setScale(amtprecision, 4);
                    BigDecimal oldcost = qty.multiply(oldprice).setScale(amtprecision, 4);
                    storageDataEntity.set("newcost", (Object)newcost);
                    storageDataEntity.set("oldcost", (Object)oldcost);
                    storageDataEntity.set("diffcost", (Object)newcost.subtract(oldcost));
                }
            }
        }
    }

    public Tuple<Boolean, String> updateStorCostByMul(DynamicObject updateBill, DynamicObject establishedBill) {
        Tuple<Boolean, String> result = this.updateStorCost(updateBill, establishedBill);
        DynamicObject originalTargetCostType = updateBill.getDynamicObject("targetcosttype");
        DynamicObjectCollection attachTargetCostTypes = establishedBill.getDynamicObjectCollection("attachtargetcosttype");
        for (DynamicObject attachTargetCostType : attachTargetCostTypes) {
            updateBill.set("targetcosttype", (Object)attachTargetCostType.getDynamicObject("fbasedataid"));
            this.updateStorCost(updateBill, establishedBill);
        }
        updateBill.set("targetcosttype", (Object)originalTargetCostType);
        return result;
    }

    private Tuple<Boolean, String> updateStorCost(DynamicObject updateBill, DynamicObject establishedBill) {
        HashMap<String, Object> matCostInfoMap = new HashMap<String, Object>();
        Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
        DynamicObjectCollection matCostInfos = establishedBill.getDynamicObjectCollection("costupdateentry");
        ArrayList<DynamicObject> entrys = new ArrayList<DynamicObject>(matCostInfos.size());
        for (DynamicObject matCostInfo : matCostInfos) {
            if (!targetCostTypeId.equals(matCostInfo.getLong("costtype.id"))) continue;
            entrys.add(matCostInfo);
        }
        ArrayList<Long> keyColIds = new ArrayList<Long>(entrys.size());
        Map<Long, Boolean> matAuxptyInfo = this.getAuxptyAndKeyCol(entrys, keyColIds);
        this.logger.info(String.format("\u66f4\u65b0\u6838\u7b97\u6210\u672c\u5230\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf keycolids:%s", keyColIds));
        Map<Long, Map<String, Object>> dimensions = this.getDimensionByKeyColIds(keyColIds);
        for (DynamicObject entry : entrys) {
            Object matcostInfosSet;
            HashMap<String, Number> matcostInfosMap = new HashMap<String, Number>();
            matcostInfosMap.put("materialid", entry.getLong("material.id"));
            matcostInfosMap.put("matverisoinid", entry.getString("matversion.id") == null ? 0L : entry.getLong("matversion.id"));
            matcostInfosMap.put("auxpropid", entry.getString("auxprop.id") == null ? 0L : entry.getLong("auxprop.id"));
            matcostInfosMap.put("elementid", entry.getString("element.id") == null ? 0L : entry.getLong("element.id"));
            matcostInfosMap.put("subelementid", entry.getString("subelement.id") == null ? 0L : entry.getLong("subelement.id"));
            matcostInfosMap.put("oldprice", entry.getBigDecimal("oldprice"));
            matcostInfosMap.put("newprice", entry.getBigDecimal("newprice"));
            Long keyColId = entry.getLong("keycolid.id");
            Map<String, Object> dimension = dimensions.get(keyColId);
            if (!CadEmptyUtils.isEmpty((Map)dimension)) {
                matcostInfosMap.putAll(dimension);
            }
            CharSequence matKey = new StringBuilder();
            ((StringBuilder)matKey).append(entry.getString("material.id")).append("@");
            ((StringBuilder)matKey).append(entry.getString("matversion.id") == null ? "0" : entry.getString("matversion.id")).append("@");
            ((StringBuilder)matKey).append(entry.getString("auxprop.id") == null ? "0" : entry.getString("auxprop.id")).append("@");
            ((StringBuilder)matKey).append((Object)(dimension.get("configuredcode") == null ? "0" : dimension.get("configuredcode"))).append("@");
            ((StringBuilder)matKey).append((Object)(dimension.get("tracknumber") == null ? "0" : dimension.get("tracknumber"))).append("@");
            ((StringBuilder)matKey).append((Object)(dimension.get("project") == null ? "0" : dimension.get("project"))).append("@");
            ((StringBuilder)matKey).append((Object)(CadEmptyUtils.isEmpty((String)dimension.get("lot").toString()) ? " " : dimension.get("lot")));
            String matKeyStr = ((StringBuilder)matKey).toString();
            if (!matCostInfoMap.containsKey(matKeyStr)) {
                matcostInfosSet = new HashSet();
                matcostInfosSet.add(matcostInfosMap);
                matCostInfoMap.put(matKeyStr, matcostInfosSet);
                continue;
            }
            matcostInfosSet = (Set)matCostInfoMap.get(matKeyStr);
            matcostInfosSet.add(matcostInfosMap);
        }
        if (!matCostInfoMap.isEmpty()) {
            this.logger.info(String.format("\u66f4\u65b0\u6838\u7b97\u6210\u672c\u5230\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf matCostInfoMap.keyset:%s", matCostInfoMap.keySet()));
        }
        HashSet<Map<String, Object>> costAllMatCostInfoSet = new HashSet<Map<String, Object>>();
        List<Map<String, Map<String, BigDecimal>>> storageDatas = this.getStorMatInfos(updateBill, establishedBill);
        if (CadEmptyUtils.isEmpty(storageDatas)) {
            return new Tuple((Object)Boolean.TRUE, null);
        }
        Map<String, Map<String, BigDecimal>> storageData = storageDatas.get(0);
        HashMap<String, BigDecimal> matTotalQtyInfosMap = new HashMap<String, BigDecimal>(16);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : storageData.entrySet()) {
            Map<String, BigDecimal> matQtyInfos = entry.getValue();
            for (Map.Entry<String, BigDecimal> entrySet : matQtyInfos.entrySet()) {
                BigDecimal qty = entrySet.getValue();
                String key = entrySet.getKey();
                if (!matTotalQtyInfosMap.containsKey(key)) {
                    matTotalQtyInfosMap.put(key, qty);
                    continue;
                }
                matTotalQtyInfosMap.put(key, ((BigDecimal)matTotalQtyInfosMap.get(key)).add(qty));
            }
        }
        for (CharSequence matKey : matTotalQtyInfosMap.keySet()) {
            String newMatKey;
            Set matCostInfosSet = (Set)matCostInfoMap.get(matKey);
            if (matCostInfosSet == null && (StringUtils.isEmpty((String)(newMatKey = this.getMatKey((String)matKey, matAuxptyInfo))) || (matCostInfosSet = (Set)matCostInfoMap.get(newMatKey)) == null)) continue;
            for (Map currMatCostInfoMap : matCostInfosSet) {
                BigDecimal newPrice;
                BigDecimal oldPrice = new BigDecimal(currMatCostInfoMap.get("oldprice").toString());
                if (oldPrice.compareTo(newPrice = new BigDecimal(currMatCostInfoMap.get("newprice").toString())) == 0) continue;
                Long auxptyId = this.getAuxptyId((String)matKey, matAuxptyInfo);
                if (auxptyId != null) {
                    currMatCostInfoMap.put("auxpropid", auxptyId);
                }
                currMatCostInfoMap.put("oldprice", oldPrice);
                currMatCostInfoMap.put("newprice", newPrice);
                currMatCostInfoMap.put("updatebillid", updateBill.getLong("id"));
                currMatCostInfoMap.put("effectdate", establishedBill.getDate("effecttime"));
                costAllMatCostInfoSet.add(currMatCostInfoMap);
            }
        }
        this.logger.info(String.format("\u66f4\u65b0\u6838\u7b97\u6210\u672c\u5230\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf costAllMatCostInfoSet:%s", costAllMatCostInfoSet));
        Object result = this.updateCalCost(updateBill, costAllMatCostInfoSet);
        Tuple<Boolean, String> statu = this.isSuccess("updateCost", result);
        if (Boolean.FALSE.equals(statu.item1)) {
            return statu;
        }
        return new Tuple((Object)Boolean.TRUE, null);
    }

    private Object updateCalCost(DynamicObject updateBill, Set<Map<String, Object>> costAllMatCostInfoSet) {
        Long costTypeId = updateBill.getLong("targetcosttype.id");
        Object[] calcParam = new Object[]{costTypeId, costAllMatCostInfoSet};
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"updateCost", (Object[])calcParam);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        return result;
    }

    public ThreeTuple<Boolean, Date, String> stopSyncBizBill(DynamicObject updatebill, DynamicObject establishedBill, Date effectTime) {
        Long costTypeId = updatebill.getLong("targetcosttype.id");
        DynamicObjectCollection costUpdateEntrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        HashSet matIds = new HashSet(costUpdateEntrys.size());
        costUpdateEntrys.forEach(p -> matIds.add(p.getLong("material.id")));
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("material", "in", matIds)};
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"material", (QFilter[])filters);
        if (matCostInfos.isEmpty()) {
            return new ThreeTuple((Object)Boolean.TRUE, (Object)effectTime, null);
        }
        matIds.clear();
        matCostInfos.forEach(p -> matIds.add(p.getLong("material")));
        Object[] calcParam = new Object[]{costTypeId, matIds};
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"stopSyncBizBill", (Object[])calcParam);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        if (result == null) {
            return new ThreeTuple((Object)Boolean.FALSE, null, (Object)"stopSyncBizBill result = null");
        }
        Map resultMap = (Map)result;
        this.writeResultLog("stopSyncBizBill", resultMap);
        String msg = (String)resultMap.get("msg");
        String strTime = (String)resultMap.get("time");
        if (strTime == null) {
            return new ThreeTuple((Object)Boolean.FALSE, null, (Object)msg);
        }
        Long time = Long.valueOf(strTime);
        Date dateTime = null;
        if (time != null) {
            Date date = new Date(time);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("S");
            int s = Integer.parseInt(simpleDateFormat.format(date));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                dateTime = dateFormat.parse(dateFormat.format(date));
                if (s >= 500) {
                    dateTime = DateUtils.getLastSecond((Date)dateTime, (int)-1);
                }
            }
            catch (ParseException e) {
                this.logger.error("stopSyncBizBill\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if ("1".equals(resultMap.get("result")) && dateTime != null) {
            return new ThreeTuple((Object)Boolean.TRUE, dateTime, null);
        }
        return new ThreeTuple((Object)Boolean.FALSE, null, (Object)msg);
    }

    public Tuple<Boolean, String> startSyncBizBill(DynamicObject establishedBill, Set<Long> failKeycolIds) {
        HashSet<Long> matIds = new HashSet<Long>(10);
        if (!CadEmptyUtils.isEmpty(failKeycolIds)) {
            QFilter filter = new QFilter("id", "in", failKeycolIds);
            DataSet keycolDataSet = QueryServiceHelper.queryDataSet((String)"startSyncBizBill", (String)"cad_keycol", (String)"material", (QFilter[])new QFilter[]{filter}, null);
            while (keycolDataSet.hasNext()) {
                Row row = keycolDataSet.next();
                if (row == null) continue;
                Long material = row.getLong("material");
                matIds.add(material);
            }
        }
        Object[] calcParam = this.getCalcParam(establishedBill, matIds);
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"startSyncBizBill", (Object[])calcParam);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        return this.isSuccess("startSyncBizBill", result);
    }

    private Object[] getCalcParam(DynamicObject establishedBill, Set<Long> addMatIds) {
        Long costTypeId = establishedBill.getLong("targetcosttype.id");
        DynamicObjectCollection matCostInfos = establishedBill.getDynamicObjectCollection("costupdateentry");
        HashSet<Long> matIds = new HashSet<Long>(10);
        matCostInfos.forEach(p -> matIds.add(p.getLong("material.id")));
        if (!CadEmptyUtils.isEmpty(addMatIds)) {
            matIds.addAll(addMatIds);
        }
        return new Object[]{costTypeId, matIds};
    }

    private List<Map<String, Map<String, BigDecimal>>> getStorMatInfos(DynamicObject updateBill, DynamicObject establishedBill) {
        HashMap<String, Map<String, BigDecimal>> matCostaccountInfoMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Map<String, BigDecimal>> matWarehouseInfoMap = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, Object> resultMap = this.getMaterialQty(updateBill, establishedBill);
        if (resultMap == null) {
            this.logger.info("\u83b7\u53d6\u5b58\u8d27\u670d\u52a1getMaterialQty\u4e3a\u7a7a");
            return new ArrayList<Map<String, Map<String, BigDecimal>>>(1);
        }
        HashSet matQtyInfoMap = (HashSet)resultMap.get("resultset");
        if (CadEmptyUtils.isEmpty((Set)matQtyInfoMap)) {
            return new ArrayList<Map<String, Map<String, BigDecimal>>>(1);
        }
        for (Map matQtyInfo : matQtyInfoMap) {
            Map<String, BigDecimal> matQtyInfosMap;
            StringBuilder sg = new StringBuilder();
            sg.append(matQtyInfo.get("materialid")).append("@").append(matQtyInfo.get("matverisoinid")).append("@").append(matQtyInfo.get("auxpropid")).append("@").append(matQtyInfo.get("configuredcode")).append("@").append(matQtyInfo.get("tracknumber")).append("@").append(matQtyInfo.get("project")).append("@").append(StringUtils.isNotEmpty((String)matQtyInfo.get("lot").toString()) ? matQtyInfo.get("lot") : " ");
            String matKey = sg.toString();
            String costaccountKey = matQtyInfo.get("accountorgid") + "@";
            costaccountKey = costaccountKey + matQtyInfo.get("costaccountid");
            String warehouseKey = costaccountKey + "@" + matQtyInfo.get("warehouseid");
            BigDecimal qty = new BigDecimal(matQtyInfo.get("qty").toString());
            if (matCostaccountInfoMap.containsKey(costaccountKey)) {
                matQtyInfosMap = (Map)matCostaccountInfoMap.get(costaccountKey);
                if (!matQtyInfosMap.containsKey(matKey)) {
                    matQtyInfosMap.put(matKey, qty);
                } else {
                    matQtyInfosMap.put(matKey, qty.add((BigDecimal)matQtyInfosMap.get(matKey)));
                }
            } else {
                matQtyInfosMap = new HashMap();
                matQtyInfosMap.put(matKey, qty);
                matCostaccountInfoMap.put(costaccountKey, matQtyInfosMap);
            }
            if (matWarehouseInfoMap.containsKey(warehouseKey)) {
                matQtyInfosMap = (Map)matWarehouseInfoMap.get(warehouseKey);
                if (!matQtyInfosMap.containsKey(matKey)) {
                    matQtyInfosMap.put(matKey, qty);
                    continue;
                }
                matQtyInfosMap.put(matKey, qty.add((BigDecimal)matQtyInfosMap.get(matKey)));
                continue;
            }
            matQtyInfosMap = new HashMap();
            matQtyInfosMap.put(matKey, qty);
            matWarehouseInfoMap.put(warehouseKey, matQtyInfosMap);
        }
        this.logger.info(String.format("\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u4fe1\u606f matCostaccountInfoMap keyset:%s", matCostaccountInfoMap.keySet()));
        this.logger.info(String.format("\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u4fe1\u606f matWarehouseInfoMap keyset:%s", matWarehouseInfoMap.keySet()));
        return Arrays.asList(matCostaccountInfoMap, matWarehouseInfoMap);
    }

    private Map<String, Object> getMaterialQty(DynamicObject updateBill, DynamicObject establishedBill) {
        Long costTypeId = updateBill.getLong("targetcosttype.id");
        DynamicObjectCollection entrys = establishedBill.getDynamicObjectCollection("costupdateentry");
        ArrayList<Long> keyColIds = new ArrayList<Long>(entrys.size());
        for (DynamicObject entry : entrys) {
            DynamicObject costType = entry.getDynamicObject("costtype");
            if (costType == null || !costTypeId.equals(costType.getLong("id"))) continue;
            keyColIds.add(entry.getLong("keycolid.id"));
        }
        List<Map<String, Object>> dimensions = this.getQtyByDimensions(keyColIds);
        if (CadEmptyUtils.isEmpty(dimensions)) {
            return null;
        }
        Object[] params = new Object[]{costTypeId, dimensions};
        this.logger.info("\u83b7\u53d6getMaterialQty");
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostUpdateService", (String)"getMaterialQty", (Object[])params);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
        if (result == null) {
            this.logger.error("\u83b7\u53d6getMaterialQty\u8fd4\u56de\u503c\u4e3a\u7a7a");
            return null;
        }
        Map resultMap = (Map)result;
        this.writeResultLog("getMaterialQty", resultMap);
        if ("0".equals(resultMap.get("result"))) {
            this.logger.error("\u83b7\u53d6getMaterialQty\u5931\u8d25");
            return null;
        }
        return resultMap;
    }

    private Tuple<Boolean, String> isSuccess(String serviceMethod, Object storCalResutl) {
        if (storCalResutl == null) {
            return new Tuple((Object)Boolean.FALSE, (Object)(serviceMethod + " result = null"));
        }
        Map resultMap = (Map)storCalResutl;
        this.writeResultLog(serviceMethod, resultMap);
        if ("1".equals(resultMap.get("result"))) {
            return new Tuple((Object)Boolean.TRUE, null);
        }
        return new Tuple((Object)Boolean.FALSE, (Object)((String)resultMap.get("msg")));
    }

    private void writeResultLog(String serviceMethod, Map<String, Object> resultMap) {
        if (resultMap == null) {
            this.logger.error(String.format("\u5fae\u670d\u52a1%s \u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a resultMap = null", serviceMethod));
        } else {
            if ("0".equals(resultMap.get("result")) && resultMap.get("msg") != null) {
                String msg = serviceMethod + "--" + resultMap.get("msg").toString();
                this.logger.error("\u5b58\u8d27\u5fae\u670d\u52a1\u51fa\u9519\uff1a" + msg);
            }
            this.logger.info(String.format("\u5fae\u670d\u52a1%s \u8fd4\u56de\u7ed3\u679c\u5927\u5c0f\uff1a%s \u8fd4\u56de\u503c\uff1a%s", serviceMethod, resultMap.size(), resultMap));
        }
    }

    private Map<Long, Boolean> getAuxptyAndKeyCol(List<DynamicObject> entrys, List<Long> keyColIds) {
        HashMap<Long, Boolean> matAuxptyInfo = new HashMap<Long, Boolean>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject mat = entry.getDynamicObject("material");
            if (mat == null) continue;
            matAuxptyInfo.put(mat.getLong("id"), this.isAffectPrice(mat));
            Long keyColId = entry.getLong("keycolid.id");
            if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
            keyColIds.add(keyColId);
        }
        return matAuxptyInfo;
    }

    private Boolean isAffectPrice(DynamicObject mat) {
        Boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
        if (Boolean.TRUE.equals(isUseAuxpty)) {
            DynamicObjectCollection isaffectprice = mat.getDynamicObjectCollection("auxptyentry");
            for (DynamicObject isPrice : isaffectprice) {
                if (!isPrice.getBoolean("isaffectprice")) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getMatKey(String matKey, Map<Long, Boolean> matAuxptyInfos) {
        String[] matInfos = matKey.split("@");
        if (matInfos.length == 0) {
            return null;
        }
        Long matId = Long.parseLong(matInfos[0]);
        Boolean result = matAuxptyInfos.get(matId);
        if (Boolean.TRUE.equals(result)) {
            return matInfos[0].concat("@").concat(matInfos[1]);
        }
        return null;
    }

    private Long getAuxptyId(String matKey, Map<Long, Boolean> matAuxptyInfos) {
        String[] matInfos = matKey.split("@");
        if (matInfos.length == 0) {
            return null;
        }
        Long matId = Long.parseLong(matInfos[0]);
        Boolean result = matAuxptyInfos.get(matId);
        if (Boolean.TRUE.equals(result)) {
            return Long.parseLong(matInfos[2]);
        }
        return null;
    }

    private Map<Long, Map<String, Object>> getDimensionByKeyColIds(List<Long> keyColIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(keyColIds.size());
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return result;
        }
        HashMap<String, Object> keyCols = null;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"id,project,tracknumber,configuredcode,lot", (QFilter[])filters);
        for (DynamicObject dyKeyCol : dyKeyCols) {
            keyCols = new HashMap<String, Object>(4);
            keyCols.put("project", dyKeyCol.getLong("project"));
            keyCols.put("tracknumber", dyKeyCol.getLong("tracknumber"));
            keyCols.put("configuredcode", dyKeyCol.getLong("configuredcode"));
            keyCols.put("lot", dyKeyCol.getString("lot"));
            result.put(dyKeyCol.getLong("id"), keyCols);
        }
        return result;
    }

    private List<Map<String, Object>> getQtyByDimensions(List<Long> keyColIds) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(keyColIds.size());
        if (CadEmptyUtils.isEmpty(keyColIds)) {
            return result;
        }
        HashMap<String, Object> keyCols = null;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
        DynamicObjectCollection dyKeyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"material,matvers mversion,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])filters);
        for (DynamicObject dyKeyCol : dyKeyCols) {
            keyCols = new HashMap<String, Object>(7);
            keyCols.put("material", dyKeyCol.getLong("material"));
            keyCols.put("mversion", dyKeyCol.getLong("mversion"));
            keyCols.put("assist", dyKeyCol.getLong("assist"));
            keyCols.put("project", dyKeyCol.getLong("project"));
            keyCols.put("tracknumber", dyKeyCol.getLong("tracknumber"));
            keyCols.put("configuredcode", dyKeyCol.getLong("configuredcode"));
            keyCols.put("lot", dyKeyCol.getString("lot"));
            result.add(keyCols);
        }
        this.logger.info("\u6839\u636e\u7ef4\u5ea6\u83b7\u53d6\u5b58\u8d27\u6570\u91cf\uff0c\u4f20\u5165\u53c2\u6570result = {}", result);
        return result;
    }

    private String stringConvert(String val) {
        if (StringUtils.isNotEmpty((String)val)) {
            return val;
        }
        return "0";
    }

    private Long getKeyColId(String[] matKeyStrs) {
        if (matKeyStrs.length != 7) {
            this.logger.info(String.format("matKeyStrs:%s", String.join((CharSequence)"@", matKeyStrs)));
            return 0L;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(16);
        values.put("material", Long.parseLong(matKeyStrs[0]));
        values.put("matvers", Long.parseLong(matKeyStrs[1]));
        values.put("auxproperty", Long.parseLong(matKeyStrs[2]));
        values.put("configuredcode", Long.parseLong(matKeyStrs[3]));
        values.put("tracknumber", Long.parseLong(matKeyStrs[4]));
        values.put("project", Long.parseLong(matKeyStrs[5]));
        values.put("lot", matKeyStrs[6]);
        Keycol keyCol = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)false);
        return keyCol.getId();
    }
}

