/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.update;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.business.update.UpdateLogInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class UpdateLog
implements Serializable {
    private static final long serialVersionUID = 1509515669372724612L;
    private static final Log logger = LogFactory.getLog(UpdateLog.class);
    private long startTime = System.currentTimeMillis();
    private long taskId = 0L;
    private Long costTypeId = 0L;
    private Boolean isSuc = Boolean.TRUE;

    public Long getCostTypeId() {
        return this.costTypeId;
    }

    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setIsSuc(boolean isSuc) {
        this.isSuc = isSuc;
    }

    public boolean getIsSuc() {
        return this.isSuc;
    }

    public void write(int errorType, Long startTime, String catalog, String errDesc, String tipContent) {
        long duration = System.currentTimeMillis() - startTime;
        this.write2db(errorType, startTime, duration, catalog, errDesc, tipContent);
    }

    private void write2db(int errorType, long startTime, long duration, String catalog, String errDesc, String tipContent) {
        if (errorType != 9) {
            try {
                UpdateLog.addTaskDetail(this.getCostTypeId(), this.getTaskId(), new Date(startTime), duration, errorType, catalog, errDesc, tipContent);
            }
            catch (Exception exp) {
                logger.error("\u5199\u5165\u65e5\u5fd7\u9519\u8bef", (Throwable)exp);
            }
        } else {
            logger.info(String.format("%s\u8017\u65f6%sms:%s", catalog, duration, errDesc));
        }
    }

    public void finish(String catalog, String desc) {
        long duration = this.getTotalTime();
        TaskServiceHelper.addTaskDetail((Long)this.getCostTypeId(), (Long)this.getTaskId(), (Date)new Date(this.startTime), (long)duration, (int)3, (String)catalog, (String)desc);
        logger.info(String.format("%s\u8017\u65f6%sms:%s", catalog, duration, desc));
    }

    private static void addTaskDetail(Long costTypeId, Long taskid, Date startTime, long time, int status, String name, String errDesc, String tipContent) {
        taskid = UpdateLog.isHaveTask(costTypeId, taskid);
        DynamicObject tasklog = BusinessDataServiceHelper.newDynamicObject((String)"cad_taskexecutelog");
        if (name != null && name.length() > 199) {
            tasklog.set("name", (Object)name.substring(0, 199));
        } else {
            tasklog.set("name", (Object)name);
        }
        tasklog.set("task", (Object)taskid);
        if (startTime != null) {
            tasklog.set("starttime", (Object)startTime);
            tasklog.set("timestamp", (Object)startTime.getTime());
        }
        tasklog.set("time", (Object)(time <= 0L ? 1L : time));
        errDesc = CadEmptyUtils.isEmpty((String)errDesc) ? "" : errDesc;
        tasklog.set("errlog", (Object)(errDesc.length() < 2000 ? errDesc : errDesc.substring(0, 1999)));
        tasklog.set("errlog_tag", (Object)errDesc);
        tasklog.set("content", (Object)tipContent);
        tasklog.set("status", (Object)String.valueOf(status));
        tasklog.set("createtime", (Object)new Date());
        tasklog.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_taskexecutelog");
        SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{tasklog});
    }

    private static Long isHaveTask(Long costTypeId, Long taskid) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskid);
        DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"id,progress,status", (QFilter[])new QFilter[]{idFilter});
        if (taskInfo == null) {
            taskid = TaskServiceHelper.createTask((Long)costTypeId, (Long)taskid, (String)ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0", (String)"UpdateLog_0", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        return taskid;
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void addLogInfo(List<UpdateLogInfo> logs, Long startTime, String catalog, String errDesc, String tipContent, int errorType) {
        UpdateLogInfo info = new UpdateLogInfo();
        info.setStartTime(startTime);
        info.setCatalog(catalog);
        info.setErrDesc(errDesc);
        info.setTipContent(tipContent.length() < 255 ? tipContent : tipContent.substring(0, 255));
        info.setErrorType(errorType);
        logs.add(info);
    }

    public void setSucMatCount(Integer successCount) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)this.getTaskId(), (String)"cad_calctaskrecord", (String)"id,nextpagepara");
        if (record == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"successCount", (Object)successCount);
        record.set("nextpagepara", (Object)jsonObject.toString());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{record});
    }
}

