/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.updatecheck;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class CalcIsOverCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        Long costTypeId = context.getCostTypeId();
        JSONObject params = context.getCheckParamJs();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Boolean isAllUpdate = params.getBoolean("isallupdate");
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        if (Boolean.FALSE.equals(isAllUpdate)) {
            List keyColIds = (List)params.get("keycolids");
            filters.add(new QFilter("keycolid", "in", (Object)keyColIds));
        }
        filters.add(new QFilter("status", "!=", (Object)"C"));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cad_calchangerecord", (String)"businessbill,srcbillno", (QFilter[])filters.toArray(new QFilter[0]));
        if (records.isEmpty()) {
            return;
        }
        String res = ResManager.loadKDString((String)"\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\u7f16\u7801%s\uff0c\u53d1\u751f\u4e86\u53d8\u52a8\u3002", (String)"CalcIsOverCheck_2", (String)"macc-cad-business", (Object[])new Object[0]);
        String out = ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868\u7f16\u7801%s\u53d1\u751f\u4e86\u53d8\u52a8\u3002", (String)"CalcIsOverCheck_3", (String)"macc-cad-business", (Object[])new Object[0]);
        String bom = ResManager.loadKDString((String)"\u6210\u672cBOM\u8bbe\u7f6e\u7f16\u7801%s\uff0c\u53d1\u751f\u4e86\u53d8\u52a8\u3002", (String)"CalcIsOverCheck_4", (String)"macc-cad-business", (Object[])new Object[0]);
        String rou = ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\u7f16\u7801%s\u53d1\u751f\u4e86\u53d8\u52a8\u3002", (String)"CalcIsOverCheck_5", (String)"macc-cad-business", (Object[])new Object[0]);
        for (DynamicObject record : records) {
            String entityName = record.getString("businessbill");
            String error = null;
            switch (entityName) {
                case "cad_resourcerate": {
                    error = res;
                    break;
                }
                case "cad_outsourceprice": {
                    error = out;
                    break;
                }
                case "cad_bomsetting": {
                    error = bom;
                    break;
                }
                case "cad_routersetting": {
                    error = rou;
                    break;
                }
            }
            if (CadEmptyUtils.isEmpty((String)error)) continue;
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            detailinfo.setCheckDetailResult(String.format(error, record.getString("srcbillno")));
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
            this.getSingleCheckContext().setPass(false);
        }
    }
}

