/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.updatecheck;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class CostAccountCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        JSONObject params = context.getCheckParamJs();
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)params.getLong("tarcosttype")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount.id accountid,costaccount.number accountnumber,costaccount.name accountname", (QFilter[])filters);
        if (accounts.isEmpty()) {
            return;
        }
        HashMap<Long, String> accountInfos = new HashMap<Long, String>(10);
        QFilter filter = null;
        for (DynamicObject account : accounts) {
            QFilter f = new QFilter("org", "=", (Object)account.getLong("calorg"));
            f.and("entryentity.costaccount", "=", (Object)account.getLong("accountid"));
            if (filter == null) {
                filter = f;
            } else {
                filter.or(f);
            }
            accountInfos.put(account.getLong("accountid"), account.getString("accountnumber") + "/" + account.getString("accountname"));
        }
        QFilter appFilter = new QFilter("appnum", "=", (Object)"sca");
        QFilter enableFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id accountid", (QFilter[])new QFilter[]{filter, appFilter, enableFilter});
        HashSet accountIds = new HashSet(startStdCosts.size());
        startStdCosts.forEach(p -> accountIds.add(p.getLong("accountid")));
        for (Map.Entry accountInfo : accountInfos.entrySet()) {
            if (accountIds.contains(accountInfo.getKey())) continue;
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            detailinfo.setCheckDetailResult(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u3002", (String)"CostAccountCheck_2", (String)"macc-cad-business", (Object[])new Object[0]), accountInfo.getValue()));
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
    }
}

