/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.updatecheck;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class EffectTimeCheck
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(EffectTimeCheck.class);

    public void doCheck() {
        CalcCheckContext context = this.getContext();
        JSONObject params = context.getCheckParamJs();
        Date effectTime = new Date(params.getLong("effecttime"));
        Long tarCostTypeId = params.getLong("tarcosttype");
        Boolean isAllUpdate = params.getBoolean("isallupdate");
        Long updateBillId = params.getLong("updatebillid");
        ArrayList<Long> matIds = new ArrayList<Long>(16);
        ArrayList<Long> keyColIds = new ArrayList(16);
        logger.info("\u68c0\u67e5\u9879-\u5f85\u66f4\u65b0\u7269\u6599\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u751f\u6548\u65f6\u95f4\u3002\u5f85\u66f4\u65b0\u7684keycolid\uff1a{}", keyColIds);
        if (Boolean.FALSE.equals(isAllUpdate)) {
            keyColIds = (List)params.get("keycolids");
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", keyColIds)};
            DynamicObjectCollection keyCols = QueryServiceHelper.query((String)"cad_keycol", (String)"material", (QFilter[])filters);
            keyCols.forEach(p -> matIds.add(p.getLong("material")));
        }
        HashSet<String> matInfos = new HashSet<String>(16);
        HashSet<Long> colIds = new HashSet<Long>(keyColIds);
        boolean isTrack = false;
        Set<Long> errKeycolIds = this.getExistsCalCostRecordKeycolIds(tarCostTypeId, effectTime, matIds, colIds, isTrack);
        logger.info("\u68c0\u67e5\u9879-\u5f85\u66f4\u65b0\u7269\u6599\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u751f\u6548\u65f6\u95f4\u3002\u6838\u7b97\u6210\u672c\u8bb0\u5f55keycolid\uff1a{}", errKeycolIds);
        List<DynamicObject> records = this.getKeycolsTips(errKeycolIds);
        for (DynamicObject dynamicObject : records) {
            String errorInfo = this.getErrorInfo(dynamicObject);
            matInfos.add(errorInfo);
            context.getFailProductKeycols().add(dynamicObject.getString("keycol"));
        }
        DynamicObjectCollection matCosts = this.getMatCostInfos(tarCostTypeId, effectTime, keyColIds);
        logger.info("\u68c0\u67e5\u9879-\u5f85\u66f4\u65b0\u7269\u6599\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u751f\u6548\u65f6\u95f4\u3002\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e2a\u6570\uff1a{}", (Object)matCosts.size());
        for (DynamicObject matCost : matCosts) {
            String errorInfo = this.getErrorInfo(matCost);
            matInfos.add(errorInfo);
            context.getFailProductKeycols().add(matCost.getString("keycol"));
        }
        List<Long> list = this.getAttachRecords(updateBillId);
        logger.info("\u68c0\u67e5\u9879-\u5f85\u66f4\u65b0\u7269\u6599\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u5df2\u751f\u6548\u65f6\u95f4\u3002\u9644\u52a0\u6210\u672c\u7c7b\u578b\u83b7\u53d6\u7684keycolid\uff1a{}", list);
        List<DynamicObject> attachRecords = this.getKeycolsTips(new HashSet<Long>(list));
        for (DynamicObject attachRecord : attachRecords) {
            String errorInfo = this.getErrorInfo(attachRecord);
            matInfos.add(errorInfo);
            context.getFailProductKeycols().add(attachRecord.getString("keycol"));
        }
        if (CadEmptyUtils.isEmpty(matInfos)) {
            return;
        }
        for (String matInfo : matInfos) {
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            String errDesc = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3001\u7269\u6599\u6210\u672c\u4fe1\u606f%1$s\u5df2\u7ecf\u5b58\u5728\u201c%2$s\u201d\u540e\u7684\u66f4\u65b0\u6570\u636e\u3002", (String)"EffectTimeCheck_2", (String)"macc-cad-business", (Object[])new Object[0]), matInfo, TimeUtils.formatDate((Date)effectTime, (String)"yyyy-MM-dd HH:mm:ss"));
            detailinfo.setCheckDetailResult(errDesc);
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        this.getSingleCheckContext().setPass(false);
    }

    private List<DynamicObject> getKeycolsTips(Set<Long> errKeycolIds) {
        QFilter filter = new QFilter("id", "in", errKeycolIds);
        return QueryServiceHelper.query((String)"cad_keycol", (String)"keycol,material,material.number number,material.name name,auxproperty,project,project.number projectnum,tracknumber,tracknumber.number tracknumbernum,configuredcode,configuredcode.number configuredcodenum,lot", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObjectCollection getMatCostInfos(Long costTypeId, Date effectTime, List<Long> keyColIds) {
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), CadEmptyUtils.isEmpty(keyColIds) ? null : new QFilter("keycolid", "in", keyColIds), new QFilter("effectdate", ">", (Object)effectTime)};
        return QueryServiceHelper.query((String)"cad_matcostinfo", (String)"keycolid,keycol,material,material.number number,material.name name,auxpty auxproperty,project,project.number projectnum,tracknumber,tracknumber.number tracknumbernum,configuredcode,configuredcode.number configuredcodenum,lot", (QFilter[])filters);
    }

    private Set<Long> getExistsCalCostRecordKeycolIds(Long costTypeId, Date effectTime, List<Long> matIds, Set<Long> keyColIds, boolean isTrack) {
        HashSet results = Sets.newHashSet();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)effectTime), new QFilter("invaliddate", ">", (Object)effectTime)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])filters);
        if (costTypeOrgs.isEmpty()) {
            return results;
        }
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("calorg", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (costTypeOrg.get("storageorgunit") != null && costTypeOrg.getLong("storageorgunit") > 0L) {
                f.and("storageorgunit", "=", (Object)costTypeOrg.getLong("storageorgunit"));
            }
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        filters = new QFilter[]{filter, CadEmptyUtils.isEmpty(matIds) ? null : new QFilter("entry.material", "in", matIds), isTrack ? null : new QFilter("bookdate", ">=", (Object)effectTime), new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.accounttype", "=", (Object)"D")};
        DataSet costRecords = QueryServiceHelper.queryDataSet((String)"COSTRECORD", (String)"cal_costrecord", (String)"entry.matcostid matcostid,entry.material.id material,entry.material.number number,entry.material.name name,entry.mversion.id mversion,entry.assist.id assist,entry.project.id project,entry.tracknumber.id tracknumber,entry.configuredcode.id configuredcode,entry.lot lot", (QFilter[])filters, null);
        HashSet cdKeycolids = Sets.newHashSet();
        HashSet matcostInfoIds = Sets.newHashSet();
        for (Row costRecord : costRecords) {
            Long matcostId = costRecord.getLong("matcostid");
            if (matcostId == null) {
                Long keycolid = this.getCostRecordKeyColId(costRecord);
                cdKeycolids.add(keycolid);
                continue;
            }
            matcostInfoIds.add(matcostId);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"cad.costupdate.EffectTimeCheck", (String)"cad_matcostinfo", (String)"keycolid.id as keycolid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)matcostInfoIds)}, null);){
            for (Row row : ds) {
                cdKeycolids.add(row.getLong("keycolid"));
            }
        }
        if (keyColIds.isEmpty()) {
            return cdKeycolids;
        }
        keyColIds.retainAll(cdKeycolids);
        return keyColIds;
    }

    private Long getCostRecordKeyColId(Row dynamicObject) {
        HashMap<String, Long> values = new HashMap<String, Long>(7);
        values.put("material", dynamicObject.getLong("material"));
        values.put("matvers", dynamicObject.getLong("mversion"));
        values.put("auxproperty", dynamicObject.getLong("assist"));
        values.put("project", dynamicObject.getLong("project"));
        values.put("tracknumber", dynamicObject.getLong("tracknumber"));
        values.put("configuredcode", dynamicObject.getLong("configuredcode"));
        Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(1), (boolean)false).getId();
        return keyColId;
    }

    private List<Long> getAttachRecords(Long updateBillId) {
        ArrayList<Long> results = new ArrayList<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((String)"cad_costupdatenew", (QFilter[])filters);
        Long periodId = updateBill.getLong("period.id");
        Long targetCostTypeId = updateBill.getLong("targetcosttype.id");
        if (!CadEmptyUtils.isEmpty((Long)periodId) && CostUpdateHelper.isUpdateByPeriod((Long)targetCostTypeId)) {
            DynamicObjectCollection attachCostTypes = updateBill.getDynamicObjectCollection("attachtargetcosttype");
            ArrayList<Long> costTypeIds = new ArrayList<Long>(attachCostTypes.size() + 1);
            costTypeIds.add(targetCostTypeId);
            for (DynamicObject attachCostType : attachCostTypes) {
                costTypeIds.add(attachCostType.getDynamicObject("fbasedataid").getLong("id"));
            }
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
            filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)dates[0]), new QFilter("invaliddate", ">", (Object)dates[1])};
            DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit,costtype", (QFilter[])filters);
            if (costTypeOrgs.isEmpty()) {
                return results;
            }
            Long establishedId = updateBill.getLong("updatebillid");
            if (CadEmptyUtils.isEmpty((Long)establishedId)) {
                return results;
            }
            filters = new QFilter[]{new QFilter("id", "=", (Object)establishedId)};
            DynamicObjectCollection establisheds = QueryServiceHelper.query((String)"cad_costupdateestablished", (String)"costupdateentry.costtype costtype,costupdateentry.material material,costupdateentry.keycolid keycolid", (QFilter[])filters);
            HashMap<Long, ArrayList<Long>> costtypeAndKeyColIds = new HashMap<Long, ArrayList<Long>>(16);
            HashSet<Long> matIds = new HashSet<Long>(1);
            for (DynamicObject established : establisheds) {
                Long costTypeId = established.getLong("costtype");
                List<Long> keyColIds = (List)costtypeAndKeyColIds.get(costTypeId);
                if (CadEmptyUtils.isEmpty((List)keyColIds)) {
                    keyColIds = new ArrayList<Long>(1);
                }
                keyColIds.add(established.getLong("keycolid"));
                costtypeAndKeyColIds.put(costTypeId, (ArrayList<Long>)keyColIds);
                matIds.add(established.getLong("material"));
            }
            QFilter filter = null;
            HashMap<Long, Boolean> orgEnableFactoryMap = new HashMap<Long, Boolean>(16);
            HashMap<String, Long> orgAndCostTypes = new HashMap<String, Long>(1);
            for (DynamicObject costTypeOrg : costTypeOrgs) {
                QFilter f = new QFilter("calorg", "=", (Object)costTypeOrg.getLong("calorg"));
                f.and("costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
                if (costTypeOrg.get("storageorgunit") != null && costTypeOrg.getLong("storageorgunit") > 0L) {
                    f.and("storageorgunit", "=", (Object)costTypeOrg.getLong("storageorgunit"));
                }
                if (filter == null) {
                    filter = f;
                } else {
                    filter.or(f);
                }
                long storageOrgId = costTypeOrg.getLong("storageorgunit");
                long orgId = costTypeOrg.getLong("calorg");
                if (!orgEnableFactoryMap.containsKey(orgId)) {
                    boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                    orgEnableFactoryMap.put(orgId, orgEnableMultiFactory);
                }
                if (!((Boolean)orgEnableFactoryMap.get(orgId)).booleanValue()) {
                    storageOrgId = 0L;
                }
                orgAndCostTypes.put(orgId + 64L + costTypeOrg.getString("costaccount") + '@' + storageOrgId, costTypeOrg.getLong("costtype"));
            }
            filters = new QFilter[]{filter, new QFilter("entry.material", "in", matIds), new QFilter("period", "=", (Object)periodId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.accounttype", "=", (Object)"D")};
            DataSet costRecords = QueryServiceHelper.queryDataSet((String)"COSTRECORD", (String)"cal_costrecord", (String)"billno,calorg,costaccount,storageorgunit,entry.matcostid matcostid,entry.material.id material,entry.material.number number,entry.material.name name,entry.mversion.id mversion,entry.assist.id assist,entry.project.id project,entry.tracknumber.id tracknumber,entry.configuredcode.id configuredcode,entry.lot lot", (QFilter[])filters, null);
            for (Row costRecord : costRecords) {
                Long keyColId;
                List keyColIds;
                Long costType;
                Long calOrg = costRecord.getLong("calorg");
                Long storageOrgUnit = costRecord.getLong("storageorgunit");
                if (!orgEnableFactoryMap.containsKey(calOrg) || !((Boolean)orgEnableFactoryMap.get(calOrg)).booleanValue()) {
                    storageOrgUnit = 0L;
                }
                if (CadEmptyUtils.isEmpty((Long)(costType = (Long)orgAndCostTypes.get(calOrg + 64L + costRecord.getString("costaccount") + '@' + storageOrgUnit))) || CadEmptyUtils.isEmpty((List)(keyColIds = (List)costtypeAndKeyColIds.get(costType))) || !keyColIds.contains(keyColId = this.getCostRecordKeyColId(costRecord))) continue;
                results.add(keyColId);
            }
            for (Map.Entry entry : costtypeAndKeyColIds.entrySet()) {
                Long costTypeId = (Long)entry.getKey();
                List keyColIds = (List)entry.getValue();
                if (CadEmptyUtils.isEmpty((List)keyColIds)) continue;
                DynamicObjectCollection matCosts = this.getMatCostInfos(costTypeId, dates[0], keyColIds);
                results.addAll(DynamicObjectHelper.getIdSet((DynamicObjectCollection)matCosts, (String)"keycolid"));
            }
            return results;
        }
        return results;
    }

    private String getErrorInfo(DynamicObject record) {
        Long material = record.getLong("material");
        String number = record.getString("number");
        String name = record.getString("name");
        Long auxproperty = record.getLong("auxproperty");
        Long project = record.getLong("project");
        String projectnum = record.getString("projectnum");
        Long tracknumber = record.getLong("tracknumber");
        String tracknumbernum = record.getString("tracknumbernum");
        Long configuredcode = record.getLong("configuredcode");
        String configuredcodenum = record.getString("configuredcodenum");
        String lot = record.getString("lot");
        String infoMsg = ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d", (String)"EffectTimeCheck_10", (String)"macc-cad-business", (Object[])new Object[0]);
        String error = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%1$s\uff1b\u540d\u79f0\uff1a%2$s", (String)"EffectTimeCheck_11", (String)"macc-cad-business", (Object[])new Object[0]), number, name);
        if (!CadEmptyUtils.isEmpty((Long)auxproperty)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u8f85\u52a9\u5c5e\u6027id\uff1a%s", (String)"EffectTimeCheck_4", (String)"macc-cad-business", (Object[])new Object[0]), auxproperty);
        }
        if (!CadEmptyUtils.isEmpty((Long)configuredcode)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u914d\u7f6e\u53f7\uff1a%s", (String)"EffectTimeCheck_5", (String)"macc-cad-business", (Object[])new Object[0]), configuredcodenum);
        }
        if (!CadEmptyUtils.isEmpty((Long)tracknumber)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u8ddf\u8e2a\u53f7\uff1a%s", (String)"EffectTimeCheck_6", (String)"macc-cad-business", (Object[])new Object[0]), tracknumbernum);
        }
        if (!CadEmptyUtils.isEmpty((Long)project)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u9879\u76ee\u53f7\uff1a%s", (String)"EffectTimeCheck_7", (String)"macc-cad-business", (Object[])new Object[0]), projectnum);
        }
        if (!CadEmptyUtils.isEmpty((String)lot)) {
            error = error + String.format(ResManager.loadKDString((String)"\uff1b\u6279\u53f7\uff1a%s", (String)"EffectTimeCheck_8", (String)"macc-cad-business", (Object[])new Object[0]), lot);
        }
        return String.format(infoMsg, error);
    }
}

