/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.updatecheck;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class PurPriceCheck
extends AbstractSingleCalcCheckAction {
    private Log logger = LogFactory.getLog(PurPriceCheck.class);

    public void doCheck() {
        CalcCheckContext context = this.getContext();
        Long costTypeId = context.getCostTypeId();
        JSONObject params = context.getCheckParamJs();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Boolean isAllUpdate = params.getBoolean("isallupdate");
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        if (Boolean.FALSE.equals(isAllUpdate)) {
            List keyColIds = (List)params.get("keycolids");
            filters.add(new QFilter("keycolid", "in", (Object)keyColIds));
        }
        this.logger.info("\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868filter:{}", filters);
        DynamicObjectCollection calcPurPrices = QueryServiceHelper.query((String)"cad_calcpurprices", (String)"priceid", (QFilter[])filters.toArray(new QFilter[0]));
        if (calcPurPrices.isEmpty()) {
            return;
        }
        ArrayList ids = new ArrayList(calcPurPrices.size());
        calcPurPrices.forEach(p -> ids.add(p.getLong("priceid")));
        filters.clear();
        filters.add(new QFilter("id", "in", ids));
        filters.add(new QFilter("billstatus", "!=", (Object)"C"));
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"billno", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)purPrices)) {
            return;
        }
        for (DynamicObject purPrice : purPrices) {
            CalcCheckDetailResultInfo detailinfo = new CalcCheckDetailResultInfo();
            detailinfo.setCheckDetailResult(String.format(ResManager.loadKDString((String)"\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868\u201c%s\u201d\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\u3002", (String)"PurPriceCheck_2", (String)"macc-cad-business", (Object[])new Object[0]), purPrice.getString("billno")));
            this.getSingleCheckContext().getCheckDetailResult().add(detailinfo);
        }
        this.getSingleCheckContext().setPass(false);
    }
}

