/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.common.enums.HourExpenseEnum;

public class SysParamHelper {
    private static final Log logger = LogFactory.getLog(SysParamHelper.class);

    public static Map<String, Boolean> getHourExpense(Long orgId) {
        String[] expenses;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(3);
        QFilter[] filters = new QFilter[]{new QFilter("actorg", "=", (Object)orgId), new QFilter("tab", "=", (Object)"settingtabpage"), new QFilter("appnum", "=", (Object)"eca")};
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"hourexpense", (QFilter[])filters);
        if (sysParam == null) {
            return result;
        }
        String hourExpense = sysParam.getString("hourexpense");
        logger.info("\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\uff1a{}", (Object)hourExpense);
        for (String expense : expenses = hourExpense.split(",")) {
            result.put(expense.toUpperCase().trim(), Boolean.TRUE);
        }
        result.put(HourExpenseEnum.TRADE.getValue(), hourExpense.contains("," + HourExpenseEnum.TRADE.getValue() + ","));
        result.put(HourExpenseEnum.ROLE.getValue(), hourExpense.contains("," + HourExpenseEnum.ROLE.getValue() + ","));
        result.put(HourExpenseEnum.RESOURCE.getValue(), hourExpense.contains("," + HourExpenseEnum.RESOURCE.getValue() + ","));
        return result;
    }

    public static List<String> getHourExpenseDimenSion(Long orgId) {
        String[] expenses;
        ArrayList<String> result = new ArrayList<String>();
        QFilter[] filters = new QFilter[]{new QFilter("actorg", "=", (Object)orgId), new QFilter("tab", "=", (Object)"settingtabpage"), new QFilter("appnum", "=", (Object)"eca")};
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"hourexpense", (QFilter[])filters);
        if (sysParam == null) {
            return result;
        }
        String hourExpense = sysParam.getString("hourexpense");
        logger.info("\u5de5\u65f6\u8d39\u7528\u7ef4\u5ea6\uff1a{}", (Object)hourExpense);
        for (String expense : expenses = hourExpense.split(",")) {
            if (CadEmptyUtils.isEmpty((String)expense)) continue;
            result.add(expense);
        }
        return result;
    }

    public static Boolean getEnableEffectByOrg(Long orgId, String value) {
        String effectcontrol;
        if (CadEmptyUtils.isEmpty((Long)orgId) || value == null) {
            return false;
        }
        QFilter acctOrgFilter = new QFilter("actorg", "=", (Object)orgId);
        acctOrgFilter.and("tab", "=", (Object)"settingtabpage");
        acctOrgFilter.and("appnum", "=", (Object)"eca");
        DynamicObject costAccumulParam = BusinessDataServiceHelper.loadSingle((String)"cad_sysparam", (String)"id,actorg,effectcontrol", (QFilter[])new QFilter[]{acctOrgFilter});
        if (costAccumulParam != null && !CadEmptyUtils.isEmpty((String)(effectcontrol = costAccumulParam.getString("effectcontrol")))) {
            return effectcontrol.contains(value);
        }
        return false;
    }
}

