/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.common.helper;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TimeConverter {
    public static final long HOUR = 10L;
    public static final long MINUTE = 9L;
    public static final long SECOND = 8L;
    private static final Set<Long> TIME_UNIT_IDS_FOR_SYS = new HashSet<Long>(16){
        {
            this.add(10L);
            this.add(9L);
            this.add(8L);
        }
    };
    private static final BigDecimal N60 = BigDecimal.valueOf(60L);
    private static final BigDecimal N360 = BigDecimal.valueOf(360L);

    public static BigDecimal convertPrice(long fromUnit, long toUnit, BigDecimal qty) {
        if (fromUnit == toUnit) {
            return qty;
        }
        if (fromUnit == 10L) {
            if (toUnit == 9L) {
                return qty.divide(N60, 10, 4);
            }
            if (toUnit == 8L) {
                return qty.divide(N360, 10, 4);
            }
            throw new KDBizException("time unit error");
        }
        if (fromUnit == 9L) {
            if (toUnit == 10L) {
                return qty.multiply(N60);
            }
            if (toUnit == 8L) {
                return qty.divide(N60, 10, 4);
            }
            throw new KDBizException("time unit error");
        }
        if (fromUnit == 8L) {
            if (toUnit == 10L) {
                return qty.multiply(N360);
            }
            if (toUnit == 9L) {
                return qty.multiply(N60);
            }
            throw new KDBizException("time unit error");
        }
        return qty;
    }

    public static BigDecimal convertHour(long fromUnit, long toUnit, BigDecimal qty) {
        if (fromUnit == toUnit) {
            return qty;
        }
        if (fromUnit == 10L) {
            if (toUnit == 9L) {
                return qty.multiply(N60);
            }
            if (toUnit == 8L) {
                return qty.multiply(N360);
            }
            throw new KDBizException("time unit error");
        }
        if (fromUnit == 9L) {
            if (toUnit == 10L) {
                return qty.divide(N60, 10, 4);
            }
            if (toUnit == 8L) {
                return qty.multiply(N60);
            }
            throw new KDBizException("time unit error");
        }
        if (fromUnit == 8L) {
            if (toUnit == 10L) {
                return qty.divide(N360, 10, 4);
            }
            if (toUnit == 9L) {
                return qty.divide(N60, 10, 4);
            }
            throw new KDBizException("time unit error");
        }
        return qty;
    }

    public static BigDecimal convertPriceByConversionFactor(long fromUnit, long toUnit, BigDecimal qty) {
        ConversionFactor conversionFactor = TimeConverter.getConversionFactor(fromUnit);
        BigDecimal result = TimeConverter.convertPrice(conversionFactor.getFromUnitId(), toUnit, qty);
        return result.multiply(conversionFactor.getConversionFactor(), MathContext.UNLIMITED);
    }

    public static ConversionFactor getConversionFactor(long fromUnit) {
        ConversionFactor conversionFactorObj = new ConversionFactor();
        BigDecimal conversionFactor = BigDecimal.ONE;
        if (!TIME_UNIT_IDS_FOR_SYS.contains(fromUnit)) {
            QFilter srcMuIdFilter = new QFilter("srcmuid", "=", (Object)fromUnit);
            DynamicObject measureUnitObj = BusinessDataServiceHelper.loadSingle((String)"bd_measureunitconv", (String)"denominator, numerator, desmuid", (QFilter[])new QFilter[]{srcMuIdFilter});
            if (measureUnitObj != null) {
                BigDecimal denominator = measureUnitObj.getBigDecimal("denominator");
                BigDecimal numerator = measureUnitObj.getBigDecimal("numerator");
                conversionFactor = numerator.divide(denominator, 10, 4);
                fromUnit = measureUnitObj.getLong("desmuid.id");
            }
        }
        conversionFactorObj.setConversionFactor(conversionFactor);
        conversionFactorObj.setFromUnitId(fromUnit);
        return conversionFactorObj;
    }

    private static class ConversionFactor {
        private long fromUnitId;
        private BigDecimal conversionFactor;

        private ConversionFactor() {
        }

        public long getFromUnitId() {
            return this.fromUnitId;
        }

        public void setFromUnitId(long fromUnitId) {
            this.fromUnitId = fromUnitId;
        }

        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        public void setConversionFactor(BigDecimal conversionFactor) {
            this.conversionFactor = conversionFactor;
        }
    }
}

