/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public abstract class BaseListPlugin
extends AbstractListPlugin {
    protected FilterContainerInitArgs filterContainerInitArgs = null;
    protected String ORG_FIELD = "org";
    protected String COSTCENTER_FIELD = "costcenter";
    protected String COSTACCOUNT_FIELD = "costaccount";

    public BaseListPlugin() {
        this.setCommonFelds();
    }

    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        } else {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String entityId = this.getBillEntityId();
        if (!"sca_mfgfeeallocstdnew".equals(entityId) && !"sca_diycostdriver".equals(entityId)) {
            filter.and("orgduty", "=", (Object)4L);
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter}, (String)"number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId, List<Long> orgdutys) {
        QFilter filter = null;
        if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        } else {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgdutyFilter = CadEmptyUtils.isEmpty(orgdutys) ? null : new QFilter("orgduty", "in", orgdutys);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter});
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(orgId)) {
            ArrayList lOrgIds = new ArrayList();
            orgId.forEach(id -> lOrgIds.add(Long.valueOf(id.toString())));
            filter = new QFilter("calorg", "in", lOrgIds);
        } else {
            filter = new QFilter("calorg", ">", (Object)0L);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter((Long)Long.parseLong(orgId.get(0).toString()), (String)this.getView().getFormShowParameter().getAppId()));
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getPeriodComboItemsByLast(Long costAccountId) {
        ArrayList<ComboItem> periodComboItems = new ArrayList<ComboItem>();
        DynamicObject curPeriodAndEnAblePeriod = PeriodHelper.getCurrentPeriodAndEnAblePeriod((Long)costAccountId);
        if (curPeriodAndEnAblePeriod == null) {
            return periodComboItems;
        }
        DynamicObject currentperiod = curPeriodAndEnAblePeriod.getDynamicObject("currentperiod");
        if (currentperiod == null) {
            return periodComboItems;
        }
        Long startperiodId = 0L;
        DynamicObject startperiod = curPeriodAndEnAblePeriod.getDynamicObject("startperiod");
        if (startperiod != null) {
            startperiodId = startperiod.getLong("id");
        }
        this.addCombItem(periodComboItems, null, currentperiod);
        if (Long.compare(startperiodId, currentperiod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)currentperiod.getPkValue());
        if (prePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePeriod);
        if (Long.compare(startperiodId, prePeriod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePrePeriod = PeriodHelper.getPreviousPeriod((Object)prePeriod.getPkValue());
        if (prePrePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePrePeriod);
        return periodComboItems;
    }

    private void addCombItem(List<ComboItem> periodComboItems, String caption, DynamicObject period) {
        if (null == period) {
            return;
        }
        ComboItem item = new ComboItem();
        String periodId = period.getString("id");
        if (StringUtils.isEmpty((String)caption)) {
            item.setCaption(new LocaleString(period.getString("name")));
        } else {
            item.setCaption(new LocaleString(caption));
        }
        item.setValue(periodId);
        periodComboItems.add(item);
    }

    protected List<Long> getCostAccounts(List<Object> orgId) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (orgId == null) {
            return result;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Object org : orgId) {
            orgIds.add(Long.valueOf(org.toString()));
        }
        String fields = "entryentity.costaccount.id id";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, enable, appNumQF, isInitFilter};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        for (DynamicObject startStdCost : startStdCosts) {
            result.add(startStdCost.getLong("id"));
        }
        return result;
    }

    protected void setCommonFelds() {
    }
}

