/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.card;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class GardHomePlugin
extends AbstractFormPlugin {
    private static final Long ONGOING_S = 696207911730356224L;

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        this.showDetailList(this.getEntityName(key), key);
    }

    private String getEntityName(String key) {
        String entityName = "";
        switch (key) {
            case "servicerun": 
            case "servicenum": {
                entityName = "pmpd_project";
                break;
            }
            case "matcount": 
            case "matamount": {
                entityName = "aca_matalloc";
                break;
            }
            case "workcount": 
            case "workamount": {
                entityName = "eca_workhoursfee";
                break;
            }
        }
        return entityName;
    }

    protected void showDetailList(String entityName, String type) {
        DynamicObject costAccount;
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(entityName);
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        para.setCustomParam("source", (Object)"GardHomePlugin");
        DynamicObject org = this.getOrg();
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            para.setCustomParam("org", org.getPkValue());
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getCostAccount())) && !"pmpd_project".equals(entityName)) {
            para.setCustomParam("costaccount", costAccount.getPkValue());
        }
        switch (type) {
            case "servicerun": {
                para.setCustomParam("prjstate", (Object)ONGOING_S);
                break;
            }
            case "matcount": 
            case "matamount": {
                para.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
                para.setCustomParam("createtime", (Object)"63");
                break;
            }
            case "servicenum": 
            case "workcount": 
            case "workamount": {
                para.setCustomParam("createtime", (Object)"63");
                break;
            }
        }
        para.setCustomParam("filter", (Object)this.getFilters(type).toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    protected DynamicObject getCostAccount() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("costaccount");
    }

    protected DynamicObject getOrg() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("org");
    }

    protected int getCount(String entityName, List<QFilter> qFilters) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)query)) {
            return 0;
        }
        return query.size();
    }

    private BigDecimal getAmount(String entityName, String selectField, List<QFilter> filters) {
        BigDecimal zero = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        DynamicObject costAccount = this.getCostAccount();
        if (costAccount == null) {
            return zero;
        }
        Long currencyId = CurrencyHelper.getCurrency((DynamicObject)costAccount);
        DynamicObject currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
        if (currency == null) {
            return zero;
        }
        DynamicObject query = QueryServiceHelper.queryOne((String)entityName, (String)(selectField + " as amount"), (QFilter[])filters.toArray(new QFilter[0]));
        Integer amtPrecision = currency.getInt("amtprecision");
        return query.getBigDecimal("amount").setScale((int)amtPrecision, RoundingMode.HALF_UP);
    }

    protected void setValue(String type) {
        Label label = (Label)this.getView().getControl(type);
        HashMap<String, String> ctrlTxt = new HashMap<String, String>(16);
        ctrlTxt.put("fc", "#666666");
        HashMap<String, String> ctrl = new HashMap<String, String>(16);
        ctrl.put("fc", "#BBBBBB");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(this.getFilters(type));
        String entityName = this.getEntityName(type);
        switch (type) {
            case "matamount": {
                this.getView().updateControlMetadata("entrynum", ctrlTxt);
                this.getView().updateControlMetadata("amount", ctrlTxt);
                BigDecimal matAmount = this.getAmount(entityName, "sum(useamount)", filters);
                label.setText(matAmount.toString());
                if (matAmount.compareTo(BigDecimal.ZERO) != 0) break;
                this.getView().updateControlMetadata(type, ctrl);
                break;
            }
            case "workamount": {
                this.getView().updateControlMetadata("entrynum", ctrlTxt);
                this.getView().updateControlMetadata("amount", ctrlTxt);
                BigDecimal workAmount = this.getAmount(entityName, "sum(entryentity.amount)", filters);
                label.setText(workAmount.toString());
                if (workAmount.compareTo(BigDecimal.ZERO) != 0) break;
                this.getView().updateControlMetadata(type, ctrl);
                break;
            }
            default: {
                this.getView().updateControlMetadata("running", ctrlTxt);
                this.getView().updateControlMetadata("monthnew", ctrlTxt);
                int count = this.getCount(entityName, filters);
                label.setText(Integer.toString(count));
                if (count != 0) break;
                this.getView().updateControlMetadata(type, ctrl);
            }
        }
    }

    protected QFilter getFilters(String type) {
        DynamicObject org = this.getOrg();
        DynamicObject costAccount = this.getCostAccount();
        QFilter filter = new QFilter("org", "=", !CadEmptyUtils.isEmpty((DynamicObject)org) ? org.getPkValue() : Long.valueOf(-1L));
        QFilter accountFilter = new QFilter("costaccount", "=", !CadEmptyUtils.isEmpty((DynamicObject)costAccount) ? costAccount.getPkValue() : Long.valueOf(-1L));
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter createTimeFilter = new QFilter("createtime", "<=", (Object)DateUtils.getThisMonthEndDay());
        createTimeFilter.and("createtime", ">=", (Object)DateUtils.getThisMonthFirstDay());
        switch (type) {
            case "servicerun": {
                filter.and("prjstate", "=", (Object)ONGOING_S);
                break;
            }
            case "servicenum": {
                filter.and(createTimeFilter);
                break;
            }
            case "matcount": 
            case "matamount": {
                filter.and(accountFilter);
                filter.and(appNumFilter);
                filter.and(createTimeFilter);
                break;
            }
            case "workcount": 
            case "workamount": {
                filter.and(accountFilter);
                filter.and(createTimeFilter);
                break;
            }
        }
        return filter;
    }
}

