/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.costcarry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.eca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class CostCarryListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final String TRACKUP = "trackup";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TRACKUP});
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("period,costcenter.name,billtype,srcbillno");
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (TRACKUP.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.trackUp();
        }
    }

    private void trackUp() {
        List<Object> orgIds = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCarryListPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u67e5\u7684\u6570\u636e\u3002", (String)"CostCarryListPlugin_1", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = selectedRows.getPrimaryKeyValues();
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)pkIds)};
        DynamicObjectCollection costCarrys = QueryServiceHelper.query((String)"eca_costcarrybill", (String)"billtype,srcbillid", (QFilter[])filters);
        HashMap srcInfos = new HashMap(costCarrys.size());
        costCarrys.forEach(p -> {
            String billType = p.getString("billtype");
            ArrayList<Long> values = (ArrayList<Long>)srcInfos.get(billType);
            if (values == null) {
                values = new ArrayList<Long>(1);
            }
            values.add(p.getLong("srcbillid"));
            srcInfos.put(billType, values);
        });
        if (srcInfos.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u67e5\u7684\u6210\u672c\u7ed3\u8f6c\u5355\u3002", (String)"CostCarryListPlugin_2", (String)"macc-eca", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry srcInfo : srcInfos.entrySet()) {
            this.showBillByPkId((String)srcInfo.getKey(), (List)srcInfo.getValue());
        }
    }

    @Override
    protected void resetPeriod(CommonFilterColumn commonFilterColumn, String costAccoutId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long costAccout = 0L;
        if (StringUtils.isNotEmpty((String)costAccoutId)) {
            costAccout = Long.parseLong(costAccoutId);
        }
        this.comboItems = this.getPeriodComboItemsByCostAccount(costAccout);
        if (CollectionUtils.isEmpty((Collection)this.comboItems)) {
            return;
        }
        this.dealSelectVal(this.comboItems, commonFilterColumn);
        commonFilterColumn.setComboItems(this.comboItems);
        String defVal = ((ComboItem)this.comboItems.get(0)).getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean linkQuery = false;
        try {
            LinkQueryPkIdCollection linkQueryPkIdCollection = ((ListShowParameter)formShowParameter).getLinkQueryPkIdCollection();
            linkQuery = !CadEmptyUtils.isEmpty((List)linkQueryPkIdCollection);
        }
        catch (Exception e) {
            logger.error("getLinkQueryPkIdCollection error -> {}", (Object)e.getMessage());
        }
        if (linkQuery) {
            defVal = "";
        } else {
            String period;
            String source = (String)formShowParameter.getCustomParam("source");
            if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(period = formShowParameter.getCustomParam("period") + "")) && !"null".equals(period)) {
                defVal = period;
            }
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("period", defVal);
    }

    protected List<ComboItem> getPeriodComboItemsByCostAccount(Long costAccountId) {
        ArrayList<ComboItem> resultComboItems = new ArrayList<ComboItem>();
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (curPeriod == null) {
            return resultComboItems;
        }
        this.addCombItem(resultComboItems, null, curPeriod);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod((Object)curPeriod.getPkValue());
        if (nextPeriod == null) {
            return resultComboItems;
        }
        this.addCombItem(resultComboItems, null, nextPeriod);
        DynamicObject prePrePeriod = PeriodHelper.getPreviousPeriod((Object)curPeriod.getPkValue());
        if (prePrePeriod == null) {
            return resultComboItems;
        }
        this.addCombItem(resultComboItems, null, prePrePeriod);
        return resultComboItems;
    }

    private void addCombItem(List<ComboItem> periodComboItems, String caption, DynamicObject period) {
        if (null == period) {
            return;
        }
        ComboItem item = new ComboItem();
        String periodId = period.getString("id");
        if (kd.bos.util.StringUtils.isEmpty((String)caption)) {
            item.setCaption(new LocaleString(period.getString("name")));
        } else {
            item.setCaption(new LocaleString(caption));
        }
        item.setValue(periodId);
        periodComboItems.add(item);
    }

    private void showBillByPkId(String formId, List<Long> pkIds) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        if ("aca_matalloc".equals(formId)) {
            param.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"CostCarryListPlugin_3", (String)"macc-eca", (Object[])new Object[0]));
        }
        param.setBillFormId(formId);
        param.setCustomParam("sqlQuery", (Object)"true");
        param.setCustomParam("isShowTitle", (Object)"true");
        pkIds.forEach(t -> param.addLinkQueryPkId(t));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }
}

