/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.eca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.eca.common.enums.HourExpenseEnum;
import kd.macc.eca.common.helper.SysParamHelper;

public class WorkHoursFeeEditPlugin
extends AbstractBillPlugIn {
    public static final String ENTITY_ENTRY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursFeeEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter(createorg);
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("org");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"WorkHoursFeeEditPlugin_0", (String)"macc-eca", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter showorgduty = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorg = new QFilter("accountorg", "=", createorg.getPkValue());
            qFilters.add(showorgduty);
            qFilters.add(calorg);
        });
        BasedataEdit attaSubElementCtrl = (BasedataEdit)this.getControl("subelement");
        attaSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_ENTRY);
            Set attaSubelemenIds = entryEntity.stream().map(s -> s.getLong("subelement.id")).collect(Collectors.toSet());
            if (!attaSubelemenIds.isEmpty()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", attaSubelemenIds));
            }
        });
        BasedataEdit workhoursunitCtrl = (BasedataEdit)this.getControl("workhour");
        workhoursunitCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("group", "=", (Object)4L));
        });
    }

    private void setAttaElement(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            ChangeData changeData = changeSet[0];
            DynamicObject row = changeData.getDataEntity();
            DynamicObject attasubelement = row.getDynamicObject("subelement");
            if (attasubelement == null) {
                return;
            }
            QFilter subeleIdFilter = new QFilter("subelement", "=", (Object)attasubelement.getLong("id"));
            DynamicObject elementDetail = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id", (QFilter[])new QFilter[]{subeleIdFilter});
            if (elementDetail != null) {
                int seq = row.getInt("seq");
                int rowIndex = seq - 1;
                this.getModel().setValue("subelement", (Object)elementDetail.getLong("element.id"), rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName().toUpperCase()) {
            case "SUBELEMENT": {
                this.setAttaElement(e);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String costaccount;
        String costcenter;
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam("orgId");
        if (!StringUtils.isEmpty((CharSequence)acctOrg) && this.getModel().getValue("org") == null) {
            this.getModel().setValue("org", (Object)acctOrg);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        if (!StringUtils.isEmpty((CharSequence)(costcenter = (String)formShowParameter.getCustomParam("costcenter"))) && this.getModel().getValue("costcenter") == null) {
            this.getModel().setValue("costcenter", (Object)costcenter);
        }
        if (!StringUtils.isEmpty((CharSequence)(costaccount = (String)formShowParameter.getCustomParam("costaccount"))) && this.getModel().getValue("costaccount") == null) {
            this.getModel().setValue("costaccount", (Object)costaccount);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costaccount"});
        }
        this.setCurrency();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.setHourExpenseVisible(org);
    }

    private void setHourExpenseVisible(DynamicObject org) {
        Long orgId = org == null ? 0L : org.getLong("id");
        Map<String, Boolean> hourExpenseInfo = SysParamHelper.getHourExpense(orgId);
        Boolean exist = hourExpenseInfo.get(HourExpenseEnum.RESOURCE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"trade"});
        exist = hourExpenseInfo.get(HourExpenseEnum.ROLE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"role"});
        exist = hourExpenseInfo.get(HourExpenseEnum.RESOURCE.getValue());
        this.getView().setVisible(Boolean.valueOf(exist != null && exist != false), new String[]{"resource"});
    }

    private QFilter getCostAccountFilter(DynamicObject org) {
        ArrayList<Long> costaccountIds = new ArrayList<Long>();
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"eca");
        QFilter isinitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        DynamicObjectCollection costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])new QFilter[]{orgFilter, isStartStdCostFilter, qfAppNum, isinitFilter});
        for (DynamicObject costaccount : costaccounts) {
            costaccountIds.add(costaccount.getLong("id"));
        }
        return new QFilter("id", "in", costaccountIds);
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccount.get("id"))});
        Long currency = result.getLong("currency");
        if (this.getModel().getValue("currency") == null) {
            this.getModel().setValue("currency", (Object)currency);
        }
    }
}

